/* $Id: unsetenv.c 1315 2004-03-17 03:59:28Z bird $ */
/** @file
 *
 * LIBC APP - unsetenv()
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird-srcspam@anduin.net>
 *
 * All Rights Reserved
 *
 */


#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <emx/startup.h>
#define __LIBC_LOG_GROUP  __LIBC_LOG_GRP_ENV
#include <InnoTekLIBC/logstrict.h>



/**
 * Delete environment variable.
 *
 * @returns 0 on success.
 * @returns -1 and errno=EINVAL if name is invalid in any way.
 * @param   name    Name of environment variable to unset.
 *                  Shall not be NULL, empty string or contain '='.
 * @remark  Leaks memory, but that's what BSD does too.
 * @author  knut st. osmundsen <bird-srcspam@anduin.net>
 */
int _STD(unsetenv)(const char *name)
{
    LIBCLOG_ENTER("name=%s\n", name);
    int     lenname;
    char ** p;


    /* validate input */
    if (name == NULL || *name == '\0' || strchr(name, '=') != NULL)
    {
        errno = EINVAL;
        LIBC_ASSERTM_FAILED("name(%p='%s') is invalid\n", name, name);
        LIBCLOG_RETURN_INT(-1);
    }

    /* search (thru all the environment in case of multiple defintions). */
    lenname = strlen(name);
    p = environ;
    while (*p != NULL)
    {
        char *s = *p;
        if (    strncmp(s, name, lenname) == 0
            && (    s[lenname] == '\0'
                ||  s[lenname] == '='))
        { /* shift down the remaining entries. */
            char **p2 = p;
            for (;;p2++)
                if ((p2[0] = p2[1]) == NULL)
                    break;
            LIBCLOG_MSG("deleted '%s'\n", s);
        }
        else
        {
            /* next */
            p++;
        }
    }

    LIBCLOG_RETURN_INT(0);
}
