/* stdio.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes
                     -- Copyright (c) 2003-2004 by knut st. osmundsen */

#include "libc-alias.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <emx/io.h>
#include <emx/startup.h>
#define __LIBC_LOG_GROUP  __LIBC_LOG_GRP_STREAM
#include <InnoTekLIBC/logstrict.h>


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** Preallocated streams
 * (public since stdin,stdout,stderr references this thru #defines.) */
static FILE                 gaPreFiles[_NFILES] = {{0}};

/** Vector entry for preallocated streams. */
static struct streamvec     gPreStreamVec = {&gaPreFiles[0], NULL, _NFILES};

/** More structures for preallocated streams. */
static struct _file2        gaPreFile2s[_NFILES];

/** The buffer for stdin. */
static char                 gachStdIn[BUFSIZ];

/** Mutex protecting the stream vector. */
_rmutex                     _streamv_rmutex;    /* See io/_newstre.c */

/*
 * (These variables must be initialized as no extended dictionary
 * entries are built for COMDEF.)
 */

/** Head of the stream vector. */
struct streamvec           *_streamvec_head = NULL;

/** Standard input stream pointer. */
FILE                       *__stdinp = &gaPreFiles[0];
/** Standard output stream pointer. */
FILE                       *__stdoutp = &gaPreFiles[1];
/** Standard error stream pointer. */
FILE                       *__stderrp = &gaPreFiles[2];


/**
 * Initialize the streams -- this function will be called by
 * _CRT_init() via the __crtinit1__ set vector.
 */
void _init_streams(void);
void _init_streams(void)
{
    LIBCLOG_ENTER("\n");
    struct _FILE       *pFile;
    struct _file2      *pFile2;
    int                 i;
    static char         fInited = 0;

    /*
     * Paranoia!
     */
    if (fInited)
        LIBCLOG_RETURN_VOID();
    fInited = 1;
    LIBCLOG_MSG("_NFILES=%d\n", _NFILES);

    /*
     * Init the _more and _owner pointers.
     */
    pFile   = &gaPreFiles[0];
    pFile2  = &gaPreFile2s[0];
    for (i = 0; i < _NFILES; i++, pFile++, pFile2++)
    {
        pFile2->owner = pFile; /* obsolete? */
        pFile->_more = pFile2;
    }

    /*
     * Create the mutex protecting the stream list and insert the table.
     * ASSUME: we're ALONE at this point.
     */
    gPreStreamVec.next  = _streamvec_head;
    _streamvec_head     = &gPreStreamVec;
    _rmutex_checked_create(&_streamv_rmutex, 0);

    /*
     * As far as I know there is no reason to initiate a bunch of streams
     * here as EM used to do. All that is required is the three standard
     * streams.
     */
    for (i = 0; i < 3; i++)
    {
        PLIBCFH pFH = __libc_FH(i);
        if (pFH)
        {
            /*
             * Common init - recall everything is ZERO.
             */
            gaPreFiles[i]._flags    |= _IOOPEN;
            gaPreFiles[i]._handle    = i;
            gaPreFiles[i]._flush     = _flushstream;
            if (_setmore(&gaPreFiles[i], 0))
            {
                LIBC_ASSERTM_FAILED("_setmore failed for i=%d\n", i);
                abort();
            }

            /*
             * Specific init.
             */
            switch (i)
            {
                case 0:
                    /* stdin is always buffered. */
                    gaPreFiles[0]._flags    |= _IOREAD | _IOFBF | _IOBUFUSER;
                    gaPreFiles[0]._ptr       = gachStdIn;
                    gaPreFiles[0]._buffer    = gachStdIn;
                    gaPreFiles[0]._buf_size  = BUFSIZ;
                    LIBCLOG_MSG("__stdinp=%p\n", __stdinp);
                    break;

                case 1:
                    /* stdout is buffered unless it's connected to a device. */
                    gaPreFiles[1]._flags |= _IOWRT | _IOBUFNONE
                        | ((pFH->fFlags & F_TYPEMASK) == F_DEV ? _IONBF : _IOFBF);
                    LIBCLOG_MSG("__stdoutp=%p flags=%#x (%s)\n", __stdoutp, gaPreFiles[1]._flags,
                                (pFH->fFlags & F_TYPEMASK) == F_DEV ? "dev" : "none-dev");
                    break;

                case 2:
                    /* stderr is always unbuffered. */
                    gaPreFiles[2]._flags |= _IOWRT | _IOBUFNONE | _IONBF;
                    LIBCLOG_MSG("__stderrp=%p\n", __stderrp);
                    break;
            }
        }
        else
            LIBCLOG_MSG("No open file for %d\n", i);
    } /* for standard handles. */
    LIBCLOG_RETURN_VOID();
}


/* Shutdown the streams -- this function will be called by _CRT_term()
   via the __crtexit1__ set vector.  Do not close the streams as this
   function is called by abort() and the signal handler might want to
   print something.  (ISO 9899-1990 lets this undefined.) */

void _exit_streams(void);
void _exit_streams(void)
{
    flushall();
    _rmtmp();
}

_CRT_INIT1(_init_streams)
_CRT_EXIT1(_exit_streams)
