/* sys/stat.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   sys/__stat.c (libc)  -- Copyright (c) 2003 by knut st. osmundsen
 */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <emx/syscalls.h>
#include <limits.h>
#include "syscalls.h"

int __stat(const char *pszPath, struct stat *pStat)
{
    ULONG   rc;
    union
    {
        FILESTATUS3     fsts3;
        FILESTATUS3L    fsts3L;
    } info;
#if OFF_MAX > LONG_MAX
    int     fLarge = 0;
#endif
    FS_VAR();

    /*
     * Validate input, refusing named pipes.
     */
    memset(pStat, 0, sizeof(*pStat));
    if (    (pszPath[0] == '/' || pszPath[0] == '\\')
        &&  !strnicmp(pszPath+1, "pipe", 4)
        &&  (pszPath[5] == '/' || pszPath[5] == '\\'))
    {
        errno = ENOENT;
        return -1;
    }

    /*
     * Get path info.
     */
    FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
    if (__pfnDosOpenL)
    {
        rc = DosQueryPathInfo(pszPath, FIL_STANDARDL, &info, sizeof(info.fsts3L));
        fLarge = 1;
    }
    else
#endif
        rc = DosQueryPathInfo(pszPath, FIL_STANDARD, &info, sizeof(info.fsts3));
    FS_RESTORE();
    if (rc)
    {
        _sys_set_errno(rc);
        return -1;
    }

    /*
     * Format stats struct.
     *      We know the info struct layouts!
     *      Only cbFile, cbFileAlloc and attrFile need be accessed
     *      using the specific structure.
     */
    /* Times: FAT might not return create and access time. */
    pStat->st_mtime = _sys_p2t(info.fsts3.ftimeLastWrite, info.fsts3.fdateLastWrite);
    if (   FTIMEZEROP(info.fsts3.ftimeCreation)
        && FDATEZEROP(info.fsts3.fdateCreation))
        pStat->st_ctime = pStat->st_mtime;
    else
        pStat->st_ctime = _sys_p2t(info.fsts3.ftimeCreation, info.fsts3.fdateCreation);
    if (   FTIMEZEROP(info.fsts3.ftimeLastAccess)
        && FDATEZEROP(info.fsts3.fdateLastAccess))
        pStat->st_atime = pStat->st_mtime;
    else
        pStat->st_atime = _sys_p2t(info.fsts3.ftimeLastAccess, info.fsts3.fdateLastAccess);

#if OFF_MAX > LONG_MAX
    rc = fLarge ? info.fsts3L.attrFile : info.fsts3.attrFile;
#else
    rc = info.fsts3.attrFile;
#endif
    pStat->st_attr = rc;
    if (rc & FILE_DIRECTORY)
    {
        /* directory */
        pStat->st_mode = S_IFDIR;
        pStat->st_mode |= ((S_IREAD|S_IWRITE|S_IEXEC) >> 6) * 0111;
        pStat->st_size = 0;
    }
    else
    {
#if OFF_MAX > LONG_MAX
        if (fLarge)
        {
            pStat->st_size = info.fsts3L.cbFile;
            pStat->st_blocks = info.fsts3L.cbFileAlloc / S_BLKSIZE;
        }
        else
#endif
        {
            pStat->st_size = info.fsts3.cbFile;
            pStat->st_blocks = info.fsts3.cbFileAlloc / S_BLKSIZE;
        }
        pStat->st_mode = S_IFREG;
        if (rc & FILE_READONLY)
            pStat->st_mode |= (S_IREAD >> 6) * 0111;
        else
            pStat->st_mode |= ((S_IREAD|S_IWRITE) >> 6) * 0111;
    }
    /* default fake stuff */
    pStat->st_uid = 0;
    pStat->st_gid = 0;
    pStat->st_ino = _sys_ino++;
    if (_sys_ino == 0)
        _sys_ino = 1;
    pStat->st_dev = 0;
    pStat->st_rdev = 0;
    pStat->st_nlink = 1;
    pStat->st_blksize = 4096*48;
    return 0;
}
