/* $Id: 64bitio.c 1292 2004-03-15 14:27:14Z bird $ */
/** @file
 *
 * 64-bit I/O testing (microscopical part of it).
 *
 * InnoTek Systemberatung GmbH confidential
 *
 * Copyright (c) 2004 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird-srcspam@anduin.net>
 *
 * All Rights Reserved
 *
 */


#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#define FILENAME "3gb.file"
#define SIZE     (3*1024*1024*1024LL)

int main()
{
    int         cErrors = 0;
    FILE       *pFile;
    struct stat s;
    int         rc;

    /*
     * Handle based tests.
     */
    pFile = fopen(FILENAME, "w");
    if (!pFile)
    {
        printf("64bitio: couldn't open file\n");
        return 1;
    }

    rc = chsize(fileno(pFile), SIZE);
    if (rc)
    {
        printf("64bitio: failed to extend file to 3GB. running on JFS?\n");
        return 1;
    }
    /* remember to delete file! */
    if (!fstat(fileno(pFile), &s))
    {
        if (s.st_size != SIZE)
        {
            printf("64bitio: fstat reports wrong filesize. %lld != %lld\n",
                   s.st_size, SIZE);
            cErrors++;
        }
    }
    else
    {
        printf("64bitio: fstat failed. errno=%d\n", errno);
        cErrors++;
    }

    fclose(pFile);


    /*
     * Tests on filename.
     */
    if (!stat(FILENAME, &s))
    {
        if (s.st_size != SIZE)
        {
            printf("64bitio: stat reports wrong filesize. %lld != %lld\n",
                   s.st_size, SIZE);
            cErrors++;
        }
    }
    else
    {
        printf("64bitio: stat failed. errno=%d\n", errno);
        cErrors++;
    }

    /*
     * Kill it.
     */
    if (unlink(FILENAME))
    {
        printf("64bitio: unlink failed! errno=%d\n", errno);
        cErrors++;
    }
    if (cErrors)
        printf("64bitio: %d errors\n", cErrors);
    else
        printf("64bitio: success\n", cErrors);
    return cErrors != 0;
}
