/* startup.c (emx+gcc) -- Copyright (c) 1990-1998 by Eberhard Mattes */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <emx/io.h>
#include <emx/syscalls.h>
#include <emx/startup.h>
#define __LIBC_LOG_GROUP    __LIBC_LOG_GRP_INITTERM
#include <InnoTekLIBC/logstrict.h>

extern int __crtinit1__;
extern void __ctordtorInit1 (int *ptr);


/* Initialize the C run-time library.  This function is called from
   crt0.s. */
int _CRT_init (void)
{
  LIBCLOG_ENTER("\n");
  static int startup_flag;

  /* Protect against multiple calls (for instance, by _CRT_init() in a
     _DLL_InitTerm() and by the application program's startup code). */
  if (startup_flag)
    LIBCLOG_RETURN_INT(0);
  startup_flag = 1;

  /* Initialize streams etc. if required. */
  __ctordtorInit1 (&__crtinit1__);

  /* ANSI X3.159-1989, 4.1.3: "The value of errno is zero at program
     startup..."

     The above code usually sets errno to EBADF, therefore we reset
     errno to zero before calling main(). */
  errno = 0;

  LIBCLOG_RETURN_INT(0);
}



/** @page Startup   Startup
 *
 * Quick description of how we startup a process which modules uses LIBC.
 *
 * The load first loads the DLLs of the process, calling their _DLL_InitTerm
 * entrypoints in order of dependencies. If you're using dynamic LIBC this
 * will be initiated first of the LIBC-based modules.
 *
 * LIBCxy.DLL:
 *      - dll0.s gets control and calls __init_dll in sys/__initdll.c
 *          - __init_dll calls __libc_HeapVote() to do the heap voting.
 *          - __init_dll calls __init_os_version() to set _osminor,_osmajor globals.
 *          - __init_dll initiates _sys_pid and _sys_ppid globals.
 *          - __init_dll creates _sys_heap_fmutex and _sys_gmtxHimem.
 *          - __init_dll then initiates __libc_gpTLS with an allocated TLS ULONG.
 *            The thread structure it self isn't initialized untill it's actually
 *            referenced, and when it is there is static structure for the first
 *            thread needing its per thread area.
 *          - __init_dll calls __init_environ() which initializes environ and _org_environ.
 *              - __init_environ() will call _hmalloc() thus initiating the high heap.
 *          - __init_dll calls _sys_init_largefileio() which checks for LFN APIs.
 *          - __init_dll calls _sys_init_filehandles() which initiates filehandle table.
 *              - _sys_init_filehandles() will call _hmalloc() and a number of OS/2 APIs
 *                to figure out what handles was inherited.
 *          - __init_dll then intializes _sys_clock0_ms with the current MS count.
 *      - dll0.s calls _DLL_InitTerm in startup/dllinit.c.
 *          - _DLL_InitTerm calls _CRT_init() in startup/startup.c to initialize the CRT.
 *              - _CRT_init calls init_files() to initialize the file handle tables.
 *              - _CRT_init then call all the crt init functions in __crtinit1__.
 *          - _DLL_InitTerm calls __ctordtorInit() to initate any exception structures and
 *            construct static C++ objects.
 *      - dll0.s then returns to DOSCALL1.DLL and back to the kernel.
 *
 * Your.DLL:
 *      - dll0.s gets control and calls __init_dll() in sys/__initdll.c
 *          - __init_dll calls __libc_HeapVote() to do the heap voting.
 *          - __init_dll then returns since already done during LIBCxy.DLL init.
 *      - dll0.s calls _DLL_InitTerm in startup/dllinit.c.
 *          - _DLL_InitTerm calls _CRT_init() in startup/startup.c to initialize the CRT.
 *              - _CRT_init return at once since already done during LIBCxy.DLL init.
 *          - _DLL_InitTerm calls __ctordtorInit() to initate any exception structures and
 *            construct static C++ objects in _this_ DLL.
 *      - dll0.s then returns to DOSCALL1.DLL and back to the kernel.
 *
 * Your.exe:
 *      - crt0.s gets control and calls ___init_app in sys/386/appinit.s which forwards
 *        the call to __init() in sys/__init.c.
 *          - __init() calls __init_dll() to do common initiation.
 *              - __init_dll calls __libc_HeapVote() to do the heap voting.
 *              - __init_dll then returns since already done during LIBCxy.DLL init.
 *          - __init() parse the commandline to figure out how much stack to use for array
 *            and the argument copy.
 *          - __init() the allocates the stack space space, adding an exception handler struct
 *            and main() callframe.
 *          - __init() parse the commandline creating argv and it's strings using the
 *            allocated stack space.
 *          - __init() installs the exception handler.
 *          - __init() set the signal focus.
 *          - __init() then 'returns' thru the hack called ___init_ret in sys/386/appinit.s
 *      - crt0.s now gets control back with esp pointing to a complete callframe for main().
 *      - crt0.s calls _CRT_init() in startup/startup.c to initialize the CRT which returns
 *        immediately since since already done during LIBCxy.DLL init.
 *      - crt0.s the calls main().
 *      - crt0.s then calls exit() with the return value of main().
 *          - exit() will call all the registered at_exit functions.
 *          - exit() will call DosExit with the exit code and terminate the process.
 *
 * @todo update this with file handle changes!
 */
