/* waitpid.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */


#include "libc-alias.h"
#include <stdlib.h>
#include <process.h>
#include <errno.h>
#include <emx/syscalls.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_PROCESS
#include <InnoTekLIBC/logstrict.h>

int _STD(waitpid)(int pid, int *status, int options)
{
    LIBCLOG_ENTER("pid=%d status=%p options=%#x\n", pid, status, options);
    int dummy;
    int rc;

    if (status == NULL)
        status = &dummy;
    rc = __waitpid(pid, status, options);
    LIBCLOG_RETURN_MSG(rc,"ret %d (%#x). *status=%#x\n", rc, rc, *status);
}
