/* system.c (emx+gcc) -- Copyright (c) 1990-1995 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <errno.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_PROCESS
#include <InnoTekLIBC/logstrict.h>

int _STD(system)(const char *name)
{
    LIBCLOG_ENTER("name=%s\n", name);
    int rc;
    const char *sh, *base, *opt;

    sh = getenv("EMXSHELL");
    if (sh == NULL)
        sh = getenv("COMSPEC");
    if (sh == NULL)
    {
        errno = ENOENT;
        LIBCLOG_RETURN_INT(-1);
    }
    LIBCLOG_MSG("using shell: %s\n", sh);
    if (name == NULL)   /* Check for command interpreter */
    {
        LIBCLOG_MSG("check shell access\n");
        rc = access(sh, 0) == 0;
        LIBCLOG_RETURN_INT(rc);
    }
    if (*name == 0)
        rc = spawnlp(P_WAIT, sh, sh, (char *)0);
    else
    {
        base = _getname(sh);
        if (stricmp(base, "cmd.exe") == 0
            || stricmp(base, "4os2.exe") == 0
            || stricmp(base, "command.com") == 0
            || stricmp(base, "4dos.com") == 0)
            opt = "/c";
        else
            opt = "-c";
        rc = spawnlp(P_WAIT, sh, sh, opt, name, (char *)0);
    }
    LIBCLOG_RETURN_INT(rc);
}
