/* spawnvpe.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <errno.h>
#include <sys/syslimits.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_PROCESS
#include <InnoTekLIBC/logstrict.h>

int _STD(spawnvpe)(int mode, const char *name, char * const argv[], char * const envp[])
{
    LIBCLOG_ENTER("mode=%#x name=%s argv=%p envp=%p\n", mode, name, argv, envp);
    char    exe[PATH_MAX];
    char    path[PATH_MAX];
    int     rc;

    if (strlen(name) >= sizeof(exe) - 4)
    {
        LIBC_ASSERTM_FAILED("name is too long, %d bytes: %s\n", strlen(name), name);
        errno = ENAMETOOLONG;
        LIBCLOG_RETURN_INT(-1);
    }
    strcpy(exe, name);
    _defext(exe, "exe");
    if (!_path(path, exe))
        LIBCLOG_RETURN_INT(-1);
    rc = spawnve(mode, path, argv, envp);
    LIBCLOG_RETURN_INT(rc);
}
