/* sigaddse.c (emx+gcc) -- Copyright (c) 1994-1995 by Eberhard Mattes */

#include "libc-alias.h"
#include <signal.h>
#include <errno.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_SIGNAL
#include <InnoTekLIBC/logstrict.h>

int _STD(sigaddset) (sigset_t *set, int sig)
{
    LIBCLOG_ENTER("set=%p sig=%d\n", set, sig);
    int rc;
    if (sig < 1 || sig >= NSIG)
    {
        LIBC_ASSERTM_FAILED("invalid signal number %d\n", sig);
        errno = EINVAL;
        LIBCLOG_RETURN_INT(-1);
    }
    rc = __sigaddset(set, sig);
    LIBCLOG_RETURN_INT(rc);
}
