/* fmutex2.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <sys/builtin.h>
#include <sys/fmutex.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_MUTEX
#include <InnoTekLIBC/logstrict.h>

/* These functions call abort() and therefore must not be linked in
   when building emx.dll. */

void _fmutex_checked_close(_fmutex *sem)
{
    LIBCLOG_ENTER("sem=%p\n", sem);
    if (_fmutex_close(sem) != 0)
    {
        LIBC_ASSERT_FAILED();
        abort();
    }
    LIBCLOG_RETURN_VOID();
}


void _fmutex_checked_create(_fmutex *sem, unsigned flags)
{
    LIBCLOG_ENTER("sem=%p flags=%#x\n", sem, flags);
    if (_fmutex_create(sem, flags) != 0)
    {
        LIBC_ASSERT_FAILED();
        abort();
    }
    LIBCLOG_RETURN_VOID();
}


void _fmutex_checked_open(_fmutex *sem)
{
    LIBCLOG_ENTER("sem=%p\n", sem);
    if (_fmutex_open(sem) != 0)
    {
        LIBC_ASSERT_FAILED();
        abort();
    }
    LIBCLOG_RETURN_VOID();
}
