/* localtim.c (emx+gcc) -- Copyright (c) 1990-1999 by Eberhard Mattes */

#include "libc-alias.h"
#include <time.h>
#include <InnoTekLIBC/thread.h>
#include <emx/time.h>

struct tm *_STD(localtime)(const time_t *t)
{
    __LIBC_PTHREAD pThrd = __libc_threadCurrent();
    return localtime_r(t, &pThrd->GmTimeAndLocalTimeBuf);
}

struct tm *_STD(localtime_r)(const time_t *t, struct tm *dst)
{
    time_t lt;
    int isdst;
    struct tm *p;

    if (!_tzset_flag) tzset();
    lt = *t;
    isdst = _gmt2loc(&lt);
    p = gmtime_r(&lt, dst);
    p->tm_isdst = isdst;
    return p;
}
