/* sys/sigsuspe.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"
#include <InnoTekLIBC/thread.h>

int _STD(sigsuspend) (const sigset_t *mask)
{
    /* TODO: Critical section */
    __LIBC_PTHREAD  pThrd = __libc_threadCurrent();
    sigset_t        old_blocked;

    old_blocked = pThrd->b.sys.sig_blocked;
    SET_BLOCKED(&pThrd->b.sys, *mask);
    pause();
    pThrd->b.sys.sig_blocked = old_blocked;
    errno = EINTR;
    return -1;
}
