/* sys/sigprocm.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"
#include <InnoTekLIBC/thread.h>

int _STD(sigprocmask)(int how, const sigset_t *iset, sigset_t *oset)
{
    __LIBC_PTHREAD  pThrd = __libc_threadCurrent();
    sigset_t temp, output;

    output = pThrd->b.sys.sig_blocked;
    if (iset != NULL)
    {
        switch (how)
        {
            case SIG_BLOCK:
                temp = pThrd->b.sys.sig_blocked | *iset;
                break;
            case SIG_UNBLOCK:
                temp = pThrd->b.sys.sig_blocked & ~*iset;
                break;
            case SIG_SETMASK:
                temp = *iset;
                break;
            default:
                errno = EINVAL;
                return -1;
        }
        SET_BLOCKED(&pThrd->b.sys, temp);
    }

    if (oset != NULL)
        *oset = output;

    _sys_deliver_pending_signals(pThrd);
    return 0;
}
