/* sys/signal.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"
#include <InnoTekLIBC/thread.h>

typedef void sigfun(int sig);

sigfun *_STD(signal)(int sig, sigfun *handler)
{
    if (handler == SIG_ACK)
    {
        __LIBC_PTHREAD pThrd;

        if (sig < 1 || sig >= NSIG || sig == SIGKILL || !_sys_sig_valid[sig])
        {
            errno = EINVAL;
            return SIG_ERR;
        }
        pThrd = __libc_threadCurrent();
        if (pThrd == NULL)
            return SIG_ERR;
        sigdelset(&pThrd->b.sys.sig_blocked, sig);
        _sys_deliver_pending_signals(pThrd);
        return pThrd->b.sys.signals[sig].sa_handler;
    }
    else
    {
        struct sigaction isa, osa;

        isa.sa_handler = handler;
        isa.sa_mask = 0;
        isa.sa_flags = SA_ACK;
        if (sigaction(sig, &isa, &osa) != 0)
            return SIG_ERR;
        else
            return osa.sa_handler;
    }
}
