/* sys/sigactio.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/thread.h>
#include "syscalls.h"

int _STD(sigaction)(int signo, const struct sigaction *iact,
                    struct sigaction *oact)
{
    struct sigaction    output;
    struct sigaction   *s;
    __LIBC_PTHREAD      pThrd;

    if (signo < 1 || signo >= NSIG || signo == SIGKILL || !_sys_sig_valid[signo])
    {
        errno = EINVAL;
        return -1;
    }
    if (signo == SIGKILL && iact != NULL)
    {
        errno = EINVAL;
        return -1;
    }
    pThrd = __libc_threadCurrent();
    s = &pThrd->b.sys.signals[signo];
    output = *s;
    if (iact != NULL)
    {
        *s = *iact;
        if (    (   s->sa_handler == SIG_DFL
                 && sig_info[signo].dfl_action != ST_IGNORE)
            ||  s->sa_handler == SIG_IGN)
            sigdelset(&pThrd->b.sys.sig_pending, signo);
    }

    if (oact != NULL)
        *oact = output;
    return 0;
}
