/* sys/raise.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <string.h>
#include <errno.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/thread.h>
#include "syscalls.h"

int _STD(raise)(int signo)
{
    __LIBC_PTHREAD  pThrd = __libc_threadCurrent();

    if (signo < 1 || signo >= NSIG || !_sys_sig_valid[signo])
    {
        errno = EINVAL;
        return -1;
    }
    if (pThrd->b.sys.signals[signo].sa_handler != SIG_IGN)
    {
        __sigaddset(&pThrd->b.sys.sig_pending, signo);
        _sys_deliver_pending_signals(pThrd);
    }
    return 0;
}
