/* strtok.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <string.h>
#include <InnoTekLIBC/thread.h>

char *_STD(strtok) (char *string1, const char *string2)
{
  char table[256];
  unsigned char *p, *result;
  __LIBC_PTHREAD pThrd = __libc_threadCurrent ();
  if (string1 != NULL)
    p = (unsigned char *)string1;
  else
    {
      if (pThrd->pszStrTokPos == NULL)
        return NULL;
      p = pThrd->pszStrTokPos;
    }
  memset (table, 0, 256);
  while (*string2 != 0)
    table[(unsigned char)*string2++] = 1;
  table[0] = 0;
  while (table[*p])
    ++p;
  result = p;
  table[0] = 1;
  while (!table[*p])
    ++p;
  if (*p == 0)
    {
      if (p == result)
        {
          pThrd->pszStrTokPos = NULL;
          return NULL;
        }
    }
  else
    *p++ = 0;
  pThrd->pszStrTokPos = p;
  return (char *)result;
}
