/* initr.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <umalloc.h>
#include <emx/umalloc.h>
#include <sys/smutex.h>
#include <InnoTekLIBC/thread.h>

/** This is the default regular heap. */
Heap_t _um_regular_heap;

/**
 * Sets the default regular heap for the current thread and perhaps
 * even the system.
 *
 * Now because of the voting procedure we do not set the _um_regular_heap nor
 * the per thread variable until the voting is completed. There for make sure
 * to use the returned value not the one in the per thread or system variables!
 *
 * @returns Default heap for the thread.
 */
Heap_t _um_init_default_regular_heap(void)
{
    _UM_MT_DECL
    static _smutex  lock;
    Heap_t          heap_reg = _UM_DEFAULT_REGULAR_HEAP;

    /*
     * Is there actually anything left to be done?
     */
    if (!heap_reg)
    {
        int     vote = __libc_HeapGetResult();
        if (vote >= 0)
        {
            /*
             * Is system wide default heap initiated?
             */
            _smutex_request(&lock);
            heap_reg = _um_regular_heap;
            if (!heap_reg)
            {
                if (vote)
                {
                    /*
                     * Use high memory heap.
                     */
                    _um_regular_heap = heap_reg = _hinitheap();
                }
                else
                {
                    /*
                     * Use low memory heap.
                     */
                    _um_regular_heap = heap_reg = _linitheap();
                }
            }
            _smutex_release(&lock);

            /*
             * Set the per thread default.
             */
            _UM_DEFAULT_REGULAR_HEAP = heap_reg;
        }
        else
        {
            /*
             * The voting is not yet over, so we must return the low heap.
             * We do not set either the per thread or system defaults!
             */
            heap_reg = _um_low_heap;
            if (!heap_reg)
                heap_reg = _linitheap();
        }
    }

    return heap_reg;
}

