/* $Id: tls.c 1287 2004-03-11 03:05:55Z bird $ */
/** @file
 *
 * InnoTek LIBC - Thread Local Storage Implementation.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <InnoTekLIBC/thread.h>
#include <errno.h>


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** TLS allocation bitmap map.
 * Set means allocated, clear means free. Updated atomically. */
static unsigned auchBitmap[(__LIBC_TLS_MAX + sizeof(unsigned) * 8 - 1) / (sizeof(unsigned) * 8)];
/** Number of allocated TLS items.
 * Updated atomically. Update before allocation and after free. */
static unsigned cTLSFree;


int     __libc_TLSAlloc(void)
{
    return -1;
}

int     __libc_TLSFree(int iIndex)
{
    return 0;
}

void *  __libc_TLSGet(int iIndex)
{
    return NULL;
}

int     __libc_TLSSet(int iIndex, void *pvValue)
{
    return 0;
}

