/* $Id: thread_internals.c 1287 2004-03-11 03:05:55Z bird $ */
/** @file
 *
 * LIBC - Thread internals.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#undef NDEBUG
#include <assert.h>
#include <string.h>
#include <emx/umalloc.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/thread.h>
#include <InnoTekLIBC/backend.h>


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** Preallocated thread structure. */
static __LIBC_THREAD    gPreAllocThrd;
/** Flags whether or not gPreAllocThrd is used. */
static int              gfPreAllocThrd;


/**
 * Initialize a thread structure.
 *
 * @param   pThrd   Pointer to the thread structure which is to be initialized.
 */
static void threadInit(__LIBC_PTHREAD pThrd)
{
    memset(pThrd, 0, sizeof(*pThrd));
    pThrd->iRand = 1;
    __libc_Back_threadInit(pThrd);
}


__LIBC_PTHREAD __libc_threadCurrentSlow(void)
{
    if (!*__libc_gpTLS)
    {
        __LIBC_PTHREAD  pThrd;
        /*
         * Setup a temporary thread block on the stack so _hmalloc()
         * can't end up calling us recursivly if something goes wrong
         */
        __LIBC_THREAD   Thrd;
        threadInit(&Thrd);
        *__libc_gpTLS   = &Thrd;

        if (!__lxchg(&gfPreAllocThrd, 1))
            pThrd = &gPreAllocThrd;
        else
        {
            pThrd = _hmalloc(sizeof(__LIBC_THREAD));
            assert(pThrd); /* deep, deep, depp, shit. abort the process in a controlled manner... */
        }
        *pThrd = Thrd;

        *__libc_gpTLS = pThrd;
    }

    return *__libc_gpTLS;
}


__LIBC_PTHREAD __libc_threadAlloc(void)
{
    /*
     * No need to use the pre allocated here since the current thread will
     * most likely be using that one!
     */
    __LIBC_PTHREAD pThrd = _hmalloc(sizeof(__LIBC_THREAD));
    if (pThrd)
        threadInit(pThrd);
    return pThrd;
}


void  __libc_threadFree(__LIBC_PTHREAD pThrd)
{
    /*
     * Clean up members.
     */
    __libc_Back_threadCleanup(pThrd);

    /*
     * Release storage.
     */
    if (pThrd != &gPreAllocThrd)
        free(pThrd);
    else
        __lxchg(&gfPreAllocThrd, 0);
}

