/* beginth.c (emx+gcc) -- Copyright (c) 1992-1998 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSEXCEPTIONS
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/thread.h>
#include <InnoTekLIBC/backend.h>


/**
 * Thread wrapper routine.
 *
 * @param   pThrd   Pointer to thread structure allocated for this thread.
 */
static void _System threadWrapper(__LIBC_PTHREAD pThrd)
{
    int                         tid;
    EXCEPTIONREGISTRATIONRECORD reg;
    FS_VAR();

    __libc_Back_threadStartup(&reg);
    pThrd->u.startup.pfnStart(pThrd->u.startup.pvArg);

    FS_SAVE_LOAD();
    tid = _gettid();
    __libc_threadFree(pThrd);
    __libc_Back_threadEnd(&reg);
    for (;;)
        DosExit(tid == 1 ? EXIT_PROCESS : EXIT_THREAD, 0);
}


int _beginthread(void (*pfnStart)(void *), void *pvStack, unsigned cbStack, void *pvArg)
{
    APIRET          rc;
    TID             tid;
    __LIBC_PTHREAD  pThrd;
    FS_VAR();

    /*
     * Allocate a thread structure.
     */
    pThrd = __libc_threadAlloc();
    if (!pThrd)
    {
        errno = ENOMEM;
        return -1;
    }

    /*
     * Set the startup thread info and create a new thread.
     */
    pThrd->u.startup.pfnStart = pfnStart;
    pThrd->u.startup.pvArg    = pvArg;
    FS_SAVE_LOAD();
    rc = DosCreateThread(&tid,
                         (PFNTHREAD)threadWrapper,
                         (ULONG)pThrd,
                         CREATE_READY | STACK_COMMITTED,
                         cbStack);
    FS_RESTORE();
    if (!rc)
        return tid;

    /*
     * Set errno and cleanup.
     */
    if (rc == ERROR_NOT_ENOUGH_MEMORY)
        errno = ENOMEM;
    else if (rc == ERROR_MAX_THRDS_REACHED)
        errno = EAGAIN;
    else
        errno = EINVAL;
    __libc_threadFree(pThrd);
    return -1;
}


void _endthread(void)
{
    __LIBC_PTHREAD  pThrd = __libc_threadCurrent();
    int             tid;
    FS_VAR();

    FS_SAVE_LOAD();
    tid = _gettid();
    __libc_threadFree(pThrd);
    for (;;)
        DosExit(tid == 1 ? EXIT_PROCESS : EXIT_THREAD, 0);
}
