/* sys/sigactio.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __sigaction (int signo, const struct sigaction *iact,
                 struct sigaction *oact)
{
  struct sigaction output, *s;
  thread_data *tp;

  if (signo < 1 || signo >= NSIG || signo == SIGKILL || !_sys_sig_valid[signo])
    {
      errno = EINVAL;
      return -1;
    }
  if (signo == SIGKILL && iact != NULL)
    {
      errno = EINVAL;
      return -1;
    }
  tp = SYS_THREAD;
  if (tp == NULL)
    {
      errno = EINVAL;
      return -1;
    }
  s = &tp->signals[signo];
  output = *s;
  if (iact != NULL)
    {
      *s = *iact;
      if ((s->sa_handler == SIG_DFL
           && sig_info[signo].dfl_action != ST_IGNORE)
          || s->sa_handler == SIG_IGN)
        __sigdelset (&tp->sig_pending, signo);
    }

  if (oact != NULL)
    *oact = output;
  return 0;
}
