/* mkdir.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <errno.h>
#include <emx/syscalls.h>

int mkdir (const char *name, long mode)
{
  (void)mode;                     /* Keep the compiler happy */
  if (__mkdir (name) == 0)
    return 0;
  else
    {
      if (errno == EACCES)
        errno = EEXIST;
      return -1;
    }
}
