/* getvol.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <emx/thread.h>
#include <emx/syscalls.h>
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2emx.h>

char *_getvol (char drive)
{
#if defined (__MT__)
  struct _thread *tp = _thread();
#define result (tp->_th_vollabel)
#else
  static char result[12];
#endif

  if (drive == 0)
    drive = _getdrive ();
  if (drive >= 'a' && drive <= 'z')
    drive += 'A' - 'a';
  if (!(drive >= 'A' && drive <= 'Z'))
    return NULL;

  ULONG rc;
  FSINFO fsinfo;

  memset (&fsinfo, 0, sizeof (fsinfo));
  rc = DosQueryFSInfo (drive - 'A' + 1, FSIL_VOLSER, &fsinfo,
                       sizeof (fsinfo));
  if (rc != 0)
    return NULL;
  strcpy (result, fsinfo.vol.szVolLabel);

  return result;
}
