/* tell.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <io.h>
#include <errno.h>
#include <emx/io.h>
#include <emx/syscalls.h>

long tell (int handle)
{
  int *pflags, *pla;
  long n;

  if ((pflags = _fd_flags (handle)) == NULL
      || (pla = _fd_lookahead (handle)) == NULL)
    {
      errno = EBADF;
      return -1;
    }
  n = (long)__lseek (handle, 0L, SEEK_CUR);
  if (n == -1)
    return n;
  if (*pla >= 0 || (*pflags & F_EOF))
    --n;
  return n;
}
