/* pipe.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <io.h>
#include <fcntl.h>
#include <errno.h>
#include <emx/io.h>
#include <emx/syscalls.h>

extern int _fmode_bin;
int _pipe_size;

int pipe (int *two_handles)
{
  int *pflags1, *pflags2;

  if (__pipe (two_handles, (_pipe_size != 0 ? _pipe_size : 8192)) != 0)
    return -1;
  pflags1 = _fd_init (two_handles[0]);
  if (pflags1 == NULL)
    pflags2 = NULL;
  else
    pflags2 = _fd_init (two_handles[1]);
  if (pflags2 == NULL)
    {
      __close (two_handles[0]);
      __close (two_handles[1]);
      errno = EMFILE;
      return -1;
    }
  *pflags1 = O_RDONLY | F_PIPE;
  *pflags2 = O_WRONLY | F_PIPE;
  if (_fmode_bin == 0)
    {
      *pflags1 |= O_TEXT;
      *pflags2 |= O_TEXT;
    }
  return 0;
}
