/* fcloseal.c (emx+gcc) -- Copyright (c) 1990-1998 by Eberhard Mattes */

#include <stdio.h>
#include <emx/io.h>

int fcloseall (void)
{
  int i, n, start;
  char ok;
  struct streamvec *sv;

  n = 0; ok = 1;
  for (sv = &_streamvec_head; sv != NULL; sv = sv->next)
    {
      if (sv->vec == _streamv)
        start = 3;              /* Keep stdin, stdout, stderr */
      else
        start = 0;
      for (i = start; i < sv->n; ++i)
        if (sv->vec[i]._flags & _IOOPEN)
          {
            if (fclose (&sv->vec[i]) == 0)
              ++n;
            else
              ok = 0;
          }
      start = 0;
    }
  return (ok ? n : EOF);
}
