/* ctype.h (emx+gcc) */

#ifndef _CTYPE_H
#define _CTYPE_H

#if defined (__cplusplus)
extern "C" {
#endif

extern unsigned char _ctype[];

#define _UPPER  0x01
#define _LOWER  0x02
#define _DIGIT  0x04
#define _XDIGIT 0x08
#define _CNTRL  0x10
#define _SPACE  0x20
#define _PUNCT  0x40
#define _PRINT  0x80

#if defined (__cplusplus)

extern inline int isalnum (int _c)
  { return (_ctype+1)[_c] & (_UPPER|_LOWER|_DIGIT); }
extern inline int isalpha (int _c)
  { return (_ctype+1)[_c] & (_UPPER|_LOWER); }
extern inline int iscntrl (int _c)
  { return (_ctype+1)[_c] & (_CNTRL); }
extern inline int isdigit (int _c)
  { return (_ctype+1)[_c] & (_DIGIT); }
extern inline int isgraph (int _c)
  { return (_ctype+1)[_c] & (_PUNCT|_UPPER|_LOWER|_DIGIT); }
extern inline int islower (int _c)
  { return (_ctype+1)[_c] & (_LOWER); }
extern inline int isprint (int _c)
  { return (_ctype+1)[_c] & (_PRINT); }
extern inline int ispunct (int _c)
  { return (_ctype+1)[_c] & (_PUNCT); }
extern inline int isspace (int _c)
  { return (_ctype+1)[_c] & (_SPACE); }
extern inline int isupper (int _c)
  { return (_ctype+1)[_c] & (_UPPER); }
extern inline int isxdigit (int _c)
  { return (_ctype+1)[_c] & (_XDIGIT); }

#else

#define isalnum(c)  ((_ctype+1)[(unsigned char)c] & (_UPPER|_LOWER|_DIGIT))
#define isalpha(c)  ((_ctype+1)[(unsigned char)c] & (_UPPER|_LOWER))
#define iscntrl(c)  ((_ctype+1)[(unsigned char)c] & (_CNTRL))
#define isdigit(c)  ((_ctype+1)[(unsigned char)c] & (_DIGIT))
#define isgraph(c)  ((_ctype+1)[(unsigned char)c] & (_PUNCT|_UPPER|_LOWER|_DIGIT))
#define islower(c)  ((_ctype+1)[(unsigned char)c] & (_LOWER))
#define isprint(c)  ((_ctype+1)[(unsigned char)c] & (_PRINT))
#define ispunct(c)  ((_ctype+1)[(unsigned char)c] & (_PUNCT))
#define isspace(c)  ((_ctype+1)[(unsigned char)c] & (_SPACE))
#define isupper(c)  ((_ctype+1)[(unsigned char)c] & (_UPPER))
#define isxdigit(c) ((_ctype+1)[(unsigned char)c] & (_XDIGIT))

int (isalnum)(int);
int (isalpha)(int);
int (iscntrl)(int);
int (isdigit)(int);
int (isgraph)(int);
int (islower)(int);
int (isprint)(int);
int (ispunct)(int);
int (isspace)(int);
int (isupper)(int);
int (isxdigit)(int);

int toupper (int);
int tolower (int);
int _toupper (int);
int _tolower (int);

#endif

#if !defined (_CTYPE_FUN)
extern __inline__ int _toupper (int _c) { return (_c-'a'+'A'); }
extern __inline__ int _tolower (int _c) { return (_c-'A'+'a'); }
extern __inline__ int toupper(int _c)
  {return (islower(_c) ? _toupper(_c) : _c);}
extern __inline__ int tolower(int _c)
  {return (isupper(_c) ? _tolower(_c) : _c);}
#endif

#if !defined (__STRICT_ANSI__) && !defined (_POSIX_SOURCE)

int (toascii)(int);
int (isascii)(int);

#define isascii(c)  ((unsigned)(c) <= 0x7f)
#define toascii(c)  ((c) & 0x7f)

#endif


#if defined (__cplusplus)
}
#endif

#endif /* not _CTYPE_H */
