/* exit.c (emx+gcc) -- Copyright (c) 1990-1998 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <emx/startup.h>
#include <emx/libclog.h>

void (*_atexit_v[64])(void);
int _atexit_n = 0;

void _STD(exit) (int ret)
{
  LIBCLOG_ENTER("ret=%d\n", ret);
  int i;

  for (i = _atexit_n-1; i >= 0; --i)
    {
      LIBCLOG_MSG("calling _atexit[%d] %p\n", i, _atexit_v[i]);
      _atexit_v[i]();
    }
  _CRT_term ();
  LIBCLOG_MSG("calling _exit\n");
  _exit (ret);
}
