/* sys/read.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
                        -- Copyright (c) 2003 by Knut St. Osmunden */

#include "libc-alias.h"
#define INCL_FSMACROS
#define INCL_FPCWMACROS
#define INCL_ERRORS
#include <os2emx.h>
#include <errno.h>
#include <stdlib.h>
#include <memory.h>
#include <sys/fcntl.h>
#include <emx/umalloc.h>
#include <emx/io.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __read (int handle, void *buf, size_t cbToRead)
{
    ULONG   rc;
    PLIBCFH pFH;
    ULONG   cbRead;

    /*
     * Get filehandle.
     */
    pFH = __libc_FH(handle);
    if (!pFH)
    {
        errno = EBADF;
        return -1;
    }

    if (!pFH->pOps)
    {
        /*
         * Standard OS/2 filehandle.
         */
        void   *pvBuf_safe = NULL;
        FS_VAR();
        FSCW_VAR();

        /*
         * Devices doesn't like getting high addresses.
         *      Allocate a buffer in the low heap.
         */
        if (    (pFH->fFlags & F_TYPEMASK) == F_DEV
            &&  (unsigned)buf >= 512*1024*1024)
        {
            pvBuf_safe = _lmalloc(cbToRead);
            if (!pvBuf_safe)
                return ERROR_NOT_ENOUGH_MEMORY;
            memcpy(pvBuf_safe, buf, cbToRead);
        }

        FS_SAVE_LOAD();
        FSCW_SAVE();
        rc = DosRead(handle, pvBuf_safe ? pvBuf_safe : buf, cbToRead, &cbRead);
        FSCW_RESTORE();
        FS_RESTORE();
        if (pvBuf_safe)
        {
            memcpy(buf, pvBuf_safe, cbToRead);
            free(pvBuf_safe);
        }
    }
    else
    {
        /*
         * Non-standard filehandle.
         */
        rc = pFH->pOps->pfnRead(pFH, handle, buf, cbToRead, &cbRead);
    }

    /*
     * Handle errors.
     */
    if (rc)
    {
        _sys_set_errno(rc);
        /* If we don't have read access, EBADF should be returned, not EACCES. */
        if (    errno == EACCES
            &&  (pFH->fFlags & O_ACCMODE) != O_RDONLY
            &&  (pFH->fFlags & O_ACCMODE) != O_RDWR)
            errno = EBADF;
        return -1;
    }

    return cbRead;
}
