/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Convert an ASCIIZ codepage to UCS-2 form and convert POSIX codepage
    names to names understood by OS/2 Unicode API.
*/

#include <string.h>
#include <uconv.h>
#include <emx/locale.h>

/* Convert an encoding name to te form understood by UniCreateUconvObject.  */
void __convert_codepage (const char *cp, UniChar *ucp)
{
  static const struct _cp_aliases
  {
      const char *pszAlias;
      const char *pszIBM;
  } aAliases[] =
  {   /* pszAlias   ->      pszIBM */
      { "SYSTEM",           ""         },
      { "ASCII",            "IBM-367"  },
      { "UTF-8",            "IBM-1208" },
      { "UTF-2",            "IBM-1200" },
      { "UTF-2LE",          "IBM-1200" },
      { "EUC-JP",           "IBM-954"  },
      { "EUC-KR",           "IBM-970"  },
      { "EUC-TW",           "IBM-964"  },
      { "EUC-CN",           "IBM-1383" },
      { "BIG5",             "IBM-950"  },
  };
  int       i;
  size_t    sl;

  /*
   * Try aliases.
   */
  for (i = 0; i < sizeof(aAliases) / sizeof(aAliases[0]); i++ )
    {
      if (!strcmp(cp, aAliases[i].pszAlias))
        {
          cp = aAliases[i].pszIBM;
          while ((*ucp++ = *cp++) != 0)
              /* nada */;
          return;
        }
    }

  /*
   * Generic transformations:
   *    CPxxxx     -> IBM-xxxx
   *    ISO-xxxx-x -> ISOxxxx-x
   */
  sl = 0;
  /* Transform CPXXX naming style to IBM-XXX style */
  if ((cp[0] == 'C' || cp[0] == 'c')
   && (cp[1] == 'P' || cp[1] == 'p'))
    {
      ucp[sl++] = 'I';
      ucp[sl++] = 'B';
      ucp[sl++] = 'M';
      ucp[sl++] = '-';
      cp += 2;
    }
  /* Transform ISO-XXXX-X naming style to ISOXXXX-X style */
  else if ((cp[0] == 'I' || cp[0] == 'i')
        && (cp[1] == 'S' || cp[1] == 's')
        && (cp[2] == 'O' || cp[2] == 'o')
        && (cp[3] == '-'))
  {
      ucp[sl++] = 'I';
      ucp[sl++] = 'S';
      ucp[sl++] = 'O';
      cp += 4;
  }

  /* copy the rest of the string. */
  while (*cp != '\0')
    ucp[sl++] = *cp++;
  ucp[sl] = 0;
}
