/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Character type querying.
*/

#ifndef _CTYPE_H_
#define	_CTYPE_H_

#include <sys/cdefs.h>
#include <sys/locale.h>

__BEGIN_DECLS
int     isalnum(int);
int     isalpha(int);
int     iscntrl(int);
int     isdigit(int);
int     isgraph(int);
int     islower(int);
int     isprint(int);
int     ispunct(int);
int     isspace(int);
int     isupper(int);
int     isxdigit(int);
int     toupper(int);
int     tolower(int);

#if __XSI_VISIBLE
int     _toupper(int);
int     _tolower(int);
int     isascii(int);
int     toascii(int);
#endif

#if __BSD_VISIBLE
/* @todo int	digittoint(int); */
int     isblank(int);
int	ishexnumber(int);
/* @todo int	isideogram(int); */
int	isnumber(int);
/* @todo int	isphonogram(int); */
/* @todo int	isrune(int); */
/* @todo int	isspecial(int); */
#endif
__END_DECLS

#define isalnum(c)  __istype((c), (__UPPER)|(__LOWER)|(__DIGIT))
#define isalpha(c)  __istype((c), (__UPPER)|(__LOWER))
#define iscntrl(c)  __istype((c), (__CNTRL))
#define isdigit(c)  __istype((c), (__DIGIT))
#define isgraph(c)  __istype((c), (__PUNCT)|(__UPPER)|(__LOWER)|(__DIGIT))
#define islower(c)  __istype((c), (__LOWER))
#define isprint(c)  __istype((c), (__PRINT))
#define ispunct(c)  __istype((c), (__PUNCT))
#define isspace(c)  __istype((c), (__SPACE))
#define isupper(c)  __istype((c), (__UPPER))
#define isxdigit(c) __istype((c), (__XDIGIT))
#define toupper(c)  __toupper(c)
#define tolower(c)  __tolower(c)

#if __XSI_VISIBLE
#define _toupper(_c) __toupper(c)
#define _tolower(_c) __tolower(c)
#define	isascii(c)   (((c) & ~0x7F) == 0)
#define	toascii(c)   ((c) & 0x7F)
#endif

#if __BSD_VISIBLE
#define isblank(c)      __istype((c), (__BLANK))
#define ishexnumber(c)  __istype((c), (__XDIGIT))
#define isnumber(c)     __istype((c), (__DIGIT))
#endif


#if !defined(_DONT_USE_CTYPE_INLINE_) && \
    (defined(_USE_CTYPE_INLINE_) || defined(__GNUC__) || defined(__cplusplus))

__BEGIN_DECLS
static inline int __istype(int _c, unsigned _f)
{ return __locale_ctype.cflags [_c & 0xff] & (_f); }
static inline int __toupper(int _c)
{ return __locale_ctype.upcase [_c & 0xff]; }
static inline int __tolower(int _c)
{ return __locale_ctype.locase [_c & 0xff]; }
__END_DECLS

#else

__BEGIN_DECLS
int __istype(int, unsigned);
int __toupper(int);
int __tolower(int);
__END_DECLS

#endif

#endif
