/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Usually these routines are not needed (they are inline), but
    for cases when a program instead of including ctype.h blindly
    declares them with "extern", they will be linked in.
*/

#define _DONT_USE_CTYPE_INLINE_
#include "libc-alias.h"
#include <sys/locale.h>
#include <ctype.h>

#undef isalnum
int isalnum(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER|__DIGIT); }

#undef isalpha
int isalpha(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER); }

#undef iscntrl
int iscntrl(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__CNTRL); }

#undef isdigit
int isdigit(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__DIGIT); }

#undef isgraph
int isgraph(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT|__UPPER|__LOWER|__DIGIT); }

#undef islower
int islower(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__LOWER); }

#undef isprint
int isprint(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PRINT); }

#undef ispunct
int ispunct(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT); }

#undef isspace
int isspace(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__SPACE); }

#undef isupper
int isupper(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER); }

#undef isxdigit
int isxdigit(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__XDIGIT); }

#undef isblank
int isblank(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__BLANK); }

#undef ishexnumber
int ishexnumber(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__XDIGIT); }

#undef isnumber
int isnumber(int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__DIGIT); }

#undef toascii
int toascii(int _c)
{ return _c & 0x7f; }

#undef isascii
int isascii(int _c)
{ return (_c & 0x80) != 0; }


