/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Default character type bits for "C" locale (default = ASCII).
*/

#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <sys/locale.h>
#include <string.h>

struct __locale_ctype __locale_ctype =
{
  cflags:
  {
    0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020,
    0x8020, 0x8068, 0x8028, 0x8028, 0x8028, 0x8028, 0x8020, 0x8020,
    0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020,
    0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020, 0x8020,
    0x8848, 0x8c10, 0x8c10, 0x8c10, 0xac10, 0x8c10, 0x8c10, 0x8c10,
    0x8c10, 0x8c10, 0x8c10, 0xac10, 0x8c10, 0x8c10, 0x8c10, 0x8c10,
    0x9e84, 0x9e84, 0x9e84, 0x9e84, 0x9e84, 0x9e84, 0x9e84, 0x9e84,
    0x9e84, 0x9e84, 0x8c10, 0x8c10, 0xac10, 0xac10, 0xac10, 0x8c10,
    0x8c10, 0x8f81, 0x8f81, 0x8f81, 0x8f81, 0x8f81, 0x8f81, 0x8f01,
    0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01,
    0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01, 0x8f01,
    0x8f01, 0x8f01, 0x8f01, 0x8c10, 0x8c10, 0x8c10, 0xac10, 0x8c10,
    0xac10, 0x8f82, 0x8f82, 0x8f82, 0x8f82, 0x8f82, 0x8f82, 0x8f02,
    0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02,
    0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02, 0x8f02,
    0x8f02, 0x8f02, 0x8f02, 0x8c10, 0xac10, 0x8c10, 0xac10, 0x8020,
  },
  upcase:
  {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
    0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
  },
  locase:
  {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
    0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
  },
  mbcsprefix:
  {
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
  },
  uconv: 0,
  locale: 0,
  mbcs: 0x0
};

int tolower (int _c);
int toupper (int _c);

int tolower (int _c)
{ return __locale_ctype.locase [_c & 0xff]; }

int toupper (int _c)
{ return __locale_ctype.upcase [_c & 0xff]; }


#if 0 /* code for regenerating that table. */

#define __INTERNAL_DEFS
#include <locale.h>
#include <ctype.h>
#include <stdio.h>

int main()
{
    int i;
    setlocale(LC_CTYPE, "en_US");
    setlocale(LC_CTYPE, "C");
    printf("/*\n"
           "    Locale support implementation through OS/2 Unicode API.\n"
           "    Copyright (c) 2003 InnoTek Systemberatung GmbH\n"
           "\n"
           "    For conditions of distribution and use, see the file COPYING.\n"
           "\n"
           "    Default character type bits for \"C\" locale.\n"
           "*/\n"
           "\n"
           "#define __INTERNAL_DEFS\n"
           "#include \"libc-alias.h\"\n"
           "#include <sys/locale.h>\n"
           "#include <string.h>\n"
           "\n"
           "\n"
           "struct __locale_ctype __locale_ctype =\n"
           "{\n"
           "  cflags:\n"
           "  {");
    for (i = 0; i < /*sizeof(__locale_ctype.cflags) / sizeof(__locale_ctype.cflags[0])*/ 128; i++)
    {
        if (i % 8)
            printf("0x%03x, ", (int)__locale_ctype.cflags[i]);
        else
            printf("\n    0x%03x, ", (int)__locale_ctype.cflags[i]);
    }
    printf("\n  },\n"
           "  upcase:\n"
           "  {");
    for (i = 0; i < /*sizeof(__locale_ctype.upcase) / sizeof(__locale_ctype.upcase[0]) */ 128; i++)
    {
        if (i % 8)
            printf("0x%02x, ", (int)__locale_ctype.upcase[i]);
        else
            printf("\n    0x%02x, ", (int)__locale_ctype.upcase[i]);
    }
    printf("\n  },\n"
           "  locase:\n"
           "  {");
    for (i = 0; i < /*sizeof(__locale_ctype.locase) / sizeof(__locale_ctype.locase[0])*/ 128; i++)
    {
        if (i % 8)
            printf("0x%02x, ", (int)__locale_ctype.locase[i]);
        else
            printf("\n    0x%02x, ", (int)__locale_ctype.locase[i]);
    }
    printf("\n  },\n"
           "  mbcsprefix:\n"
           "  {");
    for (i = 0; i < sizeof(__locale_ctype.mbcsprefix) / sizeof(__locale_ctype.mbcsprefix[0]); i++)
    {
        if (i % 8)
            printf("0x%02x, ", (int)__locale_ctype.mbcsprefix[i]);
        else
            printf("\n    0x%02x, ", (int)__locale_ctype.mbcsprefix[i]);
    }
    printf("\n  },\n"
           "  uconv: 0,\n"
           "  locale: 0,\n"
           "  mbcs: 0x%x\n"
           "};\n",
           (int)__locale_ctype.mbcs);

    return 0;
}

#endif
