/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.comm;

import com.ibm.comm.OS2SerialPort;
import com.ibm.comm.OS2SleepTime;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

public class OS2SerialNotifyThread
extends Thread {
    private OS2SerialPort sPort = null;
    private int Handle = 0;
    private SerialPortEventListener lsnr = null;
    private boolean bThreadStop;
    private boolean OnDataAvail = false;
    private boolean OnOutputEmpty = false;
    private boolean OnCts = false;
    private boolean OnDsr = false;
    private boolean OnRi = false;
    private boolean OnCd = false;
    private boolean OnOverrun = false;
    private boolean OnParityError = false;
    private boolean OnFrameError = false;
    private boolean OnBreakInt = false;

    public OS2SerialNotifyThread(OS2SerialPort oS2SerialPort, int n, SerialPortEventListener serialPortEventListener) {
        this.sPort = oS2SerialPort;
        this.Handle = n;
        this.lsnr = serialPortEventListener;
        this.bThreadStop = false;
    }

    public void setStopFlag() {
        this.bThreadStop = true;
    }

    public void run() {
        while (!this.bThreadStop) {
            try {
                OS2SleepTime oS2SleepTime = new OS2SleepTime();
                int n = oS2SleepTime.GetSleepTime();
                Thread.sleep(n);
                this.CheckForEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void CheckForEvent() {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n3 = this._GetCommStatus(this.Handle);
        int n6 = n3 & 0x80;
        if (n6 == 128) {
            n4 = this._GetCommError(this.Handle);
        }
        n5 = this._GetLineStatus(this.Handle);
        if (this.OnDataAvail) {
            n2 = this._QueryDataAvail(this.Handle);
            n = this.sPort.QueryNewData();
            if (n2 > 0) {
                this.constructEvent(1, n == 0, n != 0);
            }
        }
        if (this.OnOutputEmpty && (n2 = n3 & 4) == 4) {
            this.constructEvent(2, bl, bl2);
        }
        if (this.OnCts && (n2 = n3 & 8) == 8) {
            this.sPort.setPortValues();
            this.constructEvent(3, !this.sPort.isCTS(), this.sPort.isCTS());
        }
        if (this.OnDsr && (n2 = n3 & 0x10) == 16) {
            this.sPort.setPortValues();
            this.constructEvent(4, !this.sPort.isDSR(), this.sPort.isDSR());
        }
        if (this.OnRi && (n2 = n3 & 0x100) == 256) {
            this.sPort.setPortValues();
            this.constructEvent(5, !this.sPort.isRI(), this.sPort.isRI());
        }
        if (this.OnCd && (n2 = n3 & 0x20) == 32) {
            this.sPort.setPortValues();
            this.constructEvent(6, !this.sPort.isCD(), this.sPort.isCD());
        }
        if (this.OnOverrun && (n = n4 & 1) == 1 & (n2 = n3 & 0x80) == 128) {
            this.constructEvent(7, bl, bl2);
        }
        if (this.OnParityError && (n = n4 & 4) == 4 & (n2 = n3 & 0x80) == 128) {
            this.constructEvent(8, bl, bl2);
        }
        if (this.OnFrameError && (n = n4 & 8) == 8 & (n2 = n3 & 0x80) == 128) {
            this.constructEvent(9, bl, bl2);
        }
        if (this.OnBreakInt && (n2 = n3 & 0x40) == 64) {
            this.sPort.setPortValues();
            this.constructEvent(10, bl, bl2);
        }
    }

    public void AddNotify(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.OnDataAvail = bl;
                break;
            }
            case 2: {
                this.OnOutputEmpty = bl;
                break;
            }
            case 3: {
                this.OnCts = bl;
                break;
            }
            case 4: {
                this.OnDsr = bl;
                break;
            }
            case 5: {
                this.OnRi = bl;
                break;
            }
            case 6: {
                this.OnCd = bl;
                break;
            }
            case 7: {
                this.OnOverrun = bl;
                break;
            }
            case 8: {
                this.OnParityError = bl;
                break;
            }
            case 9: {
                this.OnFrameError = bl;
                break;
            }
            case 10: {
                this.OnBreakInt = bl;
            }
        }
    }

    private void constructEvent(int n, boolean bl, boolean bl2) {
        if (this.lsnr != null) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this.sPort, n, bl, bl2);
            this.lsnr.serialEvent(serialPortEvent);
        }
    }

    private native int _GetCommStatus(int var1);

    private native int _GetCommError(int var1);

    private native int _GetLineStatus(int var1);

    private native int _QueryDataAvail(int var1);
}

