class TestThread extends Thread
{
    private boolean doExit;

    TestThread(boolean doExit) { this.doExit = doExit; }
 
    public void run()
    {
        System.out.println("Started thread " + Thread.currentThread() + "," + Thread.currentThread().getId() + ": doExit=" + doExit);

        try
        {
            if (doExit)
            {
                System.out.println("EXITING");
                System.exit(1);
                //Runtime.getRuntime().halt(1);
            }
            else
            {
                int n = 1234;
                for (int i = 0; i < 2000000000; ++i)
                {
                    if (n == 0) n = 1234;
                    n = n * (n+1) * (n+2);
                }
                System.out.println("RESULT " + n);
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        System.out.println("Finished thread " + Thread.currentThread() + "," + Thread.currentThread().getId());
    }
}

public class test
{
    public static void main(String args[])
    {
        System.out.println("Started main thread " + Thread.currentThread() + "," + Thread.currentThread().getId());

        TestThread t1 = new TestThread(false);
        t1.start();

        TestThread t2 = new TestThread(true);
        t2.start();

        //System.out.println("EXITING main");
        //System.exit(1);

        try
        {
            t1.join();
            t2.join();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }


        System.out.println("Finished main thread " + Thread.currentThread() + "," + Thread.currentThread().getId());
    }
}
