import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * Output the time in several timezones.
 *  
 * @author estima
 */
public class TimeTest {

	/** A time formatter.*/
	private static SimpleDateFormat format = 
						new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	/**
	 * Print the date in the current timezone.
	 */
	private static final void printDate() {
		format.setTimeZone(TimeZone.getDefault());
		
		System.out.println(
				format.format(new Date()) + " " 
						+ TimeZone.getDefault().getID());		
	}
	
	/**
	 * Call to display in every time zone (or a specified list).
	 * 
	 * @param args null or a list of timezones separated by ','-
	 */
	public static void main(final String[] args) {
		
		System.out.println("BEFORE SET TIMEZONE");
		System.out.println(
				format.format(new Date()) + " " 
						+ TimeZone.getDefault().getID());
		
		System.out.println("\n");
		String[] tzs;
		
		if (args.length > 0) {
			tzs = args[0].split(",");						
		} else { 		
			tzs = TimeZone.getAvailableIDs();
		}
		
		for (String t: tzs) {
			TimeZone.setDefault(TimeZone.getTimeZone(t));
			printDate();
		}
		
	}
}
