/***
 This file belongs to the Gotcha! distribution.
 Copyright (C) 1998-2002 Thorsten Thielen <thth@c2226.de>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
#include <direct.h>
#include <uconv.h>
#include "settings.h"
#include "ctype.h"

#include "./settings/thth_settings.cpp"

PSZ SETTINGS::pszPageTab[COUNT_PAGES]; /* = {
    "Saving", "Snapshot window", "Misc", "Language" };
    // FIXME nls*/

bool saveum = FALSE;
SWP swpDef = { 0,0,0, 98,66, 0,0,0,0 };
SWP swpDefSSW = { 0,0,0, 10,10, 0,0,0,0 };
USHORT ausDef[7] = { 0 };
USHORT ausDefSSW[7] = { 0 };
BOOL  g_installer = FALSE;

ImageFormatInfo Settings::ifi[BMF_INVALID] =
{
    { TRUE, BMF_JPG,   "JPEG Interchange File Format (jpg)", "jpg", "JPG" },
    { TRUE, BMF_PNG,   "Portable Network Graphics (png)", "png", "PNG" },
    { TRUE, BMF_OS20,  "OS/2 Bitmap 2.0 (bmp)", "bmp", "Bitmap" },
    { TRUE, BMF_TIF,   "Microsoft/Aldus Tagged Image File Format (tif)", "tif", "TIFF" },
    { TRUE, BMF_TGA,   "Truevision Targa/Vista (tga)", "tga", "Targa" },
    { TRUE, BMF_PCX,   "ZSoft PC Paintbrush Image Format (pcx)", "pcx", "PCX" },
    { TRUE, BMF_GIF,   "Portable Anymap (pnm)", "pnm", "PNM" },
    { TRUE, BMF_PBM,   "Portable Pixel-map (ppm)", "ppm", "PPM" },
    { TRUE, BMF_JP2,   "Jpeg 2000 (provided by the Open Source OpenJPEG library) (jp2)", "jp2", "JP2" },
    { TRUE, BMF_DIB,   "Device Independent Bitmap (dib)", "dib", "DIB" }
};


PTHTH_SE apse[] =
{
    new THTH_SES (SEI_SAVEFILE, "Save", "Filename", "gotcha.png"),
    new THTH_SES (SEI_FORCESAVEFILE, "Save", "ForceSaveFilename", "force.png"),
    new THTH_SEL (SEI_SAVESTYLE, "Save", "Style", SAVESTYLE_FILE),
    new THTH_SEL (SEI_FILEFORMAT, "Save", "FileFormat", BMF_PNG),
    new THTH_SEL (SEI_FILESAVESTYLE, "Save", "FileSaveStyle", FSS_PROMPT),

    new THTH_SES (SEI_NUMSAVEDIR, "Save", "NumSaveDir", ""),
    new THTH_SEF (SEI_HIDEWINDOW, "Extras", "HideWindow", TRUE),
    new THTH_SEF (SEI_AUTOADDEXTENSION, "Extras", "AutoaddExtension", TRUE),
    new THTH_SEF (SEI_CONFIRMOVERWRITE, "Extras", "ConfirmOverwrite", TRUE),
    new THTH_SEF (SEI_DOSOUND, "Extras", "DoSound", TRUE),

    new THTH_SEF (SEI_DELAYEDCAPTURE, "Extras", "DelayedCapture", FALSE),
    new THTH_SEF (SEI_DELAYCOUNTDOWN, "Extras", "DelayCountdown", FALSE),
    new THTH_SEL (SEI_DELAYTIME, "Extras", "DelayTime", 5),
    new THTH_SEF (SEI_SERIALCAPTURE, "Extras", "SerialCapture", FALSE),
    new THTH_SEL (SEI_SERIALTIME, "Extras", "SerialTime", 10),
#ifdef _QUIET_
    new THTH_SEL (SEI_SSWCAPTURETYPE, "Extras", "CaptureType", CAP_SCREEN),
    new THTH_SEF (SEI_SNAPSHOTWINDOW, "Snapshot", NULL, NULL),
#else
    new THTH_SEF (SEI_SNAPSHOTWINDOW, "Snapshot", "Enable", FALSE),
    new THTH_SEL (SEI_SSWCAPTURETYPE, "Snapshot", "CaptureType", CAP_SCREEN),
    new THTH_SEF (SEI_SSWHIDE, "Snapshot", "Hide", TRUE),
    new THTH_SEF (SEI_SSWALWAYSONTOP, "Snapshot", "AlwaysOnTop", TRUE),
#endif
    new THTH_SEF (SEI_IDLEPRIORITY, "Extras", "IdlePriority", FALSE),

    new THTH_SEB (SEI_SWP, "Window", "SWP", &swpDef, sizeof (swpDef)),
    new THTH_SEB (SEI_US, "Window", "US", &ausDef, sizeof (ausDef)),
#ifndef _QUIET_
    new THTH_SEB (SEI_SWPSSW, "Snapshot", "SWP", &swpDefSSW, sizeof (swpDefSSW)),
    new THTH_SEB (SEI_USSSW, "Snapshot", "US", &ausDefSSW, sizeof (ausDefSSW)),
#endif
    new THTH_SES (SEI_LANGUAGE,     "Language", "Program", PSZ_DEFAULTLANGUAGEMOD),
    new THTH_SES (SEI_LANGUAGEHELP, "Language", "Help", PSZ_DEFAULTLANGUAGEHELP),

    new THTH_SEF (SEI_UPDATE178DONE, "Extras", "Update178Done", FALSE),

    NULL,
};

// ** Settings ************************************************************ /*FOLD00*/

Settings :: Settings (VOID) :
#ifdef _QUIET_
//#if 1
    ththSettings(apse, "gotchaq.ini", L_PROFILEVERSION)
#else
    ththSettings(apse, "gotcha.ini", L_PROFILEVERSION)
#endif
{
    if( ! QueryFlag( SEI_UPDATE178DONE ) ) {
        //DisplayError( "Updated", "false" );
        SetLong( SEI_SERIALTIME, QueryLong( SEI_SERIALTIME ) * 20 );
        SetFlag( SEI_UPDATE178DONE );
    } else {
        //DisplayError( "NOT Updated", "true" );
    }
#ifdef _QUIET_
    HINI hini = PrfOpenProfile (hab, "gotchaq.ini");
#else
    HINI hini = PrfOpenProfile (hab, "gotcha.ini");
#endif
    BOOL fLChange = FALSE;
    ULONG ulDataSize;
    PrfQueryProfileSize(hini, "Language", "LangChangeRequested", &ulDataSize );
    PrfQueryProfileData(hini, "Language", "LangChangeRequested", &fLChange, &ulDataSize);
    if (!fLChange) {
    CHAR *lang = getenv("LANG");
#ifdef _QUIET_
    PSZ  psz = "goqresen";
#else
    PSZ  psz = "gotresen";
#endif
    PSZ  pszh = "gotcha_en";
    if (lang) {
        if (!strnicmp(lang, "es", 2)) {
            psz = "gotreses";
            pszh = "gotcha_es";
        }
        else if (!strnicmp(lang, "cs", 2)) {
            psz = "gotrescz";
        }
        else if (!strnicmp(lang, "de", 2)) {
            psz = "gotresde";
        }
        else if (!strnicmp(lang, "it", 2)) {
            psz = "gotresit";
            pszh = "gotcha_it";
        }
        else if (!strnicmp(lang, "br", 2)) {
            psz = "gotresbr";
            pszh = "gotcha_br";
        }
    }
    SetString(SEI_LANGUAGE, psz);
    SetString (SEI_LANGUAGEHELP, pszh);
    Save ();
    }
    if (hini)
        PrfCloseProfile (hini);
    // to get the error msgs in default language
    ReloadResources (QueryString(SEI_LANGUAGE));
#ifdef _QUIET_
    if (!g_installer) {
#endif
        if (Error () == 1)
        {
            FileNotOpenError ();
            ReloadResources (QueryString(SEI_LANGUAGE));
        }
        else if (Error () == 2)
        {
            VersionError ();
            ReloadResources (QueryString(SEI_LANGUAGE));
        }
#ifdef _QUIET_
    }
#endif
}

// ** VersionError ********************************************************

USHORT SETTINGS :: VersionError (VOID)
{
    DisplayError (RSTR(IDS_HEADER_WARNING), RSTR(IDS_ERROR_INIFILEWRONGVERSION),
                  QueryProfileName ());
    SelectLanguage();
    return 0;
}

// ** FileNotOpenError **************************************************** /*FOLD00*/

USHORT SETTINGS :: FileNotOpenError (VOID)
{
    DisplayError (RSTR(IDS_HEADER_ERROR), RSTR(IDS_ERROR_INIFILENOTOPEN),
                  QueryProfileName ());
    SelectLanguage();
    return 0;
}

// ** Dialog ************************************************************** /*FOLD00*/

// FIXME YUKKI! YUKKI!! YUKKI!!! But I'm too lazy to do it better now :-)
HWND g_hwndSettingsDialog = NULL;
HWND g_hwndPage0 = NULL;

BOOL SETTINGS :: Dialog (BOOL fOnlyLanguage)
{
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 1" );
#endif
    fAutoLanguage = fOnlyLanguage;

    // load the main dialog window
    hwndDlg = WinLoadDlg (HWND_DESKTOP, hwndFrame, (DialogProcedure),
                          GETMODULE, ID_DLG_SETTINGS, this);
    // FIXME YUKKI! YUKKI!! YUKKI!!! But I'm too lazy to do it better now :-)
    g_hwndSettingsDialog = hwndDlg;
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 2" );
#endif

    // disable this two buttons if only language select
    if (fAutoLanguage)
    {
        WinEnableWindow (WinWindowFromID (hwndDlg, WID_PB_HELP), FALSE);
        WinEnableWindow (WinWindowFromID (hwndDlg, WID_PB_UNDO), FALSE);
    }

    HWND   hwndNB = WinWindowFromID (hwndDlg, WID_NB_SETTINGS);
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 3" );
#endif

    // set notebook background color
    WinSendMsg (hwndNB, BKM_SETNOTEBOOKCOLORS,
                MPFROMLONG (SYSCLR_DIALOGBACKGROUND),
                MPFROMSHORT (BKA_BACKGROUNDPAGECOLORINDEX));

    // set tab dimensions
    WinSendMsg (hwndNB, BKM_SETDIMENSIONS,
                MPFROM2SHORT (80, 25), MPFROMSHORT (BKA_MAJORTAB));
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 4" );
#endif

    ULONG   idPage[COUNT_PAGES];
    USHORT  i, cPages;

    if (fOnlyLanguage)
    {
        cPages = 1;

        idPage[0] = (ULONG)
            WinSendMsg (hwndDlg, BKM_INSERTPAGE, 0L,
                        MPFROM2SHORT (BKA_MAJOR | BKA_AUTOPAGESIZE,
                                      BKA_LAST));
        WinSendMsg (hwndDlg, BKM_SETTABTEXT, MPFROMLONG (idPage[0]),
                    MPFROMP (pszPageTab[COUNT_PAGES-1]));
        hwndPage[0] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page4Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE4, this);
    }
    else
    {
        cPages = COUNT_PAGES;

        // insert empty pages
        for (i = 0; i < cPages; i++)
        {
	    //BOOKPAGEINFO pi;
            idPage[i] = (ULONG)
                WinSendMsg (hwndNB, BKM_INSERTPAGE, 0L,
                            MPFROM2SHORT (BKA_MAJOR | BKA_AUTOPAGESIZE,
                                          BKA_LAST));
#if 0
            pi.cb = sizeof(pi);
            pi.fl = BFA_PAGEFROMDLGRES | BFA_MAJORTABTEXT;
            pi.bLoadDlg = TRUE;
            pi.hmodPageDlg = g_hmod;
            switch (i) {
#ifndef  _QUIET_
            case 0:
                pi.idPageDlg = ID_DLG_SETTINGSPAGE1;
                pi.pfnPageDlgProc = NULL; //(PFN) Page1Procedure;
                break;
#else
            case 0:
                pi.idPageDlg = ID_DLG_SETTINGSPAGE0;
                pi.pfnPageDlgProc = NULL; //(PFN) WindowProcedure;
                break;
#endif
            case 1:
                pi.idPageDlg = ID_DLG_SETTINGSPAGE2;
                pi.pfnPageDlgProc = NULL; //(PFN) Page2Procedure;
                break;
#ifndef  _QUIET_
            case 2:
                pi.idPageDlg = ID_DLG_SETTINGSPAGE3;
                pi.pfnPageDlgProc = NULL; //(PFN) Page3Procedure;
                break;
#else
            case 2:
                pi.idPageDlg = ID_DLG_SETTINGSPAGE1;
                pi.pfnPageDlgProc = NULL; //(PFN) Page1Procedure;
                break;
#endif
            case 3:
                pi.idPageDlg = ID_DLG_SETTINGSPAGE4;
                pi.pfnPageDlgProc = NULL; //(PFN) Page4Procedure;
                break;
            }
            pi.cbMajorTab = strlen(pszPageTab[i]);
            pi.pszMajorTab = pszPageTab[i];
            pi.cbMinorTab = strlen(pszPageTab[i]);
            pi.pszMinorTab = pszPageTab[i];
            pi.cbStatusLine = 0;
            pi.pszStatusLine = NULL;
#endif
            if (pset->GetLangID() == CZ || pset->GetLangID() == RU || pset->GetLangID() == PL) {
                UniChar     target[300];
                CHAR       ucLangStr[300];
                UconvObject     uconv_object866 = NULL;
                UconvObject     uconv_object852 = NULL;
                UconvObject     uconv_object1207 = NULL;
                UconvObject     uconv_object850 = NULL;
                HAB hab;
                CHAR ucFont[FACESIZE];
    
                UniCreateUconvObject((UniChar *)L"IBM-852", &uconv_object852);
                UniCreateUconvObject((UniChar *)L"IBM-850", &uconv_object850);
                UniCreateUconvObject((UniChar *)L"IBM-866", &uconv_object866);
                UniCreateUconvObject((UniChar *)L"IBM-1207", &uconv_object1207);
                
                strcpy(ucLangStr, pszPageTab[i]);
                if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
                    
                    UniStrToUcs( uconv_object852, target, ucLangStr, 299);
                }
                else if (pset->GetLangID() == RU)
                    UniStrToUcs( uconv_object866, target, ucLangStr, 299);
                else {
                    UniStrToUcs( uconv_object850, target, ucLangStr, 299);
                }
                UniStrFromUcs( uconv_object1207, ucLangStr, target, 300);
                WinSendMsg (hwndNB, BKM_SETTABTEXT,
                            MPFROMLONG (idPage[i]), MPFROMP (ucLangStr));
                /*pi.cbMajorTab = strlen(ucLangStr) + 10;
                pi.pszMajorTab = ucLangStr;
                pi.cbMinorTab = 0;
                pi.pszMinorTab = "";*/
                if (uconv_object866)
                    UniFreeUconvObject(uconv_object866);
                if (uconv_object852)
                    UniFreeUconvObject(uconv_object852);
                if (uconv_object850)
                    UniFreeUconvObject(uconv_object850);
                if (uconv_object1207)
                    UniFreeUconvObject(uconv_object1207);
            }
            else
                WinSendMsg (hwndNB, BKM_SETTABTEXT,
                            MPFROMLONG (idPage[i]), MPFROMP (pszPageTab[i]));
            //WinSendMsg(hwndNB, BKM_SETPAGEINFO, MPFROMLONG(idPage[i]),
              //         MPFROMP(&pi));
        }
#ifndef _QUIET_
        // open and assign dialogs to pages
        hwndPage[0] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page1Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE1, this);
        hwndPage[1] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page2Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE2, this);
        hwndPage[2] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page3Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE3, this);
        hwndPage[3] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page4Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE4, this);
#else
        hwndPage[0] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) WindowProcedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE0, this);
        hwndPage[1] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page2Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE2, this);
        hwndPage[2] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page1Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE1, this);
        hwndPage[3] = WinLoadDlg (hwndNB, hwndNB, (PFNWP) Page4Procedure,
                                  GETMODULE, ID_DLG_SETTINGSPAGE4, this);
        g_hwndPage0 = hwndPage[0];
        
#endif
    }
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 5" );
#endif

    // combine dlg-handle and page ids
    for (i = 0; i < cPages; i++)
        WinSendMsg (hwndNB, BKM_SETPAGEWINDOWHWND,
                    MPFROMLONG (idPage[i]), MPFROMHWND (hwndPage[i]));

/*    if (fAutoLanguage)
        WinSendMsg (hwndNB, BKM_TURNTOPAGE, MPFROMLONG (idPage[0]), 0L);
#if (COUNT_PAGES != 4)
#warning FIXME settings.cpp 264 or so ...
#endif */
    for (i = 0; i < cPages; i++)
        WinSendMsg (hwndPage[i], UM_SETTINGS2DIALOG, 0,0);
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 6" );
#endif
    WinSendDlgItemMsg (g_hwndPage0, WID_RB_FILE, BM_CLICK,
                       MPFROMSHORT (TRUE), 0);
    //WinSendDlgItemMsg (g_hwndPage0, WID_CB_HIDEWINDOW, BM_SETCHECK,
    //                   MPFROMLONG (TRUE), MPFROMLONG (0));
    //WinSetFocus (WinWindowFromID (hwndDlg, WID_PB_OK), TRUE);
    //WinSetFocus( hwndPage[0], FALSE );
#ifdef _QUIET_
    if (HACCEL haccel = WinLoadAccelTable (hab, GETMODULE, 1)) {
        int rc = WinSetAccelTable (hab, haccel, hwndDlg);
    }
#endif
    WinSetActiveWindow( HWND_DESKTOP, hwndDlg );
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 7" );
#endif

    WinProcessDlg (hwndDlg);
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 7.5" );
#endif
    WinDestroyWindow (hwndDlg);
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 8" );
#endif
#ifndef _QUIET_
    // it ain't the best way to do it, but ...
    SetIdlePriority(QueryFlag(SEI_IDLEPRIORITY));
#endif
    for (i = 0; i < COUNT_PAGES; i++)
        hwndPage[i] = NULL;

    hwndDlg = NULLHANDLE;
#ifdef _DOLOGDEBUG_
    LogDebug( "Dialog: checkpoint 9" );
#endif
    return TRUE;
}

ULONG winhDrawFormattedText(HPS hps, PRECTL prcl, const char *pcszText, ULONG flCmd);

// ** DialogProcedure ***************************************************** /*FOLD00*/

MRESULT EXPENTRY SETTINGS :: DialogProcedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static PSETTINGS   pset = NULL;

#ifdef _DOLOGDEBUG_
    LogDebug( "DialogProcedure:Message 0x%04x", msg );
#endif

    switch (msg)
    {
    case WM_INITDLG:
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: start WM_INITDLG" );
#endif
        pset = PSETTINGS (mp2);
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: end WM_INITDLG" );
#endif
        CHAR ucFont[FACESIZE];
        if (pset->GetLangID() == CZ || pset->GetLangID() == RU || pset->GetLangID() == PL) {
           HMQ hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
           WinSetCp(hmq, 1207);
           strcpy(ucFont, "8.Times New Roman MT 30");
           WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);

           UniChar     target[300];
           CHAR       ucLangStr[300];
           UconvObject     uconv_object866 = NULL;
           UconvObject     uconv_object860 = NULL;
           UconvObject     uconv_object852 = NULL;
           UconvObject     uconv_object1207 = NULL;
           UconvObject     uconv_object850 = NULL;
           HAB hab;
           CHAR ucFont[FACESIZE];

           UniCreateUconvObject((UniChar *)L"IBM-852", &uconv_object852);
           UniCreateUconvObject((UniChar *)L"IBM-850", &uconv_object850);
           UniCreateUconvObject((UniChar *)L"IBM-866", &uconv_object866);
           UniCreateUconvObject((UniChar *)L"IBM-1207", &uconv_object1207);
           
           WinLoadString(hab, g_hmod, IDS_UNDO, sizeof(ucLangStr), ucLangStr);
           if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
               
               UniStrToUcs( uconv_object852, target, ucLangStr, 299);
           }
           else if (pset->GetLangID() == RU)
               UniStrToUcs( uconv_object866, target, ucLangStr, 299);
           else {
               UniStrToUcs( uconv_object850, target, ucLangStr, 299);
           }
           UniStrFromUcs( uconv_object1207, ucLangStr, target, 300);
           WinSetDlgItemText(hwnd, WID_PB_UNDO, ucLangStr);
           WinLoadString(hab, g_hmod, IDS_HELP, sizeof(ucLangStr), ucLangStr);

           if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
               
               UniStrToUcs( uconv_object852, target, ucLangStr, 299);
           }
           else if (pset->GetLangID() == RU)
               UniStrToUcs( uconv_object866, target, ucLangStr, 299);
           else {
               UniStrToUcs( uconv_object850, target, ucLangStr, 299);
           }
           UniStrFromUcs( uconv_object1207, ucLangStr, target, 300);
           WinSetDlgItemText(hwnd, WID_PB_HELP, ucLangStr);
           if (uconv_object866)
               UniFreeUconvObject(uconv_object866);
           if (uconv_object852)
               UniFreeUconvObject(uconv_object852);
           if (uconv_object850)
               UniFreeUconvObject(uconv_object850);
           if (uconv_object1207)
               UniFreeUconvObject(uconv_object1207);
        }
        else {
        strcpy(ucFont, "10.WarpSans");
        WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
        }
            
        return MRESULT (FALSE);

    case WM_COMMAND:
        switch (SHORT1FROMMP (mp1))
        {
        case WID_PB_OK:
#ifdef _DOLOGDEBUG_
            LogDebug( "DialogProcedure: start WID_PB_OK" );
#endif
            saveum = TRUE;
            WinSendMsg (hwnd, WM_CLOSE, 0,0);
#ifdef _DOLOGDEBUG_
            LogDebug( "DialogProcedure: end WID_PB_OK" );
#endif
            break;
            
        case WID_PB_UNDO:
            {
                ULONG  id = (ULONG)
                    WinSendDlgItemMsg (hwnd, WID_NB_SETTINGS,
                                       BKM_QUERYPAGEID, 0,
                                       MPFROM2SHORT (BKA_TOP, 0));
                if (id)
                {
                    HWND   hwndPage = (HWND)
                        WinSendDlgItemMsg (hwnd, WID_NB_SETTINGS,
                                           BKM_QUERYPAGEWINDOWHWND,
                                           MPFROMLONG (id), 0);
                // Make mp1 1 for default use it to select setting on pages
                    WinSendMsg (hwndPage, UM_SETTINGS2DIALOG, 0,0);
                }
            }
            break;

        case WID_PB_ABOUT:
            AboutBox (hwnd);
            break;

        case DID_CANCEL:
            {
                // Undo stuff on all notebook pages:
                HWND hwndPage;

                // Get ID of first notebook page.
                ULONG id =
                    ULONG( WinSendDlgItemMsg( hwnd, WID_NB_SETTINGS,
                                              BKM_QUERYPAGEID, 0,
                                              MPFROM2SHORT( BKA_FIRST, 0 ) ) );
                if( id ) {
                    hwndPage =
                        HWND( WinSendDlgItemMsg( hwnd, WID_NB_SETTINGS,
                                                 BKM_QUERYPAGEWINDOWHWND,
                                                 MPFROMLONG( id ), 0 ) );
                    WinSendMsg( hwndPage, UM_SETTINGS2DIALOG, 0,0 );
                }

                while( id ) {
                    // Get ID of next notebook page.
                    if( ( id =
                          ULONG( WinSendDlgItemMsg( hwnd, WID_NB_SETTINGS,
                                                    BKM_QUERYPAGEID,
                                                    MPFROMLONG( id ),
                                                    MPFROM2SHORT( BKA_NEXT, 0 )
                                                  ) ) ) ) {
                        hwndPage =
                            HWND( WinSendDlgItemMsg( hwnd, WID_NB_SETTINGS,
                                                     BKM_QUERYPAGEWINDOWHWND,
                                                     MPFROMLONG( id ), 0 ) );
                        WinSendMsg( hwndPage, UM_SETTINGS2DIALOG, 0,0 );
                    }
                }
                WinSendMsg( hwnd, WM_CLOSE, 0,0 );
            }
            break;
        }
        return MRESULT (FALSE);

#ifdef _DOLOGDEBUG_
    case WM_DESTROY:
        LogDebug( "DialogProcedure: WM_DESTROY" );
        return MRESULT (FALSE);
#endif

    case WM_CLOSE:
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: WM_CLOSE" );
#endif
    case WM_QUIT:
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: WM_QUIT" );
#endif
    case WM_SAVEAPPLICATION:
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: WM_SAVEAPPLICATION" );
#endif
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: start WM_CLOSE (or WM_QUIT, WM_SAVEAPPLICATION)" );
#endif
        for (USHORT i = 0; i < COUNT_PAGES; i++)
            WinSendMsg (pset->hwndPage[i], UM_ADJUST, 0,0);
#ifdef _DOLOGDEBUG_
        LogDebug( "DialogProcedure: end WM_CLOSE (or WM_QUIT, WM_SAVEAPPLICATION)" );
#endif
        WinDismissDlg( hwnd, 0L );
        return MRESULT (FALSE);
    }

#ifdef _DOLOGDEBUG_
    LogDebug( "DialogProcedure:WinDefDlgProc->0x%04x", msg );
#endif
    return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

// ** Page1Procedure ****************************************************** /*FOLD00*/

MRESULT EXPENTRY SETTINGS :: Page1Procedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static PSETTINGS   pset = NULL;

    switch (msg)
    {
    case WM_INITDLG: {
#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: start WM_INITDLG" );
#endif
        ULONG ul;
        pset = PSETTINGS (mp2);
        for( int i = 0; i < BMF_INVALID; i++ ) {
            if( pset->ifi[ i ].available ) {
                ul = WinInsertLboxItem( WinWindowFromID( hwnd, WID_LB_FILEFORMAT ),
                                        LIT_END, pset->ifi[ i ].label );
                WinSendMsg( WinWindowFromID( hwnd, WID_LB_FILEFORMAT ),
                            LM_SETITEMHANDLE, MPFROMLONG(ul), MPFROMP( i ) );
            }
        }
        HMQ hmq;
        BOOL bUniCodeFont;
        CHAR ucFont[FACESIZE];

        if (pset->GetLangID() == RU) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 866);
            bUniCodeFont = TRUE;
        }
        else if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 852);
            bUniCodeFont = TRUE;
        }
        else {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 850);
        }

        if (bUniCodeFont) {
            strcpy(ucFont, "8.Times New Roman MT 30");
            WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
        }
        else {
            strcpy(ucFont, "10.WarpSans");
            WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
        }

#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: end WM_INITDLG" );
#endif
        return MRESULT (FALSE);
    }

    case WM_DRAWITEM:

        POWNERITEM poItem;
        HPS hps;
        RECTL       rcl,          // window area
                    rclClip;      // clipping region for drawn text
        POINTL      ptl;          // current text position
        FATTRS      fontAttrs;    // current font attributes
        FONTMETRICS fm;           // current font metr


        poItem = POWNERITEM (mp2);

        //hps = WinBeginPaint( hwnd, NULLHANDLE, NULLHANDLE );
        memset( &fontAttrs, 0, sizeof(FATTRS) );
        PmpfF(("PageID %i", poItem->hItem));
        // set the font attributes and create the logical font
        fontAttrs.usRecordLength = sizeof(FATTRS);
        fontAttrs.usCodePage     = 852;
        fontAttrs.fsType         = FATTR_TYPE_MBCS;
        fontAttrs.fsFontUse      = FATTR_FONTUSE_NOMIX;
        strcpy( fontAttrs.szFacename, "10.WarpSans");
        GpiCreateLogFont( poItem->hps, NULL, 1L, &fontAttrs );
        GpiSetCharSet( poItem->hps, 1L );
        // paint the window background
        //WinQueryWindowRect( hwnd, &rcl ); ????
        WinFillRect( hps, &poItem->rclItem, SYSCLR_WINDOW );
        GpiQueryFontMetrics( poItem->hps, sizeof(FONTMETRICS), &fm );
        rclClip.xLeft   = poItem->rclItem.xLeft + fm.lAveCharWidth;
        rclClip.yBottom = poItem->rclItem.yBottom + fm.lXHeight;
        rclClip.xRight  = poItem->rclItem.xRight - fm.lAveCharWidth;
        rclClip.yTop    = poItem->rclItem.yTop - fm.lXHeight;
        ptl.x = rclClip.xLeft;
        ptl.y = rclClip.yTop - fm.lExternalLeading - fm.lMaxAscender;
        GpiCharStringPosAt( poItem->hps, &ptl, &rclClip, CHS_CLIP,
                           /*Strlen(pszPageTab[i])*/5, (PCH) /*pszPageTab[i]*/ "Test", NULL );
        WinEndPaint( hps );

        //poItem->hwnd = hwndNB;            /*  Window handle. */
        //poItem->hps = hps;             /*  Presentation-space handle. */
        //poItem->fsState = BKS_BACKPAGESTR | BKS_MAJORTABTOP | BKS_TABBEDDIALOG;         /*  State. */
        //poItem->fsAttribute = BKA_MAJOR | BKA_AUTOPAGESIZE;     /*  Attribute. */
        //poItem->rclItem; ????        /*  Item rectangle. */
        //poItem->hItem = idPage[i];

        break;

    case WM_COMMAND:
        if( SHORT1FROMMP( mp1 ) == DID_CANCEL )
            WinPostMsg( g_hwndSettingsDialog, msg, mp1, mp2 );
        return MRESULT( FALSE );

    case UM_SETTINGS2DIALOG: {
#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: start UM_SETTINGS2DIALOG" );
#endif
        // set num save dir name
        WinSendDlgItemMsg (hwnd, WID_E_NUMSAVEDIR, EM_SETTEXTLIMIT,
                           MPARAM (_MAX_PATH-1), (MPARAM)0);
        WinSetDlgItemText (hwnd, WID_E_NUMSAVEDIR,
                           pset->QueryNumSaveDir ());
        WinSendDlgItemMsg (hwnd, WID_E_NUMSAVEDIR, EM_SETSEL,
                           MPFROM2SHORT (0, _MAX_PATH), (MPARAM)0);

        // set force file name
        WinSendDlgItemMsg (hwnd, WID_E_FORCESAVEFILE, EM_SETTEXTLIMIT,
                           MPARAM (_MAX_PATH-1), (MPARAM)0);
        WinSetDlgItemText (hwnd, WID_E_FORCESAVEFILE,
                           pset->QueryForceSaveFile ());
        WinSendDlgItemMsg (hwnd, WID_E_FORCESAVEFILE, EM_SETSEL,
                           MPFROM2SHORT (0, _MAX_PATH), (MPARAM)0);

        // Select the appropriate entry in the fileformat-listbox.
        HWND     hwndLB = WinWindowFromID( hwnd, WID_LB_FILEFORMAT );
        ULONG    c, i;

        c = WinQueryLboxCount( hwndLB );
        for( i = 0; i < c; i++ )
        {
            ULONG type = ULONG( WinSendDlgItemMsg( hwnd, WID_LB_FILEFORMAT,
                                                   LM_QUERYITEMHANDLE,
                                                   MPFROMLONG(i), NULL ) );
            if( type == ULONG( pset->QueryFileFormat() ) )
                break;
        }
        if( i < c )
            WinSendDlgItemMsg( hwnd, WID_LB_FILEFORMAT, LM_SELECTITEM,
                               MPFROMSHORT(i), MPFROMSHORT(TRUE) );
        else
            WinSendDlgItemMsg( hwnd, WID_LB_FILEFORMAT, LM_SELECTITEM,
                               MPFROMSHORT(0), MPFROMSHORT(TRUE) );
#ifdef _QUIET_
//#if 1
        // set play sound button
        pset->AdjustButton (hwnd, WID_CB_DOSOUND,
                            pset->DoSound ());
#endif
        // Select appropriate radiobutton for save style.
        switch (pset->QueryFileSaveStyle ())
        {
        case FSS_NUMFILES:
            WinSendDlgItemMsg (hwnd, WID_RB_FSSNUMFILES, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            AdjustSaveTypeButtons (FALSE);
            break;

        case FSS_FORCEFILE:
            WinSendDlgItemMsg (hwnd, WID_RB_FSSFORCEFILE, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            AdjustSaveTypeButtons (TRUE);
            break;

        default:
            WinSendDlgItemMsg (hwnd, WID_RB_FSSPROMPT, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            AdjustSaveTypeButtons (FALSE);
            break;
        }
#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: end UM_SETTINGS2DIALOG" );
#endif
        return MRESULT (FALSE);
    }

    case UM_ADJUST:
        {
#ifdef _DOLOGDEBUG_
            LogDebug( "Page1Procedure: start UM_ADJUST" );
#endif
            // get file save style
            if (WinSendMsg (WinWindowFromID (hwnd, WID_RB_FSSNUMFILES),
                            BM_QUERYCHECK, 0,0))
                pset->SetFileSaveStyle (FSS_NUMFILES);
            else if (WinSendMsg (WinWindowFromID (hwnd, WID_RB_FSSFORCEFILE),
                                 BM_QUERYCHECK, 0,0))
                pset->SetFileSaveStyle (FSS_FORCEFILE);
            else
                pset->SetFileSaveStyle (FSS_PROMPT);
#ifdef _QUIET_
//#if 1
            pset->DoSound(WinQueryButtonCheckstate
                          (hwnd, WID_CB_DOSOUND));
#endif
#ifdef _DOLOGDEBUG_
            LogDebug( "Page1Procedure: checkpoint 1" );
#endif

            // Get file format.
            ULONG ul = USHORT( WinSendDlgItemMsg( hwnd, WID_LB_FILEFORMAT,
                                                  LM_QUERYSELECTION,
                                                  MPFROMLONG( LIT_FIRST ),
                                                  0L ) );
            ul = ULONG( WinSendDlgItemMsg( hwnd, WID_LB_FILEFORMAT,
                                           LM_QUERYITEMHANDLE,
                                           MPFROMLONG( ul ), NULL ) );
            pset->SetFileFormat( SHORT( ul ) );

            pset->SetSaveFile(AddExtensionToFilename(pset->QuerySaveFile()));

#ifdef _DOLOGDEBUG_
            LogDebug( "Page1Procedure: checkpoint 2" );
#endif

            // num save dir file name
            CHAR   psz[_MAX_PATH];
            WinQueryDlgItemText (hwnd, WID_E_NUMSAVEDIR, _MAX_PATH, psz);
            pset->SetNumSaveDir (psz);

            // force file name
            WinQueryDlgItemText (hwnd, WID_E_FORCESAVEFILE, _MAX_PATH, psz);
            pset->SetForceSaveFile (psz);

            AdjustSaveTypeButtons
                (BOOL (pset->QueryFileSaveStyle () == FSS_FORCEFILE));
            pset->saveStyle = pset->QuerySaveStyle ();
            pset->pNumSaveDir = pset->QueryNumSaveDir ();
            pset->pForceSaveFile = pset->QueryForceSaveFile();

            if (saveum)
                pset->Save ();
#ifdef _DOLOGDEBUG_
            LogDebug( "Page1Procedure: end UM_ADJUST" );
#endif
        }
        break;

    case WM_CONTROL:
        switch (SHORT1FROMMP (mp1))
        {
        case WID_RB_FSSFORCEFILE:
            AdjustSaveTypeButtons (TRUE);
            break;

        case WID_RB_FSSPROMPT:
        case WID_RB_FSSNUMFILES:
            AdjustSaveTypeButtons (FALSE);
            break;
        }
        return MRESULT (FALSE);
    }

    return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

// ** Page2Procedure ****************************************************** /*FOLD00*/

MRESULT EXPENTRY SETTINGS :: Page2Procedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static PSETTINGS   pset = NULL;

    switch (msg)
    {
    case WM_INITDLG:
#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: start WM_INITDLG" );
#endif
        pset = PSETTINGS (mp2);
#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: end WM_INITDLG" );
#endif
        HMQ hmq;
        BOOL bUniCodeFont;
        CHAR ucFont[FACESIZE];
        
        if (pset->GetLangID() == RU) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 866);
            bUniCodeFont = TRUE;
        }
        else if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 852);
            bUniCodeFont = TRUE;
        }
        else {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 850);
        }

        if (bUniCodeFont) {
            strcpy(ucFont, "8.Times New Roman MT 30");
            WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
        }
        //else
           // WinRemovePresParam(hwnd, PP_FONTNAMESIZE);
        return MRESULT (FALSE);

    case WM_COMMAND:

        if( SHORT1FROMMP( mp1 ) == WID_PB_OK) {
            saveum = TRUE;
            WinSendMsg ( g_hwndSettingsDialog, WM_CLOSE, 0,0);
        }
        if( SHORT1FROMMP( mp1 ) == DID_CANCEL )
            WinPostMsg( g_hwndSettingsDialog, msg, mp1, mp2 );
        return MRESULT( FALSE );

    case UM_SETTINGS2DIALOG:
#ifdef _DOLOGDEBUG_
        LogDebug( "Page2Procedure: start UM_SETTINGS2DIALOG" );
#endif
#ifndef _QUIET_
        // set state of checkbuttons
        pset->AdjustButton (hwnd, WID_CB_SSWENABLE,
                            pset->SnapshotWindow ());
        pset->AdjustButton (hwnd, WID_CB_SSWHIDE,
                            pset->SSWHide ());
        pset->AdjustButton (hwnd, WID_CB_SSWALWAYSONTOP,
                            pset->SSWAlwaysOnTop ());
#else
//#if 1
        pset->AdjustButton (hwnd, WID_CB_SERIALCAPTURE,
                            pset->SerialCapture ());
        pset->AdjustButton (hwnd, WID_CB_DELAYCOUNTDOWN,
                            pset->DelayCountdown ());
        pset->AdjustButton (hwnd, WID_CB_DELAYEDCAPTURE,
                            pset->DelayedCapture ());

        // init delay time sb
        WinSendDlgItemMsg (hwnd, WID_SB_DELAYTIME, SPBM_SETLIMITS,
                           MPFROMLONG (65536), MPFROMLONG (1));
        WinSendDlgItemMsg (hwnd, WID_SB_DELAYTIME, SPBM_SETCURRENTVALUE,
                           MPFROMLONG (pset->QueryDelayTime ()), 0);

        // init serial time sb
        WinSendDlgItemMsg (hwnd, WID_SB_SERIALTIME, SPBM_SETLIMITS,
                           MPFROMLONG (65536), MPFROMLONG (1));
        WinSendDlgItemMsg (hwnd, WID_SB_SERIALTIME, SPBM_SETCURRENTVALUE,
                           MPFROMLONG (pset->QuerySerialTime ()), 0);
#endif
        switch (pset->QuerySSWCaptureType ())
        {
        case CAP_WINDOWINT:
            WinSendDlgItemMsg (hwnd, WID_SSWWINDOWINT, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            break;
        case CAP_SCREENREGION:
            WinSendDlgItemMsg (hwnd, WID_SSWSCREENREGION, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            break;
        case CAP_WINDOW:
            WinSendDlgItemMsg (hwnd, WID_SSWWINDOW, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            break;
        default:
            WinSendDlgItemMsg (hwnd, WID_SSWSCREEN, BM_CLICK,
                               MPFROMSHORT(TRUE), 0);
            break;
        }
#ifndef _QUIET_
        // show or hide snapshot window
        if (! WinSendDlgItemMsg (hwnd, WID_CB_SSWENABLE,
                                 BM_QUERYCHECK, 0, 0))
            WinShowWindow (hwndSnapshot, FALSE);
        else
            WinShowWindow (hwndSnapshot, TRUE);
#endif
#ifdef _DOLOGDEBUG_
        LogDebug( "Page1Procedure: end UM_SETTINGS2DIALOG" );
#endif
        return MRESULT (FALSE);

    case UM_ADJUST:
#ifdef _DOLOGDEBUG_
            LogDebug( "Page2Procedure: start UM_ADJUST" );
#endif
#ifndef _QUIET_
//#if 0
        // query state of checkbuttons and set flags
        pset->SSWHide(WinQueryButtonCheckstate(hwnd, WID_CB_SSWHIDE));
#ifdef _DOLOGDEBUG_
            LogDebug( "Page2Procedure: checkpoint 1" );
#endif
        pset->SnapshotWindow(WinQueryButtonCheckstate(hwnd, WID_CB_SSWENABLE));
        pset->SSWAlwaysOnTop(WinQueryButtonCheckstate(hwnd,
                                                      WID_CB_SSWALWAYSONTOP));
#ifdef _DOLOGDEBUG_
            LogDebug( "Page2Procedure: checkpoint 2" );
#endif
#else
            // query state of checkbuttons and set flags
            pset->SerialCapture(WinQueryButtonCheckstate
                                (hwnd, WID_CB_SERIALCAPTURE));
#ifdef _DOLOGDEBUG_
            LogDebug( "Page3Procedure: checkpoint 1" );
#endif
            pset->DelayCountdown(WinQueryButtonCheckstate
                                 (hwnd, WID_CB_DELAYCOUNTDOWN));
            pset->DelayedCapture (WinQueryButtonCheckstate
                                  (hwnd,WID_CB_DELAYEDCAPTURE));
#endif
        // get ssw capture type
        if (WinSendMsg (WinWindowFromID (hwnd, WID_SSWSCREENREGION),
                        BM_QUERYCHECK, 0,0))
            pset->SetSSWCaptureType (CAP_SCREENREGION);
        else if (WinSendMsg (WinWindowFromID (hwnd, WID_SSWWINDOW),
                             BM_QUERYCHECK, 0,0))
            pset->SetSSWCaptureType (CAP_WINDOW);
        else if (WinSendMsg (WinWindowFromID (hwnd, WID_SSWWINDOWINT),
                             BM_QUERYCHECK, 0,0))
            pset->SetSSWCaptureType (CAP_WINDOWINT);
        else
            pset->SetSSWCaptureType (CAP_SCREEN);
#ifdef _QUIET_
//#if 1
        // delay time
        ULONG   ul;
        if (! BOOL (WinSendDlgItemMsg (hwnd, WID_SB_DELAYTIME,
                                       SPBM_QUERYVALUE,
                                       MPFROMP (&ul),
                                       MPFROM2SHORT (0, 0))))
            ul = 5L;
        pset->SetDelayTime (ul);
#ifdef _DOLOGDEBUG_
        LogDebug( "Page3Procedure: checkpoint 3" );
#endif

        // serial time
        if (! BOOL (WinSendDlgItemMsg (hwnd, WID_SB_SERIALTIME,
                                       SPBM_QUERYVALUE,
                                       MPFROMP (&ul),
                                       MPFROM2SHORT (0, 0))))
            ul = 10L;
        pset->SetSerialTime (ul);
        pset->bSerialCapture = pset->SerialCapture ();
#endif
        if (saveum)
            pset->Save ();
#ifdef _DOLOGDEBUG_
        LogDebug( "Page2Procedure: end UM_ADJUST" );
#endif
        break;

    case WM_CONTROL:
        switch (SHORT1FROMMP (mp1))
        {
#ifndef _QUIET_
        case WID_CB_SSWENABLE:
            if (! WinSendDlgItemMsg (hwnd, WID_CB_SSWENABLE,
                                     BM_QUERYCHECK, 0, 0))
                WinShowWindow (hwndSnapshot, FALSE);
            else
                WinShowWindow (hwndSnapshot, TRUE);
            break;
#endif
        case WID_CB_DELAYEDCAPTURE:

            WinSendDlgItemMsg (g_hwndPage0, WID_CB_DELAYEDCAPTURE, BM_SETCHECK,
                               MPFROMLONG (WinQueryButtonCheckstate
                                           (hwnd,WID_CB_DELAYEDCAPTURE)),
                               MPFROMLONG (0));
            WinSendDlgItemMsg (WinWindowFromID(hwndFrame, FID_CLIENT),
                               WID_CB_DELAYEDCAPTURE, BM_SETCHECK,
                               MPFROMLONG (WinQueryButtonCheckstate
                                           (hwnd,WID_CB_DELAYEDCAPTURE)),
                               MPFROMLONG (0));
            break;
        }
        return MRESULT (FALSE);
    }

    return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

// ** Page3Procedure ****************************************************** /*FOLD00*/

MRESULT EXPENTRY SETTINGS :: Page3Procedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static PSETTINGS   pset = NULL;

    switch (msg)
    {
    case WM_INITDLG:
#ifdef _DOLOGDEBUG_
        LogDebug( "Page3Procedure: start WM_INITDLG" );
#endif
        pset = PSETTINGS (mp2);
#ifdef _DOLOGDEBUG_
        LogDebug( "Page3Procedure: end WM_INITDLG" );
#endif
        HMQ hmq;
        BOOL bUniCodeFont;
        CHAR ucFont[FACESIZE];
        
        if (pset->GetLangID() == RU) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 866);
            bUniCodeFont = TRUE;
        }
        else if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 852);
            bUniCodeFont = TRUE;
        }
        else {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 850);
        }

        if (bUniCodeFont) {
            strcpy(ucFont, "8.Times New Roman MT 30");
            WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
        }
        //else
        //    WinRemovePresParam(hwnd, PP_FONTNAMESIZE);
        return MRESULT (FALSE);

    case WM_COMMAND:
        if( SHORT1FROMMP( mp1 ) == DID_CANCEL )
            WinPostMsg( g_hwndSettingsDialog, msg, mp1, mp2 );
        return MRESULT( FALSE );

    case UM_SETTINGS2DIALOG:
#ifdef _DOLOGDEBUG_
        LogDebug( "Page3Procedure: start UM_SETTINGS2DIALOG" );
#endif
        // set state of checkbuttons
        pset->AdjustButton (hwnd, WID_CB_SERIALCAPTURE,
                            pset->SerialCapture ());
        pset->AdjustButton (hwnd, WID_CB_DELAYCOUNTDOWN,
                            pset->DelayCountdown ());
        pset->AdjustButton (hwnd, WID_CB_DOSOUND,
                            pset->DoSound ());
        pset->AdjustButton (hwnd, WID_CB_IDLEPRIORITY,
                            pset->QueryFlag(SEI_IDLEPRIORITY));

        // init delay time sb
        WinSendDlgItemMsg (hwnd, WID_SB_DELAYTIME, SPBM_SETLIMITS,
                           MPFROMLONG (65536), MPFROMLONG (1));
        WinSendDlgItemMsg (hwnd, WID_SB_DELAYTIME, SPBM_SETCURRENTVALUE,
                           MPFROMLONG (pset->QueryDelayTime ()), 0);

        // init serial time sb
        WinSendDlgItemMsg (hwnd, WID_SB_SERIALTIME, SPBM_SETLIMITS,
                           MPFROMLONG (65536), MPFROMLONG (1));
        WinSendDlgItemMsg (hwnd, WID_SB_SERIALTIME, SPBM_SETCURRENTVALUE,
                           MPFROMLONG (pset->QuerySerialTime ()), 0);
#ifdef _DOLOGDEBUG_
        LogDebug( "Page3Procedure: end UM_SETTINGS2DIALOG" );
#endif
        return MRESULT (FALSE);

    case UM_ADJUST:
        {
#ifdef _DOLOGDEBUG_
            LogDebug( "Page3Procedure: start UM_ADJUST" );
#endif
            // query state of checkbuttons and set flags
            pset->SerialCapture(WinQueryButtonCheckstate
                                (hwnd, WID_CB_SERIALCAPTURE));
#ifdef _DOLOGDEBUG_
            LogDebug( "Page3Procedure: checkpoint 1" );
#endif
            pset->DelayCountdown(WinQueryButtonCheckstate
                                 (hwnd, WID_CB_DELAYCOUNTDOWN));
            pset->DoSound(WinQueryButtonCheckstate
                          (hwnd, WID_CB_DOSOUND));
            pset->SetFlag(SEI_IDLEPRIORITY, WinQueryButtonCheckstate
                          (hwnd, WID_CB_IDLEPRIORITY));
#ifdef _DOLOGDEBUG_
            LogDebug( "Page3Procedure: checkpoint 2" );
#endif

            // delay time
            ULONG   ul;
            if (! BOOL (WinSendDlgItemMsg (hwnd, WID_SB_DELAYTIME,
                                           SPBM_QUERYVALUE,
                                           MPFROMP (&ul),
                                           MPFROM2SHORT (0, 0))))
                ul = 5L;
            pset->SetDelayTime (ul);
#ifdef _DOLOGDEBUG_
            LogDebug( "Page3Procedure: checkpoint 3" );
#endif

            // serial time
            if (! BOOL (WinSendDlgItemMsg (hwnd, WID_SB_SERIALTIME,
                                           SPBM_QUERYVALUE,
                                           MPFROMP (&ul),
                                           MPFROM2SHORT (0, 0))))
                ul = 10L;
            pset->SetSerialTime (ul);
            pset->bSerialCapture = pset->SerialCapture ();
            pset->idleSetInIni = pset->QueryFlag(SEI_IDLEPRIORITY);

            if (saveum)
                pset->Save ();
#ifdef _DOLOGDEBUG_
            LogDebug( "Page3Procedure: end UM_ADJUST" );
#endif
        }
        break;

    case WM_CONTROL:
        switch (SHORT1FROMMP (mp1))
        {
        case WID_CB_SERIALCAPTURE:
            {
                HWND hwndButton =
                    WinWindowFromID (WinWindowFromID (hwndFrame, FID_CLIENT),
                                     WID_CB_DELAYEDCAPTURE);
                if (! WinSendDlgItemMsg (hwnd, WID_CB_SERIALCAPTURE,
                                         BM_QUERYCHECK, 0, 0))
                    WinEnableWindow (hwndButton, TRUE);
                else
                    WinEnableWindow (hwndButton, FALSE);
            }
            break;
        }
        return MRESULT (FALSE);
    }

    return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

// ** Page4Procedure ****************************************************** /*FOLD00*/

MRESULT EXPENTRY SETTINGS :: Page4Procedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static PSETTINGS   pset = NULL;

    switch (msg)
    {
    case WM_INITDLG:
        {
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: start WM_INITDLG" );
#endif
            pset = PSETTINGS (mp2);
            HMQ hmq = WinQueryWindowULong(hwnd /*WinWindowFromID(hwnd, ID_DLG_SETTINGSPAGE4)*/, QWL_HMQ);
            WinSetCp(hmq, 1207); // UPF-8 Unicode
            WinRemovePresParam(hwnd, PP_FONTNAMESIZE);
            pset->GetLanguages(WinWindowFromID (hwnd, WID_LB_LANGUAGES));

#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: WM_INITDLG: after GetLanguages()" );
#endif
            HDIR          hdir;
            ULONG         c, fl;
            FILEFINDBUF3  findbuf;
            APIRET        rc;
            PSZ           psz;

            // find all hlps and add the names to the language list
            fl   = FILE_NORMAL;
            hdir = HDIR_CREATE;
            c    = 1;
            rc   = DosFindFirst ("*.hlp", &hdir, fl, &findbuf,
                                 sizeof (findbuf), &c, FIL_STANDARD);
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: WM_INITDLG: Entering help file loop ..." );
#endif
            while (!rc)
            {
#ifdef _DOLOGDEBUG_
                LogDebug( "Page4Procedure: WM_INITDLG: Doing '%s' ...", findbuf.achName );
#endif
                if ((psz = strchr (findbuf.achName, '.')))
                    *psz = '\0';
                findbuf.achName[0] = toupper (findbuf.achName[0]);
                WinInsertLboxItem (WinWindowFromID (hwnd, WID_LB_LANGUAGESHELP),
                                   LIT_END, findbuf.achName);
                c = 1;
                rc = DosFindNext (hdir, &findbuf, sizeof (findbuf), &c);
            }
            DosFindClose (hdir);
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: WM_INITDLG: help file loop done." );
#endif

            WinSendMsg (hwnd, UM_SETTINGS2DIALOG, 0,0);

            if (pset->fAutoLanguage)
                WinEnableWindow (WinWindowFromID (hwnd, WID_ST_LANGNOTE),
                                 FALSE);
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: end WM_INITDLG" );
#endif

            UniChar     target[300];
            CHAR       ucLangStr[300];
            UconvObject     uconv_object866 = NULL;
            UconvObject     uconv_object860 = NULL;
            UconvObject     uconv_object852 = NULL;
            UconvObject     uconv_object1207 = NULL;
            UconvObject     uconv_object850 = NULL;
            int result;
            int i;
            HAB hab;
            CHAR ucFont[FACESIZE];

            UniCreateUconvObject((UniChar *)L"IBM-852", &uconv_object852);
            UniCreateUconvObject((UniChar *)L"IBM-850", &uconv_object850);
            UniCreateUconvObject((UniChar *)L"IBM-866", &uconv_object866);
           
            UniCreateUconvObject((UniChar *)L"IBM-1207", &uconv_object1207);
            for (i = 0; i < WID_ST_END - 400; i++) {
                WinLoadString(hab, g_hmod, LANG_COPYRIGHT + i, sizeof(ucLangStr), ucLangStr);
                if (pset->GetLangID() == 420 ||
                    pset->GetLangID() == PL) {
                    
                    UniStrToUcs( uconv_object852, target, ucLangStr, 299);
                }
                else if (pset->GetLangID() == RU)
                    UniStrToUcs( uconv_object866, target, ucLangStr, 299);
                else {
                    UniStrToUcs( uconv_object850, target, ucLangStr, 299);
                }
                UniStrFromUcs( uconv_object1207, ucLangStr, target, 300);
                WinSetDlgItemText(hwnd, WID_ST_COPYRIGHT + i, ucLangStr);
            }

            if (uconv_object866)
                UniFreeUconvObject(uconv_object866);
            if (uconv_object852)
                UniFreeUconvObject(uconv_object852);
            if (uconv_object850)
                UniFreeUconvObject(uconv_object850);
            if (uconv_object1207)
                UniFreeUconvObject(uconv_object1207);
            
            if (pset->GetLangID() == RU || pset->GetLangID() == CZ || pset->GetLangID() == PL ||
               pset->GetLangID() == IT) {
                strcpy(ucFont, "8.Times New Roman MT 30");
                WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
            }
            
            //    WinRemovePresParam(hwnd, PP_FONTNAMESIZE);*/
            //HMQ hmq = WinQueryWindowULong(hwnd /*WinWindowFromID(hwnd, WID_LB_LANGUAGES)*/, QWL_HMQ);
            //WinSetCp(hmq, 1207); // UPF-8 Unicode
        return MRESULT (FALSE);
        }

    case WM_COMMAND:
        if( SHORT1FROMMP( mp1 ) == DID_CANCEL )
            WinPostMsg( g_hwndSettingsDialog, msg, mp1, mp2 );
        return MRESULT( FALSE );

    case UM_SETTINGS2DIALOG:
        {

#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: start UM_SETTINGS2DIALOG" );
#endif
            // select the appropriate entry in the language-listbox
            CHAR     ach[_MAX_FNAME];
            HWND     hwndLB = WinWindowFromID (hwnd, WID_LB_LANGUAGES);
            ULONG    c, i;

            c = WinQueryLboxCount (hwndLB);

            for (i = 0; i < c; i++)
            {
#ifdef _DOLOGDEBUG_
                LogDebug( "Page4Procedure: UM_SETTINGS2DIALOG: i.1 = %d", i );
#endif
                PSZ psz = PSZ(WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGES,
                                                 LM_QUERYITEMHANDLE,
                                                 MPFROMLONG(i), NULL));
//                WinQueryLboxItemText (hwndLB, i, ach, sizeof (ach));
                if (stricmp (pset->QueryString(SEI_LANGUAGE), psz) == 0)
                    break;
            }
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: UM_SETTINGS2DIALOG: after loop 1" );
#endif
            if (i < c)
                WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGES, LM_SELECTITEM,
                                   MPFROMSHORT (i), MPFROMSHORT (TRUE));
            else
                WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGES, LM_SELECTITEM,
                                   MPFROMSHORT (0), MPFROMSHORT (TRUE));
            hwndLB = WinWindowFromID (hwnd, WID_LB_LANGUAGESHELP);
            c = WinQueryLboxCount (hwndLB);

            for (i = 0; i < c; i++)
            {
#ifdef _DOLOGDEBUG_
                LogDebug( "Page4Procedure: UM_SETTINGS2DIALOG: i.2 = %d", i );
#endif
                WinQueryLboxItemText (hwndLB, i, ach, sizeof (ach));
                if (stricmp (pset->QueryString (SEI_LANGUAGEHELP), ach) == 0)
                    break;
            }
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: UM_SETTINGS2DIALOG: after loop 2" );
#endif
            if (i < c)
                WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGESHELP, LM_SELECTITEM,
                                   MPFROMSHORT (i), MPFROMSHORT (TRUE));
            else
                WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGESHELP, LM_SELECTITEM,
                                   MPFROMSHORT (0), MPFROMSHORT (TRUE));
#ifdef _DOLOGDEBUG_
            LogDebug( "Page4Procedure: end UM_SETTINGS2DIALOG" );
#endif
        }
        return MRESULT (FALSE);

    case WM_DESTROY:
#ifndef _QUIET_
        {
            CHAR   ach[_MAX_FNAME];
            BOOL fChanged = TRUE;

            ULONG ul = USHORT (WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGES,
                                                  LM_QUERYSELECTION,
                                                  MPFROMLONG (LIT_FIRST), 0L));
            PSZ psz = PSZ(WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGES,
                                             LM_QUERYITEMHANDLE,
                                             MPFROMLONG(ul), NULL));
            if (stricmp (pset->QueryString(SEI_LANGUAGE), psz) == 0)
                fChanged = FALSE;
            else
                pset->SetString(SEI_LANGUAGE, psz);
#if 0
            ul = USHORT (WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGESHELP,
                                            LM_QUERYSELECTION,
                                            MPFROMLONG (LIT_FIRST), 0L));
            WinSendDlgItemMsg (hwnd, WID_LB_LANGUAGESHELP, LM_QUERYITEMTEXT,
                               MPFROM2SHORT (ul, sizeof (ach)), MPFROMP (ach));
            if (stricmp (pset->QueryString(SEI_LANGUAGEHELP), ach) == 0 && !fChanged)
                fChanged = FALSE;
            else
                pset->SetString (SEI_LANGUAGEHELP, ach);
#endif
            if (fChanged) {
                if (!stricmp(psz, "gotreses") || !stricmp(psz, "goqreses"))
                    strcpy(ach, "gotcha_es");
                else if (!stricmp(psz, "gotresbr") || !stricmp(psz, "goqresbr"))
                    strcpy(ach, "gotcha_br");
                else if (!stricmp(psz, "gotresit") || !stricmp(psz, "goqresit"))
                    strcpy(ach, "gotcha_it");
                else
                    strcpy(ach, "gotcha_en");
                pset->SetString (SEI_LANGUAGEHELP, ach);
            }
            if (saveum && fChanged) {
                pset->Save ();
#ifdef _QUIET_
                HINI hini = PrfOpenProfile (hab, "gotchaq.ini");
#else
                HINI hini = PrfOpenProfile (hab, "gotcha.ini");
#endif
                BOOL fLChanged = TRUE;
                PrfWriteProfileData(hini, "Language", "LangChangeRequested", &fLChanged, sizeof(BOOL));
                if (hini)
                    PrfCloseProfile (hini);
            }
        }
#endif
        return MRESULT (FALSE);
    }

    return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

// ** AdjustSaveTypeButtons *********************************************** /*FOLD00*/

VOID AdjustSaveTypeButtons (BOOL f)
{
    HWND   hwndClient = WinWindowFromID (hwndFrame, FID_CLIENT);

    // FIXME um, em, global variables :-$
    WinEnableWindow (WinWindowFromID (hwndClient, WID_RB_CLIPBOARD), !f);
    WinEnableWindow (WinWindowFromID (hwndClient, WID_RB_FILE), !f);
}

// ** QueryWindowData ***************************************************** /*FOLD00*/

VOID SETTINGS :: QueryWindowData (SWP *pswp, USHORT us[7], BOOL f)
{
    // FIXME puke, yukk, choke! get this flag thing away! do it better!
    // FIXME what is with US?
    if (f)
        memcpy (pswp, QueryBinary(SEI_SWPSSW), sizeof (SWP));
    else
        memcpy (pswp, QueryBinary(SEI_SWP), sizeof (SWP));

    LONG  cx, cy;
    cx = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
    cy = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);

    if (pswp->cx < 32)
        pswp->cx = 32;
    // bigger than screen?
    if (pswp->cx > cx)
        pswp->cx = cx;
    // partly outside of screen?
    if (pswp->x+pswp->cx >= cx)
        pswp->x = cx-pswp->cx;
    if (pswp->cy < 32)
        pswp->cy = 32;
    // bigger than screen?
    if (pswp->cy > cy)
        pswp->cy = cy;
    // partly outside of screen?
    if (pswp->y+pswp->cy >= cy)
        pswp->y = cy-pswp->cy;
}

// ** ReloadResources ***************************************************** /*FOLD00*/

BOOL Settings :: ReloadResources (PSZ psz)
{
    if (g_hmod)
        DosFreeModule(g_hmod);

    APIRET  rc;

    if ((rc = DosLoadModule(PSZ(NULL), 0, psz, &g_hmod)))
    {
        DisplayError(RSTR(IDS_HEADER_ERROR),
                     RSTR(IDS_ERROR_RESOURSEMODFAILED), psz, rc);
        exit(1);
    }
    PVOID pv;
    INT Lang;

    DosGetResource(g_hmod, RT_RCDATA, LANG_ID, &pv);
    Lang = atoi((PCHAR) pv);
    SetLangID(Lang);
    ResourceString::Module(g_hmod);
#ifdef _QUIET_
    pszPageTab[0] = RSTR (IDS_MAINWIN);
    pszPageTab[1] = RSTR (IDS_CAPTURE );
    pszPageTab[2] = RSTR (IDS_PAGESAVE);
    pszPageTab[3] = RSTR (IDS_PAGELANGUAGE);
#else
    pszPageTab[0] = RSTR (IDS_PAGESAVE);
    pszPageTab[1] = RSTR (IDS_PAGESNAPSHOT);
    pszPageTab[2] = RSTR (IDS_CAPTURE );
    pszPageTab[3] = RSTR (IDS_PAGELANGUAGE);
#endif
    for( int i = 0; i < BMF_INVALID; i++ ) {
        ifi[ i ].label = RSTR ( IDS_BMF_JPG+i ); }

    return TRUE;
}

// ** SelectLanguage ****************************************************** /*FOLD00*/

VOID Settings :: SelectLanguage (VOID)
{
    // set this to some default, as we must open the settings dialog for
    // selecting a language
#ifdef _QUIET_
//#if 1
    pszPageTab[0] = RSTR (IDS_MAINWIN);
    pszPageTab[1] = RSTR (IDS_CAPTURE );
    pszPageTab[2] = RSTR (IDS_PAGESAVE);
    pszPageTab[3] = RSTR (IDS_PAGELANGUAGE);
#else
    pszPageTab[0] = RSTR (IDS_PAGESAVE);
    pszPageTab[1] = RSTR (IDS_PAGESNAPSHOT);
    pszPageTab[2] = RSTR (IDS_CAPTURE );
    pszPageTab[3] = RSTR (IDS_PAGELANGUAGE);
#endif
    // bring up the "select language" settings page
    Dialog (TRUE);
}

// ** GetLanguages ******************************************************** /*FOLD00*/

USHORT Settings :: GetLanguages (HWND hwnd)
{
    // find all dlls and add the names to the language list
    HDIR          hdir;
    ULONG         c, fl, ul;
    FILEFINDBUF3  findbuf;
    APIRET        rc;
    PSZ           psz;
    HMODULE       hmod;

    fl   = FILE_NORMAL;
    hdir = HDIR_CREATE;
    c    = 1;
#ifdef _QUIET_
    rc   = DosFindFirst ("goqres*.dll", &hdir, fl, &findbuf,
                         sizeof (findbuf), &c, FIL_STANDARD);
#else
    rc   = DosFindFirst ("gotres*.dll", &hdir, fl, &findbuf,
                         sizeof (findbuf), &c, FIL_STANDARD);
#endif
    while (!rc)
    {
        // we don't want the extension
        if ((psz = strchr (findbuf.achName, '.')))
            *psz = '\0';
        // try opening the dll and read the version etc. data
        if ((rc = DosLoadModule(PSZ(NULL), 0, findbuf.achName, &hmod)) == NO_ERROR) {
            PVOID pv;
            PVOID pl;

            if (DosGetResource(hmod, RT_RCDATA, DLL_ID, &pv) == NO_ERROR) {
#ifdef _QUIET_
                if (strcmp(PSZ(pv), "Gotchaq!") == 0) {
#else
                if (strcmp(PSZ(pv), "Gotcha!") == 0) {
#endif
                    psz = PSZ(pv)+strlen(PSZ(pv)) + 3;
                    
                    INT Lang;
                
                    DosGetResource(hmod, RT_RCDATA, LANG_ID, &pl);
                    Lang = atoi((PCHAR) pl);
#if 1
                    UniChar     target[300];
                    CHAR       ucLangStr[300];
                    UconvObject     uconv_object866 = NULL;
                    UconvObject     uconv_object852 = NULL;
                    UconvObject     uconv_object1207 = NULL;
                    UconvObject     uconv_object850 = NULL;
                    int i;
                    
                    strcpy(ucLangStr, psz);
                    UniCreateUconvObject((UniChar *)L"IBM-852", &uconv_object852);
                    UniCreateUconvObject((UniChar *)L"IBM-850", &uconv_object850);
                    UniCreateUconvObject((UniChar *)L"IBM-866", &uconv_object866);
                    UniCreateUconvObject((UniChar *)L"IBM-1207", &uconv_object1207);
                    
                    if (Lang == CZ) {
                        UniStrToUcs( uconv_object852, target, ucLangStr, 299);
                        }
                        else {
                            UniStrToUcs( uconv_object850, target, ucLangStr, 299);
                        }
                        /*if (Lang == RU) {
                            UniStrToUcs( uconv_object866, target, ucLangStr, 299);
                        } */
                        UniStrFromUcs( uconv_object1207, ucLangStr, target, 300);
                    Lang = 0;
                    if (uconv_object866)
                        UniFreeUconvObject(uconv_object866);
                    if (uconv_object852)
                        UniFreeUconvObject(uconv_object852);
                    if (uconv_object850)
                        UniFreeUconvObject(uconv_object850);
                    if (uconv_object1207)
                        UniFreeUconvObject(uconv_object1207);


#endif
                    ul = WinInsertLboxItem (hwnd, LIT_END,/*psz*/ucLangStr);
                    WinSendMsg(hwnd, LM_SETITEMHANDLE, MPFROMLONG(ul),
                               MPFROMP (strdup(findbuf.achName)));
                }
                if (pl)
                    DosFreeResource(pl);
                DosFreeResource(pv);
            }
            DosFreeModule(hmod);
        }
        c = 1;
        rc = DosFindNext (hdir, &findbuf, sizeof (findbuf), &c);
    }
    DosFindClose (hdir);

    return 1;
}

// ** GetFileExtension **************************************************** /*FOLD00*/

PSZ Settings :: GetFileExtension( SHORT type )
{
    if( type == BMF_INVALID )
        type = SHORT( QueryFileFormat() );
    if( ( type >= BMF_JPG ) && ( type < BMF_INVALID ) )
        return ifi[ type ].extension;
    return "";
}

#if 0
// ** GetFOURCC *********************************************************** /*FOLD00*/

FOURCC Settings :: GetFOURCC( SHORT type )
{
    if( type == BMF_INVALID )
        type = SHORT( QueryFileFormat() );
    if( ( type >= BMF_JPG ) && ( type < BMF_INVALID ) )
        return ifi[ type ].fourcc;
    return 0L;
}
#endif
// ** GetFileEAType ******************************************************* /*FOLD00*/

PSZ Settings :: GetFileEAType( SHORT type )
{
    if( type == BMF_INVALID )
        type = SHORT( QueryFileFormat() );
    if( ( type >= BMF_JPG ) && ( type < BMF_INVALID ) )
        return ifi[ type ].eaType;
    return "";
}

// ************************************************************************

PSZ Settings :: QueryNumSaveDir( VOID )
{
    // Using a static buffer here is not really good, but good enough
    // currently as we know there will be no concurrent access.
    static CHAR ach[_MAX_PATH];

    if( strspn( QueryString( SEI_NUMSAVEDIR ), " \t\n\r" ) ==
        strlen( QueryString( SEI_NUMSAVEDIR ) ) )
        return getcwd( ach, _MAX_PATH );
    return QueryString( SEI_NUMSAVEDIR );
}

// ************************************************************************

ULONG winhDrawFormattedText(HPS hps,     // in: presentation space; its settings
                                         // are used, but not altered
                            PRECTL prcl, // in/out: rectangle to use for drawing
                                         // (modified)
                            const char *pcszText, // in: text to draw (zero-terminated)
                            ULONG flCmd) // in: flags like in WinDrawText; I have
                                         // only tested DT_TOP and DT_LEFT though.
                                         // DT_WORDBREAK | DT_TEXTATTRS are always
                                         // set.
                                         // You can specify DT_QUERYEXTENT to only
                                         // have prcl calculated without drawing.
{
    PSZ     p = (PSZ)pcszText;
    LONG    lDrawn = 1,
            lTotalDrawn = 0,
            lLineCount = 0,
            lOrigYTop = prcl->yTop;
    ULONG   ulTextLen = strlen(pcszText),
            ulCharHeight,
            flCmd2,
            xLeftmost = prcl->xRight,
            xRightmost = prcl->xLeft;
    RECTL   rcl2;

    flCmd2 = flCmd | DT_WORDBREAK | DT_TEXTATTRS;

    ulCharHeight = 30;//gpihQueryLineSpacing(hps);

    while (    (lDrawn)
            && (lTotalDrawn < ulTextLen)
          )
    {
        memcpy(&rcl2, prcl, sizeof(rcl2));
        lDrawn = WinDrawText(hps,
                             ulTextLen-lTotalDrawn,
                             p,
                             &rcl2,
                             0, 0,                       // colors
                             flCmd2);

        // update char counters
        p += lDrawn;
        lTotalDrawn += lDrawn;

        // update x extents
        if (rcl2.xLeft < xLeftmost)
            xLeftmost = rcl2.xLeft;
        if (rcl2.xRight > xRightmost)
            xRightmost = rcl2.xRight;

        // update y for next line
        prcl->yTop -= ulCharHeight;

        // increase line count
        lLineCount++;
    }
    prcl->xLeft = xLeftmost;
    prcl->xRight = xRightmost;
    prcl->yBottom = prcl->yTop;
    prcl->yTop = lOrigYTop;

    return lLineCount;
}
