/***
 This file belongs to the Gotcha! distribution.
 Copyright (C) 1998-2002 Thorsten Thielen <thth@c2226.de>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/

// ** CreateMainWindow **************************************************** /*FOLD00*/

HWND CreateMainWindow (VOID)
{
#ifdef _QUIET_
    hwndFrame = WinLoadDlg (HWND_OBJECT, NULLHANDLE, NULL, GETMODULE,
                            ID_DLG_MAIN, NULL);
#else
    hwndFrame = WinLoadDlg (HWND_DESKTOP, NULLHANDLE, NULL, GETMODULE,
                            ID_DLG_MAIN, NULL);
#endif
    OldFrameWP = WinSubclassWindow (hwndFrame, FrameProcedure);
#ifndef _QUIET_
    // attach the icon
    if (HPOINTER hicon = WinLoadPointer (HWND_DESKTOP, GETMODULE, 1))
        WinSendMsg (hwndFrame, WM_SETICON, MPFROMLONG (hicon), NULL);

    // attach the accelerator table
    if (HACCEL haccel = WinLoadAccelTable (hab, GETMODULE, 1))
        WinSetAccelTable (hab, haccel, hwndFrame);
#endif

    // add extensions to system menu
/*    static MENUITEM MenuAbout = { MIT_END, MIS_TEXT, 0, WID_PB_ABOUT, 0, 0 };
    static MENUITEM MenuSettings = { MIT_END, MIS_TEXT, 0, WID_PB_SETTINGS, 0, 0 };
    static MENUITEM MenuGeneralHelp = { MIT_END, MIS_TEXT, 0, HM_GENERAL_HELP, 0, 0 };
    static MENUITEM MenuSeparator = { MIT_END, MIS_SEPARATOR, 0, 0, 0, 0 };

    AddSysMenuItem (hwndFrame, &MenuSeparator, NULL);
    AddSysMenuItem (hwndFrame, &MenuSettings, RSTR(IDS_SETTINGS));
    AddSysMenuItem (hwndFrame, &MenuGeneralHelp, RSTR(IDS_GENERALHELP));
    AddSysMenuItem (hwndFrame, &MenuAbout, RSTR(IDS_PRODUCTINFORMATION));*/

    HWND   hwnd = WinWindowFromID (hwndFrame, FID_CLIENT);

    // select the radio button
    switch (pset->QuerySaveStyle ())
    {
    case SAVESTYLE_CLIPBOARD:
        WinSendDlgItemMsg (hwnd, WID_RB_CLIPBOARD, BM_CLICK,
                           MPFROMSHORT (TRUE), 0);      break;
    default:
        WinSendDlgItemMsg (hwnd, WID_RB_FILE, BM_CLICK,
                           MPFROMSHORT (TRUE), 0);      break;
    }
    AdjustSaveTypeButtons (BOOL (pset->QueryFileSaveStyle ()==FSS_FORCEFILE));

    if (pset->SerialCapture ())
        WinEnableWindow (WinWindowFromID (hwnd, WID_CB_DELAYEDCAPTURE), FALSE);

    // adjust the other buttons
    WinSendDlgItemMsg (hwnd, WID_CB_HIDEWINDOW, BM_SETCHECK,
                       MPFROMLONG (pset->HideWindow ()), MPFROMLONG (0));
    WinSendDlgItemMsg (hwnd, WID_CB_DELAYEDCAPTURE, BM_SETCHECK,
                       MPFROMLONG (pset->DelayedCapture ()), MPFROMLONG (0));
    return hwndFrame;
}

// ** Drag **************************************************************** /*FOLD00*/

VOID Drag (HWND hwnd)
{
    // determine the new window position
    TRACKINFO   trackinfo ;
    memset (&trackinfo, 0, sizeof (trackinfo));

    trackinfo.cxBorder = 1;
    trackinfo.cyBorder = 1;
    trackinfo.cxGrid = 1;
    trackinfo.cyGrid = 1;
    trackinfo.cxKeyboard = 8;
    trackinfo.cyKeyboard = 8;
 
    SWP   swp;
    WinQueryWindowPos (hwnd, &swp);
    trackinfo.rclTrack.xLeft   = swp.x;
    trackinfo.rclTrack.xRight  = swp.x + swp.cx;
    trackinfo.rclTrack.yBottom = swp.y;
    trackinfo.rclTrack.yTop    = swp.y + swp.cy;

    WinQueryWindowPos (HWND_DESKTOP, &swp);
    trackinfo.rclBoundary.xLeft   = swp.x;
    trackinfo.rclBoundary.xRight  = swp.x + swp.cx;
    trackinfo.rclBoundary.yBottom = swp.y;
    trackinfo.rclBoundary.yTop    = swp.y + swp.cy;

    trackinfo.ptlMinTrackSize.x = 0;
    trackinfo.ptlMinTrackSize.y = 0;
    trackinfo.ptlMaxTrackSize.x = swp.cx;
    trackinfo.ptlMaxTrackSize.y = swp.cy;

    trackinfo.fs = TF_MOVE | TF_STANDARD | TF_ALLINBOUNDARY;

    if (WinTrackRect (HWND_DESKTOP, 0, &trackinfo))
        WinSetWindowPos (hwnd, 0, trackinfo.rclTrack.xLeft,
                         trackinfo.rclTrack.yBottom, 0, 0, SWP_MOVE);
}

// ** FrameProcedure ****************************************************** /*FOLD00*/

MRESULT EXPENTRY FrameProcedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    // ATTENTION: used by both main & snapshot window!

    switch (msg)
    {
    case WM_QUERYTRACKINFO:
        {
            OldFrameWP (hwnd, msg, mp1, mp2);
            PTRACKINFO  pti = PTRACKINFO (mp2);
            pti->ptlMinTrackSize.x = pti->ptlMinTrackSize.y = 16;
        }
        return MRESULT (TRUE);

    case WM_WINDOWPOSCHANGED:
        if ((PSWP (mp1)->fl & SWP_HIDE))
            WinPostMsg (WinWindowFromID (hwnd, FID_CLIENT),
                        UM_WINDOWHIDDEN, 0,0);
        break;
    }

    return OldFrameWP (hwnd, msg, mp1, mp2);
}

// ** WindowProcedure ***************************************************** /*FOLD00*/

MRESULT EXPENTRY WindowProcedure (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static BOOL     fInterior = FALSE;
    static USHORT   usState = STATE_IDLE, usCap;
    static ULONG    ulTimer, ulCountdown;
    static HWND     hwndCap, hwndParent;
    static RECTL    rcl;

#ifdef _DOLOGDEBUG_
    LogDebug( "MainWin:WindowProcedure:Message 0x%04x", msg );
#endif

    switch (msg)
    {
#ifndef _QUIET_
    case WM_CREATE:
#else
    case WM_INITDLG:
#endif
        {
#ifdef _DOLOGDEBUG_
            LogDebug( "MainWin:WindowProcedure: WM_CREATE" );
#endif
#ifndef _QUIET_
            USHORT   usResID = WinQueryWindowUShort (hwnd, QWS_ID);

            // attach the icon
            if (HPOINTER hicon = WinLoadPointer (HWND_DESKTOP, GETMODULE, usResID))
                WinSendMsg (hwnd, WM_SETICON, MPFROMLONG (hicon), MPVOID);

            RECTL   rcl;
            WinQueryWindowRect (hwndFrame, &rcl);
            WinCalcFrameRect (hwndFrame, &rcl, TRUE);
            WinSetWindowPos (WinWindowFromID (hwndFrame, FID_CLIENT), HWND_TOP,
                             rcl.xLeft, rcl.yBottom, rcl.xRight - rcl.xLeft,
                             rcl.yTop - rcl.yBottom,
                             SWP_SHOW | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
#endif
        }
#ifdef _QUIET_
        WinSendDlgItemMsg (hwnd, WID_CB_HIDEWINDOW, BM_SETCHECK,
                           MPFROMLONG (TRUE), MPFROMLONG (0));
        WinSendDlgItemMsg (hwnd, WID_CB_DELAYEDCAPTURE, BM_SETCHECK,
                           MPFROMLONG (pset->DelayedCapture ()),
                           MPFROMLONG (0));
        WinSetFocus( WinWindowFromID (g_hwndPage0, WID_RB_FILE), FALSE );
        return MRESULT (FALSE);
#else
        break;
#endif

    case WM_QUIT:
#ifdef _DOLOGDEBUG_
        LogDebug( "MainWin:WindowProcedure: WM_QUIT" );
#endif
    case WM_SAVEAPPLICATION:
#ifdef _DOLOGDEBUG_
        LogDebug( "MainWin:WindowProcedure: WM_SAVEAPPLICATION" );
#endif
    case WM_CLOSE:
#ifdef _DOLOGDEBUG_
        LogDebug( "MainWin:WindowProcedure: WM_CLOSE" );
#endif
        WinSendMsg (hwnd, UM_ADJUSTSETTINGS, 0,0);
        break;

    case UM_ADJUSTSETTINGS:
        {
#ifdef _DOLOGDEBUG_
            LogDebug( "MainWin:WindowProcedure: UM_ADJUSTSETTINGS" );
#endif
            if (WinSendMsg (WinWindowFromID (hwnd, WID_RB_CLIPBOARD),
                            BM_QUERYCHECK, 0,0))
                pset->SetSaveStyle (SAVESTYLE_CLIPBOARD);
            else
                pset->SetSaveStyle (SAVESTYLE_FILE);

            BOOL   f = FALSE;
            f = BOOL (WinSendDlgItemMsg (hwnd, WID_CB_HIDEWINDOW,
                                         BM_QUERYCHECK, 0, 0));
            pset->HideWindow (f);
#ifndef _QUIET_
            f = BOOL (WinSendDlgItemMsg (hwnd, WID_CB_DELAYEDCAPTURE,
                                         BM_QUERYCHECK, 0, 0));
            pset->DelayedCapture (f);
#endif
        }
        return MRESULT (FALSE);

    case WM_MOUSEMOVE:
        // we don't want the mouse pointer to be reset so capture this msg
        return MRESULT (FALSE);

#ifndef _QUIET_
    case WM_PAINT:
        {
            HPS   hps;
            RECTL rcl;
            COLOR color = SYSCLR_DIALOGBACKGROUND;

            HWND  hwnd2 = WinWindowFromID (hwnd, WID_RB_CLIPBOARD);
            WinQueryPresParam (hwnd2, PP_BACKGROUNDCOLOR, 0, NULL,
                               sizeof (color), &color, 0L);

            hps = WinBeginPaint (hwnd, NULLHANDLE, &rcl);
            WinQueryWindowRect (hwnd, &rcl);
            WinFillRect (hps, &rcl, color);
            WinEndPaint (hps);
        }
        break;
#endif

    case WM_COMMAND:
#ifdef _DOLOGDEBUG_
        LogDebug( "MainWin:WindowProcedure: WM_COMMAND" );
#endif
        if (usState != STATE_IDLE)
        {
            //Attempt to open settings probably a hang
            if (SHORT1FROMMP (mp1) == WID_PB_SETTINGS) {
                WinSendMsg (hwnd, UM_ABORT, 0,0);
                pset->Dialog ();
            }
            // this means ESC was pressed
            else if (SHORT1FROMMP (mp1) == DID_CANCEL)
                WinSendMsg (hwnd, UM_ABORT, MPFROMLONG(1),0);
            return MRESULT (FALSE);
        }
#ifndef _QUIET_
        else
            // FIXME pretty yukki to do it this way I guess ...
            WinSendMsg (hwnd, UM_ADJUSTSETTINGS, 0,0);
#endif         
        switch (SHORT1FROMMP (mp1))
        {
        case WID_RB_CLIPBOARD:
            WinSendDlgItemMsg (hwnd, WID_RB_CLIPBOARD, BM_CLICK,
                               MPFROMSHORT (TRUE), PVOID (0));
            break;
        case WID_RB_FILE:
            WinSendDlgItemMsg (hwnd, WID_RB_FILE, BM_CLICK,
                               MPFROMSHORT (TRUE), PVOID (0));
            break;
        case WID_CB_HIDEWINDOW:
            WinSendDlgItemMsg (hwnd, WID_CB_HIDEWINDOW, BM_CLICK,
                               MPFROMSHORT (TRUE), PVOID (0));
            break;
        case WID_CB_DELAYEDCAPTURE:
            WinSendDlgItemMsg (hwnd, WID_CB_DELAYEDCAPTURE, BM_CLICK,
                               MPFROMSHORT (TRUE), PVOID (0));
            break;

        case WID_PB_ABOUT:
            AboutBox (hwnd);
            break;

        case WID_PB_SETTINGS:
            pset->Dialog ();
            break;

        case WID_PB_SETCAPTURETYPE:
            //int capType;
            if (LONGFROMMP(mp2) == 1) {
                pset->SetSaveStyle (SAVESTYLE_CLIPBOARD);
            }

            switch (pset->QuerySSWCaptureType ())
            {
            case CAP_WINDOWINT:
                WinSendMsg (hwndFrame, WM_COMMAND,
                            MPFROM2SHORT (WID_PB_WINDOWINTERIOR,0), 0);
            case CAP_SCREENREGION:
                WinSendMsg (hwndFrame, WM_COMMAND,
                            MPFROM2SHORT (WID_PB_SCREENREGION,0), 0);
            case CAP_WINDOW:
                WinSendMsg (hwndFrame, WM_COMMAND,
                            MPFROM2SHORT (WID_PB_WINDOW,0), 0);
            default:
               WinSendMsg (hwndFrame, WM_COMMAND,
                            MPFROM2SHORT (WID_PB_SCREEN,0), 0);
            }
            break;

        case WID_PB_SCREEN:
            usCap = CAP_SCREEN;
#ifdef _QUIET_
            WinShowWindow (g_hwndSettingsDialog, FALSE);
            // WinSendMsg (g_hwndSettingsDialog, WM_CLOSE, 0,0); //Needs to go to the setting dialog
            // Replace current global with pset->GetSettingDialogHwnd () or such
            // Need for all 4 cases;
#endif
            WinSendMsg (hwnd, UM_PREPARECAPTURE, 0,0);
            break;

        case WID_PB_SCREENREGION:
            usCap = CAP_SCREENREGION;
#ifdef _QUIET_
            WinShowWindow (g_hwndSettingsDialog, FALSE);
#endif
            WinSendMsg (hwnd, UM_PREPARECAPTURE, 0,0);
            break;

        case WID_PB_WINDOWINTERIOR:
            usCap = CAP_WINDOWINT;
#ifdef _QUIET_
            WinShowWindow (g_hwndSettingsDialog, FALSE);
#endif
            WinSendMsg (hwnd, UM_PREPARECAPTURE, 0,0);
            break;

        case WID_PB_WINDOW:
            usCap = CAP_WINDOW;
#ifdef _QUIET_
            WinShowWindow (g_hwndSettingsDialog, FALSE);
#endif
            WinSendMsg (hwnd, UM_PREPARECAPTURE, 0,0);
            break;

        case WID_PB_EXIT:
            WinSendMsg (WinWindowFromID (hwndFrame, FID_CLIENT),
                        WM_CLOSE, 0,0);
            break;

        case HM_HELP_CONTENTS:    g_phelp->DisplayContents ();       break;
        case HM_HELP_INDEX:       g_phelp->DisplayIndex ();          break;
        case HM_KEYS_HELP:        g_phelp->DisplayKeysHelp ();       break;

        case HM_GENERAL_HELP:
            g_phelp->DisplayGeneralHelp ();
            break;

        default:
            break;
        }
        return MRESULT (FALSE);

    case UM_PREPARECAPTURE:
        WinSendMsg (hwndSnapshot, UM_STARTCAPTURE, 0,0);
        usState = STATE_WAITFORHIDE;

        if (usCap == CAP_SCREENREGION || usCap == CAP_SCREEN) {
#ifdef _QUIET_
            hwndParent = WinQueryFocus(HWND_DESKTOP);
#else
            hwndParent = WinQueryWindow(hwndFrame, QW_NEXTTOP );
#endif
        }
        /*else {
            SWP     swp;
            CHAR    ach[32] = {0};

            WinQueryClassName (WinQueryFocus(HWND_DESKTOP), sizeof (ach), ach);
            if (stricmp (ach, "#4") == 0) {
                WinSendMsg (hwnd, UM_ABORT, 0,0);
                if (usCap == CAP_WINDOW)
                    WinSendMsg (hwndFrame, WM_COMMAND,
                                MPFROM2SHORT (WID_PB_WINDOW,0), 0);
                else
                    WinSendMsg (hwndFrame, WM_COMMAND,
                                MPFROM2SHORT (WID_PB_WINDOWINTERIOR,0), 0);
                return MRESULT (FALSE);
            }
        } */
#ifndef _QUIET_
        if (WinQueryButtonCheckstate (hwnd, WID_CB_HIDEWINDOW)) {
            WinShowWindow (WinQueryWindow (hwnd, QW_PARENT), FALSE);
        }
        else
#endif
            WinPostMsg (hwnd, UM_WINDOWHIDDEN, 0,0);
        return MRESULT (FALSE);

    case UM_WINDOWHIDDEN:
        if (usState == STATE_WAITFORHIDE)
        {
            // FIXME
            // I have no idea why this delay is necessary, but CAP_SCREEN with
            // hiding our window does not work without it ...
            DosSleep (100);
            usState = STATE_SELECTWINDOW;
            WinSendMsg (hwnd, UM_SELECTWINDOW, 0,0);
        }
        return MRESULT (FALSE);

    case UM_SELECTWINDOW:
        switch (usCap)
        {
        case CAP_SCREEN:
            usState = STATE_WINDOWSELECTED;
            WinPostMsg (hwnd, UM_WINDOWSELECTED,
                        MPFROMHWND (HWND_DESKTOP),
                        MPFROMHWND (HWND_DESKTOP));
            break;

        case CAP_SCREENREGION:
#ifdef _QUIET_
            WinSetFocus(HWND_DESKTOP, hwnd);
#endif
            if (DoTracking (&rcl))
            {
                usState = STATE_WINDOWSELECTED;

                /*int rc = saymsg2(1, hwnd, RSTR(IDS_CAPTURE), RSTR(IDS_WISHCONTINUE));
                
                if (rc == 1)
                    DosSleep(100); // Let the dialog close*/
                    WinPostMsg (hwnd, UM_WINDOWSELECTED,
                                MPFROMHWND (HWND_DESKTOP),
                                MPFROMHWND (HWND_DESKTOP));
                /*if (rc == 2)
                    WinSendMsg (hwnd, UM_ABORT, MPFROMLONG(1),0);
                if (rc == 3) {
                    pset->Dialog ();
                    DosSleep(100); // Let the dialogs close
                    WinPostMsg (hwnd, UM_WINDOWSELECTED,
                                MPFROMHWND (HWND_DESKTOP),
                                MPFROMHWND (HWND_DESKTOP));
                }*/
            }
            else
                usState = STATE_IDLE;
            break;

        case CAP_WINDOWINT:
            fInterior = TRUE;
#ifdef _QUIET_
            WinSetFocus(HWND_DESKTOP, hwnd);
#endif
            StartSelection (hwnd);
            break;

        case CAP_WINDOW:
            fInterior = FALSE;
#ifdef _QUIET_
            WinSetFocus(HWND_DESKTOP, hwnd);
#endif
            StartSelection (hwnd);
            break;

        default:
            usState = STATE_IDLE;
            break;
        }
        return MRESULT (FALSE);

    case WM_BUTTON1UP:
        if (usState != STATE_SELECTWINDOW)
            return MRESULT (FALSE);
        else
        {
            POINTL   ptl;
            WinQueryPointerPos (HWND_DESKTOP, &ptl);
            HWND   hwndCapture =
                WinWindowFromPoint (HWND_DESKTOP, &ptl, FALSE);

            if (hwndCapture && (hwndCapture != HWND_DESKTOP))
            {
                HWND   hwndOld = hwndCapture;

                if (fInterior)
                    if (! (hwndCapture = WinWindowFromID (hwndOld,
                                                          FID_CLIENT)))
                        hwndCapture = WinQueryWindow (hwndOld, QW_BOTTOM);

                if (hwndCapture && (hwndCapture != HWND_DESKTOP))
                {
                    usState = STATE_WINDOWSELECTED;
                    WinPostMsg (hwnd, UM_WINDOWSELECTED,
                                MPFROMHWND (hwndCapture),
                                MPFROMHWND (hwndOld));
                }
                else
                    usState = STATE_IDLE;
            }
            else
                usState = STATE_IDLE;
        }
        return MRESULT (FALSE);

    case UM_WINDOWSELECTED:
        if (usState == STATE_WINDOWSELECTED)
        {
            // release the pointing device capture if it is active
            if (WinQueryCapture (HWND_DESKTOP) == hwnd)
                WinSetCapture (HWND_DESKTOP, NULLHANDLE);

            // reset the pointer to normal shape
            WinSetPointer (HWND_DESKTOP, WinQuerySysPointer (HWND_DESKTOP,
                                                             SPTR_ARROW,
                                                             FALSE));
            hwndCap = HWND (mp1);
            if (usCap != CAP_SCREENREGION && usCap != CAP_SCREEN)
                hwndParent = HWND (mp2);
            if (pset->SerialCapture ())
            {
                ulTimer = WinStartTimer (hab, hwnd, 1, 49);
                ulCountdown = pset->QuerySerialTime ();
            }
            else if (WinQueryButtonCheckstate (hwnd, WID_CB_DELAYEDCAPTURE))
            {
                ulTimer = WinStartTimer (hab, hwnd, 1, 990);
                ulCountdown = pset->QueryDelayTime ();
            }
            else
            {
                usState = STATE_CAPTURE;
                WinPostMsg (hwnd, UM_CAPTURE, 0,0);
            }
        }
        return MRESULT (FALSE);

    case WM_TIMER:
        ulCountdown --;
       
        if( ulCountdown % 20 == 0 )
            WinSendMsg (hwndSnapshot, UM_COUNTDOWN,
                        MPFROMLONG (ulCountdown), 0);
        if (pset->DelayCountdown () && !pset->SerialCapture ())
            DoCountdown (ulCountdown);

        if (ulCountdown == 0)
        {
            WinStopTimer (hab, hwnd, ulTimer);
            usState = STATE_CAPTURE;
            WinSendMsg (hwnd, UM_CAPTURE, 0,0);
        }
        return MRESULT (FALSE);

    case UM_CAPTURE:
        usState = STATE_WAITFORHIDE2;
#ifndef _QUIET_
        if (pset->SSWHide () && WinIsWindowVisible (hwndSnapshot))
            WinShowWindow (hwndSnapshot, FALSE);
        else
#endif
            WinSendMsg (hwnd, UM_CAPTURE2, 0,0);
        return MRESULT (FALSE);

    case UM_SSWHIDDEN:
        // FIXME
        // I have no idea why this delay is necessary, but CAP_SCREEN with
        // hiding our window does not work without it ...
        DosSleep (100);
        WinSendMsg (hwnd, UM_CAPTURE2, 0,0);
        return MRESULT (FALSE);

    case UM_CAPTURE2:
        if (usState == STATE_WAITFORHIDE2)
        {
            HBITMAP  hbm;

            WinEnableWindow (hwnd, FALSE);
            // capture the window to a bitmap and save this
            if (usCap == CAP_SCREENREGION)
                hbm = CaptureWindow (hwndCap, hwndParent, &rcl, FALSE);
            else if (usCap == CAP_SCREEN)
                hbm = CaptureWindow (hwndCap, hwndParent, NULL, FALSE);
            else
                hbm = CaptureWindow (hwndCap, hwndParent, NULL, TRUE);

            if (pset->SerialCapture ())
            {
                WinStopTimer (hab, hwnd, ulTimer);
#ifndef _QUIET_
                if (! WinIsWindowVisible (hwndSnapshot) && pset->SnapshotWindow ())
                    WinShowWindow (hwndSnapshot, TRUE);
#endif
                if (hbm)
                {
                    usState = STATE_WINDOWSELECTED;
                    WinPostMsg (hwnd, UM_WINDOWSELECTED,
                                MPFROMHWND (hwndCap),
                                MPFROMHWND (hwndParent));
                }
                else
                    WinSendMsg (hwnd, UM_ABORT, 0,0);
            }
            else
                WinSendMsg (hwnd, UM_CLEANUP, 0,0);
        }
        return MRESULT (FALSE);

    case UM_ABORT:
        if (LONGFROMMP(mp1) != 1)
            DosBeep (75, 200);
        WinSendMsg (hwnd, UM_CLEANUP, 0,0);
        return MRESULT (FALSE);

    case UM_CLEANUP:
        if (WinQueryCapture (HWND_DESKTOP) == hwnd)
            WinSetCapture (HWND_DESKTOP, NULLHANDLE);

        pset->Load ();

        WinSendMsg (hwndSnapshot, UM_STOPCAPTURE, 0,0);
        WinStopTimer (hab, hwnd, ulTimer);
#ifdef _QUIET_
        // ? FIXME to give option to reshow window.
        if (WinQueryButtonCheckstate (hwnd, WID_CB_HIDEWINDOW))
            WinSendMsg (g_hwndSettingsDialog, WM_CLOSE, 0,0);
        else if (WinIsWindow ( hab, g_hwndSettingsDialog) &&
            ! WinIsWindowVisible (g_hwndSettingsDialog))
            WinShowWindow (g_hwndSettingsDialog, TRUE);
        pset->HideWindow (TRUE);
#else
        // re-show the windows if they are hidden
        // FIXME using global hwndFrame is pretty yukki
        if (! WinIsWindowVisible (hwndFrame))
            WinShowWindow (hwndFrame, TRUE);
        if (! WinIsWindowVisible (hwndSnapshot) && pset->SnapshotWindow ())
            WinShowWindow (hwndSnapshot, TRUE);
#endif
        WinEnableWindow (hwnd, TRUE);
        WinSetActiveWindow (HWND_DESKTOP, hwnd);
        usState = STATE_IDLE;
        return MRESULT (FALSE);
    }

#ifdef _DOLOGDEBUG_
    LogDebug( "MainWin:WindowProcedure:WinDefWindowProc->0x%04x", msg );
#endif
    if (hwnd ==  g_hwndPage0)
        return WinDefDlgProc (hwnd, msg, mp1, mp2);
    else
        return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

// ************************************************************************
