/***
 This file belongs to the Gotcha! distribution.
 Copyright (C) 1998-2002 Thorsten Thielen <thth@c2226.de>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/

#include "gotcha.h"

#ifndef _QUIET_
MRESULT EXPENTRY AboutWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

    switch (msg) {
    case WM_INITDLG:{

        HMQ hmq;
        BOOL bUniCodeFont = FALSE;
        CHAR ucFont[FACESIZE];
        CHAR       ucLangStr[300];
        INT i;
        
        if (pset->GetLangID() == RU) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 866);
            bUniCodeFont = TRUE;
        }
        else if (pset->GetLangID() == CZ || pset->GetLangID() == PL) {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 852);
            bUniCodeFont = TRUE;
        }
        else {
            hmq = WinQueryWindowULong( hwnd, QWL_HMQ);
            WinSetCp(hmq, 850);
        }

        if (bUniCodeFont) {
            strcpy(ucFont, "9.Times New Roman MT 30");
            WinSetPresParam(hwnd, PP_FONTNAMESIZE, strlen(ucFont) + 1, ucFont);
        }
        for (i = 0; i < WID_ST_END - 400; i++) {
                WinLoadString(hab, g_hmod, LANG_COPYRIGHT + i, sizeof(ucLangStr), ucLangStr);
                WinSetDlgItemText(hwnd, WID_ST_COPYRIGHT + i, ucLangStr);
            }
        return (MRESULT) TRUE;
    }
    case WM_COMMAND:
	switch (SHORT1FROMMP(mp1)) {
	case DID_OK:
	case DID_CANCEL:
	    WinPostMsg(WinQueryWindow(hwnd, QW_OWNER), msg, mp1, mp2);
	    break;
	default:
	    return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}
	break;
    default:
        return WinDefDlgProc(hwnd, msg, mp1, mp2);
    }
    return 0;
}

VOID AboutBox (HWND hwnd)
{
    WinDlgBox (HWND_DESKTOP, hwnd, AboutWndProc, GETMODULE, ID_DLG_ABOUT, NULL);
}

#endif
