/*
 * (C) Chris Wohlgemuth 2002-2003
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwmmdataf_Source
#define SOM_Module_cwmmdataf_Source
#endif
#define CWMMDataFile_Class_Source
#define M_CWMMDataFile_Class_Source

#define INCL_PM
#define INCL_DOS
#define INCL_MMIOOS2
#define INCL_MCIOS2
#define INCL_REXXSAA

#include <os2.h>
#include <stdio.h>
#include <rexxsaa.h>                   /* needed for Rexx */
#include "os2me.h"
#include "cwmmdataf.ih"
#include "cwaudio.h"
#include <wpfolder.h>
//#include "cwmmres.h"
#include "mmres.h"
#include "cwaudioinc.h"

#include "except.h"

#include "som_wps_funcs.h"
#include "sys_funcs.h"

#if 0
#define  _PMPRINTF_
#include "PMPRINTF.H"
#endif

#define ID_STATUS_WINDOW   0x1000

HAB globalHab=NULLHANDLE;
/* Window which receives messages asking for scanning audio files. */
static HWND globalHwndAudioWorker;
/* Status window handle for message when scanning audio files. */
static HWND globalHwndStatus;
ULONG globalClassVolume;

HMODULE queryResModuleHandle(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
BOOL mmclsSetObjectType(WPFileSystem * somSelf);
PSZ _queryMMClassIniFile(void);

/* The REXX function handler */
ULONG EXPENTRY rxCallCWMMFunc(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename,PRXSTRING retstring);

MRESULT EXPENTRY audioWorkerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

MRESULT EXPENTRY appTerminateHandlerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);




/*
  Audio files are started on a separate thread. An object window is used for communication.
  Every audio object must provide a window procedure to handle the start/stop/resume commands
  sent to the object window. By using such an object specific window proc it's possible
  to alter the start/stop behaviour in child classes.
 */
/*!*******************************************************/
/*                                                       */
/* @@DESC                                                */
/*                                                       */
/* This instance method is called to set the object      */
/* window procedure handling the play commands.          */
/*                                                       */
/*                                                       */
/* @@USAGE                                               */
/*                                                       */
/* This method can be called at any time in order to     */
/* set the window procedure handling play commands.      */
/* :p.                                                   */
/* When a track is started the playing is done on a      */
/* separate thread. Communication with this thread is    */
/* done using window messages sent to an object window.  */
/* There's a default window procedure which starts or    */
/* stops audio playing. If there must be special         */
/* processing to play a particular type of file a        */
/* subclass may set a custom procedure handling the      */
/* audio commands.                                       */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* CWMMDataFile *somSelf input                           */
/*                                                       */
/* Pointer to the object on which the method is being    */
/* invoked.                                              */
/* :p.                                                   */
/* Points to an object of class                          */
/* :hp2.CWMMDatafile:ehp2..                              */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* PFNWP pObjectProc input                               */
/*                                                       */
/* Window procedure for audio command handling.          */
/*                                                       */
/*                                                       */
/* @@OVERRIDE                                            */
/*                                                       */
/* This method is usually not overriden.                 */
/*                                                       */
/* @@RETURNS                                             */
/*                                                       */
/* PFNWP pOldProc                                        */
/*                                                       */ 
/* The previous window procedure handling the play       */
/* commands.                                             */
/*                                                       */
/*                                                       */
/*                                                       */
/*                                                       */
/*!!******************************************************/
SOM_Scope PFNWP  SOMLINK cwmmdatafile_cwmmSetObjWindowProc(CWMMDataFile *somSelf, 
                                                           PFNWP pObjectProc)
{
  PFNWP pTemp;
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmSetObjWindowProc");

    pTemp=_pfnwpObjectProc;
    _pfnwpObjectProc=pObjectProc;

    return pTemp;
}


/*
  Method used to query the window procedure address for subclassing object windows.
  Every audio object may have a customized window procedure.
 */
/*!*******************************************************/
/*                                                       */
/* @@DESC                                                */
/*                                                       */
/* This instance method is called to query the object    */
/* window procedure currently used for handling the play */
/* commands.                                             */
/*                                                       */
/*                                                       */
/* @@USAGE                                               */
/*                                                       */
/* This method can be called at any time in order to     */
/* query the current window procedure handling play      */
/* commands.                                             */
/* :p.                                                   */
/* When a track is started the playing is done on a      */
/* separate thread. Communication with this thread is    */
/* done using window messages sent to an object window.  */
/* There's a default window procedure which starts or    */
/* stops audio playing. If there must be special         */
/* processing to play a particular type of file a        */
/* subclass may set a custom procedure handling the      */
/* audio commands.                                       */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* CWMMDataFile *somSelf input                           */
/*                                                       */
/* Pointer to the object on which the method is being    */
/* invoked.                                              */
/* :p.                                                   */
/* Points to an object of class                          */
/* :hp2.CWMMDatafile:ehp2..                              */
/*                                                       */
/*                                                       */
/* @@OVERRIDE                                            */
/*                                                       */
/* This method is usually not overriden.                 */
/*                                                       */
/* @@RETURNS                                             */
/*                                                       */
/* PFNWP pObjectProc                                     */
/*                                                       */ 
/* The current window procedure handling the play        */
/* commands.                                             */
/*                                                       */
/*                                                       */
/*                                                       */
/*                                                       */
/*!!******************************************************/
SOM_Scope PFNWP  SOMLINK cwmmdatafile_cwmmQueryObjWindowProc(CWMMDataFile *somSelf)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmQueryObjWindowProc");

    return _pfnwpObjectProc;
}


/*
 * The prototype for cwmmdatafile_cwmmSetRecordTitles was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmmdatafile_cwmmSetRecordTitles(CWMMDataFile *somSelf, 
                                                         PSZ pTitle, 
                                                         BOOL bAddToTitle)
{
  PUSEITEM pUseItem;
  PSZ pSZ;

  M_CWMMDataFileData *m_mmDfData = M_CWMMDataFileGetData(_CWMMDataFile);
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmSetRecordTitles");


    if(m_mmDfData->bNoExtendedIconTitles)
      return NULLHANDLE;

    if(pTitle) {
      if(!_pOrgTitle)
        _pOrgTitle=_wpQueryTitle(somSelf);
      if(bAddToTitle)
        {
          strncpy(_chrRecordTitle, _wpQueryTitle(somSelf), sizeof(_chrRecordTitle));
          _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;
          strncat(_chrRecordTitle,"\n", sizeof(_chrRecordTitle)-1-strlen(_chrRecordTitle));
          strncat(_chrRecordTitle, pTitle, sizeof(_chrRecordTitle)-1-strlen(_chrRecordTitle));
        }
      else
        strncpy(_chrRecordTitle, pTitle, sizeof(_chrRecordTitle));
      _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;
      pSZ=_chrRecordTitle;
    }
    else {
      strncpy(_chrRecordTitle, _pOrgTitle, sizeof(_chrRecordTitle));
      pSZ=_pOrgTitle;
      _pOrgTitle=NULLHANDLE;
    }
    _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;

    for(pUseItem=_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE); pUseItem;
        pUseItem=_wpFindUseItem(somSelf, USAGE_RECORD, pUseItem))
      {
        PRECORDITEM pRecordItem=(PRECORDITEM)++pUseItem;
        pUseItem--;

        pRecordItem->pRecord->pszIcon=pSZ;
        if(pRecordItem->hwndCnr)
          WinSendMsg(pRecordItem->hwndCnr, CM_INVALIDATERECORD, MPFROMP(&(pRecordItem->pRecord)),
                     MPFROM2SHORT(1,CMA_TEXTCHANGED));
      }

    for(pUseItem=_wpFindUseItem(somSelf, USAGE_LINK, NULLHANDLE); pUseItem;
        pUseItem=_wpFindUseItem(somSelf, USAGE_LINK, pUseItem))
      {
        PLINKITEM pLinkItem=(PLINKITEM)++pUseItem;
        pUseItem--;
                        
        if(somIsObj(pLinkItem->LinkObj))
          {
            PUSEITEM pUI;
            
            for(pUI=_wpFindUseItem(pLinkItem->LinkObj, USAGE_RECORD, NULLHANDLE); pUI;
                pUI=_wpFindUseItem(pLinkItem->LinkObj, USAGE_RECORD, pUI))
              {
                PRECORDITEM pRecordItem=(PRECORDITEM)++pUI;
                pUI--;

                pRecordItem->pRecord->pszIcon=pSZ;
                if(pRecordItem->hwndCnr)
                  WinPostMsg(pRecordItem->hwndCnr,CM_INVALIDATERECORD,
                             MPFROMP(&(pRecordItem->pRecord)),MPFROM2SHORT(1,CMA_TEXTCHANGED));
              }
          }
      }

    /* Return statement to be customized: */
    return TRUE;
}



/*
 * The prototype for cwmmdatafile_cwmmQueryTrackStatus was replaced by the following prototype:
 */
/*
 * Object window handling the start/stop/pause/resume commands.
 */
/*!*******************************************************/
/*                                                       */
/* @@DESC                                                */
/*                                                       */
/* This instance method is called to query the current   */
/* state of the multimedia object.g.                     */
/*                                                       */
/*                                                       */
/* @@USAGE                                               */
/*                                                       */
/* This method can be called at any time in order to     */
/* query the state of the object. This method can be used*/
/* to check if an object is currently playing, paused    */
/* etc.                                                  */
/*                                                       */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* CWMMDataFile *somSelf input                           */
/*                                                       */
/* Pointer to the object on which the method is being    */
/* invoked.                                              */
/* :p.                                                   */
/* Points to an object of class                          */
/* :hp2.CWMMDatafile:ehp2..                              */
/*                                                       */
/* @@OVERRIDE                                            */
/*                                                       */
/* This method is usually not overriden.                 */
/*                                                       */
/* @@RETURNS                                             */
/*                                                       */
/* ULONG ulStatus                                        */
/*                                                       */ 
/* :parml compact tsize=35 break=none.                   */
/* :pt.TRACK_STATUS_STOPPED                              */
/* :pd.Track is not playing                              */
/* :pt.TRACK_STATUS_PLAYING                              */
/* :pd.Track is currently playing                        */
/* :pt.TRACK_STATUS_PAUSED                               */
/* :pd.Track is paused.                                  */
/* :eparml.                                              */
/*                                                       */
/*                                                       */
/*                                                       */
/*                                                       */
/*!!******************************************************/
SOM_Scope ULONG  SOMLINK cwmmdatafile_cwmmQueryTrackStatus(CWMMDataFile *somSelf)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    //    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmQueryTrackStatus");

    /* Return statement to be customized: */
    return _ulTrackStatus;
}


/*
 * The prototype for cwmmdatafile_wpFilterPopupMenu was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwmmdatafile_wpFilterPopupMenu(CWMMDataFile *somSelf, 
                                                        ULONG ulFlags, 
                                                        HWND hwndCnr, 
                                                        BOOL fMultiSelect)
{
  /*    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);*/
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpFilterPopupMenu");

    /* Remove the print menu item. */
    return (CWMMDataFile_parent_WPDataFile_wpFilterPopupMenu(somSelf, 
                                                             ulFlags, 
                                                             hwndCnr, 
                                                             fMultiSelect)& ~CTXT_PRINT);
}


/*

 */
SOM_Scope BOOL  SOMLINK cwmmdatafile_wpAddSettingsPages(CWMMDataFile *somSelf, 
                                                        HWND hwndNotebook)
{
  BOOL bRc;
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpAddSettingsPages");

    bRc=(CWMMDataFile_parent_WPDataFile_wpAddSettingsPages(somSelf, 
                                                              hwndNotebook));
    /*
      When the settings notebook is built the WPS resets the object title
      (who knows why). If we have a custom title during playing this would
      vanish. so check if we have a backup of the original title and if so
      immediately set again the custom title.
      */

    if(_pOrgTitle)
      _cwmmSetRecordTitles(somSelf, _chrRecordTitle, FALSE);
    return bRc;
}



/*
 * The prototype for cwmmdatafile_wpModifyPopupMenu was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmmdatafile_wpModifyPopupMenu(CWMMDataFile *somSelf, 
                                                       HWND hwndMenu, 
                                                       HWND hwndCnr, 
                                                       ULONG iPosition)
{
  BOOL bRc;

    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpModifyPopupMenu");

    
    bRc=(CWMMDataFile_parent_WPDataFile_wpModifyPopupMenu(somSelf, 
                                                             hwndMenu, 
                                                             hwndCnr, 
                                                             iPosition));
    /*
      When the settings notebook is built the WPS resets the object title
      (who knows why). If we have a custom title during playing this would
      vanish. so check if we have a backup of the original title and if so
      immediately set again the custom title.
      */
    if(_pOrgTitle)
      _cwmmSetRecordTitles(somSelf, _chrRecordTitle, FALSE);

    return bRc;
}


/*
 * The prototype for cwmmdatafile_wpSetTitle was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmmdatafile_wpSetTitle(CWMMDataFile *somSelf, 
                                                PSZ pszNewTitle)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpSetTitle");

    _pOrgTitle=NULLHANDLE;

    return (CWMMDataFile_parent_WPDataFile_wpSetTitle(somSelf, 
                                                      pszNewTitle));
}

/*
 * The prototype for cwmmdatafile_wpQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwmmdatafile_wpQueryTitle(CWMMDataFile *somSelf)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpQueryTitle");

    /*
      Alway return the default title not the custom title (playtime display) 
      which is only for display in containers.
      */
    if(_pOrgTitle)
      return _pOrgTitle;
    
    return (CWMMDataFile_parent_WPDataFile_wpQueryTitle(somSelf));
}


SOM_Scope BOOL  SOMLINK cwmmdatafileM_wpclsCreateDefaultTemplates(M_CWMMDataFile *somSelf, 
                                                                  WPObject* Folder)
{
  /*    M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf);*/
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsCreateDefaultTemplates");

    return TRUE; /* We don't want a template for this base class */
}


/*
 * The prototype for cwmmdatafileM_wpclsQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwmmdatafileM_wpclsQueryTitle(M_CWMMDataFile *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf); */
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_CWMMDATAFILETITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"MMDatafile");

    return chrTitle;
}


/*
 * The prototype for cwmmdatafileM_wpclsQueryIconData was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwmmdatafileM_wpclsQueryIconData(M_CWMMDataFile *somSelf, 
                                                          PICONINFO pIconInfo)
{
    /* M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf); */
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsQueryIconData");

    return (M_CWMMDataFile_parent_M_WPDataFile_wpclsQueryIconData(somSelf, 
                                                                  pIconInfo));
}

/*
  Window telling the user we are currently scanning the audio file. 
 */
MRESULT EXPENTRY statusWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  PFNWP proc;

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        switch (LONGFROMMP(mp2))
          {
          case 0:
            WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000);
            break;
          case 1:
            WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 1);
            break;
          default:
            break;
          }
        return (MRESULT) FALSE;
      }
    case WM_TIMER:
      {
        if(SHORT1FROMMP(mp1)==1) {
          WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 1);
          /* Hide the status window */
          WinSetWindowPos(hwnd, NULLHANDLE, 0, 0, 0, 0,SWP_SIZE);
          return (MRESULT) FALSE;
        }
      }
    default:
      break;
    }

  proc=(PFNWP) WinQueryWindowULong(hwnd, QWL_USER);
  if(proc)
    return proc( hwnd, msg, mp1, mp2);

  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

/*
  The window proc is in file cwaudio.c

  This thread scans the sudio files for gathering the audio information asynchronously.
 */
void _Optlink audioWorkerThread (void *arg)
{

  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  
  M_CWMMDataFileData *somThis = (M_CWMMDataFileData*)arg;

  DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, 0, 0);
  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab, 50);
    if(hmq) {      
      globalHwndAudioWorker=WinCreateWindow(HWND_OBJECT,WC_STATIC,"CWMMObj",0,0,0,0,0,NULLHANDLE,HWND_BOTTOM,13345,NULL,NULL);
      //DosBeep(5000, 100);
      if(globalHwndAudioWorker) {
        WinSubclassWindow(globalHwndAudioWorker,&audioWorkerProc);
        _hwndAudioWorker=globalHwndAudioWorker;
        /* Window created. */
        while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
          WinDispatchMsg(hab,&qmsg);

        WinDestroyWindow(globalHwndAudioWorker);
      }
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
}


/*********************************************************************************
 *                                                                               *
 * Every app started by a MM object is started using WinStartApp(). The          *
 * notify window is this one. After starting a new view is added to the object.  *
 * When terminating a WM_APPTERMINATENOTIFY message is sent to this window.      *
 * We search the view item belonging to the app and remove it from the object    *
 * inuse list.                                                                   *
 *                                                                               *
 *********************************************************************************/
MRESULT EXPENTRY appTerminateHandlerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        for(;;) {
          PUSEITEM pUseItem;
          CWMMDataFile *somSelf= (CWMMDataFile *)WinQueryWindowULong(hwnd, QWL_USER);
          if(!somIsObj(somSelf))
            break;

          for(pUseItem=_wpFindUseItem(somSelf, USAGE_OPENVIEW, NULLHANDLE); 
              pUseItem;pUseItem=_wpFindUseItem(somSelf,USAGE_OPENVIEW, pUseItem))
            {
              PVIEWITEM pViewItem=(PVIEWITEM) ++pUseItem;
              pUseItem--;
              //  HlpWriteToTrapLog("ViewItem: %x\n",pViewItem);
              if(pViewItem->handle==LONGFROMMP(mp1)) {
                _wpDeleteFromObjUseList(somSelf,pUseItem);
                _wpFreeMem(somSelf, (PBYTE)pUseItem);
                WinDestroyWindow(hwnd);
                //          WinPostMsg(hwnd, WM_DESTROY,0,0);
                break;
              }
            }/* for() */
          break;
        };/* for() */
        return (MRESULT) FALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}


/*
 * The prototype for cwmmdatafileM_wpclsInitData was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwmmdatafileM_wpclsInitData(M_CWMMDataFile *somSelf)
{
  HINI hini;
  static BOOL bInit=FALSE;

    M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf);
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsInitData");

    M_CWMMDataFile_parent_M_WPDataFile_wpclsInitData(somSelf);

    if(!globalHab)
      globalHab=WinQueryAnchorBlock(HWND_DESKTOP);

    /* Create a status window to show user we're scanning the audio file for info */
    if(!globalHwndStatus)
      {
        HWND hwndClient;
        PFNWP proc;
        char chrText[100];

        ULONG ulFL=FCF_BORDER | FCF_TITLEBAR;
        globalHwndStatus=WinCreateStdWindow(HWND_DESKTOP,WS_VISIBLE|FS_BORDER,
                                            &ulFL, WC_STATIC, "Audiofile scanning...",
                                            WS_VISIBLE|SS_TEXT|DT_VCENTER|DT_CENTER, NULLHANDLE, ID_STATUS_WINDOW,
                                            &hwndClient);
        /* Set title */
        if(getMessage(chrText, IDSTR_AUDIOSCANNING , sizeof(chrText), queryResModuleHandle(), globalHwndStatus))
          WinSetWindowText(globalHwndStatus, chrText);
        proc=WinSubclassWindow(globalHwndStatus,&statusWindowProc);
        WinSetWindowULong(globalHwndStatus, QWL_USER,(ULONG)proc);
        WinSetWindowPos(globalHwndStatus, HWND_TOP, 0, 0, 0, 0,SWP_MOVE|SWP_SIZE|SWP_ZORDER|SWP_DEACTIVATE);
        /* Set window font to WarpSans */
        WinSetPresParam(globalHwndStatus,
                        PP_FONTNAMESIZE, (ULONG)sizeof(DEFAULT_DIALOG_FONT),
                        DEFAULT_DIALOG_FONT );
        WinSetPresParam(WinWindowFromID(globalHwndStatus, FID_CLIENT),
                        PP_FONTNAMESIZE, (ULONG)sizeof(DEFAULT_DIALOG_FONT),
                        DEFAULT_DIALOG_FONT );

      }
    _hwndStatus=globalHwndStatus;

    /* Start audio worker thread */
    if(!globalHwndAudioWorker)
      _beginthread(audioWorkerThread, NULL, 8192*10, somThis);
    else
      _hwndAudioWorker=globalHwndAudioWorker;

    if(!bInit) {    
      /* Get special settings from the user INI file */
      if(!PrfQueryProfileInt(HINI_USERPROFILE, "CWMM", MM_NO_EXTENDED_ICONTITLE, 0))
        _bNoExtendedIconTitles=FALSE;
      else
        _bNoExtendedIconTitles=TRUE;
      
      /* Get additional settings from the MM class ini. */
      if((hini=PrfOpenProfile(globalHab, _queryMMClassIniFile()))!=NULLHANDLE)
        {
          globalClassVolume=PrfQueryProfileInt(hini, CLASS_VOLUME_APP, CLASS_VOLUME_KEY,DEFVOLUME_AUDIO_FILE);
          PrfCloseProfile(hini);
        }
      /* Register mmedia class REXX functions */
      RexxRegisterFunctionExe("MMClsCallFunc", (PFN)rxCallCWMMFunc); /* This name is obsolete because it is hard
                                                                        to tell if the function is used with objects
                                                                        or with the class object. It's still here for 
                                                                        backwards compatibility. */
      RexxRegisterFunctionExe("MMCallFunc", (PFN)rxCallCWMMFunc);
      /* Don't deregister the function in wpclsUninitData. If doing it the function
         may be unavailable if the class object goes dormant. */
      bInit=TRUE;
    }/* bInit */
}


/*
 * The prototype for cwmmdatafileM_wpclsUnInitData was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwmmdatafileM_wpclsUnInitData(M_CWMMDataFile *somSelf)
{
    /* M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf); */
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsUnInitData");

    M_CWMMDataFile_parent_M_WPDataFile_wpclsUnInitData(somSelf);
}


/*
 * The prototype for cwmmdatafileM_wpclsQueryStyle was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwmmdatafileM_wpclsQueryStyle(M_CWMMDataFile *somSelf)
{
  /*    M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf);*/
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsQueryStyle");

    return CLSSTYLE_DONTTEMPLATE;
}

