/*
 * (C) Chris Wohlgemuth 2002-2004
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */          
/*
 * If you need another license for your project/product (commercial,
 * noncommercial, whatever) contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 *
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_mmfolder_Source
#define SOM_Module_mmfolder_Source
#endif
#define MMFolder_Class_Source
#define M_MMFolder_Class_Source

#define INCL_GPIBITMAPS
#define INCL_PM
#define INCL_DOSMODULEMGR
#define INCL_WINPOINTERS
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include "helpid.h"
#include "mmfolder.ih"
/* Include file with definition for WPShadow class */
#include "wpshadow.h"
#include "cwimage.h"
//#include "cwmmres.h"
#include "mmres.h"
#include "cwbmp.h"
#include "cwaudioinc.h"
#include "mmfolderinc.h"
#include "except.h"
#include "som_wps_funcs.h"
#include "sys_funcs.h"

//#if 0
#ifndef  _cwmmQuerySmallBitmapHandle
#define _cwmmQuerySmallBitmapHandle MMImage_cwmmQuerySmallBitmapHandle
#define _cwmmQuerySmallBitmapHandleCWBitmap MMBitmap_cwmmQuerySmallBitmapHandle
#endif
//#endif
#define STOREWINDOWID 112233

//#define DEBUG

void writeLog(const char* chrFormat, ...);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
HMODULE queryModuleHandle(void);
HMODULE queryResModuleHandle(void);
SHORT menuInsertMenuItem( HWND hwndMenu, HWND hwndSubMenu, SHORT sPosition, int iID, char * chrText);
MRESULT menuInsertMenuSeparator(HWND hwndMenu, HWND hwndSubMenu, SHORT sPosition );

WPObject* somGetFileSystemObject(WPObject* wpObject);
void SysWriteToTrapLog(const char* chrFormat, ...);

static SOMClass * queryWpFolderClass(void)
{
  somId mySomId;
  static SOMClass * mWPFolderClass=NULLHANDLE;
  
  if(!mWPFolderClass) {
    if((mySomId=somIdFromString("WPFolder"))!=NULLHANDLE) {
      mWPFolderClass=(SOMClass*)_somClassFromId(SOMClassMgrObject, mySomId);
      SOMFree(mySomId);
    }
  }
  return mWPFolderClass;
}

/* Now using IBM names as of V0.2.4 */
static SOMClass* queryCWImageFileClass(void)
{
  somId mySomId;
  static SOMClass *mWPImgClass=NULL;

  if(!mWPImgClass) {
    if((mySomId=somIdFromString("MMImage"))!=NULLHANDLE) {
      mWPImgClass=(SOMClass*)_somClassFromId(SOMClassMgrObject, mySomId);
      SOMFree(mySomId);
    }
  }
  return mWPImgClass;
}

/* Bitmap class */
static SOMClass* queryCWBitmapFileClass(void)
{
  somId mySomId;
  static SOMClass *mWPImgClass=NULL;
  
  if(!mWPImgClass) {
    if((mySomId=somIdFromString("MMBitmap"))!=NULLHANDLE) {
      mWPImgClass=(SOMClass*)_somClassFromId(SOMClassMgrObject, mySomId);
      SOMFree(mySomId);
    }
  }
  return mWPImgClass;
}

MRESULT EXPENTRY mmFolderContainerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  HWND hwndStore;
  MMFolder *somSelf;


  //writeLog("Msg: 0x%x, MPARM1: 0x%x, MPARM2: 0x%x\n", msg, mp1, mp2);
  switch(msg)
    {
      //    case CM_QUERYDRAGIMAGE:
      //      DosBeep(5000,150);
      //      break;
      //    return NULLHANDLE;
    case CM_SETCNRINFO:
      {
        /* Make sure CNR stays ownerdrawn even when user changes view */
        PCNRINFO pCnrInfo=(PCNRINFO)PVOIDFROMMP(mp1);

        if(pCnrInfo) {
          //      writeLog("flWindowAttr: 0x%x, Mask: 0x%x, cxTreeIndent: %d, cyLineSpacing: %d\n", 
          //       pCnrInfo->flWindowAttr, LONGFROMMP(mp2), pCnrInfo->cxTreeIndent, pCnrInfo->cyLineSpacing);

          if(!(pCnrInfo->flWindowAttr & (CV_DETAIL|CV_TREE/*|CV_ICON|CV_NAME*/)) &&
             (LONGFROMMP(mp2)&CMA_FLWINDOWATTR)) {
            HWND hwndFrame=WinQueryWindow(hwnd, QW_PARENT);
            //         writeLog("Accepted, flWindowAttr: 0x%x, Mask: 0x%x\n", pCnrInfo->flWindowAttr, LONGFROMMP(mp2));
            if((hwndStore=WinWindowFromID(hwndFrame, STOREWINDOWID))!=NULLHANDLE)
              {
                somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
                if(somIsObj(somSelf)) {
                  MMFolderData *somThis = MMFolderGetData(somSelf); 
                  
                  pCnrInfo->flWindowAttr&=~CA_DRAWICON;
                  pCnrInfo->flWindowAttr|=CA_DRAWBITMAP|CA_OWNERDRAW;
                  pCnrInfo->slBitmapOrIcon.cx=_ulCurrentSize;
                  pCnrInfo->slBitmapOrIcon.cy=_ulCurrentSize;
                  
                  mp2=MPFROMLONG(LONGFROMMP(mp2)|CMA_SLBITMAPORICON|CMA_FLWINDOWATTR);
                }
              }
          }
          else
            {
              if(pCnrInfo->flWindowAttr & (CV_DETAIL|CV_TREE)) {
                //  writeLog("Accepted, flWindowAttr: 0x%x, Mask: 0x%x\n", pCnrInfo->flWindowAttr, LONGFROMMP(mp2));
                pCnrInfo->flWindowAttr&=~(CA_OWNERDRAW|CA_DRAWBITMAP);
                pCnrInfo->flWindowAttr|=CA_DRAWICON;
                pCnrInfo->slBitmapOrIcon.cx=0;
                pCnrInfo->slBitmapOrIcon.cy=0;

                mp2=MPFROMLONG(LONGFROMMP(mp2)|CMA_SLBITMAPORICON);
              }
            }
        }
      break;
      }
    default:
      break;
    }
  /* Any other message is handled by the folder container procedure */
  if((hwndStore=WinQueryWindow(hwnd,QW_PARENT))!=NULLHANDLE)
    {
      if((hwndStore=WinWindowFromID(hwndStore, STOREWINDOWID))!=NULLHANDLE)
        {
          somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
          if(somIsObj(somSelf)) {
            MMFolderData *somThis = MMFolderGetData(somSelf); 
            if(_oldContainerProc)
              return _oldContainerProc(hwnd, msg, mp1, mp2);
          }
        }
    }    
  return WinDefWindowProc(hwnd, msg, mp1, mp2);
}


/* This function draws a two coloured 1 pixel border. It's used to draw the outmost
   line of any 3D element like buttons. */
static BOOL cwDraw2ColorBorder(HPS hps, RECTL *rcl, ULONG color1, ULONG color2)
{

  POINTL ptl=*((PPOINTL)rcl);

  GpiMove(hps, &ptl);
  GpiSetColor(hps, color1);
  ptl.x=rcl->xRight;
  GpiLine(hps,&ptl);
  ptl.y=rcl->yTop;
  GpiLine(hps,&ptl);
  ptl.x-=1;
  GpiMove(hps, &ptl);
  GpiSetColor(hps, color2);
  ptl.x=rcl->xLeft;
  GpiLine(hps,&ptl);
  ptl.y=rcl->yBottom+1;
  GpiLine(hps,&ptl);
  return TRUE;
}


static void cwAdjustIconRECTL(RECTL * rcl, ULONG ulMaxIconWidth, ULONG ulWidthBMP, ULONG ulHeightBMP)
{
  if(!rcl)
    return;

  rcl->xLeft+=2;
  if(ulMaxIconWidth>ulWidthBMP)
    rcl->xLeft+=(ulMaxIconWidth-ulWidthBMP)/2;
  rcl->xRight=rcl->xLeft+ulWidthBMP;
  rcl->yBottom+=2;
  if(ulMaxIconWidth>ulHeightBMP)
    rcl->yBottom+=(ulMaxIconWidth-ulHeightBMP)/2;
  rcl->yTop=rcl->yBottom+ulHeightBMP;///ulFact;
}

/*
  This function draws the template (but not the icon) if the object is a template.
 */
static ULONG mfldrDrawTemplate(WPObject* wpObject, RECTL* rcl, HPS hps, ULONG flCnr)
{
  HPOINTER hptrTemplate;
  HMODULE hmodTemplate;
  
  if(!DosQueryModuleHandle("PMWP",&hmodTemplate))
    {
      ULONG ulIconSize;
      
      hptrTemplate=WinLoadPointer(HWND_DESKTOP, hmodTemplate, 20);
      WinDrawPointer(hps, rcl->xLeft, rcl->yBottom, hptrTemplate, (flCnr &  CV_MINI ? DP_MINI:DP_NORMAL));
      WinDestroyPointer(hptrTemplate);
      if((ulIconSize=WinQuerySysValue(HWND_DESKTOP,SV_CXICON))!=0)
        {
          ulIconSize=(rcl->xRight-rcl->xLeft-ulIconSize/2)/2;
          rcl->xLeft+=ulIconSize/2;
          rcl->yBottom+=ulIconSize;
        }
      return DP_MINI;
    }
  
  return DP_NORMAL;
}


MRESULT EXPENTRY mmFolderFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  HWND hwndStore;
  MMFolder *somSelf;

  switch(msg)
    {
      /************************************************/
      /* Draw the icons                               */
      /************************************************/
    case WM_DRAWITEM:
      {
        POWNERITEM pOwnerItem=(POWNERITEM)PVOIDFROMMP(mp2);
 

        /* We only draw icons not text */
        if(pOwnerItem->idItem==CMA_ICON /*&& !bNot*/) {
          PMINIRECORDCORE mrc=(PMINIRECORDCORE)((PCNRDRAWITEMINFO)pOwnerItem->hItem)->pRecord;
          RECTL rclTemp=pOwnerItem->rclItem;
          HWND hwndCnr=WinWindowFromID(hwnd, FID_CLIENT);
          PCNRDRAWITEMINFO pCnrDrawItemInfo=(PCNRDRAWITEMINFO)pOwnerItem->hItem;
          CNRINFO cnrInfo;
          ULONG flCnr;

          if(WinSendMsg(hwndCnr, CM_QUERYCNRINFO,MPFROMP(&cnrInfo), MPFROMLONG(sizeof(cnrInfo))))
            flCnr=cnrInfo.flWindowAttr;

          /*
            Draw emphasis if any. Otherwise draw white background.
           */
          rclTemp.xLeft+=2;
          rclTemp.xRight-=2;
          rclTemp.yBottom+=2;
          rclTemp.yTop-=2;
          /* Check if record is selected and in use */
          if((pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_INUSE)
             && (pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_SELECTED)) {
            POINTL pointl;

            WinFillRect(pOwnerItem->hps, &rclTemp, CLR_WHITE);            
            GpiSetPattern(pOwnerItem->hps,PATSYM_DIAG2);
            pointl.x = rclTemp.xLeft;
            pointl.y = rclTemp.yBottom;
            GpiMove(pOwnerItem->hps, &pointl);
            pointl.x = rclTemp.xRight - 1;
            pointl.y = rclTemp.yTop - 1;
            GpiSetColor(pOwnerItem->hps, CLR_BLACK);
            GpiBox(pOwnerItem->hps,DRO_FILL,&pointl,1,1);         
            
          }
          /* Check if record is in use */
          else if(pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_INUSE) {
            POINTL pointl;

            WinFillRect(pOwnerItem->hps, &rclTemp, CLR_WHITE);            
            GpiSetPattern(pOwnerItem->hps,PATSYM_DIAG1);
            pointl.x = rclTemp.xLeft;
            pointl.y = rclTemp.yBottom;
            GpiMove(pOwnerItem->hps, &pointl);
            pointl.x = rclTemp.xRight - 1;
            pointl.y = rclTemp.yTop - 1;
            GpiSetColor(pOwnerItem->hps, CLR_BLACK);
            GpiBox(pOwnerItem->hps,DRO_FILL,&pointl,1,1);                    
          }
          /* or is it only selected? */
          else if(pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_SELECTED)
            WinFillRect(pOwnerItem->hps, &rclTemp, CLR_DARKGRAY);
          /* Default is paint white background */
          else
            WinFillRect(pOwnerItem->hps, &rclTemp, CLR_WHITE);
          /* Emphasis drawn */          

          /********************************************/
          /*                                          */
          /*               Draw the image             */
          /*                                          */
          /********************************************/
          if(mrc){
            WPObject *wpObject;
            ULONG ulIconSize=150;/* Default if query fails */
            
            wpObject=(WPObject*)OBJECT_FROM_PREC(mrc); // Get object
            wpObject=somGetFileSystemObject(wpObject);  // Get Filesystem object

            if(somIsObj(wpObject) && _wpIsObjectInitialized(wpObject)) {
              SOMClass* cwBitmapClass=queryCWBitmapFileClass();
              SOMClass* cwImageClass=queryCWImageFileClass();

              /* Check if object is an image or bitmap class. If yes paint the bitmap as
                 an icon. Only templates keep their normal icon. */
              if((somIsObj(cwImageClass)||somIsObj(cwBitmapClass)) && !(_wpQueryStyle(wpObject) & OBJSTYLE_TEMPLATE)) {
                HBITMAP hbm=NULLHANDLE;
                PBITMAPINFOHEADER2 pBmpInfoHeader2=NULLHANDLE;
#ifdef DEBUG
                SysWriteToTrapLog("Object is an image. (%s line: %d)\n", __FUNCTION__, __LINE__);
#endif
                /* Get object pointer of lighttable folder */                
                if((hwndStore=WinWindowFromID(hwnd, STOREWINDOWID))!=NULLHANDLE)
                  {
                    somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
                    if(somIsObj(somSelf)) {
                      MMFolderData *somThis = MMFolderGetData(somSelf); 
                      ulIconSize=_ulCurrentSize;
                    }
                  }

                /* Get a small bitmap */
                if(_somIsA(wpObject, cwImageClass)) {

                  /*
                    V0.2.8 (09.09.2003)

                    Only try to get the bitmap header when we were able to get the handle (we don't need it
                    without the handle anyway). Interestingly the  _wpQueryBitmapInfoHeader() call blocks
                    when called without a loaded bitmap. It doesn't block on loading the image but when trying
                    to alloc mem for the header using _wpAllocMem(). Probably there's a race condition while
                    inserting the USAGE_MEMORY item while the folder tries to insert the USAGE_RECORD_ITEM.
                    Requesting the object mutex semaphor doesn't work by the way. The object will just block.
                    Maybe that's exactly happening with _wpAllocMem() here. Solution is not to use _wpAllocMem()
                    at all in the image classes.

                    Wondering what hidden problems/bugs will show upt in the future...
                    */
                  if((hbm=_cwmmQuerySmallBitmapHandle( (MMImage*) wpObject, ulIconSize, mrc, hwndCnr))!=NULLHANDLE)          
                    pBmpInfoHeader2=(PBITMAPINFOHEADER2)_wpQueryBitmapInfoHeader((MMImage*)wpObject);
#ifdef DEBUG
                  SysWriteToTrapLog("Queried HBITMAP: %x (line: %d)\n", hbm, __LINE__);
#endif

                } /* somIsA( , cwImageClass) */
                else if(_somIsA(wpObject, cwBitmapClass)) {
                  /* The default WPS bitmap class (WPBitmap) returns an PBITMAPHEADER. The CWBitmap class
                     does return a PBITMAPHEADER2<-. */
                  if((hbm=_cwmmQuerySmallBitmapHandleCWBitmap( (MMBitmap*) wpObject, ulIconSize))!=NULLHANDLE)
                    pBmpInfoHeader2=(PBITMAPINFOHEADER2)_cwmmQueryBitmapInfoHeader((MMBitmap*)wpObject);
                }

                if(hbm)
                  {
                    /* We have the small bitmap */
                    if(pBmpInfoHeader2) {
                      ULONG ulWidth, ulHeight;
                      ULONG ulIconWidth;
                      ULONG ulFact;
                      RECTL rcl=pOwnerItem->rclItem;

                      if(pBmpInfoHeader2->cbFix==sizeof(BITMAPINFOHEADER2)) {
                        ulWidth=pBmpInfoHeader2->cx;
                        ulHeight=pBmpInfoHeader2->cy;
                      }
                      else {
                        PBITMAPINFOHEADER pBmpInfoHeader=(PBITMAPINFOHEADER)pBmpInfoHeader2;
                        ulWidth=pBmpInfoHeader->cx;
                        ulHeight=pBmpInfoHeader->cy;
                      }

                      ulIconWidth=rcl.xRight-rcl.xLeft-4;
                      ulFact=ulWidth>ulHeight ? ulWidth*1000/ulIconWidth : ulHeight*1000/ulIconWidth;
                      ulWidth=ulWidth*1000/ulFact;
                      ulHeight=ulHeight*1000/ulFact;
                      cwAdjustIconRECTL(&rcl, ulIconWidth, ulWidth, ulHeight);
                      /* And now draw the bitmap */
#if 0
                      if(pBmpInfoHeader2->cclrUsed==2) {                        
                        WinDrawBitmap(pOwnerItem->hps, hbm, NULL, (PPOINTL)&rcl,//pOwnerItem->rclItem,
                                      CLR_WHITE, CLR_BLACK, DBM_STRETCH /*| DBM_IMAGEATTRS*/);
                      }
                      else
#endif
                        WinDrawBitmap(pOwnerItem->hps, hbm, NULL, (PPOINTL)&rcl,//pOwnerItem->rclItem,
                                      CLR_WHITE, CLR_BLACK, DBM_STRETCH /*| DBM_IMAGEATTRS*/);
                    }

                    /* Draw a small border around the image */
                    cwDraw2ColorBorder(pOwnerItem->hps, &rclTemp, CLR_BLACK, CLR_DARKGRAY);
                    /* Done */
                    free(hbm);
                    return (MRESULT) TRUE;
                  }/* hbm */
              }/* cwImageClass/cwBitmapClass */

            /****************************************************/
            /*** It's not an image class. Draw normal pointer ***/
            /****************************************************/
            if((ulIconSize=WinQuerySysValue(HWND_DESKTOP,SV_CXICON))!=0)
              {
                ULONG ulWidth=ulIconSize;
                ULONG ulHeight=ulIconSize;
                ULONG ulIconWidth;
                RECTL rcl=pOwnerItem->rclItem;
                ULONG ulMiniOrNormal=(flCnr & CV_MINI ? DP_MINI:DP_NORMAL);
                BOOL fIsTemplate=_wpQueryStyle(wpObject) & OBJSTYLE_TEMPLATE;

                ulIconWidth=rcl.xRight-rcl.xLeft-4;
                /* Move the icon into the middle of the drawing area */
                cwAdjustIconRECTL(&rcl, ulIconWidth, ulWidth, ulHeight);

                /* Draw the template background if necessary */
                if(fIsTemplate) {
                  mfldrDrawTemplate(wpObject, &rcl, pOwnerItem->hps, flCnr);
                  if(flCnr&CV_MINI)
                    return (MRESULT) TRUE;
                  ulMiniOrNormal=DP_MINI;
                }

                /* Check for folder because of animated icon */
                if(pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_INUSE)
                  {
                    SOMClass* wpFolderClass=queryWpFolderClass();
                    
                    if(somIsObj(wpFolderClass)) {
                      if(_somIsA(wpObject, wpFolderClass)) {   
                        /* It's a folder */
                        HPOINTER hptr;
                        
                        pOwnerItem->rclItem.xLeft=rcl.xLeft;
                        pOwnerItem->rclItem.yBottom=rcl.yBottom;
                        
                        /* The following is only for Warp 4 but Warp 3 isn't supported anyway...*/
                        hptr=_wpQueryIconN(wpObject,1);
                        if(WinDrawPointer(pOwnerItem->hps, rcl.xLeft, rcl.yBottom, hptr, ulMiniOrNormal)) {
                          cwDraw2ColorBorder(pOwnerItem->hps, &rclTemp, CLR_BLACK, CLR_DARKGRAY);
                          return (MRESULT) TRUE;
                        }
                        
                      }
                    }/* if(somIsObj(wpFolderClass)) */
                  }/* if(pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_INUSE) */
                
                if(WinDrawPointer(pOwnerItem->hps, rcl.xLeft, rcl.yBottom, mrc->hptrIcon, ulMiniOrNormal)) {
                  cwDraw2ColorBorder(pOwnerItem->hps, &rclTemp, CLR_BLACK, CLR_DARKGRAY);
                  return (MRESULT) TRUE;
                }
              }/* if((ulIconSize=WinQuerySysValue(HWND_DESKTOP,SV_CXICON))!=0) */

            }/* somIsObj(wpObject)*/
          }/* mrc */
        }/* if(pOwnerItem->idItem==CMA_ICON) */
        else if(pOwnerItem->idItem==0) {
          /*************************/
          /* It's the details view */
          /*************************/
          PCNRDRAWITEMINFO pCnrDrawItemInfo=(PCNRDRAWITEMINFO)pOwnerItem->hItem;
          
          if(pCnrDrawItemInfo && pCnrDrawItemInfo->pFieldInfo->flData & CFA_BITMAPORICON) {
            PMINIRECORDCORE mrc=(PMINIRECORDCORE)((PCNRDRAWITEMINFO)pOwnerItem->hItem)->pRecord;
            if(mrc){
              WPObject *wpObjToRefresh;
              WPObject *wpObject;
              ULONG ulIconSize=150;/* Default if query fails */
              HWND hwndCnr=WinWindowFromID(hwnd, FID_CLIENT);
              RECTL rclTemp=pOwnerItem->rclItem;
              
              wpObjToRefresh=(WPObject*)OBJECT_FROM_PREC(mrc);//Get object
              wpObject=somGetFileSystemObject(wpObjToRefresh);
              
              /* Draw Background */
              rclTemp.xLeft+=2;
              rclTemp.xRight-=2;
              rclTemp.yBottom+=2;
              rclTemp.yTop-=2;
              
              /* Check if record is selected and in use... */
              if((pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_INUSE)
                 && (pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_SELECTED)) {
                POINTL pointl;
                
                GpiSetPattern(pOwnerItem->hps,PATSYM_DIAG2);
                pointl.x = rclTemp.xLeft;
                pointl.y = rclTemp.yBottom;
                GpiMove(pOwnerItem->hps, &pointl);
                pointl.x = rclTemp.xRight - 1;
                pointl.y = rclTemp.yTop - 1;
                GpiSetColor(pOwnerItem->hps, CLR_BLACK);
                GpiBox(pOwnerItem->hps,DRO_FILL,&pointl,1,1);         
                
              }
              /* or only in use... */
              else if(pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_INUSE) {
                POINTL pointl;
                
                GpiSetPattern(pOwnerItem->hps,PATSYM_DIAG1);
                pointl.x = rclTemp.xLeft;
                pointl.y = rclTemp.yBottom;
                GpiMove(pOwnerItem->hps, &pointl);
                pointl.x = rclTemp.xRight - 1;
                pointl.y = rclTemp.yTop - 1;
                GpiSetColor(pOwnerItem->hps, CLR_BLACK);
                GpiBox(pOwnerItem->hps,DRO_FILL,&pointl,1,1);         
              }
              /* or only selected. */
              else if(pCnrDrawItemInfo->pRecord->flRecordAttr & CRA_SELECTED)
                WinFillRect(pOwnerItem->hps, &rclTemp, CLR_DARKGRAY);
              else /* default is a white background */
                WinFillRect(pOwnerItem->hps, &rclTemp, CLR_WHITE);

              if(somIsObj(wpObject) && _wpIsObjectInitialized(wpObject)) {
                SOMClass* cwBitmapClass=queryCWBitmapFileClass();
                SOMClass* cwImageClass=queryCWImageFileClass();
                
                if(somIsObj(cwImageClass)||somIsObj(cwBitmapClass)) {
                  HBITMAP hbm=NULLHANDLE;
                  PBITMAPINFOHEADER2 pBmpInfoHeader2;
                  
                  /* Query object pointer */
                  if((hwndStore=WinWindowFromID(hwnd, STOREWINDOWID))!=NULLHANDLE)
                    {
                      somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
                      if(somIsObj(somSelf)) {
                        MMFolderData *somThis = MMFolderGetData(somSelf); 
                        ulIconSize=_ulCurrentSize;
                      }
                    }
                  /* Get the small bitmap from the object */ 
                  if(_somIsA(wpObject, cwImageClass)) {
                    hbm=_cwmmQuerySmallBitmapHandle( (MMImage*) wpObject, ulIconSize, mrc, hwndCnr);
                    pBmpInfoHeader2=(PBITMAPINFOHEADER2)_wpQueryBitmapInfoHeader((MMImage*)wpObject);
                  }
                  else if(_somIsA(wpObject, cwBitmapClass)) {
                    hbm=_cwmmQuerySmallBitmapHandleCWBitmap( (MMImage*) wpObject, ulIconSize);
                    pBmpInfoHeader2=(PBITMAPINFOHEADER2)_wpQueryBitmapInfoHeader((MMBitmap*)wpObject);
                  }
                  if(hbm)
                    {
                      /* We got a small bitmap for display */
                      if(pBmpInfoHeader2) {
                        ULONG ulWidth, ulHeight;
                        ULONG ulIconHeight, ulIconWidth; /* size of drawing area on screen */
                        ULONG ulFact;
                        RECTL rcl=pOwnerItem->rclItem;

                        /* Get size of bitmap */
                        if(pBmpInfoHeader2->cbFix==sizeof(BITMAPINFOHEADER2)) {
                          ulWidth=pBmpInfoHeader2->cx;
                          ulHeight=pBmpInfoHeader2->cy;
                        }
                        else {
                          /* The default WPS bitmap class returned PBITMAPINFOHEADER */
                          PBITMAPINFOHEADER pBmpInfoHeader=(PBITMAPINFOHEADER)pBmpInfoHeader2;
                          ulWidth=pBmpInfoHeader->cx;
                          ulHeight=pBmpInfoHeader->cy;
                        }

                        /* Calculate size of drawing area */
                        ulIconHeight=rcl.yTop-rcl.yBottom;
                        ulIconWidth=rcl.xRight-rcl.xLeft;
                        /* Calculate scaling factor for bitmap so aspect ratio is kept */
                        ulFact=ulWidth>ulHeight ? ulWidth*1000/ulIconHeight : ulHeight*1000/ulIconHeight;
                        ulWidth=ulWidth*1000/ulFact;
                        ulHeight=ulHeight*1000/ulFact;
                        /* Adjust x pos. Cx is greater than cy in details view. */
                        if(ulIconWidth>ulWidth)
                          rcl.xLeft+=(ulIconWidth-ulWidth)/2;
                        else {
                          ulWidth=ulIconWidth-2;
                          rcl.xLeft+=(ulIconWidth-ulWidth)/2;
                        }
                        rcl.xRight=rcl.xLeft+ulWidth;
                        /* Adjust y pos */
                        if(ulIconHeight>ulHeight)
                          rcl.yBottom+=(ulIconHeight-ulHeight)/2;
                        else {
                          ulHeight=ulIconHeight-2;
                          rcl.yBottom+=(ulIconHeight-ulHeight)/2;
                        }
                        rcl.yTop=rcl.yBottom+ulHeight;///ulFact;
                        /* And now draw the bitmap */
                        WinDrawBitmap(pOwnerItem->hps, hbm, NULL, (PPOINTL)&rcl,//pOwnerItem->rclItem,
                                      CLR_WHITE, CLR_BLACK, DBM_STRETCH /*|DBM_IMAGEATTRS*/);
                      }
                      return (MRESULT) TRUE;
                    }/* hbm */
                }/* cwImageClass */
              }/* wpObject*/
              /* It's not an image class. Draw normal pointer */
              break;
            }/*  if(mrc) */
          }/* if(pCnrDrawItemInfo && pCnrDrawItemInfo->pFieldInfo->flData & CFA_BITMAPORICON) */
        }/* Details view */
        break;
      }
#if 0
    case WM_CONTROL:
      if(SHORT2FROMMP(mp1)==CN_INITDRAG)
        {
          PCNRDRAGINIT pcnrInit=PVOIDFROMMP(mp2);
          pcnrInit->cx=-20;
          pcnrInit->cy=-20;
          //          if( pcnrInit->pRecord->cb==sizeof(MINIRECORDCORE))
          //          pcnrInit->cx+=75;
          // pcnrInit->cy+=75;
          //DosBeep(5000, 100);
        }
      break;

    case WM_CONTROL:
      if(SHORT2FROMMP(mp1)==CN_DRAGOVER)
        {
          PCNRDRAGINFO pcnrDragInfo=PVOIDFROMMP(mp2);

          DrgSetDragInfo(pcnrDragInfo->pDragInfo, pdimage, 1, NULLHANDLE);
          //          if( pcnrInit->pRecord->cb==sizeof(MINIRECORDCORE))
          //          pcnrInit->cx+=75;
          // pcnrInit->cy+=75;
          DosBeep(5000, 20);
        }
      break;
#endif
    case WM_INITMENU:
      if((hwndStore=WinWindowFromID(hwnd, STOREWINDOWID))!=NULLHANDLE)
        {
          somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
          if(somIsObj(somSelf)) {
            MMFolderData *somThis = MMFolderGetData(somSelf); 
            switch(_usLastSelMenuItem)
              {
              case 0x2d1:/* view menu */
                {
                  char text[CCHMAXPATH];
                  MENUITEM mi;
                  HWND hwndMenu;
                  CNRINFO cnrInfo;

                  /* Insert size menu only in icon view */
                  if(WinSendMsg(WinWindowFromID(hwnd, FID_CLIENT),CM_QUERYCNRINFO, MPFROMP(&cnrInfo),
                                MPFROMSHORT(sizeof(cnrInfo)))) {

                    if((cnrInfo.flWindowAttr & CV_ICON) && !(cnrInfo.flWindowAttr & CV_TREE)) {
                      /* insert separator */
                      menuInsertMenuSeparator( HWNDFROMMP(mp2), NULLHANDLE, MIT_END);
                      
                      /* Load the menu from the resource */
                      hwndMenu=WinLoadMenu(hwnd,queryResModuleHandle(), ID_MENUICONSIZE);
                      
                      /* Fill the MENUITEM structure */
                      mi.iPosition=MIT_END;
                      mi.afStyle=MIS_TEXT|MIS_SUBMENU;
                      mi.id=ID_MENUICONSIZE;
                      mi.afAttribute=NULLHANDLE;                
                      mi.hwndSubMenu=hwndMenu;
                      mi.hItem=NULLHANDLE;
                      if(!getMessage(text, IDSTR_ICONSIZEMENU, sizeof(text), queryResModuleHandle(), hwnd))
                        strcpy(text, "Icon ~size");;
                      menuInsertMenuItem(HWNDFROMMP(mp2), hwndMenu, MIT_END, ID_MENUICONSIZE, text);
                      
                      /* check current menuitem */
                      switch(_ulCurrentSize)
                        {
                        case 0:
                          WinCheckMenuItem(hwndMenu, ID_NORMALICONSITEM, TRUE);
                          break;
                        case 50:
                          WinCheckMenuItem(hwndMenu, ID_50X50ITEM, TRUE);
                          break;
                        case 100:
                          WinCheckMenuItem(hwndMenu, ID_100X100ITEM, TRUE);
                          break;
                        case 150:
                          WinCheckMenuItem(hwndMenu, ID_150X150ITEM, TRUE);
                          break;
                        case 200:
                          WinCheckMenuItem(hwndMenu, ID_200X200ITEM, TRUE);
                          break;
                        case 250:
                          WinCheckMenuItem(hwndMenu, ID_250X250ITEM, TRUE);
                          break;
                        default:
                          break; 
                        }
                    }
                  }/* if() */
                  break;
                }/* case 0x2d1 */
              default:
                break;
              }
          }
        }
      break;
    case WM_MENUSELECT:
      if((hwndStore=WinWindowFromID(hwnd, STOREWINDOWID))!=NULLHANDLE)
        {
          somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
          if(somIsObj(somSelf)) {
            MMFolderData *somThis = MMFolderGetData(somSelf); 
            _usLastSelMenuItem=SHORT1FROMMP(mp1);
          }
        }
      break;
    default:
      break;
    }
  /* Any other message is handled by the folder container procedure */
  if((hwndStore=WinWindowFromID(hwnd, STOREWINDOWID))!=NULLHANDLE)
    {
      somSelf=(MMFolder*) WinQueryWindowULong(hwndStore,QWL_USER);
      if(somIsObj(somSelf)) {
        MMFolderData *somThis = MMFolderGetData(somSelf); 
        if(_oldFrameProc)
          return _oldFrameProc(hwnd, msg, mp1, mp2);
      }
    }
  
  return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

/*
 *	wpSetupOnce :override;
 */

SOM_Scope HWND  SOMLINK mmfldr_wpOpen(MMFolder *somSelf, HWND hwndCnr, 
                                      ULONG ulView, ULONG param)
{
  HWND hwnd;

  MMFolderData *somThis = MMFolderGetData(somSelf); 
    MMFolderMethodDebug("MMFolder","mmfldr_wpOpen");

    hwnd=(MMFolder_parent_WPFolder_wpOpen(somSelf, hwndCnr, 
                                            ulView, param));

    /* Only subclass folder frames, not settings notebooks */
    if(ulView!=OPEN_SETTINGS){    
      HWND hwndStore;

      if((hwndStore=WinCreateWindow(hwnd, WC_STATIC, "objectStore", 0, 0,0,0,0,
                         hwnd, HWND_BOTTOM, STOREWINDOWID, NULLHANDLE, NULLHANDLE))!=NULLHANDLE)
        {
          HWND hwndContainer;     

          WinSetWindowULong(hwndStore, QWL_USER, (ULONG)somSelf);
          _oldFrameProc=WinSubclassWindow(hwnd, mmFolderFrameProc);
          
          if(hwnd)
            {
              CNRINFO cnrInfo;
              HWND hwndContainer=WinWindowFromID(hwnd,FID_CLIENT);
  
              /* Change the containerflags */
              if(WinSendMsg(hwndContainer,CM_QUERYCNRINFO, MPFROMP(&cnrInfo),
                            MPFROMSHORT(sizeof(cnrInfo))))
                {
                  if(cnrInfo.flWindowAttr & CV_ICON) {              
                    cnrInfo.slBitmapOrIcon.cx=_ulCurrentSize;
                    cnrInfo.slBitmapOrIcon.cy=_ulCurrentSize;
                    cnrInfo.flWindowAttr&=~CA_DRAWICON;
                    cnrInfo.flWindowAttr|=CA_DRAWBITMAP|CA_OWNERDRAW;
                    WinSendMsg(hwndContainer,CM_SETCNRINFO, MPFROMP(&cnrInfo),
                               MPFROMLONG(CMA_SLBITMAPORICON|CMA_FLWINDOWATTR));
                  }
                }
            }
          /* Subclass container */
          hwndContainer=WinWindowFromID(hwnd,FID_CLIENT);//Get container hwnd
          if(hwndContainer) {
            _oldContainerProc=WinSubclassWindow(hwndContainer, mmFolderContainerProc);
          }
        }
    }
    return hwnd;
}

#if 0
SOM_Scope BOOL  SOMLINK mmfldr_wpSetupOnce(MMFolder *somSelf, 
                                           PSZ pszSetupString)
{
  BOOL rc;

    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpSetupOnce");

    rc=(MMFolder_parent_WPFolder_wpSetupOnce(somSelf, pszSetupString));

    _ulCurrentSize=MMFLDR_DEFAULT_ICONSIZE;
#if 0
    if(_ulCurrentSize!=0 && _ulCurrentSize%50==0)
      {
        char setup[200];
        sprintf(setup, "ICONGRIDSIZE=%d;", _ulCurrentSize+15);
        _wpSetup(somSelf,setup);
      }

      _wpSetup(somSelf,"DETAILSCLASS=MMImage;ICONVIEW=GRIDDED;SORTCLASS=MMImage;");
#endif
    return rc;
}
#endif

SOM_Scope BOOL  SOMLINK mmfldr_wpRestoreState(MMFolder *somSelf, 
                                              ULONG ulReserved)
{
    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpRestoreState");

    /* Set default icon size */
    if(!_wpRestoreLong(somSelf, "MMFolder", KEY_ICONSIZE, &_ulCurrentSize)) {
      _ulCurrentSize=MMFLDR_DEFAULT_ICONSIZE;
    }

    return (MMFolder_parent_WPFolder_wpRestoreState(somSelf, 
                                                    ulReserved));
}

SOM_Scope BOOL  SOMLINK mmfldr_wpRestoreData(MMFolder *somSelf, 
                                             PSZ pszClass, ULONG ulKey, 
                                             PBYTE pValue, PULONG pcbValue)
{
  BOOL rc;
    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpRestoreData");

    rc= (MMFolder_parent_WPFolder_wpRestoreData(somSelf, pszClass, 
                                                   ulKey, pValue, 
                                                   pcbValue));
    switch(ulKey)
      {
      case IDKEY_FDRGRIDINFO:  /* 2938 Warp 4 and above */
        /* Get address in instance data for grid spacing */
        {
          if(!stricmp(pszClass, "WPFolder"))
            {
              if(!pcbValue || *pcbValue!=8L || !pValue) /* Sanity check */
                break;
              _pulGridSpacing=(ULONG*)pValue;
            }
          break;
        }
      case IDKEY_FDRLONGARRAY:     /* 2931 */
        /* Get address in instance data for view */
        {
          if(!stricmp(pszClass, "WPFolder"))
            {
              if(!pcbValue || *pcbValue!=84L || !pValue) /* Sanity check */
                break;
              _pFldrLongArray=pValue;
            }
          break;
        }
      default:
        break;
      }
    return rc;
}

SOM_Scope BOOL  SOMLINK mmfldr_wpSaveState(MMFolder *somSelf)
{
    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpSaveState");
    
    _wpSaveLong( somSelf, "MMFolder", KEY_ICONSIZE, _ulCurrentSize);

    return (MMFolder_parent_WPFolder_wpSaveState(somSelf));
}


SOM_Scope BOOL  SOMLINK mmfldr_wpSaveData(MMFolder *somSelf, 
                                          PSZ pszClass, ULONG ulKey, 
                                          PBYTE pValue, ULONG cbValue)
{
  PSZ psz;
    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpSaveData");

    /* When the template is created wpRestoreData() isn't called so we don't have
       the address of the instance data containing grid spacing and view. So
       we force the object to save the instance data and in wpSaveData we
       finally get the right addresses to change the object view to gridded. 
       This change is done in wpObjectReady() where we called wpSaveImmediate(). */

    /* If no ID result is NULL */
    /*
      @@CHANGE 0.2.8

      Check ID for NULL to prevent crash in stricmp().
     */
    psz=_wpQueryObjectID(somSelf);          
    //  if(!stricmp(_wpQueryObjectID(somSelf), "<MMPM2_MMFOLDERTEMPLATE>"))
    if(psz && !stricmp(psz, "<MMPM2_MMFOLDERTEMPLATE>"))
      {
        switch(ulKey)
          {
          case IDKEY_FDRGRIDINFO:  /* 2938 Warp 4 and above */
            /* Get address in instance data for grid spacing */
            {
              if(!stricmp(pszClass, "WPFolder"))
                {
                  /* if address is already known do nothing */
                  if(_pulGridSpacing || cbValue!=8L || !pValue) /* Sanity check */
                    break;
                  _pulGridSpacing=(ULONG*)pValue;
                }
              break;
            }
          case IDKEY_FDRLONGARRAY:     /* 2931 */
            /* Get address in instance data for view */
            {
              if(!stricmp(pszClass, "WPFolder"))
                {
                  /* if address is already known do nothing */
                  if(_pFldrLongArray || cbValue!=84L || !pValue) /* Sanity check */
                    break;
                  _pFldrLongArray=pValue;
                  //DosBeep(500, 200);
                }
              break;
            }
          default:
            break;
          }
      }

    return (MMFolder_parent_WPFolder_wpSaveData(somSelf, pszClass, 
                                                ulKey, pValue, 
                                                cbValue));
}

SOM_Scope BOOL  SOMLINK mmfldr_wpMenuItemSelected(MMFolder *somSelf, 
                                                  HWND hwndFrame, 
                                                  ULONG ulMenuId)
{
  CNRINFO cnrInfo;

    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpMenuItemSelected");

    if(ulMenuId>=0xbc01 && ulMenuId <=0xbc06) {
      HWND hwndContainer=WinWindowFromID(hwndFrame, FID_CLIENT);
      /* Change the containerflags */
      if(WinSendMsg(hwndContainer, CM_QUERYCNRINFO, MPFROMP(&cnrInfo),
                    MPFROMSHORT(sizeof(cnrInfo))))
        {
          char text[200];
          CNRINFO cnrInfo2=cnrInfo;
    
          switch(ulMenuId)
            {
            case ID_50X50ITEM:
              cnrInfo.slBitmapOrIcon.cx=50;
              break;
            case ID_100X100ITEM:
              cnrInfo.slBitmapOrIcon.cx=100;
              break;
            case ID_150X150ITEM:
              cnrInfo.slBitmapOrIcon.cx=150;
              break;
            case ID_200X200ITEM:
              cnrInfo.slBitmapOrIcon.cx=200;
              break;
            case ID_250X250ITEM:
              cnrInfo.slBitmapOrIcon.cx=250;
              break;
            default:
              cnrInfo.slBitmapOrIcon.cx=0;
              break;
            }

          _ulCurrentSize=cnrInfo.slBitmapOrIcon.cx;

          sprintf(text, "ICONGRIDSIZE=%d",cnrInfo.slBitmapOrIcon.cx+20);
          _wpSetup(somSelf, text);

          cnrInfo.slBitmapOrIcon.cy=cnrInfo.slBitmapOrIcon.cx;
          cnrInfo.flWindowAttr&=~CA_DRAWICON;
          cnrInfo.flWindowAttr|=CA_DRAWBITMAP|CA_OWNERDRAW;

          /* Prevent drawing in container */
          WinEnableWindowUpdate(hwndContainer, FALSE);

          cnrInfo2=cnrInfo;
          cnrInfo2.flWindowAttr=CV_DETAIL;
          WinSendMsg(hwndContainer,CM_SETCNRINFO, MPFROMP(&cnrInfo2),
                     MPFROMLONG(CMA_FLWINDOWATTR));

          WinSendMsg(hwndContainer,CM_SETCNRINFO, MPFROMP(&cnrInfo),
                     MPFROMLONG(CMA_SLBITMAPORICON|CMA_FLWINDOWATTR));

          /* Set gridsize. The address is gathered in wp_RestoreData */
          if(_pulGridSpacing!=NULLHANDLE){
            *(_pulGridSpacing++)=_ulCurrentSize+MMFLDR_SPACINGDELTA_X;
            /* FIXME: Use fontsize */
            *(_pulGridSpacing--)=_ulCurrentSize+MMFLDR_SPACINGDELTA_Y;
          }

          _wpSetup(somSelf, "MENUITEMSELECTED=716");/* Change to icon view */          
          _wpSetup(somSelf, "MENUITEMSELECTED=309");/* Arrange */

          WinEnableWindowUpdate(hwndContainer, TRUE);
          _wpSaveDeferred(somSelf);
          return TRUE;
        }
    }/* if() */
    return (MMFolder_parent_WPFolder_wpMenuItemSelected(somSelf, 
                                                        hwndFrame, 
                                                        ulMenuId));
}


/*
 *wpSetup:override;
 */
SOM_Scope void  SOMLINK mmfldr_wpObjectReady(MMFolder *somSelf, 
                                             ULONG ulCode, WPObject* refObject)
{
    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpObjectReady");

    MMFolder_parent_WPFolder_wpObjectReady(somSelf, ulCode, refObject);

    switch(ulCode)
      {
      case OR_FROMTEMPLATE:
      case OR_NEW:
        {
          PSZ psz;

          /* Only after creation */
#if 0
          if(_ulCurrentSize!=0 && _ulCurrentSize%50==0)
            {
              char setup[200];
              sprintf(setup, "ICONGRIDSIZE=%d;", _ulCurrentSize+15);
              _wpSetup(somSelf,setup);
            }
#endif
          /* Set default icon size */
          if(!_ulCurrentSize || _ulCurrentSize%50!=0)
            _ulCurrentSize=MMFLDR_DEFAULT_ICONSIZE;

          /* If no ID result is NULL */
          psz=_wpQueryObjectID(somSelf);          
          if(psz && !stricmp(psz, "<MMPM2_MMFOLDERTEMPLATE>")) {
            /* When the template is created wpRestoreData() isn't called so we don't have
               the address of the instance data containing grid spacing and view. So
               we force the object to save the instance data and in wpSaveData we
               finally get the right addresses to change the object view to gridded. */
            
            _wpSaveImmediate(somSelf);
            /* Set default view to gridded */
            
            if(_pFldrLongArray!=NULLHANDLE) {
              *_pFldrLongArray=0x80;
              //DosBeep(100, 200);
            }
            /* Set gridsize. The address is gathered in wp_RestoreData */
            if(_pulGridSpacing!=NULLHANDLE){
              *(_pulGridSpacing++)=_ulCurrentSize+MMFLDR_SPACINGDELTA_X;
              /* FIXME: Use fontsize */
              *(_pulGridSpacing--)=_ulCurrentSize+MMFLDR_SPACINGDELTA_Y;
            }
            
          }
          break;
        }
      default:
        break;
      }
}

SOM_Scope BOOL  SOMLINK mmfldr_wpSetup(MMFolder *somSelf, PSZ pszSetupString)
{
  char buffer[CCHMAXPATH];
  ULONG bufferSize;

    MMFolderData *somThis = MMFolderGetData(somSelf);
    MMFolderMethodDebug("MMFolder","mmfldr_wpSetup");

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMTHUMBSIZE, buffer, &bufferSize))
      {
        PVIEWITEM pViewItem;
        int iSize=atoi(buffer);
        ULONG ulMenuId;

        switch(iSize)
          {
          case 0:
            _ulCurrentSize=0;
            ulMenuId=ID_NORMALICONSITEM;
            break;
          case 50:
            _ulCurrentSize=50;
            ulMenuId=ID_50X50ITEM;
            break;
          case 100:
            _ulCurrentSize=100;
            ulMenuId=ID_100X100ITEM;
            break;
          case 150:
            _ulCurrentSize=150;
            ulMenuId=ID_150X150ITEM;
            break;
          case 200:
            _ulCurrentSize=200;
            ulMenuId=ID_200X200ITEM;
            break;
          case 250:
            _ulCurrentSize=250;
            ulMenuId=ID_250X250ITEM;
            break;
          default:
            break;
          }
        /* MENUITEMSELECTED=xxx would be easy but doesn't work to change the icons of the folder because there is no
         hwndFrame in _wpMenuItemSelected() when sending it. So iterate over all views and call the menu
         function. */
        for(pViewItem=_wpFindViewItem(somSelf,VIEW_CONTENTS|VIEW_TREE|VIEW_DETAILS, NULLHANDLE);
            pViewItem;
            pViewItem=_wpFindViewItem(somSelf,VIEW_CONTENTS|VIEW_TREE|VIEW_DETAILS, pViewItem))
          {
            _wpMenuItemSelected(somSelf, 
                                pViewItem->handle, 
                                ulMenuId);
          }
      }
    return (MMFolder_parent_WPFolder_wpSetup(somSelf, pszSetupString));
}


SOM_Scope BOOL  SOMLINK mmfldrM_wpclsCreateDefaultTemplates(M_MMFolder *somSelf, 
                                                            WPObject* Folder)
{
  char chrSetup[sizeof(MMFLDR_TEMPLATE_SETUP)+1];
  WPFolder* wpFolder;


  /* M_MMFolderData *somThis = M_MMFolderGetData(somSelf); */
  M_MMFolderMethodDebug("M_MMFolder","mmfldrM_wpclsCreateDefaultTemplates");

  if(WinQueryObject("<MMPM2_MMFOLDERTEMPLATE>"))
    return TRUE; /* There's already a template */

  sprintf(chrSetup, MMFLDR_TEMPLATE_SETUP);
  wpFolder=_wpclsQueryFolder(somSelf, MMTEMPLATE_FOLDER_ID, FALSE);
  _wpclsNew(somSelf, _wpclsQueryTitle(somSelf), chrSetup, wpFolder,FALSE);
  
  return TRUE;
}


SOM_Scope PSZ  SOMLINK mmfldrM_wpclsQueryTitle(M_MMFolder *somSelf)
{
  static char chrTitle[20]={0};
    /* M_MMFolderData *somThis = M_MMFolderGetData(somSelf); */
    M_MMFolderMethodDebug("M_MMFolder","mmfldrM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_LIGHTTABLETITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Light table");

    return chrTitle;
}


SOM_Scope ULONG  SOMLINK mmfldrM_wpclsQueryIconData(M_MMFolder *somSelf, 
                                                    PICONINFO pIconInfo)
{
  HMODULE hmod;

    /* M_MMFolderData *somThis = M_MMFolderGetData(somSelf); */
    M_MMFolderMethodDebug("M_MMFolder","mmfldrM_wpclsQueryIconData");

    hmod=queryModuleHandle();
    if(!hmod)
      return M_MMFolder_parent_M_WPFolder_wpclsQueryIconData(somSelf, pIconInfo);

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = hmod;
      pIconInfo->resid   = ID_ICONLIGHTTABLE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}


SOM_Scope ULONG  SOMLINK mmfldrM_wpclsQueryIconDataN(M_MMFolder *somSelf, 
                                                     ICONINFO* pIconInfo, 
                                                     ULONG ulIconIndex)
{
  HMODULE hmod;
    /* M_MMFolderData *somThis = M_MMFolderGetData(somSelf); */
    M_MMFolderMethodDebug("M_MMFolder","mmfldrM_wpclsQueryIconDataN");

    hmod=queryModuleHandle();
    if(!hmod)
      return M_MMFolder_parent_M_WPFolder_wpclsQueryIconDataN(somSelf, pIconInfo, ulIconIndex);

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = hmod;
      pIconInfo->resid   = ID_ICONLIGHTTABLE2;
	} /* endif */

	return ( sizeof(ICONINFO) );
}


SOM_Scope ULONG  SOMLINK mmfldrM_wpclsQueryDefaultView(M_MMFolder *somSelf)
{
    /* M_MMFolderData *somThis = M_MMFolderGetData(somSelf); */
    M_MMFolderMethodDebug("M_MMFolder","mmfldrM_wpclsQueryDefaultView");

    return VIEW_CONTENTS;
}

