/*
 * This file is (C) Chris Wohlgemuth 2002
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CDFOLDER_HH_INCLUDED
#define CDFOLDER_HH_INCLUDED

#define IDHLP_CDFOLDERMAIN 200
//#define OPEN_MMDISK  0x6500+0x400

#include "mediafolder.hh"
#include "mediafolderres.h"

typedef struct _DISKUSEITEM
{
  WPObject* wpDiskObj;
  USEITEM useItem;
  VIEWITEM viewItem;
}DISKUSEITEM;

#pragma SOMAsDefault(on)
#include <som.hh>
#include <somcls.hh>
#pragma SOMNoMangling(on)

#include "cwaudio.hh"

#pragma SOMNonDTS(on)

class M_CWCDFolder:public M_CWMediaFolder
{
/* The name of of the new class */
#pragma SOMClassName(*,"M_CWCDFolder")
/* Required SOM version */
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
public:
  virtual PSZ  wpclsQueryTitle();
  virtual ULONG wpclsQueryStyle();
  virtual	ULONG wpclsQueryIconData(PICONINFO pIconInfo);
  virtual	ULONG wpclsQueryIconDataN(PICONINFO pIconInfo, ULONG ulIconIndex);
  virtual void wpclsInitData();
  virtual BOOL wpclsQueryDefaultHelp(PULONG HelpPanelId,PSZ HelpLibrary);
  virtual BOOL wpclsCreateDefaultTemplates(WPObject * wpObject);
  /*  virtual void wpclsInitData();
  virtual void wpclsUnInitData();

  */
#pragma SOMReleaseOrder()
#pragma SOMIDLPass(*,"Implementation-End","dllname = mediafld;")
};

class CWCDFolder:public CWMediaFolder
{
#pragma SOMClassName(*,"CWCDFolder")
#pragma SOMMetaClass(*,"M_CWCDFolder")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
private:
  char  chrDrive[3];
  ULONG ulNumTracks;
  DISKUSEITEM diskUseItem;
  HWND hwndFrameCDFldr;
public:

  PFNWP pfnwpCDFrame;
#if 0
  virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
  virtual BOOL cwIsWaveFile(WPObject* wpObject);
  virtual ULONG cwSetWriteFlags(ULONG ulNewWriteFlags,ULONG ulMask);
  virtual ULONG cwQueryWriteFlags();
  virtual BOOL wpMenuItemSelected(HWND hwndFrame,ULONG ulMenuId);
  virtual void wpInitData();
  virtual void wpUnInitData();
  virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr, ULONG ulPosition);
  virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
#endif
  virtual BOOL wpRestoreState(ULONG ulReserved);
  virtual BOOL wpSaveState();
  virtual BOOL wpSetup(PSZ pSetupString);
  virtual BOOL wpSetupOnce(PSZ pSetupString);
  virtual MRESULT wpDragOver(HWND hwndCnr,PDRAGINFO pDragInfo);
  virtual BOOL wpRefresh(ULONG ulView, PVOID pReserved);
  virtual HWND wpOpen(HWND hwndCnr,ULONG ulView,ULONG ulParam);
  virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr, BOOL fMultiSelect);
  virtual ULONG wpAddObjectGeneralPage2(HWND hwndNotebook);
  virtual ULONG wpAddFolderSortPage(HWND hwndNotebook);
  virtual ULONG wpAddFolderIncludePage(HWND hwndNotebook);
  virtual ULONG wpQueryConcurrentView();
  virtual ULONG cwPlayAudioFile(HWND hwndFrame, ULONG ulWhich);
  virtual BOOL cwSeekAudioFile(LONG lPosSec);
  virtual void cwPlayTimeCallback(HWND hwndFrame, LONG lPosSec);
  virtual BOOL cwInsertAllTracks(char* chrCDDrive);
  virtual BOOL cwClose(HWND hwndFrame);
#pragma SOMReleaseOrder(\
)

#pragma SOMIDLPass(CWMediaFolder,"Implementation-End","dllname = mediafld;")
};

#pragma SOMAsDefault(pop)
#pragma SOMNonDTS(pop)

#endif /* CDFOLDER_HH_INCLUDED */












