/*
 * This file is (C) Chris Wohlgemuth 2002
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_DOS
#define INCL_WIN
#define INCL_GPIBITMAPS
#include <os2.h>

#define INCL_MCIOS2
#include <os2me.h>


#include "except.h"

#define IDTIMER_PLAY  5L
#define PLAYTIMER_DELAY 1000

#define STATUS_LENGTH 200

#define CWAUDIO_CLASS_NAME "MMAudio"

#ifdef DEBUG
    void writeDebugLog(char *text);
#endif


#pragma SOMAsDefault(on)
#include <som.hh>
#include <somcls.hh>
#pragma SOMNoMangling(on)
/*#include "progfolder.h"*/
#include "wpshadow.hh"

#pragma SOMAsDefault(off)
typedef struct _MYVIEWITEM
{
  BOOL bIsInUseList;
  USEITEM useItem;
  VIEWITEM viewItem;
}MYVIEWITEM; 

typedef struct
{
  INT id;
  RECTL rclSource;
  HBITMAP hbmSource;
  RECTL rclDest;
}CONTROLINFO;

typedef struct
{
  BITMAPINFOHEADER bmpInfoHdr;
  HBITMAP hbm;
}LOADEDBITMAP;


#pragma SOMAsDefault(on)

class M_CWAudioShadow:public M_WPShadow
{
/* The name of of the new class */
#pragma SOMClassName(*,"M_CWAudioShadow")
/* Required SOM version */
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
public:
  virtual PSZ  wpclsQueryTitle();
  virtual ULONG wpclsQueryDetailsInfo( PCLASSFIELDINFO* ppClassFieldInfo, PULONG pSize);
#if 0
  virtual void wpclsInitData();
  virtual	ULONG wpclsQueryIconData(PICONINFO pIconInfo);
  virtual	ULONG wpclsQueryIconDataN(PICONINFO pIconInfo, ULONG ulIconIndex);
  virtual void wpclsUnInitData();
	virtual	ULONG wpclsQueryStyle();
	virtual BOOL wpclsQueryDefaultHelp(PULONG HelpPanelId,PSZ HelpLibrary);
  virtual BOOL wpclsCreateDefaultTemplates(WPObject * wpObject);
#endif

#pragma SOMReleaseOrder()
#pragma SOMIDLPass(*,"Implementation-End","dllname = mediafld;")
};

class CWAudioShadow:public WPShadow
{
#pragma SOMClassName(*,"CWAudioShadow")
#pragma SOMMetaClass(CWAudioShadow,"M_CWAudioShadow")
#pragma SOMClassVersion(CWAudioShadow,1,2)
#pragma SOMCallstyle(oidl)
private:

public:

  virtual ULONG wpQueryDetailsData(PVOID* ppDetailsData, PULONG pcp);
  //  virtual void wpInitData();
#if 0
  virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
  virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr, BOOL fMultiSelect);
  virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr, ULONG ulPosition);
  virtual BOOL wpMenuItemSelected(HWND hwndFrame,ULONG ulMenuId);
  virtual ULONG wpAddFolderView2Page(HWND hwndNotebook);
  virtual MRESULT wpDragOver(HWND hwndCnr,PDRAGINFO pDragInfo);
  virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
  virtual BOOL wpAddToContent(WPObject* Object);
  virtual BOOL wpDeleteFromContent(WPObject* Object);
  virtual BOOL cwIsWaveFile(WPObject* wpObject);
  virtual ULONG cwSetWriteFlags(ULONG ulNewWriteFlags,ULONG ulMask);
  virtual ULONG cwQueryWriteFlags();
  virtual BOOL wpRestoreState(ULONG ulReserved);
  virtual BOOL wpSaveState();
  virtual MRESULT wpDragOver(HWND hwndCnr,PDRAGINFO pDragInfo);
  virtual MRESULT wpDrop(HWND hwndCnr,PDRAGINFO pDragInfo,PDRAGITEM pDragItem);  
#endif

#pragma SOMReleaseOrder()

#pragma SOMIDLPass(CWAudioShadow,"Implementation-End","dllname = mediafld;")
};















