
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwaudio_Source
#define SOM_Module_cwaudio_Source
#endif
#define CWAudio_Class_Source
#define M_CWAudio_Class_Source

#define INCL_PM
#define INCL_DOSMODULEMGR
#define INCL_DOS
#define INCL_WINWORKPLACE
#define INCL_MMIOOS2
#define INCL_REXXSAA
#define INCL_DOSDEVIOCTL
#define INCL_MCIOS2

#include <os2.h>
#include <stdio.h>
#include <rexxsaa.h>                   /* needed for Rexx */
#include "os2me.h"
#include "cwaudio.ih"
#include "cwaudioinc.h"
#include <wpdisk.h>

typedef ULONG (APIENTRY   FNWPSFUNC)(WPObject* ,...);
typedef FNWPSFUNC *PFNWPSFUNC;

char classDLLPath[CCHMAXPATH]={0};

int iFirstCD;
int iNumCD;
BOOL bGotCD=FALSE;

void parameterError(char *chrMethod)
{
  char text[200];
  sprintf(text, "%s: wrong number of parameters.", chrMethod);

  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, text, "Method error",
                1234, MB_OK|MB_MOVEABLE);
  
}

void wpObjectError(char *chrMethod)
{
  char text[200];
  sprintf(text, "Method %s: object pointer is not valid.", chrMethod);

  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, text, "Object error",
                1234, MB_OK|MB_MOVEABLE);
  
}


#define HASHSIZE 101
ULONG calculateHash(char * theString)
{
  ULONG ulHash=0;

  if(theString)
    for(ulHash=0;*theString!='\0'; theString++)
      ulHash=*theString+31*ulHash;
  
  return ulHash%HASHSIZE;
}

#define HASHSIZE2 123
ULONG calculateHash2(char * theString)
{
  ULONG ulHash=0;

  if(theString)
    for(ulHash=0;*theString!='\0'; theString++)
      ulHash=*theString+37*ulHash;
  
  return ulHash%HASHSIZE;
}

/* This function handles new WPS functions introduced by private classes */
ULONG EXPENTRY rxCallCWMMFunc(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename,PRXSTRING retstring)
{
  char text[200];
  ULONG ulHash;
  ULONG ulReturn;
  WPObject* wpObject;
  WPFileSystem* wpFSObject;

  /* At least WPObject* and name of method */
  if(argc<2)
    return 40;

  /*  TRY_LOUD(RX) {*/
    /* Get a hash for the methodname for the switch() statement */
    ulHash=calculateHash(argv[0].strptr)<<8;
    ulHash+=calculateHash2(argv[0].strptr);
    ulReturn=0;

    wpObject=(WPObject*)atol(argv[1].strptr);
    /* Check if it's a valid object */
    if(somIsObj(wpObject)) {
      PFNWPSFUNC procAddr;

      /* Try to find the requested method */
      if((procAddr=(PFNWPSFUNC) somResolveByName(wpObject, argv[0].strptr))==NULL) {
        /* method not found */
        sprintf(retstring->strptr, "ERROR_METHOD:");
        retstring->strlength=strlen(retstring->strptr);
      }
      else {
        switch(ulHash)
          {
          case 0x2a1b: /* cwmmQueryTrackInfo */
            {
              ULONG ulParam1;
             char text[100];

              if(argc<3) {
                parameterError(argv[0].strptr);
                ulReturn=40;
                break;
              }

              ulParam1=atol(argv[2].strptr);/* ulWhich */

              switch(ulParam1)
                {
                case IDINFO_PLAYTIME:
                case IDINFO_BPS:
                case IDINFO_CHANNELS:
                case IDINFO_SAMPLERATE:
                  sprintf(retstring->strptr,"%d",procAddr(wpObject, NULLHANDLE, 0, ulParam1));
                  break;
                default:
                  if(!procAddr(wpObject, &retstring->strptr, retstring->strlength, ulParam1))
                    //if(!procAddr(wpObject, text, 100, ))
                    sprintf(retstring->strptr,"ERROR:");
                }
              retstring->strlength=strlen(retstring->strptr);
              break;
            }
          default:
            ulReturn=40;        
          }/* switch */
      }/* else if((procAddr=(PFNWPSFUNC) somResolveByName(wpObject, argv[1].strptr))==NULL) */
    }/* if(somIsObj(wpObject)) */
    else {
      /* wpObject is not valid */
      wpObjectError(argv[0].strptr);

      ulReturn=40;
    }

    /*  }
        CATCH(RX)
        {}END_CATCH;*/
    
    return ulReturn;
}

/**************************************************************/
/*                                                            */
/* This funktion returns the CD-Drives in the system          */
/*                                                            */
/* iNumCD (output): # of CD-Drives                            */
/* iFirstDrive (output): first cd-Drive                       */
/* returns TRUE: We have cd-drives                            */
/*                                                            */
/**************************************************************/
BOOL cwQueryCDDrives(int *iNumCD, int * iFirstDrive)
{
  HFILE hfDevice;
  ULONG ulAction;
  ULONG ulLen;
  static int iFirst=0;
  static int iNumCDLocal=0;
  static BOOL haveCD=FALSE;
  static BOOL done=FALSE;         
  struct
  {
    USHORT usCountCD;
    USHORT usFirstCD;
  } CDInfo;

  if(!done){
    ulLen = sizeof(CDInfo);
    if(!DosOpen("\\DEV\\CD-ROM2$", &hfDevice, &ulAction, 0,
                FILE_NORMAL, OPEN_ACTION_OPEN_IF_EXISTS,
                OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY, NULL))
      {
        if(!DosDevIOCtl(hfDevice, 0x82, 0x60, NULL, 0, NULL, &CDInfo, ulLen, &ulLen))
          {
            if(CDInfo.usCountCD) {
              haveCD=TRUE;
              iNumCDLocal=CDInfo.usCountCD;
              iFirst=1+CDInfo.usFirstCD;
            }                                        
          }
        DosClose(hfDevice);
      }
    done=TRUE;
  }
  *iNumCD=iNumCDLocal;
  *iFirstDrive=iFirst;
  return haveCD;              
}

/****************************************/
/* Input: drive (e.g. o:)               */
/****************************************/
HFILE openDrive(char* drive)
{
	HFILE hfDrive = 0;
	ULONG ulAction;
	ULONG rc;

	rc = DosOpen(drive, &hfDrive, &ulAction, 0,
					 FILE_NORMAL, OPEN_ACTION_OPEN_IF_EXISTS,
					 OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY |
					 OPEN_FLAGS_DASD|OPEN_FLAGS_FAIL_ON_ERROR, NULL);	

	if(rc)
		return NULLHANDLE;//Error

	return hfDrive;
}

void closeDrive(HFILE hfDrive)
{
	DosClose(hfDrive);	
}

#pragma pack(1)

typedef struct{
	UCHAR   ucFirstTrack;
	UCHAR 	ucLastTrack;
	ULONG   ulLeadOut;
}CDINFO;

typedef struct
{
	UCHAR signature[4];
	UCHAR  ucTrackNum;
}TINFOPARAM;

typedef struct
{
	ULONG ulTrackAddress;
	UCHAR ucTCInfo;
}CDTRACKINFO;

#pragma pack()

/******************************************/
/* Result:  
	 0:   Error
	 -1: CD is Data Disk
	 other: # Audio tracks */
/******************************************/
int CDQueryAudioCDTracks(HFILE hfDrive)
{
	ULONG ulParamLen;
	ULONG ulDataLen;
	ULONG rc;
	CDINFO cdInfo;
	TINFOPARAM tip;
	CDTRACKINFO trackInfo;
    //char text[100];	

	ulDataLen=sizeof(cdInfo);
	ulParamLen=4;
		
	if(!hfDrive)
		return 0;
	
	rc = DosDevIOCtl(hfDrive, IOCTL_CDROMAUDIO, CDROMAUDIO_GETAUDIODISK,
						  "CD01", 4, &ulParamLen, &cdInfo,
						  sizeof(cdInfo), &ulDataLen);

	if(rc) {
		return 0;//Error
	}

	ulDataLen=sizeof(trackInfo);
	ulParamLen=sizeof(TINFOPARAM);
	tip.signature[0]='C';
	tip.signature[1]='D';	
	tip.signature[2]='0';
	tip.signature[3]='1';
	tip.ucTrackNum=1;
	
	/* We have a disc. Check if it's audio */
	rc = DosDevIOCtl(hfDrive, IOCTL_CDROMAUDIO, CDROMAUDIO_GETAUDIOTRACK,
						  &tip, sizeof(tip), &ulParamLen, &trackInfo,
						  sizeof(trackInfo), &ulDataLen);

	if(rc) {
		return 0;//Error
	}
		
	if(trackInfo.ucTCInfo & 0x40) {
		return -1;//It's a data track
	}
    return cdInfo.ucLastTrack-cdInfo.ucFirstTrack+1;	
}


BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd)
{
  if(!WinLoadString(WinQueryAnchorBlock(hwnd),hResource,ulID,lSizeText,text)) {
    sprintf(text,"");
    return FALSE;
  }
  return TRUE;
}

/* Remove all trailing spaces from a string. The string MUST be terminated by 0! */
void _removeTrailingSpaces(char * chrString)
{
  char *ptr;

  if((ptr=strrchr(chrString, 0))==NULLHANDLE)
    return;

  if(ptr==chrString)
    return;

  while(ptr>=chrString && (*ptr==0 || *ptr==' '))
    ptr--;

  *(++ptr)=0;
}

HMODULE queryModuleHandle(void)
{
  PSZ moduleName;
  static ULONG hModule=0;
  somId mySomId;

  if(!hModule)
    {
      mySomId=somIdFromString("M_CWAudio");
      moduleName=_somLocateClassFile(SOMClassMgrObject, mySomId, 1, 1);
      SOMFree(mySomId);
      DosQueryModuleHandle(moduleName, &hModule);
      strncpy(classDLLPath,moduleName, sizeof(classDLLPath));
      classDLLPath[sizeof(classDLLPath)-1]=0;
    }
  return hModule;
}

PSZ queryModuleName(void)
{
  if(queryModuleHandle())
    return classDLLPath;

  return NULLHANDLE;
}

SOMClass* cwGetSomClass(char* chrClassName)
{
  somId    mySomId;
  SOMClass *somClass;

  if((mySomId=somIdFromString(chrClassName))==NULLHANDLE)
    return NULLHANDLE;

  somClass=_somClassFromId(SOMClassMgrObject, mySomId);
  SOMFree(mySomId);

  return somClass;
}

#if 0
ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters)
{
  STARTDATA startData={0};
  APIRET rc;
  PID pid;
  ULONG ulSessionID=0;
  char chrLoadError[CCHMAXPATH];
  
  memset(&startData,0,sizeof(startData));
  startData.Length=sizeof(startData);
  startData.Related=SSF_RELATED_INDEPENDENT;
  startData.FgBg=SSF_FGBG_FORE;
  startData.TraceOpt=SSF_TRACEOPT_NONE;
  startData.PgmTitle=pszTitle;
    
  startData.PgmName=wrapperExe;
  startData.InheritOpt=SSF_INHERTOPT_SHELL;
  startData.SessionType=SSF_TYPE_PM;
  startData.PgmControl=0;
  startData.InitXPos=30;
  startData.InitYPos=30;
  startData.InitXSize=500;
  startData.InitYSize=400;
  startData.ObjectBuffer=chrLoadError;
  startData.ObjectBuffLen=(ULONG)sizeof(chrLoadError);

  startData.PgmInputs=parameters;

  rc=DosStartSession(&startData,&ulSessionID,&pid);   
  return 0;   
}

ULONG _launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters)
{
  PROGDETAILS progDetails={0};

  memset(&progDetails,0, sizeof(progDetails));
  progDetails.Length=sizeof(PROGDETAILS);
  progDetails.progt.progc=PROG_PM;
  progDetails.progt.fbVisible=SHE_VISIBLE;
  progDetails.pszTitle=pszTitle;
  progDetails.pszTitle="Text";
  progDetails.pszStartupDir="";
  progDetails.pszEnvironment="WORKPLACE\0\0";
  progDetails.pszExecutable=wrapperExe;
  progDetails.pszExecutable="ab.EXE";
  progDetails.swpInitial.fl=SWP_ACTIVATE;
  progDetails.swpInitial.hwndInsertBehind=HWND_TOP;

  //  WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, progDetails.pszExecutable, parameters, 12324, MB_MOVEABLE);
  return WinStartApp(NULLHANDLE, &progDetails, NULL, NULL, SAF_STARTCHILDAPP);
}

#endif

MRESULT EXPENTRY waveInfoDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWAudio *cwAudio;

  switch(msg) {
  case WM_INITDLG :
    cwAudio=(CWAudio*)LONGFROMMP(mp2);
    if(somIsObj(cwAudio)) {
      CWAudioData *somThis = CWAudioGetData(cwAudio);
      do {
        char fName[CCHMAXPATH];

        sprintf(fName,"%d",_ulChannels);
        WinSetWindowText(WinWindowFromID(hwnd, IDST_CHANNELS),fName);

        sprintf(fName,"%d",_ulSampleRate);
        WinSetWindowText(WinWindowFromID(hwnd, IDST_SAMPLERATE),fName);
        sprintf(fName,"%d",_ulBPS);
        WinSetWindowText(WinWindowFromID(hwnd, IDST_BPS),fName);
		sprintf(fName,"%d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
        WinSetWindowText(WinWindowFromID(hwnd, IDST_PLAYTIME),fName);
        WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
        break;
      }while (FALSE);
    }
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
#if 0
  case WM_WINDOWPOSCHANGED:
    {
      /* This prevents switching the notebook page behind the open folder */
      if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
        mp2=MPFROMLONG(0x80000);
      break;
    }
#endif
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);

}

SOM_Scope ULONG  SOMLINK cwaudio_cwmmAddWaveInformationPage(CWAudio *somSelf, 
                                                            HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];


  /* CWAudioData *somThis = CWAudioGetData(somSelf); */
  CWAudioMethodDebug("CWAudio","cwaudio_cwmmAddWaveInformationPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = waveInfoDlgProc;
  //The resource DLL
  pageinfo.resid = queryModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_WAVEINFOPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = IDDLG_GENERAL2PAGE;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = NULLHANDLE;
  //We have a major tab so we need a name
  /* pageName: "ISO filesystem" */
  getMessage(pageName, ID_WAVEINFOPAGENAME, sizeof(pageName),  queryModuleHandle(), hwndNotebook);
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook
  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);

}


SOM_Scope BOOL  SOMLINK cwaudio_cwmmSetTrackInfo(CWAudio *somSelf, 
                                                 char* chrString, 
                                                 ULONG ulValue, 
                                                 int iWhich)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmSetIdInfo");

    if(iWhich<1||iWhich>IDINFO_LASTINFO)
      return FALSE;

    switch(iWhich)
      {
      case IDINFO_PLAYTIME:
        _ulPlaySecs=ulValue;
        sprintf(_chrPlayTime, "%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
        break;
      case IDINFO_NAME:
        strncpy(_id3Name,chrString,sizeof(_id3Name));
        _id3Name[sizeof(_id3Name)-1]=0;
        _removeTrailingSpaces(_id3Name);
        break;
      case IDINFO_ARTIST:
        strncpy(_id3Artist,chrString,sizeof(_id3Artist));
        _id3Artist[sizeof(_id3Artist)-1]=0;
        _removeTrailingSpaces(_id3Artist);
        break;
      case IDINFO_ALBUM:
        strncpy(_id3Album, chrString, sizeof(_id3Album));
        _id3Album[sizeof(_id3Album)-1]=0;
        _removeTrailingSpaces(_id3Album);
        break;
      case IDINFO_YEAR:
        strncpy(_id3Year, chrString, sizeof(_id3Year));
        _id3Year[sizeof(_id3Year)-1]=0;
        _removeTrailingSpaces(_id3Year);
        break;
      case IDINFO_COMMENT:
        strncpy(_id3Comment,chrString, sizeof(_id3Comment));
        _id3Comment[sizeof(_id3Comment)]=0;
        _removeTrailingSpaces(_id3Comment);
        break;
      case IDINFO_GENRE:
        strncpy(_id3Genre, chrString, sizeof(_id3Genre));
        _id3Genre[sizeof(_id3Genre)-1]=0;
        _removeTrailingSpaces(_id3Genre);
        break;
      default:
        return FALSE;
      }
    /* Return statement to be customized: */
    return TRUE;
}


/*
 * The prototype for cwaudio_cwmmQueryTrackInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudio_cwmmQueryTrackInfo(CWAudio *somSelf, 
                                                    char** chrString, 
                                                    ULONG ulSize, 
                                                    int iWhich)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmQueryTrackInfo");

    switch(iWhich)
      {
      case IDINFO_PLAYTIME:
        return _ulPlaySecs;
      case IDINFO_BPS:
        return _ulBPS;
      case IDINFO_CHANNELS:
        return _ulChannels;
      case IDINFO_SAMPLERATE:
        return _ulSampleRate;
      case IDINFO_NAME:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Name)) {
            strncpy(chr, _id3Name, sizeof(_id3Name));
            chr[sizeof(_id3Name)-1]=0;
          }
          else {
            strncpy(chr, _id3Name, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ARTIST:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Artist)) {
            strncpy(chr, _id3Artist, sizeof(_id3Artist));
            chr[sizeof(_id3Artist)-1]=0;
          }
          else {
            strncpy(chr, _id3Artist, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ALBUM:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Album)) {
            strncpy(chr, _id3Album, sizeof(_id3Album));
            chr[sizeof(_id3Album)-1]=0;
          }
          else {
            strncpy(chr, _id3Album, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_COMMENT:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Comment)) {
            strncpy(chr, _id3Comment, sizeof(_id3Comment));
            chr[sizeof(_id3Comment)-1]=0;
          }
          else {
            strncpy(chr, _id3Comment, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_YEAR:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Year)) {
            strncpy(chr, _id3Year, sizeof(_id3Year));
            chr[sizeof(_id3Year)-1]=0;
          }
          else {
            strncpy(chr, _id3Year, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_GENRE:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Genre)) {
            strncpy(chr, _id3Genre, sizeof(_id3Genre));
            chr[sizeof(_id3Genre)-1]=0;
          }
          else {
            strncpy(chr, _id3Genre, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      default:
        break;
      }

    /* Return statement to be customized: */
    return 0;
}


typedef struct _OPENPARAMS
{
  CWAudio* thisPtr;
  PID pid;
  SWCNTRL swCtrl;
  USEITEM useItem;
  VIEWITEM viewItem;
}OPENPARAMS;

/* This Proc handles  */
MRESULT EXPENTRY playObjectProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        CWAudio * thisPtr;
        thisPtr=(CWAudio *)PVOIDFROMMP(mp2);/* Get object ptr */
        if(somIsObj(thisPtr)) {
          if(LONGFROMMP(mp1)==ACKEY_START) {
            unsigned char chrCommand[CCHMAXPATH*2];
            char chrDevice[20];
            char name[CCHMAXPATH];
            ULONG ulNameSize;
            char retMsg[20];
            APIRET rc;
            int iTime;
            SOMClass* mmMIDIClass=cwGetSomClass("CWMIDI");

            WinSetWindowULong(hwnd, QWL_USER, (ULONG)thisPtr);
#if 0
            if(contentObject->somIsA(mmAudioClass))
              strncpy(chrDevice,"WAVEAUDIO", sizeof(chrDevice));
            else if(contentObject->somIsA(mmMIDIClass))
              strncpy(chrDevice,"SEQUENCER", sizeof(chrDevice));
#endif
            if(_somIsA(thisPtr, mmMIDIClass))
              strncpy(chrDevice,"SEQUENCER", sizeof(chrDevice));
            else
              strncpy(chrDevice,"WAVEAUDIO", sizeof(chrDevice));

            ulNameSize=sizeof(name);
            _wpQueryRealName(thisPtr, name, &ulNameSize, TRUE);
            
            /* Start audio file */  
            sprintf(chrCommand,"open \"%s\"  type %s alias wave%d SHAREABLE wait",name, chrDevice, thisPtr);
            //WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, chrCommand, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
            rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
              WinPostMsg(hwnd,WM_QUIT,0,0);
              return MRFALSE;
            }
            sprintf(chrCommand,"STATUS wave%d LENGTH WAIT", thisPtr);
            rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
              WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
              return MRFALSE;
            }
            iTime=atoi(retMsg);
            if(iTime>3000)
              iTime-=3000;
            // WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, retMsg, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
            sprintf(chrCommand,"SETCUEPOINT wave%d ON at %d WAIT", thisPtr, iTime);
            rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {

              WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
              return MRFALSE;
            }

            sprintf(chrCommand,"play wave%d ", thisPtr);
            rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
              WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
              return MRFALSE;
            }
          }
          else if(LONGFROMMP(mp1)==ACKEY_STOP) {
            /* Stop playing */
            unsigned char chrCommand[CCHMAXPATH*2];
            char retMsg[20];

            sprintf(chrCommand,"stop wave%d wait", thisPtr);
            mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            
            sprintf(chrCommand,"close wave%d wait", thisPtr);
            mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);

            WinPostMsg(hwnd,WM_QUIT,0,0);
          }
        }/* if(thisPtr) */           
        return MRFALSE;
      }
    case MM_MCICUEPOINT:
      {
        CWAudio * thisPtr;
        unsigned char chrCommand[CCHMAXPATH*2];
        char retMsg[20];
        thisPtr=(CWAudio *)WinQueryWindowULong(hwnd, QWL_USER);

        if(somIsObj(thisPtr)) {
          sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
          do {
            APIRET rc;
            DosSleep(100);
            rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
              WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
              return MRFALSE;
            }
          }
          while(stricmp(retMsg, "playing"));
           
          WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
        }
        return MRFALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
   
}

/* This thread is only to handle the object in use emphasis */
void _Optlink playThreadFunc (void *arg)
{
  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  OPENPARAMS * params;
  CWAudio *thisPtr;
  //WPObject *thisPtr;

  params=(OPENPARAMS*)arg;
  if(!params)
    return;

  thisPtr=params->thisPtr; 
  if(!somIsObj(thisPtr))
    return;

  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab,0);
    if(hmq) {
      HWND hwnd;
      //      WPObjectData *somThis = WPObjectGetData(thisPtr);
      CWAudioData *somThis = CWAudioGetData(thisPtr);
      params->useItem.type=USAGE_OPENVIEW;
      params->viewItem.handle=NULLHANDLE;
      _wpAddToObjUseList(thisPtr, &params->useItem);

      hwnd=WinCreateWindow(HWND_OBJECT,WC_STATIC,"playObj", 0, 0, 0, 0, 0, 
                           NULLHANDLE, HWND_BOTTOM,12343,NULL,NULL);
      if(hwnd) {
        WinSubclassWindow(hwnd,&playObjectProc);
        /* Window created. */     
        WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_START), MPFROMP(thisPtr));
        _hwndObjectPlay=hwnd;
        while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
          WinDispatchMsg(hab,&qmsg);
        WinDestroyWindow(hwnd);
      }
      _wpDeleteFromObjUseList(thisPtr, &params->useItem);
      _hwndObjectPlay=NULLHANDLE;
      _wpSetDefaultView(thisPtr, _ulPreviousView);
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
  /* Free the parameters */
  _wpFreeMem(thisPtr, (PBYTE)params);
}

SOM_Scope void  SOMLINK cwaudio_cwmmPlayTrack(CWAudio *somSelf, 
                                              BOOL bPlay)
{
  ULONG ulError;
  OPENPARAMS *pThreadParams;

    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmPlayTrack");

    if(bPlay) {
      if(!WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay)) {
        /* Start playing */
        pThreadParams=(OPENPARAMS*)_wpAllocMem(somSelf, sizeof(OPENPARAMS), &ulError);
        
        if(pThreadParams) {
          memset((void*)pThreadParams ,0, sizeof(OPENPARAMS));
          pThreadParams->thisPtr=somSelf;
          pThreadParams->viewItem.view=ID_MENU_START;
          _beginthread(playThreadFunc,NULL,8192*16,(void*)pThreadParams); //Fehlerbehandlung fehlt
        }
      }
    }
    else
      if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
        WinPostMsg(_hwndObjectPlay, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(somSelf));
}


SOM_Scope BOOL  SOMLINK cwaudio_wpAddSettingsPages(CWAudio *somSelf, 
                                                   HWND hwndNotebook)
{
  BOOL rc;

  MMIOINFO mmio;
  ULONG ulSize;
  HMMIO hmmio;
  MMAUDIOHEADER mmAudioHeader={0};
  LONG lBytesRead=0;
  char fName[CCHMAXPATH];

  CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpAddSettingsPages");

    /* Reread the cached audio info because the cached value may be wrong for
       some reason. Doing it when opening the settings page does not
       slow down things too much and the user isn't surprised because it's
       normal that this needs some time. By doing it here it's semi automatic
       because once in atime every user will open the notebook. */
    do {
      memset(&mmio,0, sizeof(mmio));
      mmio.ulFlags=MMIO_READ;
      mmio.ulTranslate=MMIO_TRANSLATEHEADER;
      
      ulSize=sizeof(fName);
      _wpQueryRealName(somSelf, fName, &ulSize, TRUE);
      hmmio = mmioOpen(fName, &mmio, MMIO_READ);
      
      if(!hmmio)
        break;
  
      memset(&mmAudioHeader,0,sizeof(MMAUDIOHEADER));
      rc = mmioGetHeader(hmmio, &mmAudioHeader,sizeof(MMAUDIOHEADER),
                         &lBytesRead, 0, 0);
      
      if(rc!=MMIO_SUCCESS) {
        mmioClose(hmmio, 0);
        break;
      }
      mmioClose(hmmio, 0);
      
      _ulChannels=mmAudioHeader.mmXWAVHeader.WAVEHeader.usChannels;
      _ulSampleRate=mmAudioHeader.mmXWAVHeader.WAVEHeader.ulSamplesPerSec;
      _ulBPS=mmAudioHeader.mmXWAVHeader.WAVEHeader.usBitsPerSample;
      
      if(mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000)
        _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000;
      else
        _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
          mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec;
      
      _ulFileSize=_wpQueryFileSize(somSelf);
      
      sprintf(fName,"%d",_ulChannels);
      strncpy(_chrChannels, fName, sizeof(_chrChannels));
      _chrChannels[sizeof(_chrChannels)-1]=0;
      
      sprintf(fName,"%d", _ulSampleRate);
      strncpy(_chrSampleRate, fName, sizeof(_chrSampleRate));      
      _chrSampleRate[sizeof(_chrSampleRate)-1]=0;
      
      sprintf(fName,"%d",_ulBPS);
      strncpy(_chrBPS, fName, sizeof(_chrBPS));
      _chrBPS[sizeof(_chrBPS)-1]=0;
      
      sprintf(fName,"%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
      strncpy(_chrPlayTime, fName, sizeof(_chrPlayTime));
      _chrPlayTime[sizeof(_chrPlayTime)-1]=0;
      
      _wpSaveDeferred(somSelf);
    }while(FALSE);

    rc= (CWAudio_parent_WPDataFile_wpAddSettingsPages(somSelf, 
                                                      hwndNotebook));
    return rc|cwaudio_cwmmAddWaveInformationPage(somSelf, hwndNotebook);
}


SOM_Scope ULONG  SOMLINK cwaudio_wpQueryDetailsData(CWAudio *somSelf, 
                                                    PVOID* ppDetailsData, 
                                                    PULONG pcp)
{
  BOOL rcParent;
  PAUDIODETAILS pAudioDetails;
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpQueryDetailsData");


    rcParent= (CWAudio_parent_WPDataFile_wpQueryDetailsData(somSelf, 
                                                      ppDetailsData, 
                                                      pcp));

  /* The WPS asks for data to be displayed */
  if(ppDetailsData)
    {
#if 0
      char chrCommand[400];
      sprintf(chrCommand, "%s , ppDetailsData: %x  *ppDetailsData: %x &_chrPlayTime: %x",  _id3Artist, ppDetailsData,
              *ppDetailsData, &_chrPlayTime);
      WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, chrCommand, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
#endif
      /* Fill the structure with the info to be displayed */      
      pAudioDetails=(PAUDIODETAILS)*ppDetailsData;  
      pAudioDetails->pszPlayTime=_chrPlayTime;
      pAudioDetails->pszSampleRate=_chrSampleRate;
      pAudioDetails->pszChannels=_chrChannels;
      pAudioDetails->pszBPS=_chrBPS;

      pAudioDetails->pszName=_id3Name;
      pAudioDetails->pszArtist=_id3Artist;
      pAudioDetails->pszAlbum=_id3Album;
      pAudioDetails->pszYear=_id3Year;
      pAudioDetails->pszComment=_id3Comment;
      pAudioDetails->pszGenre=_id3Genre;
      *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pAudioDetails);  
    }
  else
    {
      /* Buffer size is queried */
      if(pcp)
        *pcp+=sizeof(*pAudioDetails);
    }
    return rcParent;
}

SOM_Scope BOOL  SOMLINK cwaudio_wpRestoreState(CWAudio *somSelf, 
                                               ULONG ulReserved)
{
  BOOL bRc; 
  char fName[CCHMAXPATH];
  BOOL bReRead=FALSE;
  ULONG ulSize;

   CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpRestoreState");

    bRc=(CWAudio_parent_WPDataFile_wpRestoreState(somSelf, ulReserved));

    _bNeedSaving=FALSE;

    /* Query the audio info */
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_FILESIZE, &_ulFileSize))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_TIME, &_ulPlaySecs))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_CHANNELS, &_ulChannels))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_SAMPLERATE, &_ulSampleRate))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_BPS, &_ulBPS))
      bReRead=TRUE;

    ulSize=sizeof(_id3Name);
    _wpRestoreString(somSelf, "CWAudio",KEY_TRACKNAME, _id3Name, &ulSize);
    ulSize=sizeof(_id3Artist);
    _wpRestoreString(somSelf, "CWAudio",KEY_ARTIST, _id3Artist, &ulSize);
    ulSize=sizeof(_id3Album);
    _wpRestoreString(somSelf, "CWAudio",KEY_ALBUM, _id3Album, &ulSize);
 
    if(_ulFileSize!=_wpQueryFileSize(somSelf))
      bReRead=TRUE; /* The filesize changed, somebody altered the audio file so reread the info */


    if(bGotCD && bReRead) {
      WPDisk *wpDisk;
      int iDiskNum;

      /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
         MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
         isn't necessary. When opening the settings notebook the info is reread anyway. */      
      if((wpDisk=_wpQueryDisk(somSelf))!=NULLHANDLE) {
        if((iDiskNum=_wpQueryLogicalDrive(wpDisk))!=0) {
          if((iDiskNum>=iFirstCD && iDiskNum<=iFirstCD+iNumCD)) {
            bReRead=FALSE;
          }
        }
      }
    }

    if(bReRead){
      ULONG rc;
      MMIOINFO mmio;
      ULONG ulSize;
      HMMIO hmmio;
      MMAUDIOHEADER mmAudioHeader={0};
      LONG lBytesRead=0;

      memset(&mmio,0, sizeof(mmio));
      mmio.ulFlags=MMIO_READ;
      mmio.ulTranslate=MMIO_TRANSLATEHEADER;
      
      ulSize=sizeof(fName);
      _wpQueryRealName(somSelf, fName, &ulSize, TRUE);
      hmmio = mmioOpen(fName, &mmio, MMIO_READ);

      if(!hmmio)
        return bRc;
      
      memset(&mmAudioHeader,0,sizeof(MMAUDIOHEADER));
      rc = mmioGetHeader(hmmio, &mmAudioHeader,sizeof(MMAUDIOHEADER),
                         &lBytesRead, 0, 0);

      if(rc!=MMIO_SUCCESS) {
        mmioClose(hmmio, 0);
        return bRc;
      }
      mmioClose(hmmio, 0);

      _ulChannels=mmAudioHeader.mmXWAVHeader.WAVEHeader.usChannels;
      _ulSampleRate=mmAudioHeader.mmXWAVHeader.WAVEHeader.ulSamplesPerSec;
      _ulBPS=mmAudioHeader.mmXWAVHeader.WAVEHeader.usBitsPerSample;
      /*      sprintf(fName,"%02d:%02d",mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
              mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec/60,
              mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
              mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec%60);*/
      if(mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000)
        _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000;
      else
        _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
          mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec;

      _ulFileSize=_wpQueryFileSize(somSelf);
      _bNeedSaving=TRUE;/* When the object is initialized the new instance data will be saved in wpObjectReady(). */
    }/* bReRead */

    sprintf(fName,"%d",_ulChannels);
    strncpy(_chrChannels, fName, sizeof(_chrChannels));
    _chrChannels[sizeof(_chrChannels)-1]=0;

    sprintf(fName,"%d", _ulSampleRate);
    strncpy(_chrSampleRate, fName, sizeof(_chrSampleRate));      
    _chrSampleRate[sizeof(_chrSampleRate)-1]=0;
    
    sprintf(fName,"%d",_ulBPS);
    strncpy(_chrBPS, fName, sizeof(_chrBPS));
    _chrBPS[sizeof(_chrBPS)-1]=0;
    
    sprintf(fName,"%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
    strncpy(_chrPlayTime, fName, sizeof(_chrPlayTime));
    _chrPlayTime[sizeof(_chrPlayTime)-1]=0;
    
    return bRc;
}

SOM_Scope BOOL  SOMLINK cwaudio_wpSaveState(CWAudio *somSelf)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpSaveState");

    _wpSaveLong(somSelf, "CWAudio",KEY_TIME,_ulPlaySecs);
    _wpSaveLong(somSelf, "CWAudio",KEY_SAMPLERATE,_ulSampleRate);
    _wpSaveLong(somSelf, "CWAudio",KEY_CHANNELS,_ulChannels);
    _wpSaveLong(somSelf, "CWAudio",KEY_BPS,_ulBPS);
    _wpSaveLong(somSelf, "CWAudio",KEY_FILESIZE,_ulFileSize);

    _wpSaveString(somSelf, "CWAudio",KEY_TRACKNAME, _id3Name);
    _wpSaveString(somSelf, "CWAudio",KEY_ARTIST, _id3Artist);
    _wpSaveString(somSelf, "CWAudio",KEY_ALBUM, _id3Album);

    return (CWAudio_parent_WPDataFile_wpSaveState(somSelf));
}

SOM_Scope BOOL  SOMLINK cwaudio_wpModifyPopupMenu(CWAudio *somSelf, 
                                                  HWND hwndMenu, 
                                                  HWND hwndCnr, 
                                                  ULONG iPosition)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpModifyPopupMenu");


    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_VOLUME, 1);
    _wpInsertPopupMenuItems(somSelf, hwndMenu, -1, queryModuleHandle(), ID_MENU_CONVERT, 0);
    if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
      _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_STOP, 1);
    else
      {
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_EDITOR, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_PLAYER, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_START, 1);
      }
    return (CWAudio_parent_WPDataFile_wpModifyPopupMenu(somSelf, 
                                                     hwndMenu, 
                                                     hwndCnr, 
                                                     iPosition));
}


SOM_Scope BOOL  SOMLINK cwaudio_wpMenuItemSelected(CWAudio *somSelf, 
                                                   HWND hwndFrame, 
                                                   ULONG ulMenuId)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpMenuItemSelected");

    switch(ulMenuId)
      {
      case ID_MENU_VOLUME:
        {
          HOBJECT hObject;
          if((hObject=WinQueryObject("<MMPM2_MMVOLUME>"))!=NULLHANDLE)
            WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
          return TRUE;
        }
      case ID_MENU_START:
      case ID_MENU_STOP:
      case ID_MENU_PLAYER:
      case ID_MENU_EDITOR:
      case ID_ITEM_CONVERT:
        _wpViewObject(somSelf, NULLHANDLE, ulMenuId,0);
        return TRUE;
      default:
        break;
      }
    return (CWAudio_parent_WPDataFile_wpMenuItemSelected(somSelf, 
                                                      hwndFrame, 
                                                      ulMenuId));
}


SOM_Scope void  SOMLINK cwaudio_wpObjectReady(CWAudio *somSelf, 
                                              ULONG ulCode, WPObject* refObject)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpObjectReady");

    if(_bNeedSaving)
      _wpSaveDeferred(somSelf);

    CWAudio_parent_WPDataFile_wpObjectReady(somSelf, ulCode, refObject);
}


SOM_Scope BOOL  SOMLINK cwaudio_wpRefresh(CWAudio *somSelf, ULONG ulView, 
                                          PVOID pReserved)
{
  BOOL bRc; 
  ULONG rc;
  MMIOINFO mmio;
  ULONG ulSize;
  HMMIO hmmio;
  MMAUDIOHEADER mmAudioHeader={0};
  LONG lBytesRead=0;
  char fName[CCHMAXPATH];

  CWAudioData *somThis = CWAudioGetData(somSelf);
  CWAudioMethodDebug("CWAudio","cwaudio_wpRefresh");

  bRc=(CWAudio_parent_WPDataFile_wpRefresh(somSelf, ulView, 
                                        pReserved));
  
  return bRc;
}


SOM_Scope BOOL  SOMLINK cwaudio_wpSetup(CWAudio *somSelf, PSZ pszSetupString)
{
  char buffer[CCHMAXPATH];
  ULONG bufferSize;

  /* CWAudioData *somThis = CWAudioGetData(somSelf); */
    CWAudioMethodDebug("CWAudio","cwaudio_wpSetup");

    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOTRACKNAME, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_NAME);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOARTIST, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ARTIST);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOALBUM, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ALBUM);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOPLAYTIME, buffer, &bufferSize))
      {
        int iPlaytime=atoi(buffer);
        if(iPlaytime<0)
          iPlaytime=0;
        _cwmmSetTrackInfo(somSelf, buffer, iPlaytime, IDINFO_PLAYTIME);
        // _wpCnrRefreshDetails(somSelf);
      }

    /* Refresh */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_REFRESH, buffer,&bufferSize))
      {
        _wpRefresh(somSelf, 0,NULL);
        _wpCnrRefreshDetails(somSelf);
      }
    
    return (CWAudio_parent_WPDataFile_wpSetup(somSelf, pszSetupString));
}

/* This thread is only to handle the object in use emphasis */
void _Optlink openThreadFunc (void *arg)
{
  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  OPENPARAMS * params;
  CWAudio *thisPtr;

  params=(OPENPARAMS*)arg;
  if(!params)
    return;

  thisPtr=params->thisPtr; 
  if(!somIsObj(thisPtr))
    return;

  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab,0);
    if(hmq) {
      RESULTCODES result;
      PID pid;

      params->useItem.type=USAGE_OPENVIEW;
      params->viewItem.handle=params->swCtrl.hwnd;
      _wpAddToObjUseList(thisPtr, &params->useItem);
      DosWaitChild(DCWA_PROCESS, DCWW_WAIT, &result, &pid, params->pid);
      _wpDeleteFromObjUseList(thisPtr, &params->useItem);
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
  /* Free the parameters */
  _wpFreeMem(thisPtr, (PBYTE)params);
}

ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  CWAudio *thisPtr, ULONG ulView)
{
  APIRET rc;
  PID pid;
  char chrLoadError[CCHMAXPATH]={0};
  RESULTCODES result;
  char *chrPtr;
  char args[CCHMAXPATH*2+3]={0};//"ab.exe\0\"M:\\Test-Audio-CD\\track Space.wav\"\0\0";

  strcpy(args,wrapperExe);
  if((chrPtr=strchr(args, 0))!=NULLHANDLE) {
    //  sprintf(args,"%s\0%s\0\0",wrapperExe, parameters);
    chrPtr++;
    strcat(chrPtr, parameters);
    // WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, args, chrPtr, 12324, MB_MOVEABLE);
    if(!DosExecPgm(chrLoadError, sizeof(chrLoadError), EXEC_ASYNCRESULT, args, NULL, &result, wrapperExe)) {
      HSWITCH hSwitch;
     
      if((hSwitch=WinQuerySwitchHandle(NULLHANDLE, result.codeTerminate))!=NULLHANDLE)
        {
          SWCNTRL swCtrl;

          if(!WinQuerySwitchEntry(hSwitch, &swCtrl)) {
            ULONG ulError;
            OPENPARAMS *pThreadParams=(OPENPARAMS*)_wpAllocMem(thisPtr,sizeof(OPENPARAMS), &ulError);
            
            if(pThreadParams) {
              memset((void*)pThreadParams ,0, sizeof(OPENPARAMS));
              pThreadParams->swCtrl=swCtrl;
              pThreadParams->pid=result.codeTerminate;
              pThreadParams->thisPtr=thisPtr;
              pThreadParams->viewItem.view=ulView;
              _beginthread(openThreadFunc,NULL,8192*16,(void*)pThreadParams); //Fehlerbehandlung fehlt
            }
            return 1;
          };
        };
      return 1;
    }
  }
  return 0;   
}

SOM_Scope HWND  SOMLINK cwaudio_wpOpen(CWAudio *somSelf, HWND hwndCnr, 
                                       ULONG ulView, ULONG param)
{
  ULONG ulRc;

    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpOpen");

    // sprintf(text, "Open: %d, %x", ulView, ulView);
    // WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, text, "", 12324, MB_MOVEABLE);
    switch(ulView)
      {
      case ID_MENU_START:
        {
          _ulPreviousView=_wpQueryDefaultView(somSelf);
          _cwmmPlayTrack(somSelf, TRUE);
          _wpSetDefaultView(somSelf, ID_MENU_STOP);
          return NULLHANDLE;
        }
      case ID_MENU_STOP:
        {
          _cwmmPlayTrack(somSelf, FALSE);
          _wpSetDefaultView(somSelf, _ulPreviousView);
          return NULLHANDLE;
        }
      case ID_MENU_PLAYER:
        /*case 0xbbe5:   Player */
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioplayer", "ab.exe", chrPlayer,sizeof(chrPlayer));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if((ulRc=launchPMProg("Spieler", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      case ID_MENU_EDITOR:
        /* case 0xbc0d:  Editor */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+10]="-e \"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioeditor", "ab.exe", chrPlayer,sizeof(chrPlayer));
          if((chrPtr=strchr(chrParams,0))!=NULLHANDLE) {
            ulSize=sizeof(chrParams)-2;
            _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
            strcat(chrPtr,"\"");
            if((ulRc=launchPMProg("Editor", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE)
              break;
            return NULLHANDLE;
          }
          break;
        }
      case 0xb4dd: /* Convert */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioconverter", "", chrPlayer,sizeof(chrPlayer));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if((ulRc=launchPMProg("Spieler", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      default:
        break;
      }
    return (CWAudio_parent_WPDataFile_wpOpen(somSelf, hwndCnr, ulView, 
                                          param));
}


SOM_Scope BOOL  SOMLINK cwaudioM_wpclsCreateDefaultTemplates(M_CWAudio *somSelf, 
                                                             WPObject* Folder)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsCreateDefaultTemplates");

    return TRUE;
}

SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryDetailsInfo(M_CWAudio *somSelf, 
                                                        PCLASSFIELDINFO* ppClassFieldInfo, 
                                                        PULONG pSize)
{
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;
  ULONG rc;


    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryDetailsInfo");

    cParentColumns= (M_CWAudio_parent_M_WPDataFile_wpclsQueryDetailsInfo(somSelf, 
                                                             ppClassFieldInfo, 
                                                             pSize));
  if(pSize)
    *pSize+=sizeof(AUDIODETAILS);

  if(ppClassFieldInfo)
    {
      if(*ppClassFieldInfo)
        {
          pCfi=*ppClassFieldInfo;
          for(i=0; i<cParentColumns;i++)
            pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);

          pCfi->pNextFieldInfo=cfiFieldInfo;
        }
      else
        *ppClassFieldInfo=cfiFieldInfo;
    }
    return (cParentColumns+NUM_AUDIO_FIELDS);
}

SOM_Scope PSZ  SOMLINK cwaudioM_wpclsQueryTitle(M_CWAudio *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_CWAUDIOTITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Digital audio");

    return chrTitle;
}

SOM_Scope void  SOMLINK cwaudioM_wpclsInitData(M_CWAudio *somSelf)
{
  PCLASSFIELDINFO pCfi;
  USHORT i,rc;

    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsInitData");

    M_CWAudio_parent_M_WPDataFile_wpclsInitData(somSelf);

    /* Register mmedia class REXX functions */
    RexxRegisterFunctionExe("MMClsCallFunc", (PFN)rxCallCWMMFunc);

    /* Get CD drives */
    if(cwQueryCDDrives(&iNumCD, &iFirstCD))
      bGotCD=TRUE;

    if(getMessage(chrPlayTime, IDSTR_PLAYTIME, sizeof(chrPlayTime),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[0]=chrPlayTime;
    if(getMessage(chrSampleRate, IDSTR_SAMPLERATE, sizeof(chrSampleRate),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[1]=chrSampleRate;
    if(getMessage(chrChannels, IDSTR_CHANNELS, sizeof(chrChannels),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[2]=chrChannels;
    if(getMessage(chrBPS, IDSTR_BPS, sizeof(chrBPS),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[3]=chrBPS;

    if(getMessage(chrName, IDSTR_TITLE, sizeof(chrName),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[4]=chrName;
    if(getMessage(chrArtist, IDSTR_ARTIST, sizeof(chrArtist),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[5]=chrArtist;
    if(getMessage(chrAlbum, IDSTR_ALBUM, sizeof(chrAlbum),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[6]=chrAlbum;
    if(getMessage(chrYear, IDSTR_YEAR, sizeof(chrYear),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[7]=chrYear;
    if(getMessage(chrComment, IDSTR_COMMENT, sizeof(chrComment),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[8]=chrComment;
    if(getMessage(chrGenre, IDSTR_GENRE, sizeof(chrGenre),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[9]=chrGenre;


  /* Setup the static data for the details view */
  for(i=0,pCfi=cfiFieldInfo;i<NUM_AUDIO_FIELDS;i++,pCfi++)
    {
      memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));

      pCfi->cb=sizeof(CLASSFIELDINFO);
      pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
      pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
      pCfi->pNextFieldInfo=pCfi+1;
      pCfi->pTitleData=(PVOID)pszAudioColTitles[i];
      pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;

      switch(i)
        {
        case 0: /* Subject */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszPlayTime));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 1: /* From */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszSampleRate));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 2:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszChannels));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 3: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszBPS));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;

        case 4: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszName));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 5: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszArtist));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 6: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszAlbum));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 7: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszYear));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 8: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszComment));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 9: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszGenre));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;

        }/* switch(i) */
    }/* for() */
  cfiFieldInfo[NUM_AUDIO_FIELDS].pNextFieldInfo=NULL;

}

SOM_Scope void  SOMLINK cwaudioM_wpclsUnInitData(M_CWAudio *somSelf)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsUnInitData");

    RexxDeregisterFunction("MMClsCallFunc");

    M_CWAudio_parent_M_WPDataFile_wpclsUnInitData(somSelf);
}


SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryDefaultView(M_CWAudio *somSelf)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryDefaultView");

    return ID_MENU_START;

    //    return (M_CWAudio_parent_M_MMAudio_wpclsQueryDefaultView(somSelf));
}


SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryIconData(M_CWAudio *somSelf, 
                                                     PICONINFO pIconInfo)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryIconData");

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = queryModuleHandle();
      pIconInfo->resid   = ID_ICONCWAUDIOFILE;
	} /* endif */

	return ( sizeof(ICONINFO) );

}

