
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwimage_Source
#define SOM_Module_cwimage_Source
#endif
#define CWImage_Class_Source
#define M_CWImage_Class_Source

#define INCL_DOS
#define INCL_GPI
#define INCL_PM
#define INCL_MMIOOS2
#include <os2.h>
#include <stdio.h>
#include "mmioos2.h"
#include "cwimage.ih"
#include "cwmmres.h"
#include "except.h"
#include "cwaudioinc.h"

//#define DEBUG

HAB globalHab=NULLHANDLE;
HWND hwndCreateBMP; /* Object window for small bitmap creation */
extern char classDLLPath[CCHMAXPATH];
extern char chrHelpLibrary[CCHMAXPATH];

LONG          lNumIOProcs;
ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView);

BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags);

void writeLog(char* chrFormat, ...);
HMODULE queryModuleHandle(void);
PSZ queryModuleName(void);

BOOL getBmpInfoHeader(PBITMAPINFOHEADER2  bmpih2, PSZ pszFileName, char* procName, ULONG ulLength, BOOL * bNoIOProcAvailable);
HBITMAP loadBitmap ( PSZ pszFileName, PBITMAPINFOHEADER2 pBMPInfoHeader2);
HBITMAP createNewBitmap ( HBITMAP hbm,
                          PBITMAPINFOHEADER2 pBmpInfoHeader2,
                          ULONG ulWidth, 
                          ULONG ulHeight, 
                          BOOL* pbQuitEarly);

ULONG showMsgBox2(ULONG ulIDTitle, ULONG ulIDText, HMODULE hModule, ULONG ulFlag);
ULONG showMsgBox(ULONG ulIDTitle, ULONG ulIDText, HMODULE hModule);
void HlpWriteToTrapLog(const char* chrFormat, ...);
BOOL cwObjectIsOnCD(WPObject * somSelf);

/* This Proc creates the small bitmaps for display on a separate thread. */
MRESULT EXPENTRY createBMPObjectProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        BOOL bLoaded=FALSE;
        HBITMAP hbm;
        PCREATEBMPINFO pCreateBMP=PVOIDFROMMP(mp1);
        CWImageData *somThis;
        WPObject *wpObject;
        PMINIRECORDCORE pmrcToRefresh;
        PUSEITEM pUse;

        if(!pCreateBMP)
          return (MRESULT) FALSE;
        if(!somIsObj(pCreateBMP->wpObject))
          return (MRESULT) FALSE;

        somThis  = CWImageGetData(pCreateBMP->wpObject);
        wpObject=pCreateBMP->wpObject;
        pmrcToRefresh=pCreateBMP->pmrcToRefresh;

        /* Check if in the meantime the bitmap was created */
        if(WinIsWindow(globalHab, pCreateBMP->hwndCnr) && 
           !_cwmmQuerySmallBitmapHandle(wpObject, 
                                        pCreateBMP->ulHeight, pCreateBMP->pmrcToRefresh, pCreateBMP->hwndCnr)) {
          /* Check if bitmap data already loaded. Keep the info so we don't discard the bitmap later on. Another
           function may have requested the bitmap before. */
          if(_hBitmap)
            bLoaded=TRUE;
          
          if(_wpQueryBitmapHandle(pCreateBMP->wpObject, 
                                  &hbm, 
                                  NULLHANDLE, 
                                  pCreateBMP->ulWidth, 
                                  pCreateBMP->ulHeight, 
                                  0, /* ulFlags*/ 
                                  0, 
                                  NULLHANDLE)) {
            _hBitmapSmall=hbm;
            _ulSizeSmallBitmap=pCreateBMP->ulHeight;
            if(!bLoaded) {
              /* The bitmap wasn't loaded so discard it now, we don't need it any more as we have
                 the small one. */
              GpiDeleteBitmap(_hBitmap);
              _hBitmap=NULLHANDLE;
            }
#if 0
            for(pUse=_wpFindUseItem(wpObject, USAGE_RECORD/*VIEW_CONTENTS|VIEW_DETAILS|VIEW_TREE*/, NULL );pUse;
                pUse=_wpFindUseItem(wpObject, USAGE_RECORD/* VIEW_CONTENTS|VIEW_DETAILS|VIEW_TREE*/, pUse ))
              {
                PRECORDITEM pRecordItem=(PRECORDITEM)++pUse;
                WinPostMsg(pRecordItem->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pRecordItem->pRecord),
                           MPFROM2SHORT(1,CMA_NOREPOSITION));
              }/* for() */
            /* Make sure shadows are refreshed too */
            if(somIsObj(wpObjToRefresh)) {
              DosBeep(5000, 100);
              for(pUse=_wpFindUseItem(wpObjToRefresh, USAGE_RECORD/*VIEW_CONTENTS|VIEW_DETAILS|VIEW_TREE*/, NULL );pUse;
                  pUse=_wpFindUseItem(wpObjToRefresh, USAGE_RECORD/* VIEW_CONTENTS|VIEW_DETAILS|VIEW_TREE*/, pUse ))
                {
                  PRECORDITEM pRecordItem=(PRECORDITEM)++pUse;
                  WinPostMsg(pRecordItem->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pRecordItem->pRecord),
                             MPFROM2SHORT(1,CMA_NOREPOSITION));
                }/* for() */
            }
#endif
            //      writeLog("objectProc: mrc: 0x%x, hwndCnr: 0x%x\n", pmrcToRefresh, pCreateBMP->hwndCnr);
            WinSendMsg(pCreateBMP->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pmrcToRefresh),MPFROM2SHORT(1,CMA_NOREPOSITION));
          }
        }
        //        WinSendMsg(pCreateBMP->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pmrcToRefresh),MPFROM2SHORT(1,CMA_NOREPOSITION));
        _wpFreeMem(wpObject, (PBYTE)pCreateBMP);
      return (MRESULT) FALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

void _Optlink createBMPThreadFunc (void *arg)
{

  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  
  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab,0);
    if(hmq) {
      hwndCreateBMP=WinCreateWindow(HWND_OBJECT,WC_STATIC,"coverObj",0,0,0,0,0,NULLHANDLE,HWND_BOTTOM,13343,NULL,NULL);
      if(hwndCreateBMP) {
        WinSubclassWindow(hwndCreateBMP,&createBMPObjectProc);
        /* Window created. */
        while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
          WinDispatchMsg(hab,&qmsg);
        WinDestroyWindow(hwndCreateBMP);
      }
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
}


MRESULT EXPENTRY imageInfoDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWImage *cwImage;

  switch(msg) {
  case WM_INITDLG :
    cwImage=(CWImage*)LONGFROMMP(mp2);
    if(somIsObj(cwImage)) {
      CWImageData *somThis = CWImageGetData(cwImage);

      PBITMAPINFOHEADER2 pbmpih2;

      if((pbmpih2=(PBITMAPINFOHEADER2)_wpQueryBitmapInfoHeader(cwImage))!=NULLHANDLE)
        {
          char fName[CCHMAXPATH];
          char chrTemplate[100];

          if(pbmpih2->cbFix==sizeof(BITMAPINFOHEADER2)) {
            getMessage(chrTemplate, IDSTR_SPRINTFPIXEL, sizeof(chrTemplate), 
                       queryModuleHandle(), hwnd);;
            sprintf(fName, chrTemplate,pbmpih2->cx);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEWIDTH),fName);
            
            sprintf(fName, chrTemplate, pbmpih2->cy);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEHEIGHT),fName);

            getMessage(chrTemplate, IDSTR_SPRINTFBIT, sizeof(chrTemplate), 
                       queryModuleHandle(), hwnd);;            
            sprintf(fName, chrTemplate, pbmpih2->cBitCount);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_COLORDEPTH),fName);
          }
          else if(pbmpih2->cbFix==sizeof(BITMAPINFOHEADER)) {
            /* We shouldn't get a BITMAPINFOHEADER here but who knows...*/
            PBITMAPINFOHEADER pbmpih=(PBITMAPINFOHEADER)pbmpih2;
            getMessage(chrTemplate, IDSTR_SPRINTFPIXEL, sizeof(chrTemplate), 
                       queryModuleHandle(), hwnd);;

            sprintf(fName, chrTemplate,pbmpih->cx);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEWIDTH),fName);
            
            sprintf(fName, chrTemplate, pbmpih->cy);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEHEIGHT),fName);

            getMessage(chrTemplate, IDSTR_SPRINTFBIT, sizeof(chrTemplate), 
                       queryModuleHandle(), hwnd);;                        
            sprintf(fName, chrTemplate, pbmpih->cBitCount);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_COLORDEPTH),fName);
          }
          
          WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEFORMAT),_chrIOProcName);
        }
    }/* somIsObj() */
    return (MRESULT)TRUE;
    /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


SOM_Scope ULONG  SOMLINK cwimg_cwmmAddImageInformationPage(CWImage *somSelf, 
                                                           HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_cwmmAddImageInformationPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = imageInfoDlgProc;
  //The resource DLL
  pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_IMAGEINFOPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = IDDLG_GENERAL2PAGE;

  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = NULLHANDLE;
  //We have a major tab so we need a name
  /* pageName: "ISO filesystem" */
  getMessage(pageName, IDSTR_IMAGEINFOPAGENAME, sizeof(pageName),  queryModuleHandle(), hwndNotebook);
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook
  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);

}


/*
 * The prototype for cwimg_cwmmQuerySmallBitmapHandle was replaced by the following prototype:
 */
SOM_Scope HBITMAP  SOMLINK cwimg_cwmmQuerySmallBitmapHandle(CWImage *somSelf, 
                                                            ULONG ulSize, 
                                                            PMINIRECORDCORE pmrcToRefresh, 
                                                            HWND hwndCnr)
{
  HBITMAP hbm;

    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_cwmmQuerySmallBitmap");

    if(_bNoIOProcAvailable)
      return NULLHANDLE; /* No IO-proc for this image format. Don't try again in the future. */

    if(ulSize<MAX_SIZE_SMALLBITMAP)
      ulSize=MAX_SIZE_SMALLBITMAP;

    if(ulSize>_ulSizeSmallBitmap)
      {
        if(_hBitmapSmall) {
          GpiDeleteBitmap(_hBitmapSmall);
          _hBitmapSmall=NULLHANDLE;
        }
      }

    if(!_hBitmapSmall) {
      BOOL bLoaded=FALSE;
      PBYTE memPtr;
      ULONG ulError;
      PCREATEBMPINFO pCreateBMP;
      _ulSizeSmallBitmap=0;


      /* Allocate memory for small bitmap info for the thread */
      if((pCreateBMP=(PCREATEBMPINFO)_wpAllocMem(somSelf, sizeof(CREATEBMPINFO),&ulError))==NULLHANDLE)
        return NULLHANDLE;

      pCreateBMP->ulWidth=ulSize;
      pCreateBMP->ulHeight=ulSize;
      pCreateBMP->wpObject=somSelf;
      pCreateBMP->pmrcToRefresh=pmrcToRefresh;
      pCreateBMP->hwndCnr=hwndCnr;

      WinPostMsg(hwndCreateBMP, WM_APPTERMINATENOTIFY,MPFROMP(pCreateBMP),0L);
      return NULLHANDLE;
    }
    /* Return statement to be customized: */
    return _hBitmapSmall;
}

SOM_Scope void  SOMLINK cwimg_cwmmFreeBitmaps(CWImage *somSelf)
{
    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_cwmmFreeBitmaps");

    if(_hBitmap) {
      GpiDeleteBitmap(_hBitmap);
      _hBitmap=NULLHANDLE;
    }

    _cwmmFreeSmallBitmap(somSelf);
}

SOM_Scope void  SOMLINK cwimg_cwmmFreeSmallBitmap(CWImage *somSelf)
{
    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_cwmmFreeSmallBitmap");

    if(_hBitmapSmall) {
      GpiDeleteBitmap(_hBitmapSmall);
      _hBitmapSmall=NULLHANDLE;
      _ulSizeSmallBitmap=0;
    }
}

SOM_Scope BOOL  SOMLINK cwimg_wpQueryBitmapHandle(CWImage *somSelf, 
                                                  HBITMAP* phBitmap, 
                                                  HPAL* phPalette, 
                                                  ULONG ulWidth, 
                                                  ULONG ulHeight, 
                                                  ULONG ulFlags, 
                                                  long lBackgroundColor, 
                                                  BOOL* pbQuitEarly)
{
  ULONG ulSize;
  char chrName[CCHMAXPATH];
  //  char text[200];

    CWImageData *somThis = CWImageGetData(somSelf); 
    CWImageMethodDebug("CWImage","cwimg_wpQueryBitmapHandle");

#ifdef DEBUG
    ulSize=sizeof(chrName);
    if(_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      writeLog("In _wpQueryBitmapHandle() for %s\n", chrName);
    else
      writeLog("\nIn _wpQueryBitmapHandle(), filename unknown\n");
#endif

    if(!phBitmap)
      return FALSE;

    if(!_wpReadImageFile(somSelf))
      return FALSE;

#if 0
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Nach ",
                  "cwimg_wpQueryBitmapHandle",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );
#endif

    *phBitmap=NULLHANDLE;
    if(phPalette)
      *phPalette=NULLHANDLE;

    ulSize=sizeof(chrName);
    if(!_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      return FALSE;

#ifdef DEBUG
    writeLog("_wpQueryBitmapHandle(), reading data from file: %s\n",
             chrName);
#endif
    
    TRY_LOUD(QRY_HBM) {
      *phBitmap=createNewBitmap ( _hBitmap, (PBITMAPINFOHEADER2) _pBmpInfoHeader2, 
                                  ulWidth, ulHeight , pbQuitEarly);
    }
    CATCH(QRY_HBM)
      {
        *phBitmap=NULLHANDLE;

        HlpWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while calling createNewBitmap().\n",
                          __FUNCTION__, __FILE__, __LINE__);
        HlpWriteToTrapLog("Image file: %s\n\n",
                          chrName);
      } END_CATCH;
      
      if(!*phBitmap)
        return FALSE;

    return TRUE;
}

SOM_Scope PBYTE  SOMLINK cwimg_wpQueryBitmapInfoHeader(CWImage *somSelf)
{
  ULONG ulSize;
  char chrName[CCHMAXPATH];
  PBYTE pByte;
  BOOL bGotHeader=FALSE;

  CWImageData *somThis = CWImageGetData(somSelf); 
    CWImageMethodDebug("CWImage","cwimg_wpQueryBitmapInfoHeader");


#ifdef DEBUG
    ulSize=sizeof(chrName);
    if(_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      HlpWriteToTrapLog("In _wpQueryBitmapInfoHeader() for %s\n", chrName);
    else
      HlpWriteToTrapLog("In _wpQueryBitmapInfoHeader(), filename unknown\n");
#endif

    if(_pBmpInfoHeader2)
      return _pBmpInfoHeader2;

    if(_bNoIOProcAvailable)
      return NULL; /* No IO-proc for this image format. Don't try again in the future. */

    ulSize=sizeof(chrName);
    if(!_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      return NULL;

#ifdef DEBUG
    HlpWriteToTrapLog("_wpQueryBitmapInfoHeader(), reading header from file: %s\n",
             chrName);
#endif

    if((pByte=_wpAllocMem(somSelf, sizeof(BITMAPINFOHEADER2)+256*sizeof(RGB2), &ulSize))==NULLHANDLE)
      return NULL;
#ifdef DEBUG
    HlpWriteToTrapLog("Got memory...\n");
#endif

    TRY_LOUD(GET_BMPIH) {

      bGotHeader=getBmpInfoHeader( (PBITMAPINFOHEADER2) pByte, chrName, _chrIOProcName, 
                                   sizeof(_chrIOProcName), &_bNoIOProcAvailable);

    }
    CATCH(GET_BMPIH)
      {
#if 0
        if(MBID_OK==showMsgBox2(IDSTR_CWIMAGETITLE, IDSTR_IMGIOPROCCRASH, queryModuleHandle(),
                                    MB_OK | MB_MOVEABLE | MB_WARNING))
          exit(0);
        exit(0);
#endif
#if 0
        if(MBID_YES==showMsgBoxFlag(IDSTR_CWIMAGETITLE, IDSTR_IMGIOPROCCRASH, queryModuleHandle(),
                             MB_YESNO | MB_MOVEABLE | MB_WARNING))
          exit(0);
#endif
        HlpWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while calling getBmpInfoHeader().\n",
                          __FUNCTION__, __FILE__, __LINE__);
        HlpWriteToTrapLog("Image file: %s\n\n",
                          chrName);

      } END_CATCH;

#ifdef DEBUG
      if(bGotHeader)
        HlpWriteToTrapLog("Got header...\n");
      else
        HlpWriteToTrapLog("Error with header...\n");
#endif

    if(!bGotHeader) {
      _wpFreeMem(somSelf,pByte);
      _pBmpInfoHeader2=NULLHANDLE;
      _chrIOProcName[0]=0;
      return NULL;
    }
    _pBmpInfoHeader2=pByte;
    return (PBYTE) _pBmpInfoHeader2;
#if 0
          sprintf(chrName,"%d", ((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cBitCount);
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,chrName,"",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );
#endif

}

SOM_Scope PBYTE  SOMLINK cwimg_wpQueryBitmapData(CWImage *somSelf, 
                                                 ULONG* pulSize)
{
    /* CWImageData *somThis = CWImageGetData(somSelf); */
    CWImageMethodDebug("CWImage","cwimg_wpQueryBitmapData");
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                  "This function is not available. Please tell the author the steps causing this message box so the function may be implemented.",
                  "cwimg_wpQueryBitmapData",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );

    return (CWImage_parent_WPImageFile_wpQueryBitmapData(somSelf, 
                                                         pulSize));
}

SOM_Scope BOOL  SOMLINK cwimg_wpSetBitmapData(CWImage *somSelf, 
                                              PBYTE pBitmapData, 
                                              ULONG ulSize)
{
    /* CWImageData *somThis = CWImageGetData(somSelf); */
    CWImageMethodDebug("CWImage","cwimg_wpSetBitmapData");
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                  "This function is not available. Please tell the author the steps causing this message box so the function may be implemented.",
                  "cwimg_wpSetBitmapData",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );

    return (CWImage_parent_WPImageFile_wpSetBitmapData(somSelf, 
                                                       pBitmapData, 
                                                       ulSize));
}

SOM_Scope BOOL  SOMLINK cwimg_wpReadImageFile(CWImage *somSelf)
{
  char chrName[CCHMAXPATH];
  ULONG ulSize;
  PBYTE pByte;
  BOOL bGotHeader=FALSE;

  CWImageData *somThis = CWImageGetData(somSelf); 
    CWImageMethodDebug("CWImage","cwimg_wpReadImageFile");

#ifdef DEBUG
    HlpWriteToTrapLog("In _wpReadImageFile()\n");
#endif

    if(_hBitmap)
      return TRUE;

    ulSize=sizeof(chrName);
    if(!_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      return FALSE;

#ifdef DEBUG
    HlpWriteToTrapLog("In _wpReadImageFile(), file: %s \n",
             chrName);
#endif

    TRY_LOUD(LOAD_BMP) {
      if(_wpQueryBitmapInfoHeader(somSelf))
        bGotHeader=TRUE;
    }
    CATCH(LOAD_BMP)
      {
#if 0
        if(MBID_OK==showMsgBox2(IDSTR_CWIMAGETITLE, IDSTR_IMGIOPROCCRASH, queryModuleHandle(),
                                   MB_OK | MB_MOVEABLE | MB_WARNING))
          exit(0);
        exit(0);
#endif
        HlpWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while calling _wpQueryBitmapInfoHeader().\n",
                          __FUNCTION__, __FILE__, __LINE__);
        HlpWriteToTrapLog("Image file: %s\n",
                          chrName);
      }END_CATCH;
      
      if(!bGotHeader)
        return FALSE;
      _hBitmap=NULLHANDLE;

      TRY_LOUD(LOAD_BMP2) {
        _hBitmap=loadBitmap ( chrName , (PBITMAPINFOHEADER2) _pBmpInfoHeader2);
      }
      CATCH(LOAD_BMP2)
        {
          HlpWriteToTrapLog("\nTrap occured in %s (LOAD_BMP2), file %s, around line %d while calling _wpQueryBitmapInfoHeader().\n",
                            __FUNCTION__, __FILE__, __LINE__);
#if 0
          if(MBID_OK==showMsgBox2(IDSTR_CWIMAGETITLE, IDSTR_IMGIOPROCCRASH, queryModuleHandle(),
                                     MB_OK | MB_MOVEABLE | MB_WARNING))
            exit(0);
          exit(0);
#endif
        } END_CATCH;
        
        if(!_hBitmap) {
          return FALSE;
        }
        
        return TRUE;
}

SOM_Scope BOOL  SOMLINK cwimg_wpWriteImageFile(CWImage *somSelf)
{
    /* CWImageData *somThis = CWImageGetData(somSelf); */
    CWImageMethodDebug("CWImage","cwimg_wpWriteImageFile");
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                  "This function is not available. Please tell the author the steps causing this message box so the function may be implemented.",
                  "cwimg_wpWriteImageFile",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );
    
    return (CWImage_parent_WPImageFile_wpWriteImageFile(somSelf));
}

/*
 * wpInitData:   override; Not used. Default is instance var initializing to zero and that's what we need.
 */

SOM_Scope void  SOMLINK cwimg_wpUnInitData(CWImage *somSelf)
{
    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_wpUnInitData");

    if(_pBmpInfoHeader2) {
      _wpFreeMem(somSelf, _pBmpInfoHeader2);
      _pBmpInfoHeader2=NULLHANDLE;
    }
    /* This frees all bitmaps. Small for icons and the normal size one */
    _cwmmFreeBitmaps(somSelf);
    CWImage_parent_WPImageFile_wpUnInitData(somSelf);
}


BOOL insertIOProcMenuItems( HWND hwndMenu )
{
    CHAR          szBuffer[ sizeof( FOURCC ) + CCHMAXPATH + 4 ];
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    void * memPtr;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;
    LONG          lBytesRead;
    HWND hwndSubMenu;
    MENUITEM mi;

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_IMAGE;
    
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         * Error - mmioQueryFormatCount failed.
         */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    memPtr=pmmFormatInfoArray;
    if( pmmFormatInfoArray == NULL )
      {
        /*
         * Could not allocate enough memory for mmFormatInfo array.
         */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }

    // Create Empty Submenu //
    hwndSubMenu=WinCreateWindow(hwndMenu,WC_MENU,"",0,
                                0,0,0,0,
                                hwndMenu,//Owner. If set, this window 
                                //is destroyed if owner is destroyed
                                HWND_TOP,
                                ID_MENU_CONVERT,//menuid
                                NULL,NULL);

    mi.iPosition=MIT_END;
    mi.afStyle=MIS_TEXT;//|MIS_SUBMENU;
    mi.id=ID_MENU_CONVERT;
    mi.afAttribute=NULLHANDLE;    
    mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
    mi.hItem=NULLHANDLE;
    mi.hwndSubMenu=hwndSubMenu;

    if(!getMessage(szBuffer, IDSTR_MENU_CONVERT, sizeof(szBuffer), queryModuleHandle(), HWND_DESKTOP))
       sprintf(szBuffer,"~Convert to");
    WinSendMsg(hwndMenu,MM_INSERTITEM,(MPARAM)&mi,
               (MPARAM)szBuffer);

    for ( index = 0; index <lNumIOProcs; index++ )
      {

        mmioGetFormatName(pmmFormatInfoArray, szBuffer, &lBytesRead, 0L, 0L);
        //        FourccToString ( pmmFormatInfoArray->fccIOProc,
        //               pszFourccString );
        
        /* Insert NULL string terminator */
        *( szBuffer + lBytesRead ) = (CHAR)NULL;

        /* Compressed TIF is not supported because the Warp 4 IO-Procs are
           broken. */
        if(pmmFormatInfoArray->fccIOProc!=mmioStringToFOURCC("TFMC",MMIO_TOUPPER) &&
           pmmFormatInfoArray->fccIOProc!=mmioStringToFOURCC("TFIC",MMIO_TOUPPER))
          {
            /* Add menu item */
            /* Fill the MENUITEM structure */
            mi.iPosition=MIT_END;
            mi.afStyle=MIS_TEXT|MIS_SUBMENU;
            mi.id=ID_ITEM_FIRSTCONVERT+index;
            mi.afAttribute=NULLHANDLE;    
            mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
            mi.hItem=NULLHANDLE;
            WinSendMsg(hwndSubMenu, MM_INSERTITEM,(MPARAM)&mi,
                       (MPARAM)szBuffer);
          }
        /*
         *  advance to next entry in mmFormatInfo array
         */        
        pmmFormatInfoArray++;
      }
    free(memPtr);
    return TRUE;
}

SOM_Scope BOOL  SOMLINK cwimg_wpModifyPopupMenu(CWImage *somSelf, 
                                                HWND hwndMenu, 
                                                HWND hwndCnr, 
                                                ULONG iPosition)
{
  /*    CWImageData *somThis = CWImageGetData(somSelf);*/
    CWImageMethodDebug("CWImage","cwimg_wpModifyPopupMenu");

    //_wpInsertPopupMenuItems(somSelf, hwndMenu, -1, queryModuleHandle(), ID_MENU_CONVERT, 0);
    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_IMGEDITOR, 1);
    /* Insert all known image I/O procs */
    TRY_LOUD(IMAGE_INSERTPOPUPMENU) {
      insertIOProcMenuItems( hwndMenu );
    }/* TRY_LOUD */
    CATCH(IMAGE_INSERTPOPUPMENU)
      {
        HlpWriteToTrapLog("\nTrap occured in %s, file %s, around line %d.\n",
                          __FUNCTION__, __FILE__, __LINE__);
      } END_CATCH;

    return (CWImage_parent_WPImageFile_wpModifyPopupMenu(somSelf, 
                                                         hwndMenu, 
                                                         hwndCnr, 
                                                         iPosition));
}

SOM_Scope BOOL  SOMLINK cwimg_wpMenuItemSelected(CWImage *somSelf, 
                                                 HWND hwndFrame, 
                                                 ULONG ulMenuId)
{
    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_wpMenuItemSelected");

    if(ulMenuId>=ID_ITEM_FIRSTCONVERT && ulMenuId<=ID_ITEM_FIRSTCONVERT+lNumIOProcs-1)
      {
        char chrEditor[CCHMAXPATH]={0};
        char chrParams[CCHMAXPATH+3+10]="\"";
        char *chrPtr=chrParams;
        char chrID[10];
        ULONG ulSize;
        ULONG ulRc;

        char text[100];
        
        PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "imageconverter", "", chrEditor,
                              sizeof(chrEditor));
        chrPtr++;
        ulSize=sizeof(chrParams)-2-10;
        _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
        strcat(chrPtr,"\" ");
        sprintf(chrID,"%d", ulMenuId-ID_ITEM_FIRSTCONVERT);
        strcat(chrPtr,chrID);
        if((ulRc=launchPMProg("", chrEditor, chrParams, somSelf, ulMenuId-ID_ITEM_FIRSTCONVERT))==NULLHANDLE) {
          /* Error */
          return TRUE;
        }
#if 0
          sprintf(text, "%d", ulMenuId-ID_ITEM_FIRSTCONVERT);        
          WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                        text,
                        "cwimg_wpMenuItemSelected",
                        0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );
#endif
        return TRUE;
      }
    switch(ulMenuId)
      {
      case ID_MENU_IMGEDITOR:
        _wpViewObject(somSelf, NULLHANDLE, ulMenuId, 0);
        return TRUE;
      default:
        break;
      }

    return (CWImage_parent_WPImageFile_wpMenuItemSelected(somSelf, 
                                                          hwndFrame, 
                                                          ulMenuId));
}

typedef struct _OPENPARAMS
{
  WPObject* thisPtr;
  PID pid;
  SWCNTRL swCtrl;
  USEITEM useItem;
  VIEWITEM viewItem;
}OPENPARAMS;

/* This thread is only to handle the object in use emphasis */
void _Optlink openThreadFunc (void *arg)
{
  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  OPENPARAMS * params;
  WPObject *thisPtr;

  params=(OPENPARAMS*)arg;
  if(!params)
    return;

  thisPtr=params->thisPtr; 
  if(!somIsObj(thisPtr))
    return;

  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab,0);
    if(hmq) {
      RESULTCODES result;
      PID pid;

      params->useItem.type=USAGE_OPENVIEW;
      params->viewItem.handle=params->swCtrl.hwnd;
      if(somIsObj(thisPtr))
        _wpAddToObjUseList(thisPtr, &params->useItem);
      DosWaitChild(DCWA_PROCESS, DCWW_WAIT, &result, &pid, params->pid);
      if(somIsObj(thisPtr))
        _wpDeleteFromObjUseList(thisPtr, &params->useItem);
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
  /* Free the parameters */
  _wpFreeMem(thisPtr, (PBYTE)params);
}

ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView)
{
  APIRET rc;
  PID pid;
  char chrLoadError[CCHMAXPATH]={0};
  RESULTCODES result;
  char *chrPtr;
  char args[CCHMAXPATH*2+3]={0};//"ab.exe\0\"M:\\Test-Audio-CD\\track Space.wav\"\0\0";

  strcpy(args,wrapperExe);
  if((chrPtr=strchr(args, 0))!=NULLHANDLE) {
    //  sprintf(args,"%s\0%s\0\0",wrapperExe, parameters);
    chrPtr++;
    strcat(chrPtr, parameters);
    // WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, args, chrPtr, 12324, MB_MOVEABLE);
    if(!DosExecPgm(chrLoadError, sizeof(chrLoadError), EXEC_ASYNCRESULT, args, NULL, &result, wrapperExe)) {
      HSWITCH hSwitch;
     
      if((hSwitch=WinQuerySwitchHandle(NULLHANDLE, result.codeTerminate))!=NULLHANDLE)
        {
          SWCNTRL swCtrl;

          if(!WinQuerySwitchEntry(hSwitch, &swCtrl)) {
            ULONG ulError;
            OPENPARAMS *pThreadParams=(OPENPARAMS*)_wpAllocMem(thisPtr,sizeof(OPENPARAMS), &ulError);
            
            if(pThreadParams) {
              memset((void*)pThreadParams ,0, sizeof(OPENPARAMS));
              pThreadParams->swCtrl=swCtrl;
              pThreadParams->pid=result.codeTerminate;
              pThreadParams->thisPtr=thisPtr;
              pThreadParams->viewItem.view=ulView;
              _beginthread(openThreadFunc,NULL,8192*16,(void*)pThreadParams); //Fehlerbehandlung fehlt
            }
            return 1;
          };
        };
      return 1;
    }
  }
  return 0;   
}

SOM_Scope HWND  SOMLINK cwimg_wpOpen(CWImage *somSelf, HWND hwndCnr, 
                                     ULONG ulView, ULONG param)
{
  /*    CWImageData *somThis = CWImageGetData(somSelf); */
    CWImageMethodDebug("CWImage","cwimg_wpOpen");

   switch(ulView)
     {
     case ID_MENU_IMGEDITOR:
        /*case 0xbc2b:   editor */
        {
          char chrEditor[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char *chrPtr=chrParams;
          ULONG ulSize;
          ULONG ulRc;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "imageeditor", "ib.exe", chrEditor,
                                sizeof(chrEditor));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if((ulRc=launchPMProg("Editor", chrEditor, chrParams, somSelf, ulView))==NULLHANDLE) {
            return NULLHANDLE;
            break;
          }
          return NULLHANDLE;
        }
     default:
       break;
     }

    return (CWImage_parent_WPImageFile_wpOpen(somSelf, hwndCnr, 
                                              ulView, param));
}


SOM_Scope BOOL  SOMLINK cwimg_wpAddSettingsPages(CWImage *somSelf, 
                                                 HWND hwndNotebook)
{
  BOOL rc;
    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_wpAddSettingsPages");

    rc=(CWImage_parent_WPImageFile_wpAddSettingsPages(somSelf, 
                                                          hwndNotebook));
    return rc | (_cwmmAddImageInformationPage(somSelf, hwndNotebook));
}


SOM_Scope ULONG  SOMLINK cwimg_wpQueryDetailsData(CWImage *somSelf, 
                                                  PVOID* ppDetailsData, 
                                                  PULONG pcp)
{
    BOOL rcParent;
    PIMAGEDETAILS pImageDetails;

    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_wpQueryDetailsData");

    rcParent=(CWImage_parent_WPImageFile_wpQueryDetailsData(somSelf, 
                                                          ppDetailsData, 
                                                          pcp));

    /* The WPS asks for data to be displayed */
    if(ppDetailsData)
      {
        ULONG ulWidth, ulHeight, ulDepth;

        PBITMAPINFOHEADER2 pBmpInfoHeader2=NULLHANDLE;       

        if(_bUseNewClsFeatures) /* Read info from CD only if allowed */
          pBmpInfoHeader2=(PBITMAPINFOHEADER2) _wpQueryBitmapInfoHeader(somSelf);

        if(pBmpInfoHeader2) {
          if(pBmpInfoHeader2->cbFix==sizeof(BITMAPINFOHEADER2)) {
            ulWidth=pBmpInfoHeader2->cx;
            ulHeight=pBmpInfoHeader2->cy;
            ulDepth=pBmpInfoHeader2->cBitCount;
          }
          else {
            PBITMAPINFOHEADER pBmpInfoHeader=(PBITMAPINFOHEADER)pBmpInfoHeader2;
            ulWidth=pBmpInfoHeader->cx;
            ulHeight=pBmpInfoHeader->cy;
            ulDepth=pBmpInfoHeader->cBitCount;
          }
        }

        /* Fill the structure with the info to be displayed */      
        pImageDetails=(PIMAGEDETAILS)*ppDetailsData;  
        pImageDetails->ulWidth=ulWidth;
        pImageDetails->ulHeight=ulHeight;
        pImageDetails->ulDepth=ulDepth;
        pImageDetails->pszFormat=_chrIOProcName;
        
        *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pImageDetails);          
      }
    else
      {
        /* Buffer size is queried */
        if(pcp)
          *pcp+=sizeof(*pImageDetails);
      }
    return rcParent;
}


SOM_Scope BOOL  SOMLINK cwimg_wpRestoreState(CWImage *somSelf, 
                                             ULONG ulReserved)
{
    CWImageData *somThis = CWImageGetData(somSelf);
    CWImageMethodDebug("CWImage","cwimg_wpRestoreState");

    _bUseNewClsFeatures=TRUE;
    
    if(cwObjectIsOnCD(somSelf)) {
#ifdef DEBUG
      char chrName[CCHMAXPATH];
      ULONG ulSize;
      
      ulSize=sizeof(chrName);
      if(_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
        HlpWriteToTrapLog("Object %s is on CD\n", chrName);
      HlpWriteToTrapLog("----------- Object is on CD\n");
#endif

      /* The object is on CD. Check if we should use the new class features */
      if(!PrfQueryProfileInt(HINI_USERPROFILE, "CWMM", IMAGECLS_FEATURES_ON_CD_KEY, 0))
        _bUseNewClsFeatures=FALSE;
    }
    
    return (CWImage_parent_WPImageFile_wpRestoreState(somSelf, 
                                                      ulReserved));
}


/*
 *    wpclsQueryStyle: override;
 */

SOM_Scope void  SOMLINK cwimgM_wpclsInitData(M_CWImage *somSelf)
{
  PCLASSFIELDINFO pCfi;
  USHORT i;

    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_CWImageMethodDebug("M_CWImage","cwimgM_wpclsInitData");

    M_CWImage_parent_M_WPImageFile_wpclsInitData(somSelf);

    globalHab=WinQueryAnchorBlock(HWND_DESKTOP);

    if(!getMessage(chrHelpLibrary, IDSTR_HELPLIBRARY, sizeof(chrHelpLibrary), 
                   queryModuleHandle(), HWND_DESKTOP))
      strcpy(chrHelpLibrary,"MMPARTS.HLP");

    /* Load strings for details titles */
    if(getMessage(chrWidth, IDSTR_IMAGEDETAIL_WIDTH, sizeof(chrWidth), queryModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[0]=chrWidth;
    if(getMessage(chrHeight, IDSTR_IMAGEDETAIL_HEIGHT, sizeof(chrHeight), queryModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[1]=chrHeight;
    if(getMessage(chrDepth, IDSTR_IMAGEDETAIL_DEPTH, sizeof(chrDepth), queryModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[2]=chrDepth;
    if(getMessage(chrFormat, IDSTR_IMAGEDETAIL_FORMAT, sizeof(chrFormat), queryModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[3]=chrFormat;

    /* Setup the static data for the details view */
    for(i=0,pCfi=cfiImageFieldInfo;i<NUM_IMAGE_DETAILS_FIELDS;i++,pCfi++)
      {
        memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));
        
        pCfi->cb=sizeof(CLASSFIELDINFO);
        pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
        pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
        pCfi->pNextFieldInfo=pCfi+1;
        pCfi->pTitleData=(PVOID)pszImageColTitles[i];
        pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;
        
        switch(i)
          {
          case 0: /* Width */
            pCfi->flData|=CFA_ULONG;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS, ulWidth));
            pCfi->ulLenFieldData=sizeof(ULONG);
            pCfi->ulLenCompareValue=sizeof(ULONG);
            pCfi->DefaultComparison=CMP_GREATER;
            break;
          case 1: /* Height */
            pCfi->flData|=CFA_ULONG;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS,ulHeight));
            pCfi->ulLenFieldData=sizeof(ULONG);
            pCfi->ulLenCompareValue=sizeof(ULONG);
            pCfi->DefaultComparison=CMP_GREATER;
            break;
          case 2: /* Depth */
            pCfi->flData|=CFA_ULONG;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS,ulDepth));
            pCfi->ulLenFieldData=sizeof(ULONG);
            pCfi->ulLenCompareValue=sizeof(ULONG);
            pCfi->DefaultComparison=CMP_GREATER;
            break;
          case 3: /* Format */
            pCfi->flData|=CFA_STRING;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS,pszFormat));
            pCfi->ulLenFieldData=sizeof(PSZ);
            pCfi->DefaultComparison=CMP_EQUAL;
            break;
          }/* switch(i) */
      }/* for() */
    cfiImageFieldInfo[NUM_IMAGE_DETAILS_FIELDS].pNextFieldInfo=NULL;    

    _beginthread(createBMPThreadFunc,NULL,8192*10, NULLHANDLE); //Fehlerbehandlung fehlt
}


/*
 *    wpclsQueryStyle: override;
 */
SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryDefaultView(M_CWImage *somSelf)
{
    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_CWImageMethodDebug("M_CWImage","cwimgM_wpclsQueryDefaultView");

    return ID_MENU_IMGEDITOR;
}

SOM_Scope PSZ  SOMLINK cwimgM_wpclsQueryTitle(M_CWImage *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_CWImageMethodDebug("M_CWImage","cwimgM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_CWIMAGETITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Digital Picture");

    return chrTitle;
}

/*
 *    wpclsQueryDefaultHelp: override;
 */

SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryIconData(M_CWImage *somSelf, 
                                                   PICONINFO pIconInfo)
{
    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_CWImageMethodDebug("M_CWImage","cwimgM_wpclsQueryIconData");

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = queryModuleHandle();
      pIconInfo->resid   = ID_ICONCWIMAGEFILE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}

SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryDetailsInfo(M_CWImage *somSelf, 
                                                      PCLASSFIELDINFO* ppClassFieldInfo, 
                                                      PULONG pSize)
{
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;
  ULONG rc;

    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_CWImageMethodDebug("M_CWImage","cwimgM_wpclsQueryDetailsInfo");

    cParentColumns= (M_CWImage_parent_M_WPImageFile_wpclsQueryDetailsInfo(somSelf, 
                                                                 ppClassFieldInfo, 
                                                                 pSize));
  if(pSize)
    *pSize+=sizeof(IMAGEDETAILS);

  if(ppClassFieldInfo)
    {
      if(*ppClassFieldInfo)
        {
          pCfi=*ppClassFieldInfo;
          for(i=0; i<cParentColumns;i++)
            pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);

          pCfi->pNextFieldInfo=cfiImageFieldInfo;
        }
      else
        *ppClassFieldInfo=cfiImageFieldInfo;
    }
    return (cParentColumns+NUM_IMAGE_DETAILS_FIELDS);
}


