/*
 * (C) Chris Wohlgemuth 2002-2003
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwaudio_Source
#define SOM_Module_cwaudio_Source
#endif
#define CWAudio_Class_Source
#define M_CWAudio_Class_Source

#define INCL_PM
#define INCL_DOS
#define INCL_WINWORKPLACE
#define INCL_MMIOOS2
#define INCL_DOSDEVIOCTL
#define INCL_MCIOS2
#define  INCL_ERRORS

#include <os2.h>
#include <stdio.h>
#include "os2me.h"
#include "cwmmdataf.h"
#include "cwaudio.ih"
#include "except.h"
#include "cwaudioinc.h"
#include "cwmp3inc.h" /* */
#include "cwogginc.h" /* */
#include <wpdisk.h>
#include <wpfolder.h>

#include "ea_funcs.h" /* Functions to read and write EA of file system objects */
#include "som_wps_funcs.h"
#include "sys_funcs.h"


/* Redefine function names */
#define cwGetStringFromEA EARestoreString
#define cwSaveStringToEA EASaveString

char classDLLPath[CCHMAXPATH]={0};
char chrHelpLibrary[CCHMAXPATH]={0};
char chrInstallDir[CCHMAXPATH]={0};
char chrMMAudioExt[200]={0};/* Array holding the extensions for wpclsQueryInstanceFilter() */
char resDLLPath[CCHMAXPATH]={0};

static PSZ pszAudioColTitles[NUM_AUDIO_FIELDS]= {"Playtime", "Bitrate", "Samplerate", "Channels", "Bits per sample",
"Track Name","Artist","Album","Year","Comment","Genre"};

char chrPlayTime[SIZE_TITLE]="";
char chrBitRate[SIZE_TITLE]=""; /* New with 0.2.7 */
char chrSampleRate[SIZE_TITLE]="";
char chrChannels[SIZE_TITLE]="";
char chrBPS[SIZE_TITLE]="";
char chrName[SIZE_TITLE]="";
char chrArtist[SIZE_TITLE]="";
char chrAlbum[SIZE_TITLE]="";
char chrYear[SIZE_TITLE]="";
char chrComment[SIZE_TITLE]="";
char chrGenre[SIZE_TITLE]="";

static CLASSFIELDINFO cfiFieldInfo[NUM_AUDIO_FIELDS];

extern PMMFORMATINFO g_pmmFormatInfoArray; /* in cwimage.c */
extern LONG          lNumIOProcs;/* Needed to know how many convert menus we have */
int iRunningAudioFiles=0;        /* Used to check if there's already an audio file started */

extern char *genreList[];
extern int iGenreLast;

/* Global var with HAB */
extern HAB globalHab;

extern ULONG globalClassVolume;

HWND globalHwndObjectPlay;
MMAudio* globalObjectPlay;

HMODULE queryModuleHandle(void);
HMODULE queryResModuleHandle(void);
PSZ queryModuleName(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags);

BOOL cwQueryCDDrives(int *iNumCD, int * iFirstDrive);
void HlpSendCommandToObject(char* chrObject, char* command);
PSZ _queryMp3HelpLibraryName(void);
BOOL cwMoveNotebookButtonsWarp4(HWND hwndDlg, USHORT usID, USHORT usDelta);
BOOL cwObjectIsOnCD(WPObject * somSelf);
PSZ queryInstallDir(void);

BOOL mmclsSetObjectType(WPFileSystem * somSelf);
BOOL mmclsCreateTheDefaultTemplate(M_WPObject *somSelf, 
                                   WPObject* Folder);
ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView);
BOOL getStringFromRexxScript(PSZ rexxFile, char* chrResult, ULONG ulSize);

/* Max string length for the EA values e.g. the trackname. If this value is increased the
   retstring length in the REXX function handler rxCallCWMMFunc() must also be increased! */
#define MAX_EA_SIZE 256



static PBYTE _readTrackInfoIntoMem(MMAudio *somSelf, char * chrEAName, PBYTE pByte, ULONG ulSize)
{
  if(cwGetStringFromEA(somSelf, chrEAName , pByte, ulSize))
    {
      PBYTE pEAValue;
      ULONG ul, len;
      
      len=strlen(pByte);
      if( (pEAValue=_wpAllocMem(somSelf, len+1, &ul))!=NULLHANDLE) {
        strncpy(pEAValue, pByte, len);
        pEAValue[len]=0;
        return pEAValue;
      }
    }
  return NULLHANDLE;
}

void _fillEntryfieldsWithCurrentTrackNames( MMAudio *cwAudio, HWND hwnd)
{
  MMAudioData *somThis = MMAudioGetData(cwAudio);

  if(_pszName)
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3NAME), _pszName);
  else
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3NAME), "");

  if(_pszArtist)
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST), _pszArtist);
  else
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST), "");

  if(_pszAlbum)
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3ALBUM), _pszAlbum);
  else
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3ALBUM), "");

  if(_pszComment)
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT), _pszComment);
  else
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT), "");

  if(_pszYear)
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3YEAR), _pszYear);
  else
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3YEAR), "");

  if(_pszGenre)
    WinSetWindowText(WinWindowFromID(hwnd,IDDD_ID3GENRE), _pszGenre);
  else
    WinSetWindowText(WinWindowFromID(hwnd,IDDD_ID3GENRE), "");

#if 0
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_NAME))
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3NAME), chr);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_ARTIST))
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_ALBUM))
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3ALBUM),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_COMMENT))
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_YEAR))
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3YEAR),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_GENRE))
    WinSetWindowText(WinWindowFromID(hwnd,IDDD_ID3GENRE),tempChar);
#endif
}

/****************************************************************/
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/****************************************************************/
static PBYTE _readTrackInfoFromTextFieldIntoMem(MMAudio *somSelf, PBYTE pByte, HWND hwnd)
{
  ULONG ulLen;
  PBYTE pNewText;
  ULONG  ul;

  ulLen=WinQueryWindowTextLength(hwnd)+1;

  /* Alloc mem for new string */
  if( (pNewText=_wpAllocMem(somSelf, ulLen, &ul))!=NULLHANDLE) {
    WinQueryWindowText(hwnd, ulLen, pNewText);
    _wpFreeMem(somSelf, pByte);

    return pNewText;
  }

  return pByte;
}

/****************************************************************/
/*                                                              */
/* WNDPROC: trackNameDlgProc()                                  */
/*                                                              */
/* Window procedure handling the track information settings     */
/* page. The user may use the page to edit the information.     */
/*                                                              */
/****************************************************************/
static MRESULT EXPENTRY trackNameDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MMAudio *cwAudio;


  switch(msg) {
  case WM_INITDLG :
    cwAudio=(MMAudio*)PVOIDFROMMP(mp2);

    WinSetWindowULong(WinWindowFromID(hwnd,IDEF_ID3NAME),
                      QWL_USER,(ULONG)cwAudio);//Save object ptr.

    if(somIsObj(cwAudio)) {
      int a;
      HWND hwndTemp;
      char name[50];
      MMAudioData *somThis = MMAudioGetData(cwAudio);
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_ID3HELP, 15);

      if(!getMessage(name, IDSTR_TRACKNAME, sizeof(name),  queryResModuleHandle(), hwnd))
        strcpy(name, "Track name");
      WinSetWindowText(WinWindowFromID(hwnd,IDGB_ID3TAGS), name);

      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3NAME),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)MAX_EA_SIZE-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ARTIST),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)MAX_EA_SIZE-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ALBUM),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)MAX_EA_SIZE-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3COMMENT),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)MAX_EA_SIZE-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3YEAR),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)MAX_EA_SIZE-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDDD_ID3GENRE),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)MAX_EA_SIZE-1),0);
#if 0
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3NAME),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Name)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ARTIST),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Artist)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ALBUM),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Album)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3COMMENT),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Comment)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3YEAR),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Year)-1),0);
#endif      
      /* Fill drop downlist with knwon genres */
      hwndTemp=WinWindowFromID(hwnd, IDDD_ID3GENRE);
      for(a=0;a<=iGenreLast;a++)
        WinSendMsg(hwndTemp, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(genreList[a]));
      _fillEntryfieldsWithCurrentTrackNames( cwAudio, hwnd);
    }
    WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd),
                       (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  case WM_COMMAND:
    cwAudio=(MMAudio*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_ID3NAME),QWL_USER);
    if(somIsObj(cwAudio)) {
      // char fName[100];

      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CANCEL:
          _fillEntryfieldsWithCurrentTrackNames( cwAudio, hwnd);
          break;
        case IDPB_ID3SAVE:
          {
            MMAudioData *somThis = MMAudioGetData(cwAudio);

            _pszName=_readTrackInfoFromTextFieldIntoMem(cwAudio, _pszName, WinWindowFromID(hwnd, IDEF_ID3NAME));
            _pszArtist=_readTrackInfoFromTextFieldIntoMem(cwAudio, _pszArtist, WinWindowFromID(hwnd, IDEF_ID3ARTIST));
            _pszAlbum=_readTrackInfoFromTextFieldIntoMem(cwAudio, _pszAlbum, WinWindowFromID(hwnd, IDEF_ID3ALBUM));
            _pszComment=_readTrackInfoFromTextFieldIntoMem(cwAudio, _pszComment, WinWindowFromID(hwnd, IDEF_ID3COMMENT));
            _pszYear=_readTrackInfoFromTextFieldIntoMem(cwAudio, _pszYear, WinWindowFromID(hwnd, IDEF_ID3YEAR));
            _pszGenre=_readTrackInfoFromTextFieldIntoMem(cwAudio, _pszGenre, WinWindowFromID(hwnd, IDDD_ID3GENRE));
#if 0
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3NAME), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_NAME);          
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_ARTIST);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ALBUM), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_ALBUM);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_COMMENT);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3YEAR), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_YEAR);
            /* Find genre */
            WinQueryWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_GENRE);
#endif
            _wpSaveDeferred(cwAudio);
          }
          break;
        default:
          break;
        }
    }
    return (MRESULT) TRUE;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/****************************************************************/
/*                                                              */
/* METHOD: cwmmAddTrackNamePage()                               */
/*                                                              */
/* Insert new settings notebook page showing track information. */
/* The user may use this page to edit the information           */
/*                                                              */
/****************************************************************/
SOM_Scope ULONG  SOMLINK cwaudio_cwmmAddTrackNamePage(MMAudio *somSelf, 
                                                      HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  /*    MMAudioData *somThis = MMAudioGetData(somSelf);*/
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmAddTrackNamePage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = trackNameDlgProc;
  //The resource DLL
  pageinfo.resid = queryResModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_ID3TAGS;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  pageinfo.idDefaultHelpPanel = TRACKNAME_SETTINGS_PANEL;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = _queryMp3HelpLibraryName();
  //We have a major tab so we need a name
  if(!getMessage(pageName, ID_TRACKNAMEPAGENAME, sizeof(pageName), queryResModuleHandle(), hwndNotebook))
    strcpy(pageName, "~Track name");
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook

  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);
}

/* Remove all trailing spaces from a string. The string MUST be terminated by 0! */
void _removeTrailingSpaces(char * chrString)
{
  char *ptr;

  if((ptr=strrchr(chrString, 0))==NULLHANDLE)
    return;

  if(ptr==chrString)
    return;

  while(ptr>=chrString && (*ptr==0 || *ptr==' '))
    ptr--;

  *(++ptr)=0;
}


/****************************************************************/
/*                                                              */
/* WNDPROC: waveInfoDlgProc()                                   */
/*                                                              */
/* Window procedure handling the wave information settings      */
/* page.                                                        */
/*                                                              */
/****************************************************************/
static MRESULT EXPENTRY waveInfoDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MMAudio *cwAudio;

  switch(msg) {
  case WM_INITDLG :
    cwAudio=(MMAudio*)LONGFROMMP(mp2);
    if(somIsObj(cwAudio)) {
      char fName[CCHMAXPATH];
      MMAudioData *somThis = MMAudioGetData(cwAudio);
      
      sprintf(fName,"%d",_ulChannels);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_CHANNELS),fName);
      
      sprintf(fName,"%d",_ulSampleRate);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_SAMPLERATE),fName);
      sprintf(fName,"%d",_ulBPS);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_BPS),fName);
      sprintf(fName,"%d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_PLAYTIME),fName);
      WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    }
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/****************************************************************/
/*                                                              */
/* METHOD: cwmmAddAudioInformationPage()                        */
/*                                                              */
/* Insert new settings notebook page showing audio information. */
/*                                                              */
/****************************************************************/
SOM_Scope ULONG  SOMLINK cwaudio_cwmmAddAudioInformationPage(MMAudio *somSelf, 
                                                            HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  MMAudioData *somThis = MMAudioGetData(somSelf);
  MMAudioMethodDebug("MMAudio","cwaudio_cwmmAddWaveInformationPage");


  if(_ulFileSize!=_wpQueryFileSize(somSelf)) {
    /* The filesize changed, somebody altered the audio file so reread the info */
    if(!cwObjectIsOnCD(somSelf)) {
      /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
         MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
         isn't necessary. When opening the settings notebook the info is reread anyway. */      
      
      /* Get class object */
      M_CWMMDataFile *m_cwmmDataFile=_CWMMDataFile;
      /* Get data pointer of class object */
      //FIXME
      /*      M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(m_cwmmDataFile);*/
      
      /* Send the object pointer to the audio worker thread to read the audio info in the background. */
      //      WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);
      WinPostMsg(__get_hwndAudioWorker(_CWMMDataFile), WM_APPTERMINATENOTIFY, somSelf, 0);
    }
  }

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = waveInfoDlgProc;
  //The resource DLL
  pageinfo.resid = queryResModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_WAVEINFOPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = IDDLG_GENERAL2PAGE;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = NULLHANDLE;
  //We have a major tab so we need a name
  if(!getMessage(pageName, ID_WAVEINFOPAGENAME, sizeof(pageName), queryResModuleHandle(), hwndNotebook))
    strcpy(pageName, "~Audio information");
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook
  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);
}

/*
 * The prototype for cwaudio_cwmmSetTrackInfo was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwaudio_cwmmSetTrackInfo(MMAudio *somSelf, 
                                                 char* chrString, 
                                                 ULONG ulValue, 
                                                 int iWhich)
{
  ULONG ulError;
    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmSetIdInfo");

    if(iWhich<1||iWhich>IDINFO_LASTINFO)
      return FALSE;

    switch(iWhich)
      {
      case IDINFO_PLAYTIME:
        _ulPlaySecs=ulValue;
        sprintf(_chrPlayTime, "%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
        break;

      case IDINFO_BPS:
        _ulBPS=ulValue;
        sprintf(_chrBPS, "%d",_ulBPS);
        break;
      case IDINFO_CHANNELS:
        _ulChannels=ulValue;
        sprintf(_chrChannels, "%d",_ulChannels);
        break;
      case IDINFO_SAMPLERATE:
        _ulSampleRate=ulValue;
        sprintf(_chrSampleRate, "%d",_ulSampleRate);
        break;

      case IDINFO_NAME:
        {
          char chrEA[MAX_EA_SIZE];
          /* Make sure string isn't longer than defined EA size */
          my_strlcpy(chrEA, chrString, sizeof(chrEA));
          _pszName=somReallocString(somSelf, _pszName, chrEA, &ulError);
          break;
        }
      case IDINFO_ARTIST:
        {
          char chrEA[MAX_EA_SIZE];
          my_strlcpy(chrEA, chrString, sizeof(chrEA));
          _pszArtist=somReallocString(somSelf, _pszArtist, chrEA, &ulError);
          break;
        }
      case IDINFO_ALBUM:
        {
          char chrEA[MAX_EA_SIZE];
          /* Make sure string isn't longer than defined EA size */
          my_strlcpy(chrEA, chrString, sizeof(chrEA));
          _pszAlbum=somReallocString(somSelf, _pszAlbum, chrEA, &ulError);
          break;
        }
      case IDINFO_YEAR:
        {
          char chrEA[MAX_EA_SIZE];
          /* Make sure string isn't longer than defined EA size */
          my_strlcpy(chrEA, chrString, sizeof(chrEA));
          _pszYear=somReallocString(somSelf, _pszYear, chrEA, &ulError);
          break;
        }
      case IDINFO_COMMENT:
        {
          char chrEA[MAX_EA_SIZE];
          /* Make sure string isn't longer than defined EA size */
          my_strlcpy(chrEA, chrString, sizeof(chrEA));
          _pszComment=somReallocString(somSelf, _pszComment, chrEA, &ulError);
          break;
        }
      case IDINFO_GENRE:
        {
          char chrEA[MAX_EA_SIZE];
          /* Make sure string isn't longer than defined EA size */
          my_strlcpy(chrEA, chrString, sizeof(chrEA));
          _pszGenre=somReallocString(somSelf, _pszGenre, chrEA, &ulError);
          break;
        }

#if 0
      case IDINFO_NAME:
        strncpy(_id3Name,chrString,sizeof(_id3Name));
        _id3Name[sizeof(_id3Name)-1]=0;
        _removeTrailingSpaces(_id3Name);
        break;
      case IDINFO_ARTIST:
        strncpy(_id3Artist,chrString,sizeof(_id3Artist));
        _id3Artist[sizeof(_id3Artist)-1]=0;
        _removeTrailingSpaces(_id3Artist);
        break;
      case IDINFO_ALBUM:
        strncpy(_id3Album, chrString, sizeof(_id3Album));
        _id3Album[sizeof(_id3Album)-1]=0;
        _removeTrailingSpaces(_id3Album);
        break;
      case IDINFO_YEAR:
        strncpy(_id3Year, chrString, sizeof(_id3Year));
        _id3Year[sizeof(_id3Year)-1]=0;
        _removeTrailingSpaces(_id3Year);
        break;
      case IDINFO_COMMENT:
        strncpy(_id3Comment,chrString, sizeof(_id3Comment));
        _id3Comment[sizeof(_id3Comment)]=0;
        _removeTrailingSpaces(_id3Comment);
        break;
      case IDINFO_GENRE:
        strncpy(_id3Genre, chrString, sizeof(_id3Genre));
        _id3Genre[sizeof(_id3Genre)-1]=0;
        _removeTrailingSpaces(_id3Genre);
        break;
#endif

      default:
        return FALSE;
      }


    /* Return statement to be customized: */
    return TRUE;
}


/*
 * The prototype for cwaudio_cwmmQueryTrackInfo was replaced by the following prototype:
 */

/*
 * SOM_Scope ULONG  SOMLINK cwaudio_cwmmQueryTrackInfo(MMAudio *somSelf, 
 *                                                     char** chrString, 
 *                                                     ULONG ulSize, 
 *                                                     int iWhich)
 */

/*
 * The prototype for cwaudio_cwmmQueryTrackInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudio_cwmmQueryTrackInfo(MMAudio *somSelf, 
                                                    PSZ chrString, 
                                                    ULONG ulSize, 
                                                    int iWhich)
{
  MMAudioData *somThis = MMAudioGetData(somSelf); 
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmQueryTrackInfo");

    switch(iWhich)
      {
      case IDINFO_PLAYTIME:
        return _ulPlaySecs;
      case IDINFO_BPS:
        return _ulBPS;
      case IDINFO_CHANNELS:
        return _ulChannels;
      case IDINFO_SAMPLERATE:
        return _ulSampleRate;
      case IDINFO_BITRATE:
        return _ulBitRate;

      case IDINFO_NAME:
        {
          //          char *chr=*chrString;
          if(!_pszName)
            return FALSE;
          if(ulSize>strlen(_pszName)) {
            strcpy(chrString, _pszName);
          }
          else {
            strncpy(chrString, _pszName, ulSize);
            chrString[ulSize-1]=0;
          }
          if(chrString[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ARTIST:
        {
          //    char *chr=*chrString;
          if(!_pszArtist)
            return FALSE;
          if(ulSize>strlen(_pszArtist)) {
            strcpy(chrString, _pszArtist);
          }
          else {
            strncpy(chrString, _pszArtist, ulSize);
            chrString[ulSize-1]=0;
          }
          if(chrString[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ALBUM:
        {
          //          char *chr=*chrString;
          if(!_pszAlbum)
            return FALSE;
          if(ulSize>strlen(_pszAlbum)) {
            strcpy(chrString, _pszAlbum);
          }
          else {
            strncpy(chrString, _pszAlbum, ulSize);
            chrString[ulSize-1]=0;
          }
          if(chrString[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_COMMENT:
        {
          //          char *chr=*chrString;
          if(!_pszComment)
            return FALSE;
          if(ulSize>strlen(_pszComment)) {
            strcpy(chrString, _pszComment);
          }
          else {
            strncpy(chrString, _pszComment, ulSize);
            chrString[ulSize-1]=0;
          }
          if(chrString[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_YEAR:
        {
          //          char *chr=*chrString;
          if(!_pszYear)
            return FALSE;
          if(ulSize>strlen(_pszYear)) {
            strcpy(chrString, _pszYear);
          }
          else {
            strncpy(chrString, _pszYear, ulSize);
            chrString[ulSize-1]=0;
          }
          if(chrString[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_GENRE:
        {
          //  char *chr=*chrString;
          if(!_pszGenre)
            return FALSE;

          if(ulSize>=strlen(_pszGenre)) {
            strcpy(chrString, _pszGenre);
          }
          else {
            strncpy(chrString, _pszGenre, ulSize);
            chrString[ulSize-1]=0;
          }
          if(chrString[0]==0)
            return FALSE;
          else
            return TRUE;
        }

#if 0
      case IDINFO_NAME:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Name)) {
            strncpy(chr, _id3Name, sizeof(_id3Name));
            chr[sizeof(_id3Name)-1]=0;
          }
          else {
            strncpy(chr, _id3Name, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ARTIST:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Artist)) {
            strncpy(chr, _id3Artist, sizeof(_id3Artist));
            chr[sizeof(_id3Artist)-1]=0;
          }
          else {
            strncpy(chr, _id3Artist, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ALBUM:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Album)) {
            strncpy(chr, _id3Album, sizeof(_id3Album));
            chr[sizeof(_id3Album)-1]=0;
          }
          else {
            strncpy(chr, _id3Album, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_COMMENT:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Comment)) {
            strncpy(chr, _id3Comment, sizeof(_id3Comment));
            chr[sizeof(_id3Comment)-1]=0;
          }
          else {
            strncpy(chr, _id3Comment, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_YEAR:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Year)) {
            strncpy(chr, _id3Year, sizeof(_id3Year));
            chr[sizeof(_id3Year)-1]=0;
          }
          else {
            strncpy(chr, _id3Year, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_GENRE:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Genre)) {
            strncpy(chr, _id3Genre, sizeof(_id3Genre));
            chr[sizeof(_id3Genre)-1]=0;
          }
          else {
            strncpy(chr, _id3Genre, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
#endif

      default:
        break;
      }

    /* Return statement to be customized: */
    return 0;
}

/************************************************************/
/*                                                          */
/*                                                          */
/*                                                          */
/************************************************************/
MRESULT EXPENTRY playObjectProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        if(LONGFROMMP(mp1)==ACKEY_START)
          {
            unsigned char chrCommand[CCHMAXPATH*2];
            char chrDevice[20];
            char name[CCHMAXPATH];
            ULONG ulNameSize;
            char retMsg[20];
            APIRET rc;
            int iTime;
            OPENPARAMS * pParams;
            MMAudio * thisPtr;
            
            pParams=PVOIDFROMMP(mp2);/* Get parameter block */
            if(!pParams)
              {
                WinPostMsg(hwnd,WM_QUIT,0,0);
                return MRFALSE;
              }
            
            WinSetWindowULong(hwnd, QWL_USER, (ULONG)pParams);

            thisPtr=pParams->wpObject;
            if(somIsObj(thisPtr)) {
              SOMClass* mmMIDIClass=somGetSomClass("MMMIDI");
              MMAudioData *somThis;
              //FIXME
              // CWMMDataFileData *mmdf_somThis;

              somThis = MMAudioGetData(thisPtr);
              //mmdf_somThis = CWMMDataFileGetData(thisPtr);
                    
              if(_somIsA(thisPtr, mmMIDIClass))
                strncpy(chrDevice,"SEQUENCER", sizeof(chrDevice));
              else
                strncpy(chrDevice,"WAVEAUDIO", sizeof(chrDevice));
                    
              ulNameSize=sizeof(name);
              _wpQueryRealName(thisPtr, name, &ulNameSize, TRUE);
                    
              /* Start audio file */  
              sprintf(chrCommand,"open \"%s\"  type %s alias wave%d SHAREABLE wait",name, chrDevice, thisPtr);
              rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd,WM_QUIT,0,0);
                return MRFALSE;
              }
                    
              /* Set time format */
              sprintf(chrCommand,"SET wave%d TIME FORMAT MILLISECONDS wait", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
                    
              sprintf(chrCommand,"STATUS wave%d LENGTH WAIT", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
                    
              iTime=atoi(retMsg);
                    
              //   sprintf(chrCommand,"SETPOSITIONADVISE wave%d ON EVERY %d NOTIFY", thisPtr, 3000);
              //   rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                    
              if(iTime>1100)
                iTime-=700;
              else
                iTime-=300;
                    
              if(iTime<=0)
                iTime=100;
                    
              sprintf(chrCommand,"SETCUEPOINT wave%d ON at %d WAIT", thisPtr, iTime);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
                
              /* Set volume */
              sprintf(chrCommand,"SET wave%d AUDIO VOLUME %d wait", thisPtr, globalClassVolume);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              /* Not able to set the volume isn't that bad so don't quit in case of an error. */
#if 0
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
#endif

              WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 100);
                    
              sprintf(chrCommand,"play wave%d ", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
                    
              /* Set Time in icon title to 00:00 */
              strncpy(chrCommand, _wpQueryTitle(thisPtr), CCHMAXPATH);
              if(_ulPlaySecs) {
                sprintf(retMsg, "%02d:%02d", _ulPlaySecs/60, _ulPlaySecs%60);                  
                strncat(chrCommand,"\n00:00 / ",sizeof(chrCommand)-1-strlen(chrCommand));
                strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
              }
              else
                strncat(chrCommand,"\n00:00", sizeof(chrCommand)-1-strlen(chrCommand));

              _cwmmSetRecordTitles(thisPtr, chrCommand, FALSE);
              WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000);
              //FIXME
              //mmdf_somThis->ulTrackStatus=TRACK_STATUS_PLAYING;
              __set_ulTrackStatus( thisPtr,TRACK_STATUS_PLAYING);
              break;
            }/* somIsObj(thisPtr) */
          }
        else
          {
            MMAudio * thisPtr;
       
            thisPtr=(MMAudio *)PVOIDFROMMP(mp2);/* Get object ptr */
            if(somIsObj(thisPtr)) {
              switch(LONGFROMMP(mp1))
                {
                case ACKEY_VOLUME:
                  {
                    HWND globalHwndObjectPlay;
                    unsigned char chrCommand[CCHMAXPATH];
                    char retMsg[20];

                    /* Set volume */
                    sprintf(chrCommand,"SET wave%d AUDIO VOLUME %d ", thisPtr, globalClassVolume);
                    mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                    /* Not able to set the volume isn't that bad so don't quit in case of an error. */
                    break;
                  }
                case ACKEY_STOP:
                  {
                    /* Stop playing */
                    unsigned char chrCommand[CCHMAXPATH];
                    char retMsg[20];
                  
                    //CWMMDataFileData *mmdf_somThis = CWMMDataFileGetData(thisPtr);                  
                    
                    WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,1 );
                    
                    sprintf(chrCommand,"stop wave%d wait", thisPtr);
                    mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                    
                    sprintf(chrCommand,"close wave%d wait", thisPtr);
                    mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                    
                    //FIXME
                    //    mmdf_somThis->ulTrackStatus=TRACK_STATUS_STOPPED;
                    __set_ulTrackStatus(thisPtr, TRACK_STATUS_STOPPED);
                    WinPostMsg(hwnd,WM_QUIT,0,0);
                    break;
                  }
                case ACKEY_PAUSE:
                  {
                    unsigned char chrCommand[CCHMAXPATH];
                    char retMsg[20];
                    APIRET rc;
                    // CWMMDataFileData *mmdf_somThis = CWMMDataFileGetData(thisPtr);                  
                    
                    sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
                    rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                    if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                      WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                      return MRFALSE;
                    }
                    
                    if(!stricmp(retMsg, "playing"))
                      {
                        sprintf(chrCommand,"PAUSE wave%d wait", thisPtr);
                        rc=mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                        if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                          WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                          return MRFALSE;
                        }
                        //FIXME
                        //mmdf_somThis->ulTrackStatus=TRACK_STATUS_PAUSED;
                        __set_ulTrackStatus(thisPtr, TRACK_STATUS_PAUSED);
                      }
                    break;
                  }
                case ACKEY_RESUME:
                  {
                    unsigned char chrCommand[CCHMAXPATH];
                    char retMsg[20];
                    APIRET rc;
                    //  CWMMDataFileData *mmdf_somThis = CWMMDataFileGetData(thisPtr);
                    
                    sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
                    rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                    if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                      WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                      return MRFALSE;
                    }
                                        
                    if(!stricmp(retMsg, "paused"))
                      {
                        sprintf(chrCommand,"RESUME wave%d wait", thisPtr);
                        rc=mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                        if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                          WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                          return MRFALSE;
                        }
                        //FIXME
                        //mmdf_somThis->ulTrackStatus=TRACK_STATUS_PLAYING;
                        __set_ulTrackStatus(thisPtr, TRACK_STATUS_PLAYING);
                      }
                    break;
                  }
                default:
                  break;
                }
            }/* if(thisPtr) */
            return MRFALSE;
          }
      }
      //case MM_MCIPOSITIONCHANGE:
    case WM_TIMER:
      if(SHORT1FROMMP(mp1)==1) {
        MMAudio * thisPtr;
        OPENPARAMS * pParams;
        pParams=(OPENPARAMS*)WinQueryWindowULong(hwnd, QWL_USER);
        thisPtr=pParams->wpObject;

        if(somIsObj(thisPtr)) {
          char retMsg[50];
          unsigned char chrCommand[CCHMAXPATH+20];
          APIRET rc;
          ULONG ulCur;
          MMAudioData *somThis = MMAudioGetData(thisPtr);

          /* Check if folder closed. If yes stop playing */
          if(!WinIsWindow(globalHab, pParams->hwndCnr)) {
            WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
            return MRFALSE;
          }
          /* Get current play position */
          sprintf(chrCommand,"STATUS wave%d POSITION WAIT", thisPtr);
          rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
          if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
            return MRFALSE;
          }

          ulCur=atoi(retMsg);
          if(ulCur) {
           ulCur/=1000;
           if(!ulCur)
             ulCur=1;
          }

          strncpy(chrCommand, _wpQueryTitle(thisPtr), CCHMAXPATH);
          strncat(chrCommand,"\n",sizeof(chrCommand)-1-strlen(chrCommand));
          if(_ulPlaySecs) {
            sprintf(retMsg, "%02d:%02d / %02d:%02d", ulCur/60, ulCur%60, _ulPlaySecs/60, _ulPlaySecs%60);
            strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
          }
          else
            {
            sprintf(retMsg, "%02d:%02d", ulCur/60, ulCur%60);
            strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
            }
          if(_cwmmQueryTrackStatus(thisPtr)==TRACK_STATUS_PAUSED) {
            if(!getMessage(retMsg,  IDSTR_TRACKPAUSED, sizeof(retMsg), queryResModuleHandle(), HWND_DESKTOP))
              strcpy(retMsg," (Paused)");
            strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
          }
          /* Set new time in icon title */
          _cwmmSetRecordTitles(thisPtr, chrCommand, FALSE);
        }
        return MRFALSE;
      }
      break;
    case MM_MCICUEPOINT:
      {
        /***********************************************/
        /* The track is about to end                   */
        /***********************************************/
        MMAudio * thisPtr;
        OPENPARAMS * pParams;
        pParams=(OPENPARAMS*)WinQueryWindowULong(hwnd, QWL_USER);
        thisPtr=pParams->wpObject;

        if(somIsObj(thisPtr)) {
          unsigned char chrCommand[CCHMAXPATH];
          char retMsg[20];

          sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
          do {
            APIRET rc;
            retMsg[0]=0;
            DosSleep(100);
            rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
              WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));

              return MRFALSE;
            }
            //  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, retMsg, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
            //HlpWriteToTrapLog("%s\n", retMsg);
          } while(!stricmp(retMsg, "playing"));
          /* The track ended. Call 'Stop' so the object title is updated and everything is cleaned up. 
             During handling of the 'Stop' message the WM_QUIT message will be posted to end the thread. */
          //WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_NEXT), MPFROMP(thisPtr));
          WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
        }
        return MRFALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

/************************************************************/
/*                                                          */
/* This thread is used to handle the object in use emphasis.*/
/* Playing starts on the object window proc.                */
/*                                                          */
/************************************************************/
void _Optlink playThreadFunc (void *arg)
{
  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  OPENPARAMS * params;
  CWMMDataFile *thisPtr;
  BOOL bCntDecremented=FALSE; /* Flag telling if the play counter was decremented so another audio file may be started. */

  params=(OPENPARAMS*)arg;
  if(!params) {
    iRunningAudioFiles--;
    if(iRunningAudioFiles<0)
      iRunningAudioFiles=0;/* Should never happen... */
    return;
  }

  thisPtr=params->wpObject; 
  if(!somIsObj(thisPtr)) {
    iRunningAudioFiles--;
    if(iRunningAudioFiles<0)
      iRunningAudioFiles=0;/* Should never happen... */
    _wpFreeMem(thisPtr, (PBYTE)params);
    return;
  }

  /* Prevent starting of several audio files at the same time */
  //if(iRunningAudioFiles<MAX_AUDIOFILE_STARTS+1) { 
    hab=WinInitialize(0);
    if(hab) {
      hmq=WinCreateMsgQueue(hab,0);
      if(hmq) {
        HWND hwnd;
        BOOL notFound;

        //FIXME
        //CWMMDataFileData *somThis = CWMMDataFileGetData(thisPtr);
        
        if(somIsObj(thisPtr)) {
          params->useItem.type=USAGE_OPENVIEW;
          params->viewItem.handle=NULLHANDLE;
          
          /* Create an invisible object window */
          hwnd=WinCreateWindow(HWND_OBJECT,WC_STATIC,"playObj", 0, 0, 0, 0, 0, 
                               NULLHANDLE, HWND_BOTTOM,12343,NULL,NULL);
          if(hwnd) {
            /* Window created. */
            /* Set in use emphasis for object */
            _wpAddToObjUseList(thisPtr, &params->useItem);

            /* Subclass the object window with the audio object private window proc.
               Every audio pbject has to set this in order to manage start/stop/resume command.
               It's usually done in MMAudio::wpInitData().  */
            WinSubclassWindow(hwnd, _cwmmQueryObjWindowProc(thisPtr));
            
            //  DosSetPriority(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER, 0, 0);
            
            /* Tell the window proc to start the file */
            WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_START), MPFROMP(params));

            /* Save object window pointer in instance data */
            //FIXME
            //_hwndObjectPlay=hwnd;
            __set_hwndObjectPlay(thisPtr, hwnd);
            /* Needed for volume setting */
            globalHwndObjectPlay=hwnd;
            globalObjectPlay=thisPtr;

            while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
              WinDispatchMsg(hab,&qmsg);
            WinDestroyWindow(hwnd);
            _cwmmSetRecordTitles(thisPtr, NULLHANDLE, FALSE);
          }
          if(somIsObj(thisPtr)) {
            /* Remove in use emphasis */
            _wpDeleteFromObjUseList(thisPtr, &params->useItem);
            //FIXME
            //_hwndObjectPlay=NULLHANDLE;
            __set_hwndObjectPlay(thisPtr, NULLHANDLE);
            //   _wpSetDefaultView(thisPtr, _ulPreviousView);
            _wpSetDefaultView(thisPtr, __get_ulPreviousView(thisPtr));
          }/* somIsObj() */

          iRunningAudioFiles--;
          if(iRunningAudioFiles<0)
            iRunningAudioFiles=0;/* Should never happen... */
          bCntDecremented=TRUE;

          /* The track ended. Check if there're other tracks selected in
             the container. If yes, start the next track. */
          notFound=TRUE;
          for(;;)
            {
              PMINIRECORDCORE pMrc, mrcTemp;
              OPENPARAMS * pParams;
              WPObject * contentObject;
              SOMClass *cwAudioClass=somGetSomClass("MMAudio");
        
              pParams=params;
        
              /* Get MINIRECORDCORE */
              if(!(pMrc=_wpQueryCoreRecord(thisPtr)))
                break;

              if(!WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP), pParams->hwndCnr))
                break; /* Container isn't valid. Probably the folder was closed. */

              //              HlpWriteToTrapLog("Container is valid\n");
              /* Remove selected state if any */
              WinSendMsg(pParams->hwndCnr, CM_SETRECORDEMPHASIS, MPFROMP(pMrc), MPFROM2SHORT(FALSE, CRA_SELECTED));

              /* Get next selected audio file */
              mrcTemp=(PMINIRECORDCORE)WinSendMsg(pParams->hwndCnr,CM_QUERYRECORDEMPHASIS, pMrc,
                                                  MPFROMSHORT(CRA_SELECTED));
              if((int)mrcTemp==-1) 
                /* Wrong parameter -> user deleted the shadow. */
                break;
        
              /* No selected files after the currently playing one. So start at the beginnning of the
                 container. */
              if(!mrcTemp)
                mrcTemp=(PMINIRECORDCORE)WinSendMsg(pParams->hwndCnr,CM_QUERYRECORDEMPHASIS, (MPARAM)CMA_FIRST,
                                                    MPFROMSHORT(CRA_SELECTED));
              //          HlpWriteToTrapLog("in Thread, iRunning: %d , mrcTemp %x\n", iRunningAudioFiles, mrcTemp);
              while(notFound && mrcTemp && (int)mrcTemp!=-1){
                contentObject=(WPObject*)OBJECT_FROM_PREC(mrcTemp);//Get object
                if(somIsObj(contentObject)) {
                  /* Get file system object or NULL */
                  if((contentObject=somGetFileSystemObject(contentObject))==NULLHANDLE) {
                    mrcTemp=(PMINIRECORDCORE)WinSendMsg(pParams->hwndCnr,CM_QUERYRECORDEMPHASIS, mrcTemp,
                                                        MPFROMSHORT(CRA_SELECTED));
                    continue;
                  }
                }
                else
                  break;/* Error */
          
                if(_somIsA(contentObject, cwAudioClass)) {
                  notFound=FALSE;
                }
                else
                  {
                    /* Try next object */
                    mrcTemp=(PMINIRECORDCORE)WinSendMsg(pParams->hwndCnr,CM_QUERYRECORDEMPHASIS, mrcTemp,
                                                        MPFROMSHORT(CRA_SELECTED));
                  }
              }; /* while */
              if(notFound)
                break;
              /* Another audio file is selected. Start it. */
              _wpViewObject(contentObject, params->hwndCnr, ID_MENU_START, NULLHANDLE);
              break;
            }; /* for() */
          /* FIXME
             Set global handle to NULL if no more files to play. Doing it this way we prevent a race condition
             with the newly started thread. No really nice but simple. A mutex wouldn't help because we must
             prevent that this ending thread overwrites the handle which may be set by the newly started thread. */
          if(notFound) {
            globalHwndObjectPlay=NULLHANDLE;
            globalObjectPlay=NULLHANDLE;
          }
        }/* somIsObj() */
        WinDestroyMsgQueue(hmq);
      }
      WinTerminate(hab);
    }/* hab */
    //  }/* iRunningAudioFiles */

    if(!bCntDecremented) {
      iRunningAudioFiles--;
      if(iRunningAudioFiles<0)
        iRunningAudioFiles=0;/* Should never happen... */
    }
  /* Free the parameter block */
  _wpFreeMem(thisPtr, (PBYTE)params);
}

/****************************************************************/
/*                                                              */
/* New method which starts playing of the file. Playing is done */
/* on a separate thread.                                        */
/*                                                              */
/****************************************************************/
SOM_Scope void  SOMLINK cwaudio_cwmmPlayTrack(MMAudio *somSelf, 
                                              HWND hwndCnr, BOOL bPlay)
{
  ULONG ulError;
  OPENPARAMS *pThreadParams;

  /*    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf); */
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmPlayTrack");

    if(bPlay) { /* Start playing */
      /* Check if there's a valid object window for handling the play messages. */
      //FIXME
      //      if(!WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay)) {
      if(!WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),__get_hwndObjectPlay(somSelf))) {
        /* Start playing only if there's not an object window yet. This is only
           a sanity check. If there's already an object window the track already is
           started.
           */
        pThreadParams=(OPENPARAMS*)_wpAllocMem(somSelf, sizeof(OPENPARAMS), &ulError);
        if(pThreadParams) {
          char chrTitle[CCHMAXPATH];
          char chrText[100];

          strncpy(chrTitle, _wpQueryTitle(somSelf), sizeof(chrTitle));
          chrTitle[sizeof(chrTitle)-1]=0;
          if(!getMessage(chrText, IDSTR_STARTINGTRACK, sizeof(chrText), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrText, "Starting Track...");;
          strncat(chrTitle,"\n", sizeof(chrTitle)-1-strlen(chrTitle));
          strncat(chrTitle, chrText, sizeof(chrTitle)-1-strlen(chrTitle));

          memset((void*)pThreadParams ,0, sizeof(OPENPARAMS));
          pThreadParams->wpObject=somSelf;
          pThreadParams->hwndCnr=hwndCnr;
          pThreadParams->viewItem.view=ID_MENU_START;
          if(_beginthread(playThreadFunc,NULL,8192*16,(void*)pThreadParams)) //Fehlerbehandlung fehlt
            _cwmmSetRecordTitles(somSelf, chrTitle, FALSE);
        }
      }
    }
    else /* Stop playing. */
      //FIXME
      //  if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
      //        WinPostMsg(_hwndObjectPlay, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(somSelf));
      if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),__get_hwndObjectPlay(somSelf)))
        WinPostMsg(__get_hwndObjectPlay(somSelf), WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(somSelf));
}



/*
  This method is called to pause a playing track from the context menu.
*/
/*
 *    LONG  cwmmSetTrackVolume(in ULONG ulVolume);
 *    LONG  cwmmQueryTrackVolume();
 */

SOM_Scope void  SOMLINK cwaudio_cwmmPauseTrack(MMAudio *somSelf, 
                                               HWND hwndCnr, 
                                               ULONG ulAction)
{
  /*    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);*/
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmPauseTrack");
    
    if(_cwmmQueryTrackStatus(somSelf)==TRACK_STATUS_STOPPED)
      return;

    switch(ulAction)
      {
      case ACKEY_PAUSE:

        /* Already paused? Shouldn't happen but I've seen it. */
        if(_cwmmQueryTrackStatus(somSelf)==TRACK_STATUS_PAUSED)
          return;

        /* Post a message to the object window handling the commands. */
        //FIXME
        //        if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
        //  WinPostMsg(_hwndObjectPlay, WM_APPTERMINATENOTIFY, MPFROMLONG(ulAction), MPFROMP(somSelf));
        if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),__get_hwndObjectPlay(somSelf)))
          WinPostMsg(__get_hwndObjectPlay(somSelf), WM_APPTERMINATENOTIFY, MPFROMLONG(ulAction), MPFROMP(somSelf));

        break;
      case ACKEY_RESUME:

        if(_cwmmQueryTrackStatus(somSelf)==TRACK_STATUS_PLAYING)
          return;
        //FIXME
        //        if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
        //      WinPostMsg(_hwndObjectPlay, WM_APPTERMINATENOTIFY, MPFROMLONG(ulAction), MPFROMP(somSelf));
        if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP), __get_hwndObjectPlay(somSelf)))
          WinPostMsg(__get_hwndObjectPlay(somSelf), WM_APPTERMINATENOTIFY, MPFROMLONG(ulAction), MPFROMP(somSelf));
        break;
      default:
        break;
      }
}

#if 0
SOM_Scope long  SOMLINK cwaudio_cwmmSetTrackVolume(MMAudio *somSelf, 
                                                   ULONG ulVolume)
{
    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmSetTrackVolume");

    /* Return statement to be customized: */
    return -1;
}

SOM_Scope long  SOMLINK cwaudio_cwmmQueryTrackVolume(MMAudio *somSelf)
{
    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_cwmmQueryTrackVolume");

    /* Return statement to be customized: */
    return -1;
}
#endif

/****************************************************************/
/*
  Two new settings pages are added to every audio object:
  
  -Audio information showing playtime samplerate and so on.
  -Track information for editing artist name, album name and so
   on.
  
  */
/****************************************************************/
SOM_Scope BOOL  SOMLINK cwaudio_wpAddSettingsPages(MMAudio *somSelf, 
                                                   HWND hwndNotebook)
{
  BOOL rc;

  /*  MMAudioData *somThis = MMAudioGetData(somSelf);*/
    MMAudioMethodDebug("MMAudio","cwaudio_wpAddSettingsPages");


    rc= (MMAudio_parent_CWMMDataFile_wpAddSettingsPages(somSelf, hwndNotebook));

    return rc | _cwmmAddAudioInformationPage(somSelf, hwndNotebook)|
      _cwmmAddTrackNamePage(somSelf, hwndNotebook);
}

/*
 * The prototype for cwaudio_wpQueryDetailsData was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudio_wpQueryDetailsData(MMAudio *somSelf, 
                                                    PVOID* ppDetailsData, 
                                                    PULONG pcp)
{
  BOOL rcParent;
  PAUDIODETAILS pAudioDetails;
    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_wpQueryDetailsData");

    /* Call parent */
    rcParent= (MMAudio_parent_CWMMDataFile_wpQueryDetailsData(somSelf, 
                                                      ppDetailsData, 
                                                      pcp));

  /* The WPS asks for data to be displayed */
  if(ppDetailsData)
    {
      /* Fill the structure with the info to be displayed */      
      pAudioDetails=(PAUDIODETAILS)*ppDetailsData;  
      pAudioDetails->pszPlayTime=_chrPlayTime;
      pAudioDetails->pszBitRate=_chrBitRate;            /* New with 0.2.7 */
      pAudioDetails->pszSampleRate=_chrSampleRate;
      pAudioDetails->pszChannels=_chrChannels;
      pAudioDetails->pszBPS=_chrBPS;

      pAudioDetails->pszName=_pszName;
      pAudioDetails->pszArtist=_pszArtist;
      pAudioDetails->pszAlbum=_pszAlbum;
      pAudioDetails->pszYear=_pszYear;
      pAudioDetails->pszComment=_pszComment;
      pAudioDetails->pszGenre=_pszGenre;

#if 0
      pAudioDetails->pszName=_id3Name;
      pAudioDetails->pszArtist=_id3Artist;
      pAudioDetails->pszAlbum=_id3Album;
      pAudioDetails->pszYear=_id3Year;
      pAudioDetails->pszComment=_id3Comment;
      pAudioDetails->pszGenre=_id3Genre;
#endif
      *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pAudioDetails);  
    }
  else
    {
      /* Buffer size is queried */
      if(pcp)
        *pcp+=sizeof(*pAudioDetails);
    }
    return rcParent;
}


/*
 * The prototype for cwaudio_wpRestoreState was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwaudio_wpRestoreState(MMAudio *somSelf, 
                                               ULONG ulReserved)
{
  BOOL bRc; 
  char fName[CCHMAXPATH];
  BOOL bReRead=FALSE;
  ULONG ulError;
  BOOL bIsMidi;
  PBYTE pByte;

   MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_wpRestoreState");

    bRc=(MMAudio_parent_CWMMDataFile_wpRestoreState(somSelf, ulReserved));

    _bNeedSaving=FALSE;

    /* Query the audio info */
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_FILESIZE, &_ulFileSize))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_TIME, &_ulPlaySecs))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_CHANNELS, &_ulChannels))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_SAMPLERATE, &_ulSampleRate))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_BPS, &_ulBPS))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_TIME_MS, &_ulPlayMsecs))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_NUM_AUDIO_BYTES, &_ulNumAudioBytes))
      bReRead=TRUE;

    /* New with 0.2.7 */
    if(EARestoreString(somSelf, "MMBITRATE", _chrBitRate, sizeof(_chrBitRate))) {
      _ulBitRate=atol(_chrBitRate);
    }
    else {
      //SysWriteToTrapLog("No EA for %s\n", _wpQueryTitle(somSelf));
      bReRead=TRUE;
    }
    /* Get audiotrack info from EA */
    if( (pByte=_wpAllocMem(somSelf, MAX_EA_SIZE, &ulError))!=NULLHANDLE)
      {
        _pszName=_readTrackInfoIntoMem(somSelf, "MMTRACKNAME" , pByte, MAX_EA_SIZE);
        _pszArtist=_readTrackInfoIntoMem(somSelf, "MMARTIST" , pByte, MAX_EA_SIZE);
        _pszAlbum=_readTrackInfoIntoMem(somSelf, "MMALBUM" , pByte, MAX_EA_SIZE);
        _pszYear=_readTrackInfoIntoMem(somSelf, "MMYEAR" , pByte, MAX_EA_SIZE);
        _pszComment=_readTrackInfoIntoMem(somSelf, "MMCOMMENT" , pByte, MAX_EA_SIZE);
        _pszGenre=_readTrackInfoIntoMem(somSelf, "MMGENRE" , pByte, MAX_EA_SIZE);
        _wpFreeMem(somSelf, pByte);
      }

#if 0
    cwGetStringFromEA(somSelf, "MMTRACKNAME" , _id3Name, sizeof(_id3Name));
    cwGetStringFromEA(somSelf, "MMARTIST" , _id3Artist, sizeof(_id3Artist));
    cwGetStringFromEA(somSelf, "MMALBUM" , _id3Album, sizeof(_id3Album));
    cwGetStringFromEA(somSelf, "MMYEAR" , _id3Year, sizeof(_id3Year));
    cwGetStringFromEA(somSelf, "MMCOMMENT" , _id3Comment, sizeof(_id3Comment));
    cwGetStringFromEA(somSelf, "MMGENRE" , _id3Genre, sizeof(_id3Genre));

    sprintf(chrBuffer,"%d",_ulSampleRate);
    cwSaveStringToEA(somSelf, "MMSAMPLERATE", chrBuffer);
    sprintf(chrBuffer,"%d",_ulChannels);
    cwSaveStringToEA(somSelf, "MMCHANNELS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulBPS);
    cwSaveStringToEA(somSelf, "MMBPS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulPlaySecs);
    cwSaveStringToEA(somSelf, "MMPLAYTIME", chrBuffer);
    sprintf(chrBuffer,"%d",_ulPlayMsecs);
    cwSaveStringToEA(somSelf, "MMPLAYTIMEMS", chrBuffer);
#endif

    if(_ulFileSize!=_wpQueryFileSize(somSelf))
      bReRead=TRUE; /* The filesize changed, somebody altered the audio file so reread the info */

    if(!_ulFileSize)
      bReRead=FALSE;
    /* If filesize=0 do nothing because the file was just created and there's no contents yet */
 
    if(cwObjectIsOnCD(somSelf) && bReRead) {
      /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
         MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
         isn't necessary. When opening the settings notebook the info is reread anyway. */      
      bReRead=FALSE;
    }
    bIsMidi=_somIsA(somSelf, somGetSomClass("MMMIDI"));
    if(bReRead){
      /* Some info changed or isn't present. Reread the audio information */
      /* Get data pointer of class object */
      //  M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(_CWMMDataFile);

      /* Send the object pointer to the audio worker thread to read the audio info in the background.
         The audio worker thread was started during initialization of CWMMDataFile. 
         */
      //FIXME
      //      WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);
      WinPostMsg(__get_hwndAudioWorker(_CWMMDataFile) , WM_APPTERMINATENOTIFY, somSelf, 0);

      /* Set default values into instance vars */
      if(bIsMidi)
        {
          /* MIDI files don't have this info. */
          strncpy(_chrSampleRate, "---", sizeof(_chrSampleRate));      
          strncpy(_chrBPS, "---", sizeof(_chrBPS));
        }
      else
        {
          strncpy(_chrSampleRate, "??", sizeof(_chrSampleRate));
          strncpy(_chrBPS, "??", sizeof(_chrBPS));
        }
      strncpy(_chrBitRate, "---", sizeof(_chrBitRate));
      strncpy(_chrChannels, "??", sizeof(_chrChannels));
      strncpy(_chrPlayTime, "??:??", sizeof(_chrPlayTime));

      _ulFileSize=0;
      _ulPlaySecs=0;
      _ulChannels=0;
      _ulSampleRate=0;
      _ulBitRate=0;
      _ulBPS=0;
      _ulPlayMsecs=0;
      _ulNumAudioBytes=0;
    }/* bReRead */
    else {
      /* No new reading necessary. Fill in the instance vars with the restored
         data. */
      sprintf(fName,"%d",_ulChannels);
      strncpy(_chrChannels, fName, sizeof(_chrChannels));
      
      if(bIsMidi)
        strncpy(_chrSampleRate, "---", sizeof(_chrSampleRate));      
      else {
        sprintf(fName,"%d", _ulSampleRate);
        strncpy(_chrSampleRate, fName, sizeof(_chrSampleRate));      
      }
      
      if(bIsMidi)
        strncpy(_chrBPS, "---", sizeof(_chrBPS));
      else {
        sprintf(fName,"%d",_ulBPS);
        strncpy(_chrBPS, fName, sizeof(_chrBPS));
      }
      /* Bitrate of MP3 files */
      if(!_ulBitRate)
        strncpy(_chrBitRate, "---", sizeof(_chrBitRate));
      else {
        sprintf(fName,"%d",_ulBitRate);
        strncpy(_chrBitRate, fName, sizeof(_chrBitRate));
      }

      sprintf(fName,"%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
      strncpy(_chrPlayTime, fName, sizeof(_chrPlayTime));
    }
    _chrChannels[sizeof(_chrChannels)-1]=0;
    _chrSampleRate[sizeof(_chrSampleRate)-1]=0;
    _chrBPS[sizeof(_chrBPS)-1]=0;
    _chrPlayTime[sizeof(_chrPlayTime)-1]=0;

    return bRc;
}


/*
 * The prototype for cwaudio_wpSaveState was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwaudio_wpSaveState(MMAudio *somSelf)
{
  char chrBuffer[10];

    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_wpSaveState");


    if(_ulFileSize) {
      _wpSaveLong(somSelf, "CWAudio", KEY_TIME,_ulPlaySecs);
      _wpSaveLong(somSelf, "CWAudio", KEY_SAMPLERATE,_ulSampleRate);
      _wpSaveLong(somSelf, "CWAudio", KEY_CHANNELS,_ulChannels);
      _wpSaveLong(somSelf, "CWAudio", KEY_BPS,_ulBPS);
      _wpSaveLong(somSelf, "CWAudio", KEY_FILESIZE,_ulFileSize);
      _wpSaveLong(somSelf, "CWAudio", KEY_TIME_MS,_ulPlayMsecs);
      _wpSaveLong(somSelf, "CWAudio", KEY_NUM_AUDIO_BYTES, _ulNumAudioBytes);
    }

    /* Save audio info in EA for other programs */
    cwSaveStringToEA(somSelf, "MMTRACKNAME", _pszName);
    cwSaveStringToEA(somSelf, "MMARTIST", _pszArtist);
    cwSaveStringToEA(somSelf, "MMALBUM", _pszAlbum);
    cwSaveStringToEA(somSelf, "MMCOMMENT", _pszComment);
    cwSaveStringToEA(somSelf, "MMYEAR", _pszYear);
    cwSaveStringToEA(somSelf, "MMGENRE", _pszGenre);


#if 0
    cwSaveStringToEA(somSelf, "MMTRACKNAME", _id3Name);
    cwSaveStringToEA(somSelf, "MMARTIST", _id3Artist);
    cwSaveStringToEA(somSelf, "MMALBUM", _id3Album);
    cwSaveStringToEA(somSelf, "MMCOMMENT", _id3Comment);
    cwSaveStringToEA(somSelf, "MMYEAR", _id3Year);
    cwSaveStringToEA(somSelf, "MMGENRE", _id3Genre);
#endif

    sprintf(chrBuffer,"%d",_ulSampleRate);
    cwSaveStringToEA(somSelf, "MMSAMPLERATE", chrBuffer);
    sprintf(chrBuffer,"%d",_ulChannels);
    cwSaveStringToEA(somSelf, "MMCHANNELS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulBPS);
    cwSaveStringToEA(somSelf, "MMBPS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulPlaySecs);
    cwSaveStringToEA(somSelf, "MMPLAYTIME", chrBuffer);
    sprintf(chrBuffer,"%d",_ulPlayMsecs);
    cwSaveStringToEA(somSelf, "MMPLAYTIMEMS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulNumAudioBytes);
    cwSaveStringToEA(somSelf, "MMNUMAUDIOBYTES", chrBuffer);

    /* New with 0.2.7 */
    sprintf(chrBuffer,"%d",_ulBitRate);
    EASaveString(somSelf, "MMBITRATE", chrBuffer);

#if 0
    cwGetStringFromEA(somSelf, "MMTRACKNAME" , chrBuf, sizeof(chrBuf));
    HlpWriteToTrapLog("Value: %s\n", chrBuf);
    cwGetStringFromEA(somSelf, "MMARTIST" , chrBuffer, sizeof(chrBuffer));
    cwGetStringFromEA(somSelf, "MMALBUM" , chrBuffer, sizeof(chrBuffer));
#endif

#if 0
    /* Set .TYPE EA so the editor and the player are happy. */
    strncpy(chrBuf, _wpQueryType(somSelf), sizeof(chrBuf));
    chrBuf[sizeof(chrBuf)-1]=0;

    if(!strstr(chrBuf, TYPE_DIGITALAUDIO)) {
      ulLength=strlen(chrBuf);
      if(ulLength) {
        if(ulLength+2+sizeof(TYPE_DIGITALAUDIO) < sizeof(chrBuf)) {
          strcat(chrBuf, "\n");
          strcat(chrBuf, TYPE_DIGITALAUDIO);
        }
      }
      else
        strcpy(chrBuf, TYPE_DIGITALAUDIO);      
      /* Set .TYPE EA so the editor and the player are happy. */
      _wpSetType(somSelf, chrBuf , NULL);
    }
#endif
    //_wpSetType(somSelf, "Digital Audio" , NULL);
    return (MMAudio_parent_CWMMDataFile_wpSaveState(somSelf));
}

/*
  FIXME:

  This function isn't thread safe because of one global memory area. It is supposed to be
  called from the wpPopupMenu() method. This method can only be called once at
  a time, so that's not a problem. It may become a problem if this function is also
  called from somewhere else. The global mem pointer is used by the image class and the
  audio class.

  This function inserts only write enabled IO procedures into the menu.
*/
static BOOL insertAudioIOProcMenuItems( HWND hwndMenu )
{
    CHAR          szBuffer[ sizeof( FOURCC ) + CCHMAXPATH + 4 ];
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;
    LONG          lBytesRead;
    HWND hwndSubMenu;
    MENUITEM mi;
    LONG          lNumIOProcs;

    if(g_pmmFormatInfoArray)
      free(g_pmmFormatInfoArray);
    g_pmmFormatInfoArray=NULLHANDLE;

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_AUDIO;
    mmFormatInfo.ulFlags|=MMIO_CANWRITETRANSLATED;/* FIXME: CANWRITEUNTRANSLATED???*/
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /* Error - mmioQueryFormatCount failed. */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    g_pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    if( g_pmmFormatInfoArray == NULL )
      {
        /* Could not allocate enough memory for mmFormatInfo array. */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   g_pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(g_pmmFormatInfoArray);
        g_pmmFormatInfoArray=NULLHANDLE;
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(g_pmmFormatInfoArray);
        g_pmmFormatInfoArray=NULLHANDLE;
        return FALSE;
      }

    // Create Empty Submenu //
    hwndSubMenu=WinCreateWindow(hwndMenu,WC_MENU,"",0,
                                0,0,0,0,
                                hwndMenu,//Owner. If set, this window 
                                //is destroyed if owner is destroyed
                                HWND_TOP,
                                ID_MENU_CONVERT,//menuid
                                NULL,NULL);

    mi.iPosition=MIT_END;
    mi.afStyle=MIS_TEXT;//|MIS_SUBMENU;
    mi.id=ID_MENU_CONVERT;
    mi.afAttribute=NULLHANDLE;    
    mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
    mi.hItem=NULLHANDLE;
    mi.hwndSubMenu=hwndSubMenu;

    if(!getMessage(szBuffer, IDSTR_MENU_CONVERT, sizeof(szBuffer), queryResModuleHandle(), HWND_DESKTOP))
       sprintf(szBuffer,"~Convert to");
    WinSendMsg(hwndMenu,MM_INSERTITEM,(MPARAM)&mi,
               (MPARAM)szBuffer);

    pmmFormatInfoArray=g_pmmFormatInfoArray;
    for ( index = 0; index <lNumIOProcs; index++ )
      {
        mmioGetFormatName(pmmFormatInfoArray, szBuffer, &lBytesRead, 0L, 0L);
        
        /* Insert NULL string terminator */
        *( szBuffer + lBytesRead ) = (CHAR)NULL;

        /* Only write enabled IO procs are used in the convert menu.
         */
        if(pmmFormatInfoArray->ulFlags & MMIO_CANWRITETRANSLATED)
          {
            //  HlpWriteToTrapLog("IO-Proc 2: %s\n\n", szBuffer);
            /* Add menu item */
            /* Fill the MENUITEM structure */
            mi.iPosition=MIT_END;
            mi.afStyle=MIS_TEXT|MIS_SUBMENU;
            mi.id=ID_ITEM_FIRSTCONVERT+index;/* Create menu id */
            mi.afAttribute=NULLHANDLE;    
            mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
            mi.hItem=NULLHANDLE;
            WinSendMsg(hwndSubMenu, MM_INSERTITEM,(MPARAM)&mi,
                       (MPARAM)szBuffer);
          }
        /*
         *  advance to next entry in mmFormatInfo array
         */
        pmmFormatInfoArray++;
      }
    return TRUE;
}


/*
 * The prototype for cwaudio_wpModifyPopupMenu was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwaudio_wpModifyPopupMenu(MMAudio *somSelf, 
                                                  HWND hwndMenu, 
                                                  HWND hwndCnr, 
                                                  ULONG iPosition)
{
  BOOL rc;

  //FIXME
  /*  CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);*/
  MMAudioMethodDebug("MMAudio","cwaudio_wpModifyPopupMenu");

    /* New Volume item */
    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_VOLUME, 1);
    /* Convert menu item */
    //    _wpInsertPopupMenuItems(somSelf, hwndMenu, -1, queryModuleHandle(), ID_MENU_CONVERT, 0);
    //#if 0
    /* Insert all known audio I/O procs */
    TRY_LOUD(AUDIO_INSERTPOPUPMENU) {
      insertAudioIOProcMenuItems( hwndMenu );
    }/* TRY_LOUD */
    CATCH(AUDIO_INSERTPOPUPMENU)
      {
        SysWriteToTrapLog("\nTrap occured in %s, file %s, near line %d.\n",
                          __FUNCTION__, __FILE__, __LINE__);
      } END_CATCH;
      //#endif

      if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),__get_hwndObjectPlay(somSelf))) {
        if(_cwmmQueryTrackStatus(somSelf)==TRACK_STATUS_PAUSED)
          _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_RESUME, 1);
        else
          _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_PAUSE, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_STOP, 1);
      }
    else
      {
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_EDITOR, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_PLAYER, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_START, 1);
      }
    rc= (MMAudio_parent_CWMMDataFile_wpModifyPopupMenu(somSelf, 
                                                       hwndMenu, 
                                                       hwndCnr, 
                                                       iPosition));
    return rc;
}


/*
 * The prototype for cwaudio_wpMenuItemSelected was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwaudio_wpMenuItemSelected(MMAudio *somSelf, 
                                                   HWND hwndFrame, 
                                                   ULONG ulMenuId)
{
  /*    MMAudioData *somThis = MMAudioGetData(somSelf);*/
    MMAudioMethodDebug("MMAudio","cwaudio_wpMenuItemSelected");


    if(ulMenuId>=ID_ITEM_FIRSTCONVERT && ulMenuId<=ID_ITEM_FIRSTCONVERT+lNumIOProcs-1)
      {
        char chrEditor[CCHMAXPATH]={0};
        char chrParams[2*CCHMAXPATH]="\"";
        char *chrPtr=chrParams;
        ULONG ulSize;
        ULONG ulRc;
        
        PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioconverter", "", chrEditor,
                              sizeof(chrEditor));
        chrPtr++;
        ulSize=sizeof(chrParams);
        _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
        strcat(chrPtr,"\" \"");
        chrPtr=strrchr(chrPtr, 0);
        mmioGetFormatName(&g_pmmFormatInfoArray[ulMenuId-ID_ITEM_FIRSTCONVERT], chrPtr,(LONG*) &ulSize, 0L, 0L);
        *( chrPtr + ulSize ) = (CHAR)NULL;
        strcat(chrPtr,"\"");

        if((ulRc=launchPMProg("", chrEditor, chrParams, somSelf, ulMenuId-ID_ITEM_FIRSTCONVERT))==NULLHANDLE) {
          /* Error */
          return TRUE;
        }
        return TRUE;
      }

    switch(ulMenuId)
      {
      case ID_MENU_VOLUME:
      case ID_MENU_START:
      case ID_MENU_STOP:
      case ID_MENU_PAUSE:
      case ID_MENU_RESUME:
      case ID_MENU_PLAYER:
      case ID_MENU_EDITOR:
      case ID_ITEM_CONVERT:
        _wpViewObject(somSelf, WinWindowFromID(hwndFrame, FID_CLIENT), ulMenuId,0);
        return TRUE;
      default:
        break;
      }
    return (MMAudio_parent_CWMMDataFile_wpMenuItemSelected(somSelf, 
                                                      hwndFrame, 
                                                      ulMenuId));
}

/*
 * The prototype for cwaudio_wpObjectReady was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwaudio_wpObjectReady(MMAudio *somSelf, 
                                              ULONG ulCode, WPObject* refObject)
{
 MMAudioData *somThis = MMAudioGetData(somSelf);
  MMAudioMethodDebug("MMAudio","cwaudio_wpObjectReady");

  MMAudio_parent_CWMMDataFile_wpObjectReady(somSelf, ulCode, refObject);

  /* Set the type of this object to keep the MM player happy. */
  mmclsSetObjectType(somSelf);

  if(_bNeedSaving)
    _wpSaveDeferred(somSelf);
}


/*
 * The prototype for cwaudio_wpSetup was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwaudio_wpSetup(MMAudio *somSelf, PSZ pszSetupString)
{
  char buffer[MAX_EA_SIZE];
  ULONG bufferSize;

  MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_wpSetup");

    /* Setting volume while playing */
    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOVOLUME, buffer, &bufferSize))
      {
        LONG l;

        l=atol(buffer);
        if(l>100)
          l=100;
        if(l<0)
          l=0;

        globalClassVolume=l;
        /* Now tell the running file if any */
        WinSendMsg(globalHwndObjectPlay, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_VOLUME), MPFROMP(globalObjectPlay));
      }

    /* These are the old setup strings. They will be removed in the future */
    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOTRACKNAME, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_NAME);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOARTIST, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ARTIST);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOALBUM, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ALBUM);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOCOMMENT, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_COMMENT);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOGENRE, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_GENRE);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOYEAR, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_YEAR);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOPLAYTIME, buffer, &bufferSize))
      {
        int iPlaytime=atoi(buffer);
        if(iPlaytime<0)
          iPlaytime=0;
        _cwmmSetTrackInfo(somSelf, buffer, iPlaytime, IDINFO_PLAYTIME);
      }

    /* Refresh */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_REFRESH, buffer,&bufferSize))
      {
        _ulFileSize=1; /* Set filesize to 1 this will force a reread */
        /* Make sure MMIOMP3 doesn't take the time from the EA */
        cwSaveStringToEA(somSelf, "MMPLAYTIME", "");
        cwSaveStringToEA(somSelf, "MMPLAYTIMEMS", "");
        
        /* The filesize changed, somebody altered the audio file so reread the info */
        if(!cwObjectIsOnCD(somSelf)) {
          /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
             MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
             isn't necessary. When opening the settings notebook the info is reread anyway. */      
          
          //FIXME
          /* Get class object */
          //M_CWMMDataFile *m_cwmmDataFile=_CWMMDataFile;
          /* Get data pointer of class object */
          //M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(m_cwmmDataFile);         
          /* Send the object pointer to the audio worker thread to read the audio info in the background. */
          //          WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);
          WinPostMsg(__get_hwndAudioWorker(_CWMMDataFile) , WM_APPTERMINATENOTIFY, somSelf, 0);
        }
        _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_COPYTAGTO, buffer, &bufferSize))
      {
        /* The caller requested to copy the tags from this audio file to another */
        PBYTE pByte;
        ULONG ul;

        /* Length of instance var string can't be longer than MAX_EA_SIZE. See cwmmSetTrackInfo() */
        if((pByte=_wpAllocMem(somSelf, MAX_EA_SIZE+100, &ul))!=NULLHANDLE)
          {
            sprintf(pByte,"%s=%s;",SETUP_AUDIOTRACKNAME, _pszName);
            HlpSendCommandToObject( buffer, pByte);
         
            sprintf(pByte,"%s=%s",SETUP_AUDIOARTIST, _pszArtist);
            HlpSendCommandToObject( buffer, pByte);

            sprintf(pByte,"%s=%s",SETUP_AUDIOALBUM, _pszAlbum);
            HlpSendCommandToObject( buffer, pByte);
            
            sprintf(pByte,"%s=%s",SETUP_AUDIOCOMMENT, _pszComment);
            HlpSendCommandToObject( buffer, pByte);
            
            sprintf(pByte,"%s=%s",SETUP_AUDIOYEAR, _pszYear);
            HlpSendCommandToObject( buffer, pByte);
            
            sprintf(pByte,"%s=%s",SETUP_AUDIOGENRE, _pszGenre);
            HlpSendCommandToObject( buffer, pByte);
          }
      }

#if 0
    /* Old code using a static array. To be removed in V.0.2.8 */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_COPYTAGTO, buffer, &bufferSize))
      {
        /* The caller requested to copy the tags from this audio file to another */
        char chrCommand[200];

        sprintf(chrCommand,"%s=%s;",SETUP_AUDIOTRACKNAME, _id3Name);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOARTIST, _id3Artist);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOALBUM, _id3Album);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOCOMMENT, _id3Comment);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOYEAR, _id3Year);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOGENRE, _id3Genre);
        HlpSendCommandToObject( buffer, chrCommand);
      }
#endif

    /* The new MM* setup strings. These have a better naming */
    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOTRACKNAME, buffer, &bufferSize))
      _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_NAME);
      
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOARTIST, buffer, &bufferSize))
      _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ARTIST);
    
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOALBUM, buffer, &bufferSize))
      _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ALBUM);
    
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOCOMMENT, buffer, &bufferSize))
      _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_COMMENT);
      
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOGENRE, buffer, &bufferSize))
      _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_GENRE);
      
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOYEAR, buffer, &bufferSize))
      _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_YEAR);
    
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOPLAYTIME, buffer, &bufferSize))
      {
        int iPlaytime=atoi(buffer);
        if(iPlaytime<0)
          iPlaytime=0;
        _cwmmSetTrackInfo(somSelf, buffer, iPlaytime, IDINFO_PLAYTIME);
      }

    /* Refresh */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMREFRESH, buffer,&bufferSize))
      {
        _ulFileSize=1; /* Set filesize to 1 this will force a reread */
        /* Make sure MMIOMP3 doesn't take the time from the EA */
        cwSaveStringToEA(somSelf, "MMPLAYTIME", "");
        cwSaveStringToEA(somSelf, "MMPLAYTIMEMS", "");

        /* The filesize changed, somebody altered the audio file so reread the info */
        if(!cwObjectIsOnCD(somSelf)) {
          /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
             MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
             isn't necessary. When opening the settings notebook the info is reread anyway. */      

          //FIXME          
          /* Get class object */
          //M_CWMMDataFile *m_cwmmDataFile=_CWMMDataFile;
          /* Get data pointer of class object */
          //M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(m_cwmmDataFile);
          /* Send the object pointer to the audio worker thread to read the audio info in the background. */
          //WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);
          WinPostMsg(__get_hwndAudioWorker(_CWMMDataFile) , WM_APPTERMINATENOTIFY, somSelf, 0);
        }
        _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMCOPYTAGTO, buffer, &bufferSize))
      {
        /* The caller requested to copy the tags from this audio file to another */
        PBYTE pByte;
        ULONG ul;
        
        /* Length of instance var string can't be longer than MAX_EA_SIZE. See cwmmSetTrackInfo() */
        if((pByte=_wpAllocMem(somSelf, MAX_EA_SIZE+100, &ul))!=NULLHANDLE)
          {

            sprintf(pByte,"%s=%s;",SETUP_MMAUDIOTRACKNAME, _pszName);
            HlpSendCommandToObject( buffer, pByte);

            sprintf(pByte,"%s=%s",SETUP_MMAUDIOARTIST, _pszArtist);
            HlpSendCommandToObject( buffer, pByte);

            sprintf(pByte,"%s=%s",SETUP_MMAUDIOALBUM, _pszAlbum);
            HlpSendCommandToObject( buffer, pByte);

            sprintf(pByte,"%s=%s",SETUP_MMAUDIOCOMMENT, _pszComment);
            HlpSendCommandToObject( buffer, pByte);

            sprintf(pByte,"%s=%s",SETUP_MMAUDIOYEAR, _pszYear);
            HlpSendCommandToObject( buffer, pByte);
            
            sprintf(pByte,"%s=%s",SETUP_MMAUDIOGENRE, _pszGenre);
            HlpSendCommandToObject( buffer, pByte);
          }
      }
    
#if 0
    /* Old code using a static array. To be removed in V0.2.8 */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMCOPYTAGTO, buffer, &bufferSize))
      {
        /* The caller requested to copy the tags from this audio file to another */
        char chrCommand[200];

        sprintf(chrCommand,"%s=%s;",SETUP_MMAUDIOTRACKNAME, _id3Name);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_MMAUDIOARTIST, _id3Artist);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_MMAUDIOALBUM, _id3Album);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_MMAUDIOCOMMENT, _id3Comment);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_MMAUDIOYEAR, _id3Year);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_MMAUDIOGENRE, _id3Genre);
        HlpSendCommandToObject( buffer, chrCommand);
      }
#endif

    return (MMAudio_parent_CWMMDataFile_wpSetup(somSelf, pszSetupString));
}

/*

 */
/*
 *  wpSetTitle              : override;
 *    wpQueryRealName         : override;
 *    wpQueryTitle            : override;
 *    wpRefresh               : override;
 */

SOM_Scope HWND  SOMLINK cwaudio_wpOpen(MMAudio *somSelf, HWND hwndCnr, 
                                       ULONG ulView, ULONG param)
{
  ULONG ulRc;

  /*    CWAudioData *somThis = CWAudioGetData(somSelf);*/
  /*  CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf); */
    MMAudioMethodDebug("MMAudio","cwaudio_wpOpen");

    switch(ulView)
      {
      case ID_MENU_START:
        {
          //  HlpWriteToTrapLog("ID_MENU_START selected, iRunningAudioFile: %d hwndCnr: %x %x\n", iRunningAudioFiles, hwndCnr, param);
          if(iRunningAudioFiles<MAX_AUDIOFILE_STARTS) {
            /* Another audio file running */
            iRunningAudioFiles++;
            //FIXME
            //_ulPreviousView=_wpQueryDefaultView(somSelf);/* Save the view set by the user                  */
            __set_ulPreviousView(somSelf, _wpQueryDefaultView(somSelf));/* Save the view set by the user                  */
            _cwmmPlayTrack(somSelf, hwndCnr, TRUE);      /* Start playing                                  */
            _wpSetDefaultView(somSelf, ID_MENU_STOP);    /* Set new view so doubleclick stops the playing. */
          }
          return NULLHANDLE;
        }
      case ID_MENU_STOP:
        {
          _cwmmPlayTrack(somSelf, hwndCnr, FALSE);     /* Stop playing                                   */
          //FIXME
          // _wpSetDefaultView(somSelf, _ulPreviousView); /* Restore the user view                          */
          _wpSetDefaultView(somSelf, __get_ulPreviousView(somSelf)); /* Restore the user view                          */
          return NULLHANDLE;
        }
      case ID_MENU_PAUSE:
        {
          _cwmmPauseTrack(somSelf, hwndCnr, ACKEY_PAUSE);
          return NULLHANDLE;
        }
      case ID_MENU_RESUME:
        {
          _cwmmPauseTrack(somSelf, hwndCnr, ACKEY_RESUME);
          return NULLHANDLE;
        }
      case ID_MENU_PLAYER:
        /*case 0xbbe5:   Player */
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;

          /* Build path for the audio player app */
          sprintf(chrPlayer, "%s\\bin\\%s", chrInstallDir, "mmplayer.exe");

          /* The user may override the audio player using a setting in the ini. Default is using the
             provided one.
             */
          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioplayer", chrPlayer, chrPlayer,sizeof(chrPlayer));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE); /* Add filename */
          strcat(chrPtr,"\"");

          /* Get the Title for the window list */
          if(!getMessage(chrTitle, IDSTR_AUDPLAYERTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Player");

          if((ulRc=launchPMProg(chrTitle, chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      case ID_MENU_VOLUME:
        {
          char chrVolume[CCHMAXPATH]={0};
          char chrTitle[100]={0};
          char chrParam[CCHMAXPATH]="\"";
          ULONG ulRc;

          sprintf(chrVolume, "%s\\bin\\classvol.exe", queryInstallDir());
          
          ulRc=sizeof(chrParam);
          _wpQueryRealName(somSelf,chrParam+1, &ulRc, TRUE);
          strcat(chrParam,"\"");
          /* Get the Title for the window list */
          if(!getMessage(chrTitle, IDSTR_VOLUMETITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Volume");

          if((ulRc=launchPMProg(chrTitle, chrVolume, chrParam, somSelf, ID_MENU_VOLUME))==0)
           return NULLHANDLE;

#if 0
          HOBJECT hObject;
          if((hObject=WinQueryObject("<MMPM2_MMVOLUME>"))!=NULLHANDLE)
            WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
#endif
          return NULLHANDLE;
        }
      case ID_MENU_EDITOR:
        /* case 0xbc0d:  Editor */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+10]="-e \"";
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;

          /*
            Check if the user specified another audio editor. 
            */
          if(!PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioeditor", NULLHANDLE, chrPlayer,sizeof(chrPlayer)))
            {
              /* No user setting. Use default ab.exe copied by the installation program to another location */
              PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "ab", NULLHANDLE, chrPlayer,sizeof(chrPlayer));
            }
          chrPtr+=4;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");

          if(!getMessage(chrTitle, IDSTR_AUDEDITORTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Editor");

          if((ulRc=launchPMProg( chrTitle, chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }

          return NULLHANDLE;
        }
#if 0
        /* 
           FIXME:
           Moved this to wpMenuItemSelected(). Should be moved back later.
           */
      case 0xb4dd: /* Convert */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioconverter", "", chrPlayer,sizeof(chrPlayer));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if((ulRc=launchPMProg("Spieler", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
#endif
      default:
        break;
      }
    return (MMAudio_parent_CWMMDataFile_wpOpen(somSelf, hwndCnr, ulView, 
                                          param));
}


SOM_Scope void  SOMLINK cwaudio_wpInitData(MMAudio *somSelf)
{
    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_wpInitData");

    MMAudio_parent_CWMMDataFile_wpInitData(somSelf);
    /* Flag to mark we haven't yet the audio size. The size will be read from the
       EAs (to circumvent the IO proc file scanning) or by checking the file using
       IO procs when the file was altered. */
    _ulFileSize=1;

    /* This proc handles the start/stop/resume commands for audio objects.
       Playing takes place on a separate thread with an object window and this proc used
       for communicating. */
    _cwmmSetObjWindowProc(somSelf, &playObjectProc);
}

/*
  This function checks all the installed audio IO procs if one of them can handle the
  audio file with the given extension. Only write enabled IO procs are accepted because
  we use this function to determine if we should create a template for the audio class. 
 */
static BOOL checkForWriteEnabledAudioIOProc(char * chrExt)
{
    CHAR          szBuffer[ sizeof( FOURCC ) + CCHMAXPATH + 4 ];
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    void * memPtr;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;
    LONG          lBytesRead;
    LONG          lNumIOProcs;

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_AUDIO;
    mmFormatInfo.ulFlags|=MMIO_CANWRITETRANSLATED;
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         * Error - mmioQueryFormatCount failed.
         */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    memPtr=pmmFormatInfoArray;
    if( pmmFormatInfoArray == NULL )
      {
        /*
         * Could not allocate enough memory for mmFormatInfo array.
         */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }

    for ( index = 0; index <lNumIOProcs; index++ )
      {
        mmioGetFormatName(pmmFormatInfoArray, szBuffer, &lBytesRead, 0L, 0L);
        
        /* Insert NULL string terminator */
        *( szBuffer + lBytesRead ) = (CHAR)NULL;

        if(pmmFormatInfoArray->ulFlags & MMIO_CANWRITETRANSLATED)
          {
            //if(pmmFormatInfoArray->fccIOProc==mmioStringToFOURCC(chr, MMIO_TOUPPER))
            //HlpWriteToTrapLog("%s --- %x %x %s\n",szBuffer, pmmFormatInfoArray->fccIOProc, mmioStringToFOURCC(chrType, MMIO_TOUPPER),
            // pmmFormatInfoArray->szDefaultFormatExt);
              if(strstr(chrExt, pmmFormatInfoArray->szDefaultFormatExt)) {
                //   HlpWriteToTrapLog("******* Ext given: %s  IO-Proc: %s\n", chrExt, pmmFormatInfoArray->szDefaultFormatExt);
                free(memPtr);
                return TRUE;
              }
          }
        /*
         *  advance to next entry in mmFormatInfo array
         */
        pmmFormatInfoArray++;
      }
    free(memPtr);
    return FALSE;
}

/*
 *    wpCreateShadowObject    : override;
 */

SOM_Scope void  SOMLINK cwaudio_wpUnInitData(MMAudio *somSelf)
{
    MMAudioData *somThis = MMAudioGetData(somSelf);
    MMAudioMethodDebug("MMAudio","cwaudio_wpUnInitData");

    if(_pszName)
      _wpFreeMem(somSelf, _pszName);
        
    if(_pszArtist)
      _wpFreeMem(somSelf, _pszArtist);
    
    if(_pszAlbum)
      _wpFreeMem(somSelf, _pszAlbum);

    if(_pszComment)
      _wpFreeMem(somSelf, _pszComment);

    if(_pszYear)
      _wpFreeMem(somSelf, _pszYear);

    if(_pszGenre)
      _wpFreeMem(somSelf, _pszGenre);

    MMAudio_parent_CWMMDataFile_wpUnInitData(somSelf);
}


/*
  Only templates for write enabled audio IO procs are created in this method. 
 */
SOM_Scope BOOL  SOMLINK cwaudioM_wpclsCreateDefaultTemplates(M_MMAudio *somSelf, 
                                                             WPObject* Folder)
{
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsCreateDefaultTemplates");

    //HlpWriteToTrapLog("Classtitle: %s, Type: %s\n",_wpclsQueryTitle(somSelf), _wpclsQueryInstanceType(somSelf));
    if(checkForWriteEnabledAudioIOProc( _wpclsQueryInstanceFilter(somSelf))) {
      /* A write enabled IO proc was found, create the template. */
      mmclsCreateTheDefaultTemplate(somSelf, Folder);
      return TRUE; /* Tell the WPS template created*/
    }

    return TRUE; /* We created the template or don't want to have one */
}


SOM_Scope PSZ  SOMLINK cwaudioM_wpclsQueryInstanceType(M_MMAudio *somSelf)
{
    /* M_MMAudioData *somThis = M_MMAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsQueryInstanceType");

    return TYPE_DIGITALAUDIO;
}

SOM_Scope PSZ  SOMLINK cwaudioM_wpclsQueryInstanceFilter(M_MMAudio *somSelf)
{
    /* M_MMAudioData *somThis = M_MMAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsQueryInstanceFilter");

    /* The list of additional extensions is built in wpclsInitData(). 

       FIXME
       This is a static list read in only once during startup.
       Should probably be changed later on.
       */
    return chrMMAudioExt;
    /*   return (M_MMAudio_parent_M_CWMMDataFile_wpclsQueryInstanceFilter(somSelf)); */
}

/*
 * The prototype for cwaudioM_wpclsQueryDetailsInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryDetailsInfo(M_MMAudio *somSelf, 
                                                        PCLASSFIELDINFO* ppClassFieldInfo, 
                                                        PULONG pSize)
{
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;

    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsQueryDetailsInfo");

    cParentColumns= (M_MMAudio_parent_M_CWMMDataFile_wpclsQueryDetailsInfo(somSelf, 
                                                             ppClassFieldInfo, 
                                                             pSize));
  if(pSize)
    *pSize+=sizeof(AUDIODETAILS);

  if(ppClassFieldInfo)
    {
      if(*ppClassFieldInfo)
        {
          pCfi=*ppClassFieldInfo;
          for(i=0; i<cParentColumns;i++)
            pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);

          pCfi->pNextFieldInfo=cfiFieldInfo;
        }
      else
        *ppClassFieldInfo=cfiFieldInfo;
    }
    return (cParentColumns+NUM_AUDIO_FIELDS);
}


/*
 * The prototype for cwaudioM_wpclsQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwaudioM_wpclsQueryTitle(M_MMAudio *somSelf)
{
  static char chrTitle[30]={0};
  
  M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsQueryTitle");
  
  if(chrTitle[0]==0)
    if(!getMessage(chrTitle, IDSTR_CWAUDIOTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
      strcpy(chrTitle, CLSTITLE_DIGITALAUDIO);
  
  return chrTitle;
}

/*
  Initialize the MMAudio class.
 */
SOM_Scope void  SOMLINK cwaudioM_wpclsInitData(M_MMAudio *somSelf)
{
  PCLASSFIELDINFO pCfi;
  USHORT i;
  static BOOL bGotAudioExt=FALSE;

  /*    M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsInitData");

    /* 
       Get extensions of additional audio procs. These extensions may be specified by
       newly installed IO procs in MMPM2.INI or by using the Multimedia setup. For
       example the MMIOMP3 procedure for reading MP3 files adds the MP3 extension this
       way to the system. Extensions already handled by a specialized class will be
       filtered in the called REXX script e.g. MP3 so only unknown extensions end up here.

       Strangely enough wpclsQueryInstanceFilter() is called during wpclsInitData() so
       we query the extensions here before calling the parent.

       FIXME:
       The check is only done once during initialization. This is a little annoyance for
       the user because new extension specified in the settings will only be picked up
       on next WPS start. 
       */
     if(!bGotAudioExt)
      {
        getStringFromRexxScript("audioext.rx", chrMMAudioExt, sizeof(chrMMAudioExt));
        bGotAudioExt=TRUE; 
      }

    M_MMAudio_parent_M_CWMMDataFile_wpclsInitData(somSelf);

    /* Get strings for details view titled from the ressource DLL */
    if(getMessage(chrPlayTime, IDSTR_PLAYTIME, sizeof(chrPlayTime),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[0]=chrPlayTime;
    /* New with 0.2.7 */
    if(getMessage(chrSampleRate, IDSTR_BITRATE, sizeof(chrBitRate),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[1]=chrBitRate;

    if(getMessage(chrSampleRate, IDSTR_SAMPLERATE, sizeof(chrSampleRate),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[2]=chrSampleRate;
    if(getMessage(chrChannels, IDSTR_CHANNELS, sizeof(chrChannels),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[3]=chrChannels;
    if(getMessage(chrBPS, IDSTR_BPS, sizeof(chrBPS),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[4]=chrBPS;

    if(getMessage(chrName, IDSTR_TITLE, sizeof(chrName),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[5]=chrName;
    if(getMessage(chrArtist, IDSTR_ARTIST, sizeof(chrArtist),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[6]=chrArtist;
    if(getMessage(chrAlbum, IDSTR_ALBUM, sizeof(chrAlbum),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[7]=chrAlbum;
    if(getMessage(chrYear, IDSTR_YEAR, sizeof(chrYear),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[8]=chrYear;
    if(getMessage(chrComment, IDSTR_COMMENT, sizeof(chrComment),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[9]=chrComment;
    if(getMessage(chrGenre, IDSTR_GENRE, sizeof(chrGenre),  queryResModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[10]=chrGenre;


  /* Setup the static data for the details view */
  for(i=0,pCfi=cfiFieldInfo;i<NUM_AUDIO_FIELDS;i++,pCfi++)
    {
      memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));

      pCfi->cb=sizeof(CLASSFIELDINFO);
      pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
      pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
      pCfi->pNextFieldInfo=pCfi+1;
      pCfi->pTitleData=(PVOID)pszAudioColTitles[i];
      pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;

      switch(i)
        {
        case 0: /* play time */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszPlayTime));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 1: /* Bitrate */     /* New with 0.2.7 */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszBitRate));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 2: /* Sample rate */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszSampleRate));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 3: /* Channels */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszChannels));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 4: /* BPS */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszBPS));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;

        case 5: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszName));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 6: 
          pCfi->flData|=CFA_STRING;
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszArtist));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 7: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszAlbum));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 8: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszYear));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 9: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszComment));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 10: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszGenre));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;

        }/* switch(i) */
    }/* for() */
  cfiFieldInfo[NUM_AUDIO_FIELDS].pNextFieldInfo=NULL;

  /* Get name of help library from resource */
  if(!getMessage(chrHelpLibrary, IDSTR_HELPLIBRARY, sizeof(chrHelpLibrary),
                 queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrHelpLibrary,"MMPARTS.HLP"); /* Fall back to default Warp hel library */
}






SOM_Scope void  SOMLINK cwaudioM_wpclsUnInitData(M_MMAudio *somSelf)
{
    /* M_MMAudioData *somThis = M_MMAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsUnInitData");

    M_MMAudio_parent_M_CWMMDataFile_wpclsUnInitData(somSelf);
}

/*
 * The prototype for cwaudioM_wpclsQueryDefaultView was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryDefaultView(M_MMAudio *somSelf)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsQueryDefaultView");

    /* Default view for audio objects is 'Start' so on doubleclick the playing starts
       immediately. */
    return ID_MENU_START;
    //    return (M_CWAudio_parent_M_MMAudio_wpclsQueryDefaultView(somSelf));
}

/*
 * The prototype for cwaudioM_wpclsQueryIconData was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryIconData(M_MMAudio *somSelf, 
                                                     PICONINFO pIconInfo)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_MMAudioMethodDebug("M_MMAudio","cwaudioM_wpclsQueryIconData");
    /*
      We have our own icon.
      */
	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = queryModuleHandle();
      pIconInfo->resid   = ID_ICONCWAUDIOFILE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}



MRESULT EXPENTRY audioWorkerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
      ULONG ulSize;
      char fName[CCHMAXPATH];
      char text[CCHMAXPATH];
      BOOL bContinue=FALSE;
      MMAudio *somSelf=(MMAudio*)mp1;
      MMAudioData *somThis= MMAudioGetData(somSelf);
      ULONG ulLoop;
      //FIXME
      //M_CWMMDataFileData *m_mmCWMM = M_CWMMDataFileGetData(_CWMMDataFile);

      TRY_LOUD(AUDIO_WORKER) {
        for(;;) {
          ULONG rc;
          MMIOINFO mmio;
          HMMIO hmmio;
          MMAUDIOHEADER mmAudioHeader={0};
          LONG lBytesRead=0;
          char* pChar;
          ULONG ulFSize;
          BOOL bIsMidi=FALSE;

          mmclsSetObjectType(somSelf);

          if(!somIsObj(somSelf))
            break;

          ulFSize=_wpQueryFileSize(somSelf);
          if(_ulFileSize==ulFSize)
            break;          /* We already scanned this file */
          
          ulSize=sizeof(fName);
          if(!_wpQueryRealName(somSelf, fName, &ulSize, TRUE))
            break;

          /* Show status window */
          if((pChar=strrchr(fName, '\\'))!=NULLHANDLE) {
            HPS hps;
            ULONG ulWinTextLen;
            POINTL aptlPoints[TXTBOX_COUNT];
            SWP swp;
            ULONG ulCy;
            WPOINT pwpBorder;
            //FIXME
            //HWND hwndClient=WinWindowFromID(m_mmCWMM->hwndStatus, FID_CLIENT);
            HWND hwndClient=WinWindowFromID(__get_hwndStatus(_CWMMDataFile), FID_CLIENT);

            sprintf(text,"%c:\\...%s",fName[0], pChar);
            WinSetWindowText(hwndClient, text);
            ulWinTextLen=(ULONG)strlen(text); // Query text length

            /* Calculate text size in pixel */
            hps=WinBeginPaint(hwndClient,(HPS)NULL,(PRECTL)NULL);
            GpiQueryTextBox(hps,ulWinTextLen,text,TXTBOX_COUNT,aptlPoints);
            WinEndPaint(hps);
            //FIXME
            //if(WinSendMsg(m_mmCWMM->hwndStatus ,WM_QUERYBORDERSIZE, MPFROMP(&pwpBorder), 0L))
            if(WinSendMsg(__get_hwndStatus(_CWMMDataFile) ,WM_QUERYBORDERSIZE, MPFROMP(&pwpBorder), 0L))
              ulCy=pwpBorder.x*2;
            else
              ulCy=SV_CYBORDER*2;
            //FIXME
            // if(WinQueryWindowPos(WinWindowFromID(m_mmCWMM->hwndStatus, FID_TITLEBAR),&swp))
            if(WinQueryWindowPos(WinWindowFromID(__get_hwndStatus(_CWMMDataFile), FID_TITLEBAR),&swp))
              ulCy+=swp.cy;
            else
              ulCy+=15;
            //FIXME
            //            WinSetWindowPos(m_mmCWMM->hwndStatus, HWND_TOP, 0,0,
            WinSetWindowPos(__get_hwndStatus(_CWMMDataFile), HWND_TOP, 0,0,
                            aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x+18,
                            aptlPoints[TXTBOX_TOPRIGHT].y-aptlPoints[TXTBOX_BOTTOMRIGHT].y+ulCy+4,
                            SWP_SIZE|SWP_SHOW|SWP_ZORDER|SWP_DEACTIVATE);
            //FIXME
            //            WinPostMsg(m_mmCWMM->hwndStatus, WM_APPTERMINATENOTIFY, 0,MPFROMLONG(1L));
            WinPostMsg(__get_hwndStatus(_CWMMDataFile), WM_APPTERMINATENOTIFY, 0,MPFROMLONG(1L));
          }
          //#if 0
          /* This part obsolete?? */
          /* Get file name */
          ulSize=sizeof(fName);
          if(!_wpQueryRealName(somSelf, fName, &ulSize, TRUE))
            break;
          //#endif

          if(!_somIsA(somSelf, somGetSomClass("MMMIDI")))
            {
              /* Check audio files */
              MP3OPTIONS mp3Opt; /* Struct holding MP3 additional info */
              VORBISOPTIONS vorbisOpt;
      
              PMP3OPTIONS returnedMP3Opts;
              PVORBISOPTIONS returnedVorbisOpts;

              memset(&mmio,0, sizeof(mmio));
              mmio.ulFlags=MMIO_READ;
              mmio.ulTranslate=MMIO_TRANSLATEHEADER;

              if(somObjectIsA(somSelf, "MMOGG"))
                {
                  vorbisOpt.cookie = VORBIS_COOKIE;
                  mmio.pExtraInfoStruct = &vorbisOpt;
                }
              else
                {
                  /* For bitrate query of MP3 */
                  mp3Opt.cookie = MP3_COOKIE;
                  mmio.pExtraInfoStruct = &mp3Opt;              
                }
              hmmio = mmioOpen(fName, &mmio, MMIO_READ);
              if(!hmmio)
                break;
              
              memset(&mmAudioHeader,0,sizeof(MMAUDIOHEADER));
              rc = mmioGetHeader(hmmio, &mmAudioHeader,sizeof(MMAUDIOHEADER),
                                 &lBytesRead, 0, 0);
              
              if(rc!=MMIO_SUCCESS) {
                mmioClose(hmmio, 0);
                break;
              }
              mmioClose(hmmio, 0);
              
              /* Check if the object is still living. */
              if(!somIsObj(somSelf))
                break;

              if(somObjectIsA(somSelf, "MMOGG")) {
                returnedVorbisOpts = (PVORBISOPTIONS)mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.pAdditionalInformation;
                if(0 != returnedVorbisOpts && VORBIS_COOKIE == returnedVorbisOpts->cookie && 0 != returnedVorbisOpts->nominal_bitrate)
                  _ulBitRate=returnedVorbisOpts->nominal_bitrate;
                else
                  _ulBitRate=0;
              }
              else {
                returnedMP3Opts = (PMP3OPTIONS)mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.pAdditionalInformation;
                if(0 != returnedMP3Opts && MP3_COOKIE == returnedMP3Opts->cookie && 0 != returnedMP3Opts->bitrate)
                  _ulBitRate=returnedMP3Opts->bitrate;
                else
                  _ulBitRate=0;
              }


              _ulChannels=mmAudioHeader.mmXWAVHeader.WAVEHeader.usChannels;
              _ulSampleRate=mmAudioHeader.mmXWAVHeader.WAVEHeader.ulSamplesPerSec;
              _ulBPS=mmAudioHeader.mmXWAVHeader.WAVEHeader.usBitsPerSample;
              _ulNumAudioBytes=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes;
              /*      sprintf(fName,"%02d:%02d",mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
                      mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec/60,
                      mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
                      mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec%60);*/
              if(mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000) {
                _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000;
                _ulPlayMsecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS;
              }
              else {
                _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
                  mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec;
                _ulPlayMsecs=_ulPlaySecs*1000;
              }
            }/* _somIsA()*/
          else
            {
              /* The file is a midi file. Get audio information using MCI commands. */
              unsigned char chrCommand[CCHMAXPATH];
              char retMsg[20];
              APIRET rc;
              ULONG ulTime;

              bIsMidi=TRUE;

              //              HlpWriteToTrapLog("File: %s\n",  fName);
              /* open the file */
              sprintf(chrCommand,"open \"%s\"  type SEQUENCER alias wave%d SHAREABLE wait",fName,  somSelf);
              rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), NULLHANDLE, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                break;
              }

              /* Set time format */
              sprintf(chrCommand,"SET wave%d TIME FORMAT MILLISECONDS wait", somSelf);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                /* close the file */
                sprintf(chrCommand,"close wave%d wait", somSelf);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                break;
              }

              /* Get midi info */
              sprintf(chrCommand,"STATUS wave%d LENGTH WAIT", somSelf);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                /* close the file */
                sprintf(chrCommand,"close wave%d wait", somSelf);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                break;
              }
              ulTime=atoi(retMsg);
              //     HlpWriteToTrapLog("Midi-Time in ms: %d %s\n", ulTime, fName);

              if(ulTime/1000) {
                _ulPlaySecs=ulTime/1000;
                _ulPlayMsecs=ulTime;
              }
              else {
                _ulPlaySecs=1;
                _ulPlayMsecs=_ulPlaySecs*1000;
              }

              //              HlpWriteToTrapLog("Midi-Time ulPlaySecs: %d\n", _ulPlaySecs);
              sprintf(chrCommand,"STATUS wave%d NUMBER OF TRACKS WAIT", somSelf);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)==MCIERR_SUCCESS) {
                _ulChannels=atoi(retMsg);
                //     HlpWriteToTrapLog("Midi-Tracks: %d %s %s\n", _ulChannels, fName, retMsg);
              }

              /* close the file */
              sprintf(chrCommand,"close wave%d wait", somSelf);
              mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            }/* else is MMMIDI */

          _ulFileSize=_wpQueryFileSize(somSelf);
          _bNeedSaving=TRUE;/* When the object is initialized the new instance data will be saved in wpObjectReady(). */

          sprintf(fName,"%d",_ulChannels);
          strncpy(_chrChannels, fName, sizeof(_chrChannels));
          _chrChannels[sizeof(_chrChannels)-1]=0;

          if(bIsMidi)
            strncpy(_chrSampleRate, "---", sizeof(_chrSampleRate));      
          else {
          sprintf(fName,"%d", _ulSampleRate);
          strncpy(_chrSampleRate, fName, sizeof(_chrSampleRate));          
          }
          _chrSampleRate[sizeof(_chrSampleRate)-1]=0;

          if(!_ulBitRate)
            strncpy(_chrBitRate, "---", sizeof(_chrBitRate));
          else {
            sprintf(fName,"%d",_ulBitRate);
            strncpy(_chrBitRate, fName, sizeof(_chrBitRate));
          }
          _chrBitRate[sizeof(_chrBitRate)-1]=0;

          if(bIsMidi)
            strncpy(_chrBPS, "---", sizeof(_chrBPS));
          else {
            sprintf(fName,"%d",_ulBPS);
            strncpy(_chrBPS, fName, sizeof(_chrBPS));
          }
          _chrBPS[sizeof(_chrBPS)-1]=0;
          
          sprintf(fName,"%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
          strncpy(_chrPlayTime, fName, sizeof(_chrPlayTime));
          _chrPlayTime[sizeof(_chrPlayTime)-1]=0;
          
          bContinue=TRUE;
          break;
        }/* for */
      }
      CATCH(AUDIO_WORKER)
        {
          SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d.\n",
                            __FUNCTION__, __FILE__, __LINE__);
          SysWriteToTrapLog("Audio file: %s\n\n",
                            fName);
        } END_CATCH;
        //FIXME
        //        WinPostMsg(m_mmCWMM->hwndStatus, WM_APPTERMINATENOTIFY, 0, 0L);
        WinPostMsg(__get_hwndStatus(_CWMMDataFile), WM_APPTERMINATENOTIFY, 0, 0L);
        
        if(!bContinue)
          return (MRESULT)FALSE;

        /* This Message was posted from wpRestore(). It's not allowed to call
         wpSaveDeferred() from there. The object must be initilized! This is important when 
         creating objects form templates. So we wait for the object to be initialized.
         If it isn't initialized within 2s we quit. */
        ulLoop=0;
        while(!_wpIsObjectInitialized(somSelf) && ulLoop<40) {
          DosSleep(50);
          ulLoop++;
        }
        if(ulLoop<20)
          _wpSaveDeferred(somSelf);
        _wpCnrRefreshDetails(somSelf);

        return (MRESULT) FALSE;
      }
    default:
      break;
    }

  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

