/*
 * (C) Chris Wohlgemuth 2002-2004
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product (commercial,
 * noncommercial, whatever) contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 *
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwastream_Source
#define SOM_Module_cwastream_Source
#endif
#define CWAudioStream_Class_Source
#define M_CWAudioStream_Class_Source

#define INCL_PM
#define INCL_MCIOS2
#include <os2.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include "os2me.h"
#include "cwastream.ih"
#include "cwaudioinc.h"
#include "helpid.h"


HMODULE queryResModuleHandle(void);
HMODULE queryModuleHandle(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
void SysWriteToTrapLog(const char* chrFormat, ...);
BOOL cwMoveNotebookButtonsWarp4(HWND hwndDlg, USHORT usID, USHORT usDelta);

PSZ _queryMp3HelpLibraryName(void); /* Get help library name for introduced classes */

static BOOL _getUrlFromFile(WPFileSystem * wpFS, char *chrBuf, ULONG ulBufSize)
{
  ULONG ulSize;
  char* pChr;
  FILE* fStream;

  for(;;)
    {
      ulSize=ulBufSize;
      if(!_wpQueryRealName(wpFS, chrBuf, &ulSize, TRUE))
        break;
      
      if((fStream=fopen( chrBuf, "r"))==NULLHANDLE)
        break;
      
      if(!fgets(chrBuf, ulBufSize, fStream)) {
        fclose(fStream);
        sprintf(chrBuf, DEFAULT_AUDIOSTREAM_SERVER);
      }
      fclose(fStream);
      if((pChr=strchr(chrBuf, '\n'))!=NULLHANDLE)
        *pChr=0;
      //      HlpWriteToTrapLog("%s\n", chrBuf);
      return TRUE;
    }
  return FALSE;
}

static BOOL _saveUrlToFile(WPFileSystem * wpFS, char *chrUrl)
{
  ULONG ulSize;
  int fHandle;
  char chrPath[CCHMAXPATH];

  for(;;)
    {
      ulSize=sizeof(chrPath);
      if(!_wpQueryRealName(wpFS, chrPath, &ulSize, TRUE))
        break;

      if((fHandle=open(chrPath, O_TEXT | O_WRONLY, S_IWRITE)) == -1)
        break;

      _chsize(fHandle, 0);

      if(-1 == write(fHandle , chrUrl,  strlen(chrUrl)))
        break;

      close(fHandle);
      return TRUE;
    }
  close(fHandle);
  return FALSE;
}

/************************************************************/
/*                                                          */
/*                                                          */
/*                                                          */
/************************************************************/
MRESULT EXPENTRY playStreamProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        MMAudio * thisPtr;
        OPENPARAMS * pParams;

        /* Depending on mp1 the parameter in mp2 is either a pointer
           to OPENPARAMS (mp1==ACKEY_START) or the object pointer (mp1==ACK_STOP) */
        if(ACKEY_START==LONGFROMMP(mp1)) {
          pParams=PVOIDFROMMP(mp2);/* Get parameter block */
          if(!pParams)
            {
              WinPostMsg(hwnd,WM_QUIT,0,0);
              return MRFALSE;
            }
          WinSetWindowULong(hwnd, QWL_USER, (ULONG)pParams);        
          thisPtr=pParams->wpObject;
        }
        else
          thisPtr=(MMAudio*)PVOIDFROMMP(mp2);

        if(somIsObj(thisPtr)) {
          switch(LONGFROMMP(mp1))
            {
              case ACKEY_START:
                {
                  unsigned char chrCommand[CCHMAXPATH*2];
                  unsigned char chrURL[CCHMAXPATH];
                  char retMsg[20];
                  APIRET rc;

                  _cwmmSetRecordTitles(thisPtr, "Connecting to server...", TRUE);

                  /* Read URL from file */
                  if(!_getUrlFromFile(thisPtr, chrURL, sizeof(chrURL)))
                    {
                      WinPostMsg(hwnd,WM_QUIT,0,0);
                      return MRFALSE;
                    };

                  /* Try to open stream. A usable storage proc is not yet available but maybe in the future... */
                  sprintf(chrCommand,"open stream:%s type WAVEAUDIO alias wave%d SHAREABLE wait", chrURL, thisPtr);
                  rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    /* No success so try storage procedure from plugin pack. */
                  
                    sprintf(chrCommand,"open ipipe:%s type WAVEAUDIO alias wave%d SHAREABLE wait", chrURL, thisPtr);
                    rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                    if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                      _cwmmSetRecordTitles(thisPtr, "Can't connect to server!", TRUE);
                      WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 2, 4000);
                      return MRFALSE;
                    }

                  }

                  /* Set time format */
                  sprintf(chrCommand,"SET wave%d TIME FORMAT MILLISECONDS wait", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  sprintf(chrCommand,"play wave%d ", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000);
                  _cwmmSetRecordTitles(thisPtr, "00:00", TRUE);

                  break;
                }
            case ACKEY_STOP:
              {
                /* Stop playing */
                unsigned char chrCommand[CCHMAXPATH];
                char retMsg[20];

                WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,1 );

                sprintf(chrCommand,"stop wave%d wait", thisPtr);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                
                sprintf(chrCommand,"close wave%d wait", thisPtr);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                
                WinPostMsg(hwnd,WM_QUIT,0,0);
              }
            default:
              break;
            }
        }/* if(thisPtr) */
        return MRFALSE;
      }
    case WM_TIMER:
      switch(SHORT1FROMMP(mp1))
        {
        case 1:
          {
            MMAudio * thisPtr;
            OPENPARAMS * pParams;


            pParams=(OPENPARAMS*)WinQueryWindowULong(hwnd, QWL_USER);
            thisPtr=pParams->wpObject;
            
            if(somIsObj(thisPtr)) {
              char retMsg[20];
              unsigned char chrCommand[CCHMAXPATH];
              APIRET rc;
              ULONG ulCur;
              
              /* Get current play position */
              sprintf(chrCommand,"STATUS wave%d POSITION WAIT", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                return MRFALSE;
              }
              
              ulCur=atoi(retMsg)/1000;
              sprintf(chrCommand, "%02d:%02d", ulCur/60, ulCur%60);
              
              /* Set new time in icon title */
              _cwmmSetRecordTitles(thisPtr, chrCommand, TRUE);

              sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
              if(stricmp(retMsg, "playing")) {
                /* Not playing anymore. Try to reconnect */
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_START), MPFROMP(thisPtr));
              }
              return MRFALSE;
            }
          }
        case 2:
          WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd, 2);
          WinPostMsg(hwnd,WM_QUIT,0,0);
          return MRFALSE;
        default:
          break;
        }
      break;
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}


MRESULT EXPENTRY streamUrlDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MMAudioStream *cwAudioStream;

  switch(msg) 
    {
    case WM_INITDLG :
      {
        char chrURL[CCHMAXPATH];
        cwAudioStream=(MMAudio*)PVOIDFROMMP(mp2);
        WinSetWindowULong(WinWindowFromID(hwnd,IDEF_URL),
                          QWL_USER,(ULONG)cwAudioStream);//Save object ptr.

        WinSendMsg(WinWindowFromID(hwnd,IDEF_URL),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(chrURL)),0);

        /* Move default buttons on Warp 4 */
        cwMoveNotebookButtonsWarp4(hwnd, IDPB_STREAMHELP, 15);

        if(somIsObj(cwAudioStream)) {
       
          /* CWAudioStreamData *somThis = CWAudioStreamGetData(cwAudioStream); */
          
          /* Move default buttons on Warp 4 */
          // cwMoveNotebookButtonsWarp4(hwnd, IDPB_ID3HELP, 15);
          
          if(_getUrlFromFile(cwAudioStream, chrURL, sizeof(chrURL)))
            {
              WinSetWindowText(WinWindowFromID(hwnd,IDEF_URL),chrURL);
            }
          WinSendMsg(WinWindowFromID(hwnd,IDEF_URL),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
        }

        WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
        return (MRESULT)TRUE;
      }
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;
        
        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd),
                       (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      cwAudioStream=(MMAudioStream*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_URL), QWL_USER);
      if(somIsObj(cwAudioStream)) {
        char fName[CCHMAXPATH];

        WinQueryWindowText(WinWindowFromID(hwnd,IDEF_URL), sizeof(fName), fName);
        _saveUrlToFile(cwAudioStream, fName);
      }

      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
#if 0
  case WM_COMMAND:
    cwAudio=(CWAudio*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_ID3NAME),QWL_USER);
    if(somIsObj(cwAudio)) {
      char fName[100];

      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CANCEL:
          break;
        default:
          break;
        }
    }
    return (MRESULT) TRUE;
#endif
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/*
 * The prototype for cwastream_cwmmAddURLPage was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwastream_cwmmAddURLPage(MMAudioStream *somSelf, 
                                                  HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_cwmmAddURLPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = streamUrlDlgProc;
  //The resource DLL
  pageinfo.resid = queryResModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_STREAMURLPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  pageinfo.idDefaultHelpPanel = AUDIOSTREAM_SETTINGS_PANEL;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = _queryMp3HelpLibraryName();
  //We have a major tab so we need a name
  if(!getMessage(pageName, IDSTR_STREAMURLPAGENAME, sizeof(pageName),  queryResModuleHandle(), hwndNotebook))
    strcpy(pageName, "Stream ~URL");
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook

  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);
}


SOM_Scope void  SOMLINK cwastream_wpCopiedFromTemplate(MMAudioStream *somSelf)
{
    /* MMAudioStreamData *somThis = MMAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_wpCopiedFromTemplate");

    MMAudioStream_parent_MMAudio_wpCopiedFromTemplate(somSelf);

    _wpViewObject(somSelf, NULLHANDLE, OPEN_SETTINGS,0);
}

/*
 * The prototype for cwastream_wpModifyPopupMenu was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwastream_wpModifyPopupMenu(MMAudioStream *somSelf, 
                                                    HWND hwndMenu, 
                                                    HWND hwndCnr, 
                                                    ULONG iPosition)
{
  BOOL bRC;
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_wpModifyPopupMenu");

    bRC=(MMAudioStream_parent_MMAudio_wpModifyPopupMenu(somSelf, 
                                                        hwndMenu, 
                                                        hwndCnr, 
                                                        iPosition));
    WinSendMsg(hwndMenu,MM_DELETEITEM,MPFROM2SHORT( ID_MENU_PLAYER, TRUE),
               0L);
    WinSendMsg(hwndMenu,MM_DELETEITEM,MPFROM2SHORT( ID_MENU_EDITOR, TRUE),
               0L);
    WinSendMsg(hwndMenu,MM_DELETEITEM,MPFROM2SHORT( ID_MENU_CONVERT, FALSE),
               0L);

    return bRC;
}

/*
 * The prototype for cwastream_wpAddSettingsPages was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwastream_wpAddSettingsPages(MMAudioStream *somSelf, 
                                                     HWND hwndNotebook)
{
  BOOL bRc;
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_wpAddSettingsPages");

    bRc=MMAudioStream_parent_MMAudio_wpAddSettingsPages(somSelf, 
                                                              hwndNotebook);
    _cwmmAddURLPage(somSelf,  hwndNotebook);
    return bRc;
}

/*
 * The prototype for cwastream_wpInitData was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwastream_wpInitData(MMAudioStream *somSelf)
{
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_wpInitData");

    MMAudioStream_parent_MMAudio_wpInitData(somSelf);
    _cwmmSetObjWindowProc(somSelf, &playStreamProc);
}

SOM_Scope ULONG  SOMLINK cwastream_cwmmAddAudioInformationPage(MMAudioStream *somSelf, 
                                                               HWND hwndNotebook)
{
    /* MMAudioStreamData *somThis = MMAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_cwmmAddAudioInformationPage");

    return SETTINGS_PAGE_REMOVED;
    //    return (MMAudioStream_parent_MMAudio_cwmmAddAudioInformationPage(somSelf, 
    //                                                               hwndNotebook));
}

/*
 * The prototype for cwastream_cwmmAddTrackNamePage was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwastream_cwmmAddTrackNamePage(MMAudioStream *somSelf, 
                                                        HWND hwndNotebook)
{
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    MMAudioStreamMethodDebug("MMAudioStream","cwastream_cwmmAddTrackNamePage");

    return SETTINGS_PAGE_REMOVED;
}

/*
 * The prototype for cwastreamM_wpclsQueryInstanceType was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwastreamM_wpclsQueryInstanceType(M_MMAudioStream *somSelf)
{
  // static char chrTitle[20]={0};
    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_MMAudioStreamMethodDebug("M_MMAudioStream","cwastreamM_wpclsQueryInstanceType");
#if 0
    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_AUDIOSTREAMTITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Audio-Stream");
    return chrTitle;
#endif
    return TYPE_AUDIOSTREAM;
}

/*
 * The prototype for cwastreamM_wpclsQueryDefaultHelp was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwastreamM_wpclsQueryDefaultHelp(M_MMAudioStream *somSelf, 
                                                         PULONG pHelpPanelId, 
                                                         PSZ pszHelpLibrary)
{
  PSZ pszHelpLibName;
    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_MMAudioStreamMethodDebug("M_MMAudioStream","cwastreamM_wpclsQueryDefaultHelp");

    if((pszHelpLibName=_queryMp3HelpLibraryName())!=NULLHANDLE)
      {
        if(pHelpPanelId)
          *pHelpPanelId=AUDIOSTREAM_HELP_PANEL;
        if(pszHelpLibrary)
          strncpy(pszHelpLibrary, pszHelpLibName, CCHMAXPATH);
        return TRUE; 
      }

    return (M_MMAudioStream_parent_M_MMAudio_wpclsQueryDefaultHelp(somSelf, 
                                                                   pHelpPanelId, 
                                                                   pszHelpLibrary));
}

/*
 * The prototype for cwastreamM_wpclsQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwastreamM_wpclsQueryTitle(M_MMAudioStream *somSelf)
{
  static char chrTitle[20]={0};

    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_MMAudioStreamMethodDebug("M_MMAudioStream","cwastreamM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_AUDIOSTREAMTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle, CLSTITLE_AUDIOSTREAM);

    return chrTitle;
}

/*
 * The prototype for cwastreamM_wpclsQueryIconData was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwastreamM_wpclsQueryIconData(M_MMAudioStream *somSelf, 
                                                       PICONINFO pIconInfo)
{
  HMODULE hmod;

    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_MMAudioStreamMethodDebug("M_MMAudioStream","cwastreamM_wpclsQueryIconData");

    hmod=queryModuleHandle();
    if(!hmod)
      return M_MMAudioStream_parent_M_MMAudio_wpclsQueryIconData(somSelf, pIconInfo);

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = hmod;
      pIconInfo->resid   = ID_ICONAUDIOSTREAM;
	} /* endif */

	return ( sizeof(ICONINFO) );
}

