/*
 * This file is (C) Chris Wohlgemuth 2002
 */

#ifndef M3UFOLDER_HH_INCLUDED
#define M3UFOLDER_HH_INCLUDED

#include "mediafolder.hh"
#include "mediafolderres.h"

#pragma SOMAsDefault(on)
#include <som.hh>
#include <somcls.hh>
#pragma SOMNoMangling(on)

#include "cwaudio.hh"

#pragma SOMAsDefault(off)
#pragma SOMNonDTS(on)

/* The help panel for the M3U folder */
#define IDHLP_M3UFOLDERMAIN 300

typedef struct _M3UTHREADPARMS
{
  WPObject* thisPtr;
  HWND hwndCnr;
  HWND hwndFrame;
  BOOL fSaveOnly;
}M3UTHREADPARMS; 

#pragma SOMAsDefault(on)
//#pragma SOMNonDTS(on)

class M_CWM3UFolder:public M_CWMediaFolder
{
/* The name of of the new class */
#pragma SOMClassName(*,"M_CWM3UFolder")
/* Required SOM version */
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
public:
  virtual PSZ  wpclsQueryTitle();
  virtual ULONG wpclsQueryStyle();
  virtual	ULONG wpclsQueryIconData(PICONINFO pIconInfo);
  virtual	ULONG wpclsQueryIconDataN(PICONINFO pIconInfo, ULONG ulIconIndex);
  virtual void wpclsInitData();
  virtual BOOL wpclsQueryDefaultHelp(PULONG HelpPanelId,PSZ HelpLibrary);
  virtual BOOL wpclsCreateDefaultTemplates(WPObject * wpObject);
  /*  
  virtual void wpclsUnInitData();

  */
#pragma SOMReleaseOrder()
#pragma SOMIDLPass(*,"Implementation-End","dllname = mediafld;")
};

class CWM3UFolder:public CWMediaFolder
{
#pragma SOMClassName(*,"CWM3UFolder")
#pragma SOMMetaClass(*,"M_CWM3UFolder")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
private:

public:

  BOOL fContentsChanged;
  BOOL fClosing;

  virtual HWND wpOpen(HWND hwndCnr,ULONG ulView,ULONG ulParam);
  //  virtual BOOL wpSetup(PSZ pSetupString);
  virtual BOOL cwInsertAllTracks(char* chrM3UFile);
  virtual BOOL cwSavePlaylist(char* chrM3UFile, BOOL fClose);
  virtual BOOL wpDeleteFromContent(WPObject* Object);
  virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr, BOOL fMultiSelect);
  virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr, ULONG ulPosition);
  virtual MRESULT wpDrop(HWND hwndCnr,PDRAGINFO pDragInfo,PDRAGITEM pDragItem);  
#if 0
  virtual BOOL wpRestoreState(ULONG ulReserved);
  virtual BOOL wpSaveState();
  virtual BOOL wpSetupOnce(PSZ pSetupString);
  virtual MRESULT wpDragOver(HWND hwndCnr,PDRAGINFO pDragInfo);
  virtual BOOL wpRefresh(ULONG ulView, PVOID pReserved);
  virtual ULONG wpAddObjectGeneralPage2(HWND hwndNotebook);
  virtual ULONG wpAddFolderSortPage(HWND hwndNotebook);
  virtual ULONG wpAddFolderIncludePage(HWND hwndNotebook);
  virtual ULONG wpQueryConcurrentView();
  virtual ULONG cwPlayAudioFile(HWND hwndFrame, ULONG ulWhich);
  virtual BOOL cwSeekAudioFile(LONG lPosSec);
  virtual void cwPlayTimeCallback(HWND hwndFrame, LONG lPosSec);
  virtual MRESULT wpDrop(HWND hwndCnr,PDRAGINFO pDragInfo,PDRAGITEM pDragItem);
  virtual BOOL wpDeleteFromContent(WPObject* Object);
#endif
  virtual BOOL cwClose(HWND hwndFrame);
#pragma SOMReleaseOrder( \
"cwSavePlaylist")

#pragma SOMIDLPass(CWMediaFolder,"Implementation-End","dllname = mediafld;")
};

#pragma SOMAsDefault(pop)
#pragma SOMNonDTS(pop)

#endif /* CDFOLDER_HH_INCLUDED */












