
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwmmdataf_Source
#define SOM_Module_cwmmdataf_Source
#endif
#define CWMMDataFile_Class_Source
#define M_CWMMDataFile_Class_Source

#define INCL_PM
#define INCL_DOS
#define INCL_MMIOOS2
#include <os2.h>
#include <stdio.h>
#include "os2me.h"
#include "cwmmdataf.ih"
#include "cwaudio.ih"
#include <wpfolder.h>
#include "cwmmres.h"
#include "cwaudioinc.h"
#include "except.h"

#define ID_STATUS_WINDOW   0x1000

HMODULE queryModuleHandle(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
void HlpWriteToTrapLog(const char* chrFormat, ...);


SOM_Scope PFNWP  SOMLINK cwmmdatafile_cwmmSetObjWindowProc(CWMMDataFile *somSelf, 
                                                           PFNWP pObjectProc)
{
  PFNWP pTemp;
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmSetObjWindowProc");

    pTemp=_pfnwpObjectProc;
    _pfnwpObjectProc=pObjectProc;
    /* Return statement to be customized: */
    return pTemp;
}

SOM_Scope PFNWP  SOMLINK cwmmdatafile_cwmmQueryObjWindowProc(CWMMDataFile *somSelf)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmQueryObjWindowProc");

    /* Return statement to be customized: */
    return _pfnwpObjectProc;
}


SOM_Scope BOOL  SOMLINK cwmmdatafile_cwmmSetRecordTitles(CWMMDataFile *somSelf, 
                                                         PSZ pTitle, 
                                                         BOOL bAddToTitle)
{
  PUSEITEM pUseItem;
  PSZ pSZ;

  M_CWMMDataFileData *m_mmDfData = M_CWMMDataFileGetData(_CWMMDataFile);
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_cwmmSetRecordTitles");


    if(m_mmDfData->bNoExtendedIconTitles)
      return NULLHANDLE;

    if(pTitle) {
      //   WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, _wpQueryTitle(somSelf),
      // "cwmmSet - wpQuerytitle()", 1234, MB_OK|MB_MOVEABLE);
      if(!_pOrgTitle)
        _pOrgTitle=_wpQueryTitle(somSelf);
      if(bAddToTitle)
        {
          strncpy(_chrRecordTitle, _wpQueryTitle(somSelf), sizeof(_chrRecordTitle));
          _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;
          strncat(_chrRecordTitle,"\n", sizeof(_chrRecordTitle)-1-strlen(_chrRecordTitle));
          strncat(_chrRecordTitle, pTitle, sizeof(_chrRecordTitle)-1-strlen(_chrRecordTitle));
        }
      else
        strncpy(_chrRecordTitle, pTitle, sizeof(_chrRecordTitle));
      _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;
      pSZ=_chrRecordTitle;
    }
    else {
      //  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, _wpQueryTitle(somSelf), 
      //"cwmmSet(NULLHANDLE) - wpQuerytitle()", 1234, MB_OK|MB_MOVEABLE);
      strncpy(_chrRecordTitle, _pOrgTitle, sizeof(_chrRecordTitle));
      pSZ=_pOrgTitle;
      _pOrgTitle=NULLHANDLE;
      //      WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, _wpQueryTitle(somSelf), 
      //"cwmmSet(NULLHANDLE) - _chrRecordTitle", 1234, MB_OK|MB_MOVEABLE);
    }
    _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;

    for(pUseItem=_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE); pUseItem;
        pUseItem=_wpFindUseItem(somSelf, USAGE_RECORD, pUseItem))
      {
        PRECORDITEM pRecordItem=(PRECORDITEM)++pUseItem;
        pUseItem--;

        pRecordItem->pRecord->pszIcon=pSZ;
        if(pRecordItem->hwndCnr)
          WinSendMsg(pRecordItem->hwndCnr, CM_INVALIDATERECORD, MPFROMP(&(pRecordItem->pRecord)),
                     MPFROM2SHORT(1,CMA_TEXTCHANGED));
      }

    for(pUseItem=_wpFindUseItem(somSelf, USAGE_LINK, NULLHANDLE); pUseItem;
        pUseItem=_wpFindUseItem(somSelf, USAGE_LINK, pUseItem))
      {
        PLINKITEM pLinkItem=(PLINKITEM)++pUseItem;
        pUseItem--;
                        
        if(somIsObj(pLinkItem->LinkObj))
          {
            PUSEITEM pUI;
            
            for(pUI=_wpFindUseItem(pLinkItem->LinkObj, USAGE_RECORD, NULLHANDLE); pUI;
                pUI=_wpFindUseItem(pLinkItem->LinkObj, USAGE_RECORD, pUI))
              {
                PRECORDITEM pRecordItem=(PRECORDITEM)++pUI;
                pUI--;

                pRecordItem->pRecord->pszIcon=pSZ;
                if(pRecordItem->hwndCnr)
                  WinPostMsg(pRecordItem->hwndCnr,CM_INVALIDATERECORD,
                             MPFROMP(&(pRecordItem->pRecord)),MPFROM2SHORT(1,CMA_TEXTCHANGED));
              }
          }
      }

    /* Return statement to be customized: */
    return TRUE;
}

#if 0               
SOM_Scope PSZ  SOMLINK cwaudio_cwmmSetRecordTitles(CWAudio *somSelf, 
                                                    PSZ pTitle)
{
  PUSEITEM pUseItem;
  PSZ pSZ;

    M_CWAudioData *m_cwAudioData = M_CWAudioGetData(_CWAudio);
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmSetRecordTitles");

    if(m_cwAudioData->bNoExtendedIconTitles)
      return NULLHANDLE;

    if(pTitle) {
      //   WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, _wpQueryTitle(somSelf),
      // "cwmmSet - wpQuerytitle()", 1234, MB_OK|MB_MOVEABLE);
      if(!_pOrgTitle)
        _pOrgTitle=_wpQueryTitle(somSelf);
      strncpy(_chrRecordTitle, pTitle, sizeof(_chrRecordTitle));
      pSZ=_chrRecordTitle;
    }
    else {
      //  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, _wpQueryTitle(somSelf), 
      //"cwmmSet(NULLHANDLE) - wpQuerytitle()", 1234, MB_OK|MB_MOVEABLE);
      strncpy(_chrRecordTitle, _pOrgTitle, sizeof(_chrRecordTitle));
      pSZ=_pOrgTitle;
      _pOrgTitle=NULLHANDLE;
      //      WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, _wpQueryTitle(somSelf), 
      //"cwmmSet(NULLHANDLE) - _chrRecordTitle", 1234, MB_OK|MB_MOVEABLE);
    }
    _chrRecordTitle[sizeof(_chrRecordTitle)-1]=0;

    for(pUseItem=_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE); pUseItem;
        pUseItem=_wpFindUseItem(somSelf, USAGE_RECORD, pUseItem))
      {
        PRECORDITEM pRecordItem=(PRECORDITEM)++pUseItem;
        pUseItem--;
        
        //        pRecordItem->pRecord->pszIcon=_chrRecordTitle;
        pRecordItem->pRecord->pszIcon=pSZ;
        if(pRecordItem->hwndCnr)
          WinSendMsg(pRecordItem->hwndCnr, CM_INVALIDATERECORD, MPFROMP(&(pRecordItem->pRecord)),MPFROM2SHORT(1,CMA_TEXTCHANGED));
      }

    for(pUseItem=_wpFindUseItem(somSelf, USAGE_LINK, NULLHANDLE); pUseItem;
        pUseItem=_wpFindUseItem(somSelf, USAGE_LINK, pUseItem))
      {
        PLINKITEM pLinkItem=(PLINKITEM)++pUseItem;
        pUseItem--;
                        
        if(somIsObj(pLinkItem->LinkObj))
          {
            PUSEITEM pUI;
            
            for(pUI=_wpFindUseItem(pLinkItem->LinkObj, USAGE_RECORD, NULLHANDLE); pUI;
                pUI=_wpFindUseItem(pLinkItem->LinkObj, USAGE_RECORD, pUI))
              {
                PRECORDITEM pRecordItem=(PRECORDITEM)++pUI;
                pUI--;
                
                //                pRecordItem->pRecord->pszIcon=_chrRecordTitle;
                pRecordItem->pRecord->pszIcon=pSZ;
                if(pRecordItem->hwndCnr)
                  WinPostMsg(pRecordItem->hwndCnr,CM_INVALIDATERECORD,
                             MPFROMP(&(pRecordItem->pRecord)),MPFROM2SHORT(1,CMA_TEXTCHANGED));
              }
          }
      }

    /* Return statement to be customized: */
    return NULLHANDLE;
}
#endif

SOM_Scope ULONG  SOMLINK cwmmdatafile_wpFilterPopupMenu(CWMMDataFile *somSelf, 
                                                        ULONG ulFlags, 
                                                        HWND hwndCnr, 
                                                        BOOL fMultiSelect)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpFilterPopupMenu");

    /* Remove the print menu item. */
    return (CWMMDataFile_parent_WPDataFile_wpFilterPopupMenu(somSelf, 
                                                             ulFlags, 
                                                             hwndCnr, 
                                                             fMultiSelect)& ~CTXT_PRINT);
}

SOM_Scope BOOL  SOMLINK cwmmdatafile_wpAddSettingsPages(CWMMDataFile *somSelf, 
                                                        HWND hwndNotebook)
{
  BOOL bRc;
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpAddSettingsPages");

    bRc=(CWMMDataFile_parent_WPDataFile_wpAddSettingsPages(somSelf, 
                                                              hwndNotebook));
    if(_pOrgTitle)
      _cwmmSetRecordTitles(somSelf, _chrRecordTitle, FALSE);
    return bRc;
}


SOM_Scope BOOL  SOMLINK cwmmdatafile_wpModifyPopupMenu(CWMMDataFile *somSelf, 
                                                       HWND hwndMenu, 
                                                       HWND hwndCnr, 
                                                       ULONG iPosition)
{
  BOOL bRc;

    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpModifyPopupMenu");

    
    bRc=(CWMMDataFile_parent_WPDataFile_wpModifyPopupMenu(somSelf, 
                                                             hwndMenu, 
                                                             hwndCnr, 
                                                             iPosition));
    if(_pOrgTitle)
      _cwmmSetRecordTitles(somSelf, _chrRecordTitle, FALSE);

    return bRc;
}


SOM_Scope BOOL  SOMLINK cwmmdatafile_wpSetTitle(CWMMDataFile *somSelf, 
                                                PSZ pszNewTitle)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpSetTitle");

    _pOrgTitle=NULLHANDLE;

    return (CWMMDataFile_parent_WPDataFile_wpSetTitle(somSelf, 
                                                      pszNewTitle));
}


SOM_Scope PSZ  SOMLINK cwmmdatafile_wpQueryTitle(CWMMDataFile *somSelf)
{
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWMMDataFileMethodDebug("CWMMDataFile","cwmmdatafile_wpQueryTitle");

    if(_pOrgTitle)
      return _pOrgTitle;

    return (CWMMDataFile_parent_WPDataFile_wpQueryTitle(somSelf));
}


SOM_Scope PSZ  SOMLINK cwmmdatafileM_wpclsQueryTitle(M_CWMMDataFile *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf); */
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_CWMMDATAFILETITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"MMData file");

    return chrTitle;
}

SOM_Scope ULONG  SOMLINK cwmmdatafileM_wpclsQueryIconData(M_CWMMDataFile *somSelf, 
                                                          PICONINFO pIconInfo)
{
    /* M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf); */
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsQueryIconData");

    return (M_CWMMDataFile_parent_M_WPDataFile_wpclsQueryIconData(somSelf, 
                                                                  pIconInfo));
}

MRESULT EXPENTRY audioWorkerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
      ULONG ulSize;
      char fName[CCHMAXPATH];
      char text[CCHMAXPATH];
      BOOL bContinue=FALSE;
      CWAudio *somSelf=(CWAudio*)mp1;
      CWAudioData *somThis= CWAudioGetData(somSelf);
      WPFolder *wpFolder;
      M_CWMMDataFileData *m_mmCWMM = M_CWMMDataFileGetData(_CWMMDataFile);

      TRY_LOUD(AUDIO_WORKER) {
        for(;;) {
          ULONG rc;
          MMIOINFO mmio;
          HMMIO hmmio;
          MMAUDIOHEADER mmAudioHeader={0};
          LONG lBytesRead=0;
          char* pChar;
          ULONG ulFSize;

          if(!somIsObj(somSelf))
            break;

          ulSize=sizeof(fName);
          if(!_wpQueryRealName(somSelf, fName, &ulSize, TRUE))
            break;

          ulFSize=_wpQueryFileSize(somSelf);
          if(_ulFileSize==ulFSize)
            break;          /* We already scanned this file */

#if 0
          /* Can't write EAs on readonly files, so skip it */
          if(_wpQueryAttr(somSelf) & FILE_READONLY)
            break;
#endif
          
#if 0
          wpFolder=_wpQueryFolder(somSelf);
          if(!somIsObj(wpFolder))
            break;
          /* The folder must be populated ptherwise the object isn't inserted into the container */
          if(_wpQueryFldrFlags(wpFolder)&(FOI_POPULATEDWITHALL)) {
            /* Test if the requested object is still visible in a folder. If not don't read info. */
            if(!_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE)) {
              /* This object is hidden so put it at the end of the list */
              //            WinPostMsg(hwnd , WM_APPTERMINATENOTIFY, somSelf, 0);
              break;
            }
          }
#endif

          /* Show status window */
          if((pChar=strrchr(fName, '\\'))!=NULLHANDLE) {
            HPS hps;
            ULONG ulWinTextLen;
            POINTL aptlPoints[TXTBOX_COUNT];
            SWP swp;
            ULONG ulCy;
            WPOINT pwpBorder;
            HWND hwndClient=WinWindowFromID(m_mmCWMM->hwndStatus, FID_CLIENT);

            sprintf(text,"%c:\\...%s",fName[0], pChar);
            WinSetWindowText(hwndClient, text);
            ulWinTextLen=(ULONG)strlen(text); // Query text length

            /* Calculate text size in pixel */
            hps=WinBeginPaint(hwndClient,(HPS)NULL,(PRECTL)NULL);
            GpiQueryTextBox(hps,ulWinTextLen,text,TXTBOX_COUNT,aptlPoints);
            WinEndPaint(hps);

            if(WinSendMsg(m_mmCWMM->hwndStatus ,WM_QUERYBORDERSIZE, MPFROMP(&pwpBorder), 0L))
              ulCy=pwpBorder.x*2;
            else
              ulCy=SV_CYBORDER*2;

            if(WinQueryWindowPos(WinWindowFromID(m_mmCWMM->hwndStatus, FID_TITLEBAR),&swp))
              ulCy+=swp.cy;
            else
              ulCy+=15;

            WinSetWindowPos(m_mmCWMM->hwndStatus, HWND_TOP, 0,0,
                            aptlPoints[TXTBOX_BOTTOMRIGHT].x-aptlPoints[TXTBOX_BOTTOMLEFT].x+18,
                            aptlPoints[TXTBOX_TOPRIGHT].y-aptlPoints[TXTBOX_BOTTOMRIGHT].y+ulCy+4,
                            SWP_SIZE|SWP_SHOW|SWP_ZORDER|SWP_DEACTIVATE);

            WinPostMsg(m_mmCWMM->hwndStatus, WM_APPTERMINATENOTIFY, 0,MPFROMLONG(1L));
          }

          memset(&mmio,0, sizeof(mmio));
          mmio.ulFlags=MMIO_READ;
          mmio.ulTranslate=MMIO_TRANSLATEHEADER;
          
          hmmio = mmioOpen(fName, &mmio, MMIO_READ);
          if(!hmmio)
            break;
          
          memset(&mmAudioHeader,0,sizeof(MMAUDIOHEADER));
          rc = mmioGetHeader(hmmio, &mmAudioHeader,sizeof(MMAUDIOHEADER),
                             &lBytesRead, 0, 0);
          
          if(rc!=MMIO_SUCCESS) {
            mmioClose(hmmio, 0);
            break;
          }
          mmioClose(hmmio, 0);

          /* Check if the object is still living. */
          if(!somIsObj(somSelf))
            break;
          
          _ulChannels=mmAudioHeader.mmXWAVHeader.WAVEHeader.usChannels;
          _ulSampleRate=mmAudioHeader.mmXWAVHeader.WAVEHeader.ulSamplesPerSec;
          _ulBPS=mmAudioHeader.mmXWAVHeader.WAVEHeader.usBitsPerSample;
          /*      sprintf(fName,"%02d:%02d",mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
                  mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec/60,
                  mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
                  mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec%60);*/
          if(mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000) {
            _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS/1000;
            _ulPlayMsecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInMS;
          }
          else {
            _ulPlaySecs=mmAudioHeader.mmXWAVHeader.XWAVHeaderInfo.ulAudioLengthInBytes/
              mmAudioHeader.mmXWAVHeader.WAVEHeader.ulAvgBytesPerSec;
            _ulPlayMsecs=_ulPlaySecs*1000;
          }

          _ulFileSize=_wpQueryFileSize(somSelf);
          _bNeedSaving=TRUE;/* When the object is initialized the new instance data will be saved in wpObjectReady(). */
          sprintf(fName,"%d",_ulChannels);
          strncpy(_chrChannels, fName, sizeof(_chrChannels));
          _chrChannels[sizeof(_chrChannels)-1]=0;
          
          sprintf(fName,"%d", _ulSampleRate);
          strncpy(_chrSampleRate, fName, sizeof(_chrSampleRate));      
          _chrSampleRate[sizeof(_chrSampleRate)-1]=0;
          
          sprintf(fName,"%d",_ulBPS);
          strncpy(_chrBPS, fName, sizeof(_chrBPS));
          _chrBPS[sizeof(_chrBPS)-1]=0;
          
          sprintf(fName,"%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
          strncpy(_chrPlayTime, fName, sizeof(_chrPlayTime));
          _chrPlayTime[sizeof(_chrPlayTime)-1]=0;
          
          bContinue=TRUE;
          break;
        }/* for */
      }
      CATCH(AUDIO_WORKER)
        {
          HlpWriteToTrapLog("\nTrap occured in %s, file %s, around line %d.\n",
                            __FUNCTION__, __FILE__, __LINE__);
          HlpWriteToTrapLog("Audio file: %s\n\n",
                            fName);
        } END_CATCH;

        WinPostMsg(m_mmCWMM->hwndStatus, WM_APPTERMINATENOTIFY, 0,0L);
        
        if(!bContinue)
          return (MRESULT)FALSE;
        
        _wpSaveDeferred(somSelf);
        _wpCnrRefreshDetails(somSelf);

        return (MRESULT) FALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY statusWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  PFNWP proc;

  switch (msg)
    {
#if 0
    case WM_BUTTON2MOTIONSTART:
    case WM_BUTTON1MOTIONSTART:
      /* Drag the window without titlebar */
      WinSendMsg(hwnd, WM_TRACKFRAME, 
                 MPFROMSHORT(TF_MOVE   /*| TF_SETPOINTERPOS */), NULL) ;
      return (MRESULT) 0 ;
#endif
    case WM_APPTERMINATENOTIFY:
      {
        switch (LONGFROMMP(mp2))
          {
          case 0:
            WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000);
            break;
          case 1:
            WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 1);
            break;
          default:
            break;
          }
        return (MRESULT) FALSE;
      }
    case WM_TIMER:
      {
        if(SHORT1FROMMP(mp1)==1) {
          WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 1);
          /* Hide the status window */
          WinSetWindowPos(hwnd, NULLHANDLE, 0, 0, 0, 0,SWP_SIZE);
          return (MRESULT) FALSE;
        }
      }
    default:
      break;
    }

  proc=(PFNWP) WinQueryWindowULong(hwnd, QWL_USER);

  if(proc)
    return proc( hwnd, msg, mp1, mp2);

  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

void _Optlink audioWorkerThread (void *arg)
{

  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  
  M_CWMMDataFileData *somThis = (M_CWMMDataFileData*)arg;

  DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, 0, 0);
  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab,0);
    if(hmq) {      
      _hwndAudioWorker=WinCreateWindow(HWND_OBJECT,WC_STATIC,"CWMMObj",0,0,0,0,0,NULLHANDLE,HWND_BOTTOM,13343,NULL,NULL);
      if(_hwndAudioWorker) {
        WinSubclassWindow(_hwndAudioWorker,&audioWorkerProc);
        /* Window created. */
        while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
          WinDispatchMsg(hab,&qmsg);

        WinDestroyWindow(_hwndAudioWorker);
      }
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
}

SOM_Scope void  SOMLINK cwmmdatafileM_wpclsInitData(M_CWMMDataFile *somSelf)
{
    M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf);
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsInitData");

    M_CWMMDataFile_parent_M_WPDataFile_wpclsInitData(somSelf);

    /* Create a status window to show user we're scanning the audio file for info */
    if(!_hwndStatus)
      {
        HWND hwndClient;
        PFNWP proc;
        char chrText[100];

        ULONG ulFL=FCF_BORDER | FCF_TITLEBAR;
        _hwndStatus=WinCreateStdWindow(HWND_DESKTOP,WS_VISIBLE|FS_BORDER,
                                      &ulFL, WC_STATIC, "Audiofile scanning...",
                                      WS_VISIBLE|SS_TEXT|DT_VCENTER|DT_CENTER, NULLHANDLE, ID_STATUS_WINDOW,
                                      &hwndClient);
        if(getMessage(chrText, IDSTR_AUDIOSCANNING , sizeof(chrText), queryModuleHandle(),  _hwndStatus))
          WinSetWindowText(_hwndStatus, chrText);
        proc=WinSubclassWindow(_hwndStatus,&statusWindowProc);
        WinSetWindowULong(_hwndStatus, QWL_USER,(ULONG)proc);
        WinSetWindowPos(_hwndStatus, HWND_TOP, 0, 0, 0, 0,SWP_MOVE|SWP_SIZE|SWP_ZORDER|SWP_DEACTIVATE);
      }

    /* Get special settings from the INI file */
    if(!PrfQueryProfileInt(HINI_USERPROFILE, "CWMM", MM_NO_EXTENDED_ICONTITLE, 0))
      _bNoExtendedIconTitles=FALSE;
    else
      _bNoExtendedIconTitles=TRUE;
    
    _beginthread(audioWorkerThread, NULL, 8192*10, somThis);
}

SOM_Scope void  SOMLINK cwmmdatafileM_wpclsUnInitData(M_CWMMDataFile *somSelf)
{
    /* M_CWMMDataFileData *somThis = M_CWMMDataFileGetData(somSelf); */
    M_CWMMDataFileMethodDebug("M_CWMMDataFile","cwmmdatafileM_wpclsUnInitData");

    M_CWMMDataFile_parent_M_WPDataFile_wpclsUnInitData(somSelf);
}

